C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( ntap, otap, ptap, 
     :     dx, dy, CdpInt, NumVertices, Vertex_XY,
     :     Vertex_XY_Transformed, nsamp, ntrc, nrec, iform, nsi, 
     :     Num_CDPS, XSD_Record, XSD_Trace, XSD_Sample, verbos ) 

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer NumVertices
      integer nsamp, ntrc, nrec, iform, nsi, Num_CDPS

      real dx, dy, CdpInt
      real Vertex_XY(2,NumVertices)
      real Vertex_XY_Transformed(2,NumVertices)
      real XSD_Record(NumVertices), XSD_Trace(NumVertices)
      real XSD_Sample(NumVertices)

      character  ntap*(*), otap*(*), ptap*(*)

      logical    verbos

c declare local variables

      integer length

c begin output

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name   =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set name   =  stdin'
      endif
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '

      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name  =  ', otap(1:length)
      else
        write(LERR,*) ' output data set name  =  stdout'
      endif
      write(LERR,*) ' start record          =  ', 1
      write(LERR,*) ' end record            =  ', Num_CDPS
      write(LERR,*) ' start trace           =  ', 1
      write(LERR,*) ' end trace             =  ', 1
      write(LERR,*) ' processing sample start = ', 1
      write(LERR,*) ' processing sample end   = ', nsamp
      write(LERR,*)' '

      length = lenth(ptap)
      if (length .gt. 0) then
        write(LERR,*) ' input xsd pickfile name = ', ptap(1:length)
      else
        write(LERR,*) ' input xsd pickfile name = pipe'
      endif
      write(LERR,*)' '
      write(LERR,*)' Input Volume Trace Spacing '
      write(LERR,*)' '
      write(LERR,*)' Trace spacing within records = ', dx
      write(LERR,*)' Distance between records     = ', dy
      write(LERR,*)' '
      write(LERR,*)' Arbitrary Traverse Parameters '

      if (verbos) then
         write(lerr,*) ' '
         write(lerr,*) ' XSD picks (record, trace, sample) '
         write(lerr,*) ' --------------------------------- '
         write(lerr,*) ' '
         do i = 1, NumVertices
            write(lerr,*) XSD_Record(i), XSD_Trace(i), XSD_Sample(i)
         enddo
      endif
      write(LERR,*)' '
      write(LERR,*)' Traverse Turning Vertices '
      write(LERR,*)' '
      do i = 1, NumVertices
         write(LERR,*)' (x', i, ',y', i, ') = (',
     :        Vertex_XY_Transformed(1,i), ',', 
     :        Vertex_XY_Transformed(2,i), ')'
      enddo

      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





