C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine grid (nz,nzeta0,nzeta,isis,fmin,fmax,lngth,lngth4,
     1                 mzeql,nzeql,zett,zett4,zeql,DZEQL)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real    zett4(0:4000), zett(0:nzeta0), zeql(0:4000)
      integer ordfft

C**********************EQUALLY-SAMPLED OUTPUT
C
C     REFINE THE DEPTH GRID TO .25 TIMES THE ORIGINAL SPACING.
C     THEN CREATE AN EQUALLY-SPACED DEPTH GRID WITH SPACING
C     EQUAL TO A SUFFICIENTLY SMALL MULTIPLE OF 10 UNITS (IN DEPTH)
C     OR .008 SEC (IN TIME), SO THAT THERE WILL BE NZEQL
C     EQUALLY-SPACED POINTS PER TRACE.
C
C
C     EQUAL-DEPTH-SAMPLED OUTPUT
C
      write(LERR,*)'grid0: ',nz,nzeta0,isis,fmin,fmax
      IF (ISIS .EQ. 0) THEN
        WRITE(LERR,*)'EQUAL-DEPTH-SAMPLED OUTPUT'
        ZETT(0) = 0.
        DO 400 JZ = 0,NZ-1
          write(LERR,*)'JZ = ',jz,' zett= ',ZETT(JZ)
          ZETT4(4*JZ) = ZETT(JZ)
          ZETT4(4*JZ+1) = ZETT(JZ)+.25*(ZETT(JZ+1)-ZETT(JZ))
          ZETT4(4*JZ+2) = ZETT(JZ)+.50*(ZETT(JZ+1)-ZETT(JZ))
          ZETT4(4*JZ+3) = ZETT(JZ)+.75*(ZETT(JZ+1)-ZETT(JZ))
400     CONTINUE
        ZETT4(4*NZ) = ZETT(NZ)
c       DZEQL = (INT(ZETT(2)-ZETT(1))/10)*10.
        dzeql = float ( nint (ZETT(2)-ZETT(1)) )
        DZEQL = AMIN1(DZEQL,50.)
        write(LERR,*)'EQUAL-DEPTH SAMPLE RATE ON OUTPUT:   ', DZEQL
      END IF

C
C     EQUAL-TIME-SAMPLED OUTPUT
C
      IF (ISIS .EQ. 1) THEN
        WRITE(LERR,*)'EQUAL-TIME-SAMPLED OUTPUT'
        FSUM = 2.*(FMIN+FMAX)
        write(LERR,*)'FSUM= ',FSUM,FMIN,FMAX
        ZETT(0) = 0.

        DO 401 JZ = 0,NZ-1
          ZETT4(4*JZ) =      JZ /FSUM
          ZETT4(4*JZ+1) =(     JZ +.25  )/FSUM
          ZETT4(4*JZ+2) =(     JZ +.50  )/FSUM
          ZETT4(4*JZ+3) =(     JZ +.75  )/FSUM
401     CONTINUE
        ZETT4(4*NZ) =      NZ /FSUM
        DZEQL = .008
        IF (FMAX .GT. 62.5) DZEQL = .004
        write(LERR,*)'EQUAL-TIME SAMPLE RATE ON OUTPUT:   ', DZEQL
      END IF

      NZEQL = 1
      write(LERR,*)'grid: ',ZETT(0),DZEQL,nz
      ZEQL(0) = ZETT(0)
      ZEQL(1) = ZEQL(0)+DZEQL
      DO 440 JZ = 3,4*NZ
        MZEQL = (ZETT4(JZ)-ZEQL(NZEQL))/DZEQL+.49
        DO 420 JZEQL = NZEQL+1,NZEQL+MZEQL
          ZEQL(JZEQL) = ZEQL(0)+JZEQL*DZEQL
420     CONTINUE
        NZEQL = NZEQL+MZEQL
c     print*,'M/Nzeqk= ',jz,mzeql,nzeql
440   CONTINUE
      NZEQL = NZEQL
      ZEQL(NZEQL) = ZEQL(0)+NZEQL*DZEQL
C**********************

      LNGTH = 400
      IF (NZ .GT.  400) LNGTH =  800
      IF (NZ .GT.  800) LNGTH = 1600
      IF (NZ .GT.  800) THEN
        write(LERR,*)'STOP ERROR: NZ > 800 '
        STOP
      END IF
      write(LERR,*)'nzeql= ',nzeql

c     LNGTH = nz
      nu = ordfft (LNGTH)
      LNGTH = 2 **nu
      LNGTH4 = 4*LNGTH
      
      

      return
      end
