C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine migset (NXI,NZ,NRAY1,NT,NTMAX,LNGTH,LNGTH4,nsi,ntrc,
     1                  dipmax,sinmax,ppmax,sqrf,trigs1,trigs2,trigs3,
     2                  trigs4,uc,p,nsamp,scalet,
     3                  tscale,df,dt,itaper,taper)

#include <f77/iounit.h>

      parameter    (pi = 3.14159265)
      integer      ordfft,itaper
      complex      uc(0:4100)
      real         tscale(0:4100)
      real         taper(*)
      real         sqrf(*)
      real         p(0:nray1)
      real         trigs1(*), trigs2(*), trigs3(*), trigs4(*)
      

      write(LERR,*)'migset: ',NXI,NZ,NRAY1,NT,NTMAX,LNGTH,LNGTH4,nsi,
     1ntrc,dipmax,sinmax,ppmax,nsamp

      nu = ordfft (nsamp)
      NT = 2 ** nu
      NTMAX = NT*nsi/2
c     if (ntmax .gt. LNGTH4) ntmax = LNGTH4

      write(LERR,*)'FORWARD FFT LENGTH FOR UNMIGRATED TRACES: ',NT
      write(LERR,*)'INVERSE FFT LENGTH FOR UNMIGRATED TRACES: ',NTMAX
      write(LERR,*)'FORWARD FFT LENGTH FOR   MIGRATED TRACES: ',LNGTH
      write(LERR,*)'INVERSE FFT LENGTH FOR   MIGRATED TRACES: ',LNGTH4

      
      DT = .001 * float(nsi)
      fnyq = 500./float(nsi)
      DF = 1./(NT*DT)
      DTINV = 2./.002
      SINMAX = AMIN1(SIN(PI*DIPMAX/180.),.9999)

C
C     FILTER COEFFICIENTS: SQRT(ABS(F))
C
      DO 402 JT = 1,NT/2
        F = (JT-1)*DF
        SQRF(JT) = SQRT(F)
402   CONTINUE

      DO 403 JT = 1,NT
        TSCALE(JT) = (FLOAT(JT))**SCALET
403   CONTINUE


C
C     FFT SETUPS FOR INPUT TRACE FILTERS
C     FFT SETUPS FOR OUTPUT TRACE SINC INTERPOLATION
C
      DO 45 JT = 1,8000
        TRIGS1(JT) = 0.
        TRIGS2(JT) = 0.
        TRIGS3(JT) = 0.
        TRIGS4(JT) = 0.
45    CONTINUE
      CALL cfftx(uc, 2, NT    , 0, 1,TRIGS1, ierr)
      CALL cfftx(uc, 2, NTMAX , 0, 1,TRIGS2, ierr)
      CALL cfftx(uc, 2, LNGTH , 0, 1,TRIGS3, ierr)
      CALL cfftx(uc, 2, LNGTH4, 0, 1,TRIGS4, ierr)
      write(LERR,*)'grid1 ',NT,NTMAX,LNGTH,LNGTH4

      write(LERR,*)'after tables',ierr
      write(LERR,*)'df= ',df
        WRITE(LERR,*)'PPMAX,P(1): ',PPMAX,P(1)
      PALIAS = P(1)/PPMAX
        WRITE(LERR,*)'PALIAS: ',PALIAS

      call vfill (1.0, taper, 1, ntrc)
      rtaper = itaper/100.
      itaper = rtaper * ntrc

      write(LERR,*)'Number of traces each side of section to taper= ',
     1              itaper

      do  10  i = 1, itaper

          fac = float(itaper - i)/float(itaper)
          taper(i) = 0.5 * (1. + cos (pi * fac))
          taper(ntrc-i+1) = taper(i)
          write(LERR,*)'Taper(',i,') = ',taper(i)

10    continue


      return
      end
