C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE TTIMES
     1   (TAU,XP,      NRAY1,      P,VZ,ZETT,      NZ,NZETA
     2    ,JZMIN,JZMAX,JPMIN,JPMAX,TAUTRN,XPTRN,SINMAX,NP
     3    ,JTIM  ,DPMAX,LHDR11,JXMIN,JXMAX,DX,DY,DR,NTMAX,NXI
     4    ,JPCRTX,JPCRTY,RCRITX,RCRITY
     4    ,JWMIN,JWMAX,PPMAX
     5    )
C
C     IN A DEPTH-DEPENDENT VELOCITY STRUCTURE,
C     FIND TRAVELTIMES FROM (0,0) TO (XXI,ZETA) -- OR BY
C     RECIPROCITY FROM (0,ZETA) TO (XXI,0) -- FOR ALL XXI
C     BETWEEN 0 AND SOME RMAX.
C     SHOOT RAYS DOWNWARD FROM (0,0) TO ALL DEPTHS.
C     HAVING COMPUTED TRAVELTIMES ALONG SELECTED RAYS
C     (GIVEN BY RAY PARAMETERS P) FROM DEPTH 0 TO DEPTH
C     ZETA-DZETA, COMPUTE TRAVELTIMES ALONG THE SAME RAYS
C     FROM ZETA-DZETA TO ZETA AND ADD TO PREVIOUSLY
C     COMPUTED TRAVELTIMES.
C     WHERE APPROPRIATE, FLIP A TURNED RAY (PROPAGATION
C     ANGLE = 90 DEGREES) ABOUT ITS TURNING POINT TO GET A
C     RAY TO INTERROGATE GREATER THAN VERTICAL DIPS.
C     BECAUSE THE CHOSEN RAYPATHS DO NOT STRIKE THE GRID
C     POINTS (JX*DX,ZETA), FIND TRAVELTIMES FROM (0,0) TO
C     (JX*DX,ZETA) BY INTERPOLATING LINEARLY FROM TWO
C     RAYPATHS WHICH STRADDLE (JX*DX,ZETA).
C
      DIMENSION TAU(0:NRAY1,0:NZETA),XP(0:NRAY1,0:NZETA),P(0:NRAY1)
      DIMENSION VZ(0:NZETA),ZETT(0:NZETA)
      DIMENSION JPMIN(0:NZETA),JPMAX(0:NZETA)
      DIMENSION TAUTRN(0:NRAY1,0:NZETA),XPTRN(0:NRAY1,0:NZETA)
      DIMENSION JZMIN(0:NRAY1),JZMAX(0:NRAY1)
      INTEGER   JTIM  (0:NXI,0:NZETA)
      DIMENSION DPMAX(0:NZETA)
      DIMENSION RCRITX(0:NZETA)
      DIMENSION RCRITY(0:NZETA)
      DIMENSION JXMIN(0:NZETA)
      DIMENSION JXMAX(0:NZETA)
      DIMENSION JWMIN(3,0:NZETA)
      DIMENSION JWMAX(3,0:NZETA)
      NRAY = NRAY1-1
      CZERO = VZ(0)


C
C     INITIALIZE TAU, XP
C
      DO 20 JP = 0,NRAY1
        XP(JP,0) = 0.
        TAU(JP,0) = 0.
        JZMIN(JP) = NZ
        JZMAX(JP) = 0
20    CONTINUE

C
C     INITIALIZE TAUTRN, XPTRN
C
      DO 60 JP = 0,NRAY
        DO 40 JZETA = 0,NZETA
          XPTRN(JP,JZETA) = 0.
          TAUTRN(JP,JZETA) = 0.
40      CONTINUE
60    CONTINUE

CWAVENUMBER FILTER START
      DO 70 JALIAS = 1,3
        DO 65 JZETA = 0,NZETA
          JWMIN(JALIAS,JZETA) = LHDR11
          JWMAX(JALIAS,JZETA) = 0
65      CONTINUE
70    CONTINUE
CWAVENUMBER FILTER END

C
C     FIRST LOOP (OVER DEPTHS).
C     RAY CALCULATIONS FOR ALL RAYS AT A FIXED DEPTH.
C
      DO 140 JZETA = 1,NZ
        ZETA = ZETT(JZETA)
        DZETA = ZETT(JZETA)-ZETT(JZETA-1)
        CZETA = VZ(JZETA)
        CZETM = VZ(JZETA-1)
        EN = CZETA/CZERO
        SLOPE = (CZETA-CZETM)/DZETA
CCC     IF (ABS(SLOPE) .LT. .0001) SLOPE = .0001
        JPMIN(JZETA) = NRAY

C
C       SECOND LOOP (OVER HORIZONTAL RAY PARAMETERS).
C

C
C       FIND RAY OF LARGEST INCIDENCE ANGLE WHICH HAS NOT YET TURNED
C
        JPMAXZ = NP
        DO 80 JP = NP-1,1,-1
          SINTHM = P(JP)*CZETM/CZERO
          IF ((SINTHM .LT. .9999) .AND. (TAU(JP,JZETA-1) .GT. -1.))
     1      JPMAXZ = JPMAXZ-1
80      CONTINUE

C
C       THE REMAINING RAYS HAVE TURNED AT A PREVIOUS DEPTH
C
        DO 100 JP = 1,JPMAXZ-1
          TAU(JP,JZETA) = -10000.
100     CONTINUE

C
C       RAY PARAMETERS JPMAXZ+1,...,NP-1
C       (NON-TURNED RAYS AT DEPTH ZETA)
C
        DO 120 JP = JPMAXZ+1,NP-1
          PP = P(JP)
          SINTH  = PP*EN
          SINTHM = PP*CZETM/CZERO
          IF (ABS(SLOPE) .GT. .001) THEN
            DXP  = (SQRT(1.-SINTHM**2)-SQRT(1.-SINTH**2))*
     1             CZERO/(PP*SLOPE)
            DTAU = ALOG((CZETA*(1.+SQRT(1.-SINTHM**2)))/
     1                  (CZETM*(1.+SQRT(1.-SINTH **2))))/SLOPE
          ELSE
            DXP  = DZETA* SINTH/SQRT(1.-SINTH**2)
            DTAU = DZETA/(CZETA*SQRT(1.-SINTH**2))
          END IF
C
C         UPDATE THE RAYPATH;
C         UPDATE THE MINIMUM DEPTH FOR THE
C         TURNED SEGMENT OF THE GIVEN RAY.
C
          XP(JP,JZETA) = XP(JP,JZETA-1)+DXP
          TAU(JP,JZETA) = TAU(JP,JZETA-1)+DTAU
          IF (SINTH .GT. SINMAX) JZMIN(JP) = MIN(JZMIN(JP),JZETA)
120     CONTINUE

C
C       SEPARATE CASE #1: RAY PARAMETER JPMAXZ
C       (THE RAY CLOSEST TO HORIZONTAL AT DEPTH ZETA)
C       EITHER
C              THE RAY IS     ABOUT TO TURN IN THE CURRENT DEPTH INTERVA
C              (INCREASING VELOCITY)
C       OR
C              THE RAY IS NOT ABOUT TO TURN IN THE CURRENT DEPTH INTERVA
C              (DECREASING VELOCITY)
C
        JP = JPMAXZ
        PP = P(JP)
        SINTH  = PP*EN
        SINTHM = PP*CZETM/CZERO
        IF (SINTH .GT. .9999) THEN
C
C         RAY IS     ABOUT TO TURN IN THE CURRENT DEPTH INTERVAL:
C         RAY PARAMETER PP SATISFIES PP = CZERO/CZETA,
C         SO THAT CZETA = VELOCITY AT THE TURNING DEPTH.
C         ASSIGN MAXIMUM DEPTH FOR RAY; COMPUTE RAYPATH INCREMENT.
C
          JZMAX(JP) = JZETA
          SQR = SQRT(1.-(PP*(CZETA-1.)/CZERO)**2)
          DXP = SQRT(1.-SINTHM**2)                    *
     1          CZERO/(PP*SLOPE)
          DTAU=ALOG((CZETA*(1.+SQRT(1.-SINTHM**2)))/
     1               CZETM                         )/SLOPE
        ELSE
C
C         RAY IS NOT ABOUT TO TURN IN THE CURRENT DEPTH INTERVAL:
C         COMPUTE RAYPATH INCREMENT.
C
          IF (ABS(SLOPE) .GT. .001) THEN
            DXP  = (SQRT(1.-SINTHM**2)-SQRT(1.-SINTH**2))*
     1             CZERO/(PP*SLOPE)
            DTAU = ALOG((CZETA*(1.+SQRT(1.-SINTHM**2)))/
     1                  (CZETM*(1.+SQRT(1.-SINTH **2))))/SLOPE
          ELSE
            DXP  = DZETA* SINTH/SQRT(1.-SINTH**2)
            DTAU = DZETA/(CZETA*SQRT(1.-SINTH**2))
          END IF
        END IF

C
C       UPDATE THE RAYPATH;
C       UPDATE THE MINIMUM DEPTH FOR THE
C       UPTURNED SEGMENT OF THE GIVEN RAY.
C
        XP(JP,JZETA) = XP(JP,JZETA-1)+DXP
        TAU(JP,JZETA) = TAU(JP,JZETA-1)+DTAU
        IF (SINTH .GT. SINMAX) JZMIN(JP) = MIN(JZMIN(JP),JZETA)

C
C       SEPARATE CASE #2: RAY PARAMETER NP (THE VERTICAL RAY)
C
        XP(NP,JZETA) = 0.0000
        DTAU = DZETA/CZETA
        TAU(NP,JZETA) = TAU(NP,JZETA-1)+DTAU
140   CONTINUE

C
C     HAVE DOWNGOING RAYPATHS AND TRAVELTIMES AT ALL DEPTHS.
C     COMBINE THESE WITH PARTIAL UPGOING RAYPATHS AND TRAVELTIMES
C     TO GET TURNED RAYPATHS AND TRAVELTIMES AT ALL DEPTHS BETWEEN
C     MIN AND MAX DEPTHS FOR WHICH RAY ANGLE EXCEEDS (180-DIPMAX) DEGREES
C
      DO 180 JP = 1,NP-20
        JZMINN = JZMIN(JP)
        JZMAXX = JZMAX(JP)
C       PRINT*,' JP, JZMIN, JZMAX',JP,JZMINN,JZMAXX
C       PRINT*,'  P,  ZMIN,  ZMAX',P(JP),ZETT(JZMINN),ZETT(JZMAXX)
C
C       FOR A GIVEN RAY AND ALL DEPTHS FOR WHICH RAY ANGLE EXCEEDS
C       (180-DIPMAX) DEGREES, FIND TURNED RAY BY SUBTRACTION.
C       ALSO FIND MIN AND MAX RAY FOR EACH OF THESE DEPTHS.
C
        DO 160 JZETA = JZMINN,JZMAXX
          TAUTRN(JP,JZETA) = 2.*TAU(JP,JZMAXX)-TAU(JP,JZETA)
          XPTRN(JP,JZETA)  = 2.* XP(JP,JZMAXX)- XP(JP,JZETA)
          JPMIN(JZETA) = MIN(JP,JPMIN(JZETA))
          JPMAX(JZETA) = JP
C         PRINT*,' JP, JZETA ',JP, JZETA
C         PRINT*,' JPMIN, JPMAX ',JPMIN(JZETA),JPMAX(JZETA)
160     CONTINUE
CCC     PRINT*,JP,ZETT(JZMAXX),XPTRN(JP,JZMAXX),TAUTRN(JP,JZMAXX)
180   CONTINUE

C
C     VELOCITY REVERSALS:  DEPTHS WHERE NO RAYS TURN.
C     FIND MIN AND MAX RAY FOR EACH OF THESE DEPTHS.
C
      CMAX = CZERO
      DO 200 JZETA = 1,NZ
        ZETA = ZETT(JZETA)
        CZETA = VZ(JZETA)
CMAY 11,1990 START
        JPMINN = NP
CMAY 11,1990 END
        IF (CZETA .LT. CMAX+.00001) THEN
CCCCC     DO WHILE ((P(JPMINN) .LT. CZERO/CZETA) .AND.
CCCCC1              (TAU(JPMINN,JZETA) .GT. 0.))
 9919     IF (.NOT.((P(JPMINN) .LT. CZERO/CZETA) .AND.
     1              (TAU(JPMINN,JZETA) .GT. 0.))) GOTO 9921
            JPMINN = JPMINN-1
CCCCC     REPEAT
 9920     GOTO 9919
 9921     CONTINUE
          IF (JPMIN(JZETA) .EQ. NRAY) THEN
            JPMIN(JZETA) = NP-19
            JPMAX(JZETA) = JPMINN
          END IF
        END IF
CMAY 11,1990 START
        IF (JPMIN(JZETA) .EQ. NRAY) THEN
          JPMIN(JZETA) = NP-19
          JPMAX(JZETA) = JPMINN
        END IF
CMAY 11,1990 END
        CMAX = AMAX1(CMAX,CZETA)
200   CONTINUE


C
C     INTERPOLATE UNTURNED- AND TURNED-RAY TRAVELTIMES ONTO
C     REGULAR (X,Z) GRID.
C
      EPS = .01*DX
      CMAX = CZERO
      DO 400 JZETA = 1,NZ
        ZETA = ZETT(JZETA)
        CZETA = VZ(JZETA)
        IF (CZETA .GT. CMAX) CMAX = CZETA
CCC     PRINT*, ' JZETA, ZETA, JPMIN, JPMAX'
CCC     PRINT*,   JZETA, ZETA, JPMIN(JZETA), JPMAX(JZETA)

C
C       INITIALIZE TRAVELTIMES, MIN AND MAX OFFSETS
C
        DO 220 JXOFST = 0,LHDR11
          JTIM  (JXOFST,JZETA) = NTMAX
220     CONTINUE
        JXMIN(JZETA) = LHDR11
        JXMAX(JZETA) = 0

C
C       FOR EACH PAIR OF ADJACENT RAYS, FIND RAY ENDPOINTS AND
C       TRAVELTIMES FOR INTERPOLATION ONTO OUTPUT TRACE GRID
C       (EQUALLY-SPACED TRAVELTIME CURVE FOR UPGOING WAVE).
C       PERFORM THIS BOTH FOR UNTURNED RAYS (XP, TAU) AND
C       TURNED RAYS (XPTRN, TAUTRN).  UNTURNED RAYS HAVE RAY
C       PARAMETERS NUMBERED FROM NP TO JPMIN; TURNED RAYS HAVE
C       RAY PARAMETERS NUMBERED FROM JPMAX TO JPMIN.
C

C
C       DOWNGOING RAYS, CORRESPONDING TO SIS PROGRAM BORN.
C

C
C       REDUCE MAX DOWNGOING RAY PARAMETER IF NEEDED
C       TO ACCOMMODATE DIPMAX < 90 DEGREES.
C
        JPMINN = JPMIN(JZETA)
        IF (DPMAX(JZETA) .LT. 1.571) THEN
          PMINN = SIN(DPMAX(JZETA))*CZERO/VZ(JZETA)
          JP = 1
CCCCC     DO WHILE ((JP .LT. NP) .AND. (P(JP) .GT. PMINN))
 9929     IF (.NOT.((JP .LT. NP) .AND. (P(JP) .GT. PMINN))) GOTO 9931
            JP = JP+1
CCCCC     REPEAT
 9930     GOTO 9929
 9931     CONTINUE
          JPMINN = MAX(JP,JPMINN)
        END IF

C
C       DIFFRACTION CURVE SEGMENTS, FROM NEARLY VERTICAL RAYS (NP-1)
C       TO MAXIMUM DOWNGOING RAY (JPMINN)
C
        DO 260 JP = NP-1,JPMINN,-1
CWAVENUMBER FILTER START
C
C         IN 3-D, WILL NEED PPMAXX, PPMAXY, JALIASX, JALIASY; THEN
C         JWAVE(JXOFST,JYOFST,JZETA) WILL BE CONSTANT WITHIN ELLIPSE
C         DEFINED BY MAXIMUM OFFSETS OF CONSTANT JALIASX = JALIASY.
C
          JALIAS = 1
CC        IF (P(JP)/PPMAX .GT. 1.) JALIAS = 2
CC        IF (P(JP)/(PPMAX+P(1)) .GT. .5 ) JALIAS = 3
          IF (P(JP)/PPMAX .GT. .67) JALIAS = 2
          IF (P(JP)/(PPMAX+P(1)) .GT. .33) JALIAS = 3
CWAVENUMBER FILTER END
          T0     = TAU(JP+1,JZETA)
          T1     = TAU(JP,JZETA)
          X0     =  XP(JP+1,JZETA)
          X1     =  XP(JP,JZETA)
          JX0    = X0/DR
          JX1    = X1/DR
          JXLEFT = MIN(JX0,JX1)
          JXRGHT = MAX(JX0,JX1)
          JXLEFT = MIN(JXLEFT,LHDR11)
          JXRGHT = MIN(JXRGHT,LHDR11-1)
          JXMAX(JZETA)  = MAX(JXMAX(JZETA),JXRGHT)
          IF (ABS(X1-X0) .LT. EPS) THEN
            SLOPE = 0.
          ELSE
            SLOPE = (T1-T0)/(X1-X0)
          END IF

          DO 240 JXOFST = JXLEFT,JXRGHT
C
C           LINEAR INTERPOLATION:
C           INTERPOLATE BETWEEN TAU(JP-1,JZETA) AND TAU(JP,JZETA)
C           FOR XOFST BETWEEN XP(JP-1,JZETA) AND XP(JP,JZETA)
C
            JTT = 1000.*(T0+SLOPE*(JXOFST*DR-X0))
            JTIM  (JXOFST,JZETA) = MIN(JTT,NTMAX)
            JWMIN(JALIAS,JZETA) = MIN(JXLEFT,JWMIN(JALIAS,JZETA))
            JWMAX(JALIAS,JZETA) = JXRGHT
240       CONTINUE
260     CONTINUE
        JTT = 1000.*TAU(NP,JZETA)
        JTIM  (0,JZETA) = MIN(JTT,NTMAX)
        JXMIN(JZETA)  = 1
        JWMIN(1,JZETA) = 0

C
C       TURNED RAYS, EXTENDING PROGRAM BORN.
C
        JPMAXX = JPMAX(JZETA)

        IF (DPMAX(JZETA) .LT. 1.571) THEN
C
C         MAX DIP < 90 DEGREES (NO TURNED RAYS): DISABLE THE NEXT LOOP
C
          JPMAXX = JPMINN-1
        ELSE
C
C         MAX DIP > 90 DEGREES:  FIND MAXIMUM TURNED RAY PARAMETER
C
          PMAXX = SIN(DPMAX(JZETA))*CZERO/VZ(JZETA)
          JP = 1
CCCCCC    DO WHILE (P(JP) .GT. PMAXX)
 1919     IF (.NOT.(P(JP) .GT. PMAXX)) GOTO 1921
            JP = JP+1
CCCCCC    REPEAT
 1920     GOTO 1919
 1921     CONTINUE
          JPMAXX = MIN(JP,JPMAXX)
C         PRINT*,JZETA,ZETT(JZETA),JPMINN,JPMAXX,JPMIN(JZETA)
        END IF

C
C       DIFFRACTION CURVE SEGMENTS, FROM MAXIMUM TURNED RAY (JPMAXX)
C       TO MINIMUM TURNED RAY (JPMINN)
C
        DO 300 JP = JPMAXX-1,JPMINN,-1
CWAVENUMBER FILTER START
C
C         IN 3-D, WILL NEED PPMAXX, PPMAXY, JALIASX, JALIASY; THEN
C         JWAVE(JXOFST,JYOFST,JZETA) WILL BE CONSTANT WITHIN ELLIPSE
C         DEFINED BY MAXIMUM OFFSETS OF CONSTANT JALIASX = JALIASY.
C
          JALIAS = 1
CC        IF (P(JP)/PPMAX .GT. 1.) JALIAS = 2
CC        IF (P(JP)/(PPMAX+P(1)) .GT. .5 ) JALIAS = 3
          IF (P(JP)/PPMAX .GT. .67) JALIAS = 2
          IF (P(JP)/(PPMAX+P(1)) .GT. .33) JALIAS = 3
CWAVENUMBER FILTER END
          T0     = TAUTRN(JP+1,JZETA)
          T1     = TAUTRN(JP  ,JZETA)
          X0     =  XPTRN(JP+1,JZETA)
          X1     =  XPTRN(JP  ,JZETA)
          JX0    = X0/DR
          JX1    = X1/DR
          JXLEFT = MIN(JX0,JX1)
          JXRGHT = MAX(JX0,JX1)
          JXLEFT = MIN(JXLEFT,LHDR11)
          JXRGHT = MIN(JXRGHT,LHDR11-1)
          JXMIN(JZETA)  = MIN(JXMIN(JZETA),JXLEFT)
          JXMAX(JZETA)  = MAX(JXMAX(JZETA),JXRGHT)
          IF (ABS(X1-X0) .LT. EPS) THEN
            SLOPE = 0.
          ELSE
            SLOPE = (T1-T0)/(X1-X0)
          END IF

          DO 280 JXOFST = JXLEFT,JXRGHT
C
C           LINEAR INTERPOLATION:
C           INTERPOLATE BETWEEN TAUTRN(JP-1,JZETA) AND TAUTRN(JP,JZETA
C           FOR XOFST BETWEEN XPTRN(JP-1,JZETA) AND XPTRN(JP,JZETA)
C
            JTT = 1000.*(T0+SLOPE*(JXOFST*DR-X0))
            JTT1 = JTIM  (JXOFST,JZETA)
              JTIM  (JXOFST,JZETA) = MIN(JTT1,JTT,NTMAX)
C           IF (JTT .LT. JTT1) THEN
C             JTIM  (JXOFST,JZETA) = MIN(JTT,NTMAX)
              JWMIN(JALIAS,JZETA) = MIN(JXLEFT,JWMIN(JALIAS,JZETA))
              JWMAX(JALIAS,JZETA) = MAX(JXRGHT,JWMAX(JALIAS,JZETA))
C           END IF
280       CONTINUE
300     CONTINUE

C
C       3-D CODE:  LARGEST OFFSET IN DIFFRACTION CURVE IS LIMITED
C                  IN X AND/OR Y
C                  IF MAXIMUM RAY PARAMETER IS TOO SMALL OR
C                  IF THERE IS NO RAY WHICH TURNS AT DEPTH ZETA.
C
        RCRITX(JZETA) = JXMAX(JZETA)*DR
        JPMINX = MAX(JPMINN,JPCRTX)
CC      IF ((JPCRTX .GT. JPMINN) .OR. (CZETA .LT. CMAX)) THEN
        IF (JPCRTX .GT. JPMINN) THEN
          RCRITX(JZETA) = AMAX1(XP(JPMINX,JZETA),XPTRN(JPMINX,JZETA))
          IF (
     1      (XPTRN(JPMINX,JZETA)-XP(JPMINX,JZETA))/(XP(JPMINX,JZETA)+1.)
     2         .GT.
     3      .1
     4       ) RCRITX(JZETA) = XP(JPMINX,JZETA)
        END IF

        RCRITY(JZETA) = JXMAX(JZETA)*DR
        JPMINY = MAX(JPMINN,JPCRTY)
CC      IF ((JPCRTY .GT. JPMINN) .OR. (CZETA .LT. CMAX)) THEN
        IF (JPCRTY .GT. JPMINN) THEN
          RCRITY(JZETA) = AMAX1(XP(JPMINY,JZETA),XPTRN(JPMINY,JZETA))
          IF (
     1      (XPTRN(JPMINY,JZETA)-XP(JPMINY,JZETA))/(XP(JPMINY,JZETA)+1.)
     2         .GT.
     3      .1
     4       ) RCRITY(JZETA) = XP(JPMINY,JZETA)
        END IF

400   CONTINUE

      RETURN
      END
