C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE DIX(vtap,VRMS,TeIME,VINT,DEPTH,VUP,ZUP,NVEL,
     1               scalev, flat, tdfn)
C
C     CALCULATE A FIRST ORDER INTERVAL VELOCITY
C     FUNCTION FROM A SET OF TIMES AND RMS (STACKING) VELOCITIES

#include <f77/iounit.h>

      character vtap*(*)
      REAL VRMS(*),VINT(*),TeIME(*),DEPTH(*)
      REAL VUP(0:4000),ZUP(0:4000)
      real scalev
      INTEGER IVRMS(1000),ITIME(1000)
      logical flat, tdfn

c  read in depth vs interval velocities
      write(LERR,*)'vread: ',vtap

           luvel = 29

           open(unit=luvel, file=vtap, status='old', iostat=ierr)

           if(ierr .ne. 0) then
              write(LERR,*)'Could not open velocity file'
              write(LERR,*)'Check existence'
              stop
           endif


      DO 20 J = 1,1000
        IVRMS(J) = 0
        ITIME(J) = 0
20    CONTINUE

C
C     READ IN VRMS AND TIME(MS)
C

      IF (tdfn) THEN

      N = 0
      J = 0
      write(LERR,*)'VELOCITIES FROM TDFN CARDS'
40    J = J+1
      READ(luvel,1000,END = 80) (ITIME(JJ),IVRMS(JJ),JJ = 7*(J-1)+1,7*J)
      WRITE(LERR,1000) (ITIME(JJ),IVRMS(JJ),JJ = 7*(J-1)+1,7*J)
      DO 60 JJ = 7*(J-1)+1,7*J
        IF (IVRMS(JJ) .NE. 0) N = N+1
C       PRINT*,ITIME(JJ),IVRMS(JJ)
60    CONTINUE
      GO TO 40
80    CONTINUE

      ELSEIF( flat ) THEN

      N = 0
      J = 0
140   continue
      j = j + 1
      READ(luvel,*,end=180) itime(j),ivrms(j)
      write(LERR,*)'VELOCITIES FROM vmod FILE',j,itime(j),ivrms(j)
      if (itime(j) .ge. 0) then
         go to 140
      else
         N = J - 1
         go to 180
      endif

      ENDIF

180   continue

      write(LERR,*)'Number of Velocities= ',N
1000  FORMAT (5X,7(I4,I5),12X)
      DO 100 J = 1,N
        TeIME(J) = ITIME(J)
        VRMS(J) = IVRMS(J) * scalev
100   CONTINUE
      if (TeIME(1) .ne. 0.0) TeIME(1) = 0.0


C
c     Interval Velocity Computation
C
      CALL VINTER( N, VRMS, TeIME, VUP  , ZUP   , NVEL )

      RETURN
      end

c * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


      SUBROUTINE VINTER( N, VRMS, TeIME, SVINT, DDEPTH, NN )

c     This routine computes a Dix estimate of Interval Velocities
c     and Depths from RMS Velocities and 2-Way Travel Times

c     n       = # of velocity layers            (input)
      integer n
c     vrms    = rms velocity                    (input)
      real    vrms(*)
c     time    = two way travel time in millsec. (input)
      real    teime(*)
c     vint    = interval velocity               (output)
C     REAL    VINT(*)
c     depth   = depth of layer                  (output)
C     REAL    DEPTH(*)
C     TTIME   = RESAMPLED TIMES IN MILLSEC.     (OUTPUT)
      REAL    TTIME(0:4000)
C     VVRMS   = RESAMPLED VRMS                  (OUTPUT)
      REAL    VVRMS(0:4000)
C     DDEPTH  = RESAMPLED DEPTHS                (OUTPUT)
      REAL    DDEPTH(0:4000)
C     VVINT   = RESAMPLED VINT                  (OUTPUT)
      REAL    VVINT(0:4000)
C     SVINT   = SMOOTHED RESAMPLED VINT         (OUTPUT)
      REAL    SVINT(0:4000)
C     NN      = # OF RESAMPLED VELOCITY LAYERS  (OUTPUT)
      INTEGER NN


C     INTERPOLATE AND RESAMPLE VRMS TO .004 SEC.
      DO 40 I = 1,N-1
        T1 = TeIME(I)
        T2 = TeIME(I+1)
        V1 = VRMS(I)
        V2 = VRMS(I+1)
	SLOPE = ( V2 - V1 ) / ( T2 - T1 )
        IT1 = T1/4.
        IT2 = T2/4.
        DO 20 ITIME = IT1,IT2
          TTIME(ITIME) = 4.*ITIME
          VVRMS(ITIME) = V1+((v2-v1)/(t2-t1))*(TTIME(ITIME)-T1)
20      CONTINUE
40    CONTINUE
      NN = IT2

c     Initialize first velocity, depth
      VVINT(0)=VVRMS(0)
C      DEPTH(1)= VINT(1)* TIME(1)/2000.
      DDEPTH(0)=VVINT(0)*TTIME(0)/2000.

C     NOT RESAMPLED
C     IF(N.GT.1) THEN
C      DO 100 I=1,N-1
C       T2   = TIME(I+1)/1000.
C       T1   = TIME(I  )/1000.
C       DELT = T2 -T1
C       ARG  = ( VRMS(I+1)**2 * T2 - VRMS(I  )**2 * T1 )/DELT
C       VINT(I+1)=SQRT(ARG)
C       DEPTH(I+1)=DEPTH(I)+VINT(I+1)*DELT/2.
c100    CONTINUE
C     ENDIF

C         RESAMPLED
      IF (NN .GT. 0) THEN

      DO 200 II = 1,NN
        TT2 = TTIME(II)/1000.
        TT1 = TTIME(II-1)/1000.
        DDELT = TT2-TT1
        ARG = ( VVRMS(II)**2 * TT2 - VVRMS(II-1)**2 * TT1 )/DDELT
        VVINT(II) = SQRT(ARG)
        DDEPTH(II) = DDEPTH(II-1)+VVINT(II)*DDELT/2.
 200  CONTINUE

      ENDIF

C
C     SMOOTH THE DIX INTERVAL VELOCITIES
C     OBTAINED FROM THE RESAMPLED RMS VELOCITIES
C
      NAVE = 50
      NAVE = (NAVE/2)*2+1
      SVINT(0) = VVINT(0)
      DO 12 I = 1,NAVE/2
        SVINT(I) = 0.
        DO 11 JAVE = 1,2*I-1
          SVINT(I) = SVINT(I)+VVINT(JAVE)
11      CONTINUE
        SVINT(I) = SVINT(I)/(2.*I-1)
12    CONTINUE
      DO 16 I = NAVE/2+1,NN-NAVE/2
        SVINT(I) = 0.
        DO 14 JAVE = 1,NAVE
          SVINT(I) = SVINT(I)+VVINT(I-NAVE/2+JAVE-1)
14      CONTINUE
        SVINT(I) = SVINT(I)/NAVE
16    CONTINUE
      DO 18 I = NN-NAVE/2+1,NN
        SVINT(I) = VVINT(I)
18    CONTINUE


      return
      end
