C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       BSSTK                                                *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  PERFORM 2D-FFT, WEDGE FILTER, WEIGHT EACH RECORD,         *
C          - INVERSE 2-D-FFT AND POWER STACK                           *
C          - ITYPE       (TYPE OF FILTER TO APPLY)                     *
C          - = 1=ZERO INNER RING           (PDSCI)                     *
C          - = 2=ZERO INNER AND OUTER RING (PDISC)                     *
C          - = 3=ZERO OUTER RING           (PDSCO)                     *
C          - = 4=APPLY A PIE FILTER        (PPIE)                      *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 87/11/05  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/09/12  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      cmdlin          -                                               *
C      LBOPEN          -                                               *
C      OPENPR          -                                               *
C      GAMOCO          -                                               *
C      ICOPEN  INTEGER -                                               *
C      RTAPE           -                                               *
C      VMOV            -                                               *
C      PWROF2          -                                               *
C      WRTAPE          -                                               *
C      MOVE            -                                               *
C      WEDGEI          -                                               *
C      XBSSTK          -                                               *
C      LBCLOS          -                                               *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C      ABS     GENERIC -                                               *
C      ATAN    GENERIC -                                               *
C      SIN     GENERIC -                                               *
C  FILES:                                                              *
C      LCRD   ( INPUT  SEQUENTIAL ) - CARD FILE                        *
C      LPRT   ( OUTPUT SEQUENTIAL ) - PRINTER FILE                     *
C      LLIST  (        SEQUENTIAL ) - FREE LOGICAL UNIT                *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      200      ( 2) - printfile errors                                *
C      50       ( 3) - card file errors                                *
C      =BLANK=  ( 6) - no errors                                       *
C      75       ( 2) - tapeio errors                                   *
C      100      ( 1) - user errors                                     *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  THIS ROUTINE READS AN SIS TAPE INTO 2-D ARRAY *
C       - 2-D FFT APPLIED, WEDGE FILTER APPLIED, INVERSE 2-D FFT APPLIE*
C       - THEN RECORD IS WEIGHTED AND POWER-STACKED INTO A 2-D ARRAY   *
C       - THEN OUTPUT TO SIS TAPE                                      *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/09/12  *
C            - Corrected error in a sign, and added printout, acct.,etc*
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 88/09/23  *
C            - removed reference to ipad-user does not have the option *
C            - to do extra zero padding. Padding will be done to the   *
C            - next power of 2 automatically.                          *
C            - allowed 2048 samples per trace limitation               *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 89/08/15  *
C            - increased no. traces limit to 2048                      *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 90/08/15  *
C            - Changed bsct.f to bsstk.f to increase no. records and   *
C            - replace all the angle cards with only one card that     *
C            - contains no. angles, starting angle, angle increment    *
C            - and move the beamwidth to the BSSTK card and set all    *
C            - weights to 1.0 inside the code                          * 
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/01/30  *
C            - Changed code to have a starting and ending recordi      *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/08/30  *
C            - Move code to sun for maintenance/distribution           *
C  REVISED BY:  MARY ANN THORNTON   V:2.1     REVISION DATE: 92/03/11  *
C            - Call openpr with full program name, compatible w/OS6.1  *
C            - Remove word size references to run on 32 Bit machine
C            - This routine requires lib.routines not available on Sun
C  REVISED BY:  MARY ANN THORNTON   V:2.2     REVISION DATE: 92/04/24  *
C            - remove the f8x syntax from xbsstk routine to run on   
C            - 32 bit machine
C  REVISED BY:  MARY ANN THORNTON   V:2.3     REVISION DATE: 93/04/04  *
C            - Change line header size, add LER for HP, 
C            - and make all command line arguments.
C            - program will still read the cards if they are present,
C            - but the option is not advertised in the man page or pattern
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      PARAMETER (MXTRA=2048, MXSAM=2048, LHEAD=SZLNHD)
      PARAMETER (MXXXX=MXSAM+ITRWRD,LCRD=25,LPRT=26,LLIST=27)
      PARAMETER (MSPACE=MXTRA*7, MXTOT=MXTRA*MXSAM)
c     mspace must be max(4*ksam2+6,ltr*7)

#ifdef HPUXSYSTEM
c     unit 7 should be pre-connected to stderr on HP systems
      parameter (LER=7)
#else
      parameter (LER=0)
#endif
C
      DIMENSION IHEAD(LHEAD),PARM(6),WPARM(11,2),PARM0(5)
      DIMENSION RXX(MXXXX),DATA(MXSAM),A(MXTOT)
      DIMENSION B(MXTOT),WRK(MSPACE)
C
      INTEGER*2 IRX(LNTRHD),ITHD(LNTRHD,MXTRA)
C
      LOGICAL VERBOS
      CHARACTER*1 CARD(80),parr(66)
      CHARACTER*4 VERSION,NAME,GIASC
      CHARACTER*5 PPNAME
      CHARACTER*128 NTAP,OTAP,INPUT
C
      EQUIVALENCE (CARD(1),NAME)
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))
      DATA VERSION/'2.3 '/
      DATA PPNAME/'BSSTK'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ',' ',' ','B','A','C','K','S','C','A','T','T','E','R',' ',
     3'S','T','A','C','K',' ',' ',' ',' ',' ',' ',
     3          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/
C
C
      LTRM = LER
      R1   = 0
      R2   = 0
      R3   = 0
      R4   = 0
      IERR  =  0
      call cmdlin(NTAP,OTAP,INPUT,ipow,dx,vref,dtms,bw,istart,
     &           iend,nang,angstrt,anginc,IPIPI,IPIPO,LTRM,VERBOS)
      IF(IPIPI.EQ.0) THEN
C        LU1 IS A INPUT DATASET
         CALL LBOPEN(LU1,NTAP,'r')
      ELSE
C        WE KNOW LU1 IS A PIPE
         LU1=0
      ENDIF
      IF(IPIPO.EQ.0) THEN
C        LU2 IS A OUTPUT DATASET
         CALL LBOPEN(LU2,OTAP,'w')
      ELSE
C        WE KNOW LU2 IS A PIPE
         LU2=1
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     ITYPE  = 4=APPLY A PIE FILTER        (PPIE)
C     Note:  = DATA WILL BE PADDED TO NEXT POWER OF 2 and
C              DATA WILL BE PADDED TO NEXT POWER OF 2 IF IT IS AN EXACT
C              POWER OF TWO TO START WITH
C     DX     = TRACE SPACING
C     DTMS   = TIME IN MS
C     BW     = BEAM WIDTH
C     BW TO CALCULATE THE SIZE OF THE WEDGE FOR THE PIE FILTER
C     BW IS RECORD VARIABLE AND READ IN IN DO-500-LOOP WITH ANGLE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      JERR = 0
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include <mbsdate.h>
      NLIN = 1
      CALL GAMOCO(PARR,NLIN,LPRT)
      WRITE(LPRT,38)NTAP,OTAP
   38 FORMAT(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
      JERR = 0
      ncards = 0
      IF(INPUT.NE.' ')THEN
         OPEN(UNIT=LCRD,FILE=INPUT,STATUS='OLD',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE(LPRT,*)'  ERROR OPENING EXTERNAL CARD FILE'
            STOP 50
         ENDIF
         NCARDS = 1
      ELSE
         N=ICOPEN('-bsstk.crd',LCRD)
         if(n.gt.0)NCARDS = 1
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ CARDS  if there are any
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
    4 CONTINUE
      ITYPE = 4
      if(ncards.gt.0)then
        IREAD=1
        READ(LCRD,5,ERR=3000)CARD
    5   FORMAT(80A1)
        READ(LCRD,55)IPOW,DX,VREF,DTMS,BW,ISTART,IEND
   55   FORMAT(I10,4F10.0,2I10)
      endif
      IF(IPOW.EQ.0)IPOW=1

C     INPUT LINE HEADER
      JEOF = 0
      CALL RTAPE(LU1,IHEAD,JEOF)
      IF(JEOF.EQ.0)GO TO 1000
      CALL SAVER(IHEAD, 'NumTrc', LTR, LINHED)
      CALL SAVER(IHEAD, 'NumRec', NREC, LINHED)
      CALL SAVER(IHEAD, 'SmpInt', ISI, LINHED)
      CALL SAVER(IHEAD, 'NumSmp', KSAMP, LINHED)
      CALL SAVER(IHEAD, 'Format', IFORM, LINHED)
      IF(DTMS.EQ.0.) DTMS = ISI
      DT = DTMS/1000.
      if(iend.gt.nrec .or. iend.le.0)iend=nrec
      if(istart.le.0 .or. istart.gt.nrec)istart=1
      mrec = iend-istart+1
      WRITE(LPRT,10)
   10 FORMAT (/////, 27X, 'PROGRAM PARAMETERS',//)
      WRITE(LPRT,25)IPOW,DX,VREF,DTMS,BW,istart,iend
   25 FORMAT(
     *' STACKING POWER                         ', 10X,'=', I10,   //,
     *' DELTA-X                                ', 10X,'=', F10.3, //,
     *' REFERENCE VELOCITY                     ', 10X,'=', F10.3, //,
     *' DELTA-T (MS)                           ', 10X,'=', F10.3, //,
     *' BEAMWIDTH                              ', 10X,'=', F10.3, //,
     *' STARTING RECORD TO PROCESS             ', 10X,'=', I10  , //,
     *' ENDING RECORD TO PROCESS               ', 10X,'=', I10  )

   50 CONTINUE
      IF(ITYPE.EQ.4)WRITE(LPRT,*)' APPLY A PIE FILTER'
C
      IF(LTR.GT.MXTRA)THEN
         WRITE(LPRT,*)' ERROR*****MAXIMUM NO. TRACES ALLOWED IS ',MXTRA
         STOP 100
      ENDIF
      IF(KSAMP.GT.MXSAM)THEN
         WRITE(LPRT,*)' ERROR*****MAXIMUM NO. SAMPLES ALLOWED IS ',MXSAM
         STOP 100
      ENDIF
C     GET GROUP INTERVAL FROM LINE HEADER FOR TRACE SPACING
      IF(DX.LE.0.0)THEN
         CALL SAVER(IHEAD, 'GrpInt', GIASC, LINHED)
         READ(GIASC,23,IOSTAT=IERR)DX
   23    FORMAT(F8.0)
         IF(IERR .NE. 0) THEN
           WRITE(LPRT,*)'BAD READ ON GROUP INTERVAL FROM LINEHEADER'
           STOP 999
         ELSE
           WRITE(LPRT,*)'GROUP INTERVAL READ FROM LINEHEADER ', DX
         ENDIF
         IF(DX.LE.0.0)THEN
            WRITE(LPRT,*)'  GROUP INTERVAL IN HEADER LE ZERO'
            WRITE(LPRT,*)'  YOU MUST ENTER DX FOR TRACE SPACING'
            STOP 100
         ELSE
            WRITE(LPRT,*)' GROUP INTERVAL USED FOR TRACE SPACING',DX
         ENDIF
      ENDIF
      IF(ITYPE.NE.0)THEN
         CALL PWROF2(KSAMP,KPOW)
         KSAM2 = 2**KPOW
         IF(KSAM2.GT.MXSAM)THEN
      WRITE(LPRT,*)' ERROR****MAX. SAMPLES EXCEEDED AT NEXT POWER OF 2'
            STOP
         ENDIF
         IF(KSAM2.EQ.KSAMP) THEN
           KPOW=KPOW+1
           KSAM2=2**KPOW
           IF(KSAM2.GT.MXSAM)THEN
         WRITE(LPRT,*)' ERROR***MAX. SAMPLES EXCEEDED AT EXTRA ZERO-PAD'
              STOP
           ENDIF
         ENDIF

         PI     = 4.0*ATAN(1.0)
         TWOPI  = 2. * PI
         RADIAN = PI/180.
         DEGREE = 180./PI

         CALL PWROF2(LTR,LPOW)
         LTR2 = 2**LPOW
         X    = FLOAT(LTR2)*DX
         DKX  = TWOPI/X
         RAMP = DKX
         T    = FLOAT(KSAM2)*DT
         DW   = TWOPI/T
CMAT
         R1   = TWOPI/X
         R2   = TWOPI/X
         R3   = TWOPI/DT
         R4   = TWOPI/DT
CMAT
         IF(VERBOS)WRITE(LPRT,37)DKX,DW,X,T
   37 FORMAT(/
     *' DELTA KX                               ', 10X,'=', F10.6, //,
     *' DELTA OMEGA                            ', 10X,'=', F10.3, //,
     *' SIZE IN THE X DIRECTION                ', 10X,'=', F10.3, //,
     *' SIZE IN THE T DIRECTION                ', 10X,'=', F10.3,/)

         PARM(1) = DKX
         PARM(2) = DW
         PARM(3) = R1
         PARM(4) = R2
         PARM(5) = R3
         PARM(6) = R4
         PARM0(1)= DKX
         PARM0(2)= DW
         PARM0(5)= RAMP
      ELSE
         LTR2  = LTR
         KSAM2 = KSAMP
      ENDIF
      KZMIN = 1
      KZMAX = KSAM2/2
C     IF SUMMING ONLY, DON'T NEED THE EXTRA POWER-OF-2 SPACE
C
      CALL SAVEW(IHEAD, 'NumRec', 1, LINHED)
      LEN=4
      CALL WRTAPE(LU2,IHEAD,JEOF)
      IF(VERBOS)WRITE(LPRT,36)  MREC
   36 FORMAT(
     *' NUMBER OF RECORDS TO PROCESS           ', 10X,'=', I10)
C
      IPARM = 6
      IF((ITYPE.EQ.1) .OR. (ITYPE.EQ.3))THEN
         IPARM = 4
      ENDIF
      IW=22
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  START PROCESSING DATASET                                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL VCLR(A,1,(MXSAM*MXTRA))
   95 CONTINUE
      if(ncards.gt.0)then
        IREAD=5
        READ(LCRD,5,ERR=3000)CARD
        READ(LCRD,56)NANG, ANGSTRT, ANGINC
      endif
      if(istart.gt.1)then
        ntrc = (istart-1)*ltr
CCCCCCCCnbytes = 4 * ksamp + 2 * 128
C     cray data on tape is ibm-word-sized (4 bytes)
        NBYTES = 4 * KSAMP + SZTRHD
        call skipt(lu1, ntrc, NBYTES)
      endif
      ANGLE = ANGSTRT + ((ISTART-1)*ANGINC) - ANGINC 
      BW = ABS(BW)
      WEIGHT = 1.0
   56 FORMAT(I10,2F10.0)
      DO 500 MR=ISTART,IEND
         IF(ITYPE.EQ.4) THEN
            ANG1 = ANGLE + ANGINC
            ANGLE = ANG1
            IF(VERBOS)WRITE(LPRT,59)MR,ANG1
   59       FORMAT('  PROCESSING RECORD ',I5,' ANGLE ',F6.2)
            ANG2 = ANG1 - BW
            IF(ANG2.LT.-90.) ANG2 = -90.
            IF(ANG2.GT. 90.) ANG2 =  90.
            ANG1 = ANG1 + BW
            IF(ANG1.LT.-90.) ANG1 = -90.
            IF(ANG1.GT. 90.) ANG1 =  90.
            SANG1 = 2.* SIN(ANG1*RADIAN)
            SANG2 = 2.* SIN(ANG2*RADIAN)
            IF(SANG1.NE. 0.) THEN
             A1 = ATAN(VREF/SANG1) * DEGREE
            ELSE
             A1 = 90.
            ENDIF
            IF(SANG2.NE. 0.) THEN
             A2 = ATAN(VREF/SANG2) * DEGREE
            ELSE
             A2 = 90.
            ENDIF
            IF(A1 .LT.  0.) A1 =  A1+180.
            IF(A2 .LT.  0.) A2 =  A2+180.
            IF(A1 .LT. A2) THEN
               ANG1 = A1
               ANG2 = A2
            ELSE
               ANG1 = A2
               ANG2 = A1
            ENDIF
            IF(ANG1 .LT.   0.) ANG1 = 0.
            IF(ANG1 .GT. 180.) ANG1 = 180.
            IF(ANG2 .LT.   0.) ANG2 = 0.
            IF(ANG2 .GT. 180.) ANG2 = 180.

            PARM0(3)=ANG1
            PARM0(4)=ANG2
            CALL WEDGEI(LTR2,PARM0,WPARM)
            IW = 11*2
         ENDIF

         LA=1
         DO 100 L= 1,LTR
            JEOF=0
            CALL RTAPE(LU1,RXX,JEOF)
            IF(JEOF.EQ.0)GO TO 1500
            CALL VMOV(RXX,1,ITHD(1,L),1,ITRWRD)
            CALL VMOV(DATA,1,A(LA),1,KSAMP)
            LA=LA+KSAM2
  100    CONTINUE

         IF(LTR2.LE.LTR)GO TO 120
            DO 110 L=LTR+1,LTR2
               CALL VCLR(A(LA),1,KSAM2)
               LA=LA+KSAM2
  110       CONTINUE
  120    CONTINUE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C   CALL THE WEDGE FILTER AND POWER STACK ROUTINE
C   FILTERED DATA RETURNED IN B-ARRAY
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL XBSSTK(WEIGHT,A,B,PARM,KZMIN,KZMAX,KSAM2,LTR2,ITYPE,
     1WPARM,IERR,MR,IPOW,IEND,WRK)
      IF(IERR.NE.0)GO TO 2000
  500 CONTINUE
      IF(VERBOS)WRITE(LPRT,*) '  PROCESSING SUMMED RECORD '
      LA=1
      DO 600 L=1,LTR
         ITHD(106,L) = 1
         ITHD(107,L) = L
         CALL VMOV(ITHD(1,L),1,IRX,1,ITRWRD)
         CALL VMOV(B(LA),1,DATA,1,KSAMP)
         LA=LA+KSAM2
         CALL WRTAPE(LU2,RXX,JEOF)
         IF(JEOF.EQ.0)GO TO 1600
  600 CONTINUE
      WRITE(LPRT,*) ' JOB COMPLETE '
      ICODE = 0
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(LPRT,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER FROM TAPE')
      CALL LBCLOS(LU1)
      CALL LBCLOS(LU2)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(LPRT,1510)MR,L
 1510 FORMAT(2X,'TAPEIO ERROR ON RECORD',I5,' TRACE',I5)
      ICODE = 75
      GO TO 5000
 1600 CONTINUE
      WRITE(LPRT,1610)L
 1610 FORMAT(2X,'TAPEIO ERROR ON OUTPUT TRACE',I5)
      ICODE = 75
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                          ERRORS FROM FILTER SUBROUTINES              C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 2000 CONTINUE
      WRITE(LPRT,*)'  ERROR FROM XBSSTK = ',IERR
      ICODE = 100
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                          READ CARD ERRORS                            C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 3000 CONTINUE
      WRITE(LPRT,*)'  ERROR READING INPUT CARDS ON READ ',IREAD
      ICODE=50
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                             END OF JOB                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 5000 CONTINUE
      CALL LBCLOS(LU1)
      CALL LBCLOS(LU2)
      IF(ICODE.EQ.0)STOP
      IF(ICODE.EQ.50)STOP 50
      IF(ICODE.EQ.75)STOP 75
      IF(ICODE.EQ.100)STOP 100
      IF(ICODE.EQ.200)STOP 200
      STOP
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       cmdlin                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  Get command line arguments                                *
C  AUTHOR:   Mary Ann Thornton                  ORIGIN DATE: 88/09/12  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/09/12  *
C***********************************************************************
      SUBROUTINE cmdlin(NTAP,OTAP,INPUT,ipow,dx,vref,dtms,bw,istart,
     &           iend,nang,angstrt,anginc,IPIPI,IPIPO,LTRM,VERBOS)
      INTEGER ARGIS
      LOGICAL HELP,VERBOS
      CHARACTER*128 NTAP,OTAP,INPUT
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      VERBOS=.FALSE.
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS'
         WRITE(LTRM,*)'BACKSCATTER--FILTER--POWER STACK'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[ntap]   .. input dataset name'
         WRITE(LTRM,*)'-O[otap]   .. output dataset name'
         WRITE(LTRM,*)'-ip[ipow]  .. exponent for power stacking'
         WRITE(LTRM,*)'-dx[dx]    .. input trace spacing value'
         WRITE(LTRM,*)'-vr[vref]  .. reference velocity'
         WRITE(LTRM,*)'-dt[dtms]  .. input sample spacing in ms'
         WRITE(LTRM,*)'-bw[bw]    .. angle defining narrow dip band' 
         WRITE(LTRM,*)'-rs[rs]    .. starting record'
         WRITE(LTRM,*)'-re[re]    .. ending record'
         WRITE(LTRM,*)'-na[nang]  .. number of angles on input dataset'
         WRITE(LTRM,*)'-as[as]    .. first angle on input dataset'
         WRITE(LTRM,*)'-ai[ai]    .. angle increment of input dataset'
         WRITE(LTRM,*)'-V         .. verbose printout'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'bsstk -N[] -O[] -ip[] -dx[] -vr[] -dt[] -bw[]'
         WRITE(LTRM,*)'      -rs[] -re[] -na[] -as[] -ai[] -V'
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP,' ',' ')
      CALL ARGSTR('-O',OTAP,' ',' ')
      CALL ARGSTR('-C',INPUT,' ',' ')
      CALL ARGI4 ('-ip',ipow,0,0)
      CALL ARGr4 ('-dx',dx,0.0,0.0)
      CALL ARGr4 ('-vr',vref,0.0,0.0)
      CALL ARGr4 ('-dt',dtms,0.0,0.0)
      CALL ARGr4 ('-bw',bw,0.0,0.0)
      CALL ARGI4 ('-rs',istart,0,0)
      CALL ARGI4 ('-re',iend,0,0)
      CALL ARGI4 ('-na',nang,0,0)
      CALL ARGr4 ('-as',angstrt,0.0,0.0)
      CALL ARGr4 ('-ai',anginc,0.0,0.0)
      VERBOS =   (ARGIS( '-V' ).GT.0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PWROF2                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  GIVEN A NUMBER(N) THIS ROUTINE RETURNS THE BASE TWO       *
C       EXPONENT(IPWR) WHICH WILL GIVE 2**(IPWR-1).GT.N.LE.2**I *PWR   *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      PWROF2  (N,IPWR)                                                *
C  ARGUMENTS:                                                          *
C      N       INTEGER    I    - INPUT VALUE (INTEGER)                 *
C      IPWR    INTEGER    O    - OUTPUT VALUE RETURNED (INTEGER)       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   BRUCE CROWL                        ORIGIN DATE: 84/06/18  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/09/12  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 87/05/08  *
C            - CONVERTED TO CRAY FORTRAN                               *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE PWROF2 (N,IPWR)
      IPWR = 0
      IF (N.LE.0) GO TO 200
100   CONTINUE
      IF (2**IPWR.GE.N) GO TO 200
      IPWR = IPWR+1
      IF (IPWR.LT.30) GO TO 100
200   CONTINUE
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       WEDGEI                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      WEDGEI  (NX,PARM0,PARM)                                         *
C  ARGUMENTS:                                                          *
C      NX      INTEGER  ??IOU*         -                               *
C      PARM0   REAL     ??IOU*  (5)    -                               *
C      PARM    REAL     ??IOU*  (11,2) -                               *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   RON D. COLEMAN                     ORIGIN DATE: 88/09/12  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/09/12  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL    -                                               *
C      SQRT    GENERIC -                                               *
C      TAN     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C********************************************************************C
C NAME: WEDGEI  INIT WEDGE FILTER PARAMETERS    REV 1.0     JUL 86   C
C********************************************************************C
C
C  PURPOSE:
C       CALCULATES THE WEDGE FILTER PARAMETER ARRAY, PARM, GIVEN
C       PARM0 = (DX,DY,A1,A2,R).
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JUL 86          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL WEDGEI (NX, PARM0, PARM)
C
C  PARAMETERS:
C       NX      INTEGER INPUT SCALAR
C               NUMBER OF X'S - COLUMNN DIMENSION OF INPUT MATRIX.
C
C       PARM0   REAL INPUT ARRAY OF LENGTH 5
C               PARM0(1) = DX = DELTA X
C               PARM0(2) = DY = DELTA Y
C               PARM0(3) = A1 = ANGLE FOR FIRST RAY (DEGREES)
C               PARM0(4) = A2 = ANGLE FOR SECOND RAY (DEGREES)
C               PARM0(5) = R  = RAMP WIDTH
C
C       PARM    REAL OUTPUT ARRAY OF DIMENSION 11 BY 2
C               PARM( 1,K) = CASE: 0 = HORIZONTAL RAY
C                                  1 = RAMP REGION IS BELOW RAY
C                                  2 = RAMP REGION IS ABOVE RAY
C                                  3 = VERTICAL RAY
C               PARM( 2,K) = INDEX OF FIRST X       (CASE 1,2,3)
C               PARM( 3,K) = INDEX OF LAST X        (CASE 1,2,3)
C               PARM( 4,K) = INDEX BIAS             (CASE 1,3)
C               PARM( 5,K) = DX  = DELTA X          (CASE 1,2,3)
C               PARM( 6,K) = DY  = DELTA Y          (CASE 1,2)
C                          = R   = RAMP WIDTH       (CASE 3)
C               PARM( 7,K) = DYR = 1.0 / DY         (CASE 1,2)
C                          = RR  = 1.0 / R          (CASE 3)
C               PARM( 8,K) = TANPHI = SLOPE         (CASE 1,2)
C               PARM( 9,K) = B1 = LOWER Y-INTERCEPT (CASE 1,2)
C               PARM(10,K) = B2 = UPPER Y-INTERCEPT (CASE 1,2)
C               PARM(11,K) = SCALE = - 1.0 / B1     (CASE 1)
C                                  = - 1.0 / B2     (CASE 2)
C               WHERE: K = 1 FOR FIRST RAY AND K = 2 FOR SECOND RAY.
C
C  DESCRIPTION:
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
      SUBROUTINE WEDGEI (NX, PARM0, PARM)
C
      INTEGER NX
      REAL    PARM0(5), PARM(11,2)
C
      DATA PI / 3.1415927 /
C
C---------------------------------------------------------------------
C
      DO 30 K = 1, 2
         DO 20 I = 1, 11
            PARM(I,K) = 0.0
   20    CONTINUE
   30 CONTINUE
C
      DX = PARM0(1)
      DY = PARM0(2)
      R  = PARM0(5)
C
      IF (DX .LE. 0.0) GO TO 90
      IF (DY .LE. 0.0) GO TO 90
      IF (R  .LE. 0.0) GO TO 90
C
      RAD = PI / 180.0
C
      DO 80 K = 1, 2
         ANG = PARM0(K+2)
         IF (ANG .LE. 0.0 .OR. ANG .GE. 180.0) GO TO 80
C
         KOFF = 4 * K + 4
C
         IF (ANG .EQ. 90.0) THEN
            ICASE = 3
         ELSE IF (ANG .LT. 90.0) THEN
            IF (K .EQ. 1) THEN
               ICASE = 1
            ELSE
               ICASE = 2
            ENDIF
         ELSE
            IF (K .EQ. 1) THEN
               ICASE = 2
            ELSE
               ICASE = 1
            ENDIF
         ENDIF
C
         PARM(1,K) = FLOAT( ICASE )
C
         GO TO (40, 50, 60), ICASE
C
   40    CONTINUE
         NXOVR2 = NX / 2
         IF (K .EQ. 1) THEN
            J1 = 2
            J2 = NXOVR2 + 1
            JB = 1
         ELSE
            J1 = NXOVR2 + 2
            J2 = NX
            JB = NX + 1
         ENDIF
C
         DYR    = 1.0 / DY
         PHI    = ANG * RAD
         TANPHI = TAN( PHI )
         SECPHI = SQRT( TANPHI * TANPHI + 1.0 )
         B1     = - R * SECPHI
         B2     = 0.0
         SCALE  = - 1.0 / B1
C
         PARM( 2,K) = FLOAT( J1 )
         PARM( 3,K) = FLOAT( J2 )
         PARM( 4,K) = FLOAT( JB )
         PARM( 5,K) = DX
         PARM( 6,K) = DY
         PARM( 7,K) = DYR
         PARM( 8,K) = TANPHI
         PARM( 9,K) = B1
         PARM(10,K) = B2
         PARM(11,K) = SCALE
         GO TO 80
C
   50    CONTINUE
         DYR    = 1.0 / DY
         PHI    = ANG * RAD
         TANPHI = TAN( PHI )
         SECPHI = SQRT( TANPHI * TANPHI + 1.0 )
         B1     = 0.0
         B2     = R * SECPHI
         SCALE  = - 1.0 / B2
C
         PARM( 2,K) = 1.0
         PARM( 3,K) = FLOAT( NX )
         PARM( 5,K) = DX
         PARM( 6,K) = DY
         PARM( 7,K) = DYR
         PARM( 8,K) = TANPHI
         PARM( 9,K) = B1
         PARM(10,K) = B2
         PARM(11,K) = SCALE
         GO TO 80
C
   60    CONTINUE
         NXOVR2 = NX / 2
         IF (K .EQ. 1) THEN
            J1 = 2
            J2 = NXOVR2 + 1
            JB = 1
         ELSE
            J1 = NXOVR2 + 2
            J2 = NX
            JB = NX + 1
         ENDIF
C
         RR = 1.0 / R
C
         PARM( 2,K) = FLOAT( J1 )
         PARM( 3,K) = FLOAT( J2 )
         PARM( 4,K) = FLOAT( JB )
         PARM( 5,K) = DX
         PARM( 6,K) = R
         PARM( 7,K) = RR
C
   80 CONTINUE
C
   90 CONTINUE
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       XBSSTK                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:       2D-FFT FORWARD, DISK OR PIE FILTER, 2D-FFT INVERSE   *
C           -     POWER STACK                                          *
C  ENTRY POINTS:                                                       *
C      XBSSTK  (WEIGHT,A,B,PARM,NWMIN,NFREQ,KSAM2,LTR,ITYP,WPARM,IERR,  *
C              MR,IPOW,MREC,WRK)                                       *
C  ARGUMENTS:                                                          *
C      WEIGHT  REAL     ??IOU*       -                                 *
C      A       REAL     ??IOU*  (*)  -                                 *
C      B       REAL     ??IOU*  (*)  -                                 *
C      PARM    REAL     ??IOU*  (6)  -                                 *
C      NWMIN   INTEGER  ??IOU*       -                                 *
C      NFREQ   INTEGER  ??IOU*       -                                 *
C      KSAM2   INTEGER  ??IOU*       -                                 *
C      LTR     INTEGER  ??IOU*       -                                 *
C      ITYP    INTEGER  ??IOU*       -                                 *
C      WPARM   REAL     ??IOU*  (22) -                                 *
C      IERR    INTEGER  ??IOU*       -                                 *
C      MR      INTEGER  ??IOU*       -                                 *
C      IPOW    INTEGER  ??IOU*       -                                 *
C      MREC    INTEGER  ??IOU*       -                                 *
C      WRK     REAL     ??IOU*  (*)  -                                 *
C       +------------------------------------------------------+       *
C       ]               DEVELOPMENT INFORMATION                ]       *
C       +------------------------------------------------------+       *
C  AUTHOR:   R.D. COLEMAN                       ORIGIN DATE: 87/05/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/09/12  *
C       +------------------------------------------------------+       *
C       ]                 EXTERNAL ENVIRONMENT                 ]       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      XRFFT -                                                         *
C      XCFFT -                                                         *
C      FDSCI -                                                         *
C      FDISC -                                                         *
C      FDSCO -                                                         *
C      FPIE  -                                                         *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      SIGN    GENERIC -                                               *
C      ABS     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       ]             OTHER DOCUMENTATION DETAILS              ]       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 87/10/01  *
C            - ADDED CODE TO DO POWER STACK                            *
C       +------------------------------------------------------+       *
C       ]                 ANALYSIS INFORMATION                 ]       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 88/09/12 ==================   *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C     WEIGHT = A WEIGHT NEEDED FOR EACH RECORD WHEN DOING A SUM        *
C     A      = ARRAY CONTAINING THE INCOMING AND OUTGOING DATA         *
C     B      = ARRAY TO HOLD THE OUTPUT (SUM OF ALL INPUT RECORDS)     *
C     PARM   = 4 WORDS CONTAINING PARAMETERS FOR THE DISK-SHAPE FILTER *
C     NWMIN  = INDEX OF FIRST ELEMENT                                  *
C     NFREQ  = NUMBER OF ELEMENTS                                      *
C     KSAM2  = TIME SAMPLES/TRACE                                      *
C     LTR    = TRACES/RECORD                                           *
C     ITYP   = TYPE OF FILTER TO INVOKE                                *
C     WPARM  = 22 WORDS CONTAINING PARAMETERS FOR THE PIE FILTER       *
C     IERR   = ERROR FLAG                                              *
C     MR     = RECORD NO. (IF = 1, THEN CLEAR B ARRAY)                 *
C     IPOW   = POWER FOR THE POWER STACKING                            *
C     MREC   = IF MR .EQ. LAST RECORD, 2-D FFT THE SUMMED OUTPUT RECORD*
C     WRK    = SCRATCH VECTOR OF LENGTH MAX( 4*KSAM2+6, 7*LTR )        *
C  ARGUMENTS:  (WEIGHT, A, B, PARM, NWMIN, NFREQ, KSAM2, LTR, ITYP,    *
C               WPARM, IERR, MR, IPOW, MREC, WRK)                      *
C                           (1)   DKX                                  *
C                           (2)   DKY * ASPECT RATIO                   *
C                           (3)   R1 (RADIUS 1 IN KX'S                 *
C                           (4)   R2 (RADIUS 2 IN KX'S                 *
C                           (5)   R3 (RADIUS 3 IN KX'S                 *
C                           (6)   R4 (RADIUS 4 IN KX'S                 *
C              1 = ZERO INNER CIRCLE                                   *
C              2 = ZERO INNER AND OUTER                                *
C              3 = ZERO OUTER CIRCLE                                   *
C              4 = PIE FILTER                                          *
C              THESE ARE CALCULATED BY FORTRAN ROUTINE WEDGEI          *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
C
      SUBROUTINE XBSSTK (WEIGHT, A, B, PARM, NWMIN, NFREQ, KSAM2, LTR,
     &                  ITYP, WPARM, IERR, MR, IPOW, MREC, WRK)
C
      REAL    A(*), PARM(6), WPARM(22), B(*), WEIGHT, WRK(*), RPOW
      INTEGER IERR, LTR, ITYP, MR, KSAM2, NFREQ, IDIR, NWMIN,
     &        MREC, IPOW
C
C-----------------------------------------------------------------------
C
      IDIR = 1
      CALL XRFFT (A, IDIR, NWMIN, NFREQ, KSAM2, LTR, WRK, IERR)
      IF (IERR .NE. 0) GO TO 900
      CALL XCFFT (A, IDIR, NFREQ, LTR, WRK, IERR)
      IF (IERR .NE. 0) GO TO 900
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     APPLY THE FILTER
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      IF (ITYP .EQ. 1) CALL FDSCI (A, PARM       , LTR, NFREQ, IDUMMY)
      IF (ITYP .EQ. 2) CALL FDISC (A, PARM       , LTR, NFREQ, IDUMMY)
      IF (ITYP .EQ. 3) CALL FDSCO (A, PARM       , LTR, NFREQ, IDUMMY)
      IF (ITYP .EQ. 4) CALL FPIE  (A, PARM, WPARM, LTR, NFREQ, IDUMMY)
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     DO THE INVERSE FFT
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      IDIR = -1
      CALL XCFFT (A, IDIR, NFREQ, LTR, WRK, IERR)
      IF (IERR .NE. 0) GO TO 900
      CALL XRFFT (A, IDIR, NWMIN, NFREQ, KSAM2, LTR, WRK, IERR)
      IF (IERR .NE. 0) GO TO 900
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     DO THE POWER STACK INTO B
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      do 700 k=1,ksam2
         la = k
         do 600 l=1,ltr
            wrk(k) = abs(a(la))**ipow * weight
            wrk(k) = sign(wrk(k),a(la))
            b(la)  = b(la) + wrk(k)
            la = la + ksam2
  600    continue
  700 continue
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     TAKE THE SQUARE ROOT NOW AND APPLY PROPER SIGN
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      IF (MR .EQ. MREC) THEN
         RPOW = IPOW
         RPOW = 1./RPOW
         do 800 k=1,ksam2
            la = k
            do 750 l=1,ltr
               wrk(k) = abs(b(la))**rpow
               b(la) = sign(wrk(k),b(la))
               la = la + ksam2
  750       continue
  800    continue
      ENDIF
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     EXIT ROUTINE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
  900 CONTINUE
      RETURN
      END
