C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: C3GETPAR   GET PARAMETERS                                      *
C***********************************************************************

      subroutine c3getpar( fn_data, fn_vel, fn_ddout, fn_image, fn_zeta,
     &                     nw, w0, dw, nkx, kx0, dkx, nky, ky0, dky,
     &                     nt, nx, ny, dzgrid, zmax, dtgrid, tmax, vref,
     &                     dip, strch, tablelu, axis3, verbos, debug )

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c symbolic constants:

      real      HUGE            ! deeper than the deepest depth
      parameter( HUGE = 1.0e37 )
      
c output parameters:       

      character axis3*2         ! third axis name
      integer   debug           ! debug output flag
      real      dip             ! maximum dip (degrees)
      real      dkx             ! delta kx
      real      dky             ! delta ky
      real      dtgrid              ! delta t
      real      dw              ! delta omega
      real      dzgrid              ! delta z
      character fn_data*100     ! name of input data file
      character fn_ddout*100    ! name of output data dictionary file
      character fn_image*100    ! name of output image file
      character fn_vel*100      ! name of input velocity file
      character fn_zeta*100     ! name of output zeta file
      real      kx0             ! kx origin
      real      ky0             ! ky origin
      integer   nkx             ! number of x wave numbers
      integer   nky             ! number of y wave numbers
      integer   nt              ! original number of time samples/trace
      integer   nw              ! number of omegas
      integer   nx              ! original number of x's
      integer   ny              ! original number of y's
      character path*100        ! output data/zeta file path
      real      strch           ! stretch factor
      logical   tablelu         ! table loop-up flag
      real      tmax            ! maximum time for migration
      real      vref            ! reference velocity
      logical   verbos          ! verbose output flag
      real      w0              ! omega origin
      real      zmax            ! maximum depth for migration

c local variables:

      character dsuffix*100     ! data file suffix
      real      err             ! error magnitude
      character flags*16        ! flag string
      integer   j
      integer   nstr            ! number of tokens in text line less one
      integer   rank            ! rank of input data
      character str(0:3)*100    ! tokens from data dictionary lines
      character zsuffix*100     ! zeta file suffix

c functions:
      integer   str2int         ! string to integer
      real      str2real        ! string to real

c-----------------------------------------------------------------------

      call argstr  ( 'out='        , fn_ddout,    ' ',    ' ' )
      call argstr  ( 'vel='        , fn_vel  ,    ' ',    ' ' )
      call argstr  ( 'flags='      , flags   ,    ' ',    ' ' )
      call argstr  ( 'data_path='  , path    ,   './',   './' )
      call argstr  ( 'data_suffix=', dsuffix , '.usp', '.usp' )
      call argstr  ( 'zeta_suffix=', zsuffix , '.zet', '.zet' )
      call argr4   ( 'dz='         , dzgrid  ,    0.0,    0.0 )
      call argr4   ( 'dtms='       , dtgrid  ,    0.0,    0.0 )
      call argr4   ( 'zmax='       , zmax    ,   HUGE,   HUGE )
      call argr4   ( 'tmax='       , tmax    ,   HUGE,   HUGE )
      call argr4   ( 'vref='       , vref    ,    0.0,    0.0 )
      call argr4   ( 'maxdip='     , dip     ,   90.0,   90.0 )
      call argr4   ( 'stretch='    , strch   ,    1.0,    1.0 )
      call argi4   ( 'debug='      , debug   ,      1,      0 )
cdan  Oct 96 strch = 1.0

      if( index( flags, 'T' ) .gt. 0 ) then
         tablelu = .true.
      else
         tablelu = .false.
      endif

      if( index( flags, 'V' ) .gt. 0 .or. debug .gt. 0 ) then
         verbos = .true.
      else
         verbos = .false.
      endif

      if( dip    .gt. 90.0 ) dip     = 90.0
      if( dzgrid .lt.  0.0 ) dzgrid  =  0.0
      if( dtgrid .lt.  0.0 ) dtgrid  =  0.0

      if     ( dtgrid .eq. 0.0 .and. dzgrid .eq. 0.0 ) then
         dzgrid = 0.005 * vref
      else if( dtgrid .gt. 0.0 .and. dzgrid .gt. 0.0 ) then
         write( LER, * ) '***** ERROR: dt and dz cannot both be ',
     &                   'specified *****'
         call exitfu(1)
      endif
                                       
      if( fn_ddout .eq. ' ' ) then
         write( LER, * ) '***** ERROR: fn_ddout must be specified *****'
         call exitfu(1)
      endif

      if( fn_vel .eq. ' ' ) then
         write( LER, * ) '***** ERROR: fn_vel must be specified *****'
         call exitfu(1)
      endif

      if( tmax .le. 0.0 ) then
         write( LER, * ) '***** ERROR: tmax must be positive *****'
         call exitfu(1)
      endif

      if( zmax .le. 0.0 ) then
         write( LER, * ) '***** ERROR: zmax must be positive *****'
         call exitfu(1)
      endif

      if( vref .le. 0.0 ) then
         write( LER, * ) '***** ERROR: vref must be positive *****'
         call exitfu(1)
      endif

      if( dip .le. 0.0 ) then
         write( LER, * ) '***** ERROR: dip must be positive *****'
         call exitfu(1)
      endif

      if( strch .le. 0.0 ) then
         write( LER, * ) '***** ERROR: strch must be positive *****'
         call exitfu(1)
      endif

      call mkname( path, fn_ddout, dsuffix, fn_image )
      call mkname( path, fn_ddout, zsuffix, fn_zeta  )

  100 continue
         call getline( LUSI, str, nstr )
         if( nstr .lt. 0 ) go to 200

         if     ( str(0) .eq. 'data='      ) then
            fn_data = str(1)
         else if( str(0) .eq. 'format='    ) then
            if( str(1) .ne. 'usp' ) then
               write( LER, * ) '***** ERROR: format must be usp *****'
               call exitfu(1)
            endif
         else if( str(0) .eq. 'data_type=' ) then
            if( str(1) .ne. 'complex*8' ) then
               write( LER, * ) '***** ERROR: data_type must be ',
     &                         'complex*8 *****'
               call exitfu(1)
            endif
         else if( str(0) .eq. 'axis='      ) then
            rank  = nstr
            axis3 = str(3)
            if( (str(1).ne.'w') .or. (str(2).ne.'kx') .or.
     &          (rank.eq.3 .and. str(3).ne.'ky' .and. str(3).ne.'y') )
     &          then
               write( LER, * ) '***** ERROR: invalid axis *****'
               call exitfu(1)
            endif
         else if( str(0) .eq. 'size='      ) then
            if( nstr .ne. rank ) then
               write( LER, * ) '***** ERROR: invalid size rank *****'
               call exitfu(1)
            endif
            nw  = str2int( str(1) )
            nkx = str2int( str(2) )
            nky = str2int( str(3) )
            if( nky .eq. 0 ) nky = 1
         else if( str(0) .eq. 'delta='     ) then
            if( nstr .ne. rank ) then
               write( LER, * ) '***** ERROR: invalid delta rank *****'
               call exitfu(1)
            endif
            dw  = str2real( str(1) )
            dkx = str2real( str(2) )
            dky = str2real( str(3) )
         else if( str(0) .eq. 'origin='    ) then
            if( nstr .ne. rank ) then
               write( LER, * ) '***** ERROR: invalid origin rank *****'
               call exitfu(1)
            endif
            w0  = str2real( str(1) )
            kx0 = str2real( str(2) )
            ky0 = str2real( str(3) )
         else if( str(0) .eq. 'txy_size='  ) then
            if( nstr .ne. 3 ) then
               write( LER, * )'***** ERROR: invalid txy_size rank *****'
               call exitfu(1)
            endif
            nt  = str2int( str(1) )
            nx  = str2int( str(2) )
            ny  = str2int( str(3) )
         endif
         go to 100

  200 continue
c
c insure that w0 is an integer multiple of dw
c
      if( w0 .lt. 0.0 ) w0 = 0.0
      err = abs( w0 - dw * nint( w0/dw ) ) / dw
      if( err .gt. 0.01 ) then
         write( LER, * ) '***** ERROR: w0 is not a multiple of dw *****'
         call exitfu(1)
      endif

      return
      end
