C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: C3RDNVEL   READ NUMBER OF VELOCITIES                           *
C***********************************************************************

      subroutine c3rdnvel( verbos, debug, nvel, ierr )

      implicit none

#include <f77/iounit.h>

c input parameters:

      integer   debug           ! debug printout flag
      logical   verbos          ! verbose printout flag

c output parameters:

      integer   ierr            ! error flag
      integer   nvel            ! number of velocities in velocity file

c local variables:

      character card*100        ! card image buffer

c-----------------------------------------------------------------------

  900 format( a80 )
  901 format( 10x, i10 )
  910 format( /' ', 'NOVEL     # VELOCITY' )
  911 format(  ' ', 'NOVEL     ', i10 )

c-----------------------------------------------------------------------

      if( debug .gt. 0 ) write( LUPRT, * ) 'Entered subroutine c3rdnvel'
         
      read( LUCARD, 900, iostat=ierr ) card
      if( ierr .ne. 0 ) then
         write( LER, * ) '*** ERROR: cannot read velocity card 1 ***'
         ierr = 2001
         return
      endif

      write( LUPRT, 910 )

cmat  added code here to read the 'MODEL' style velocity cards

      if( card(1:5) .eq. 'NOVEL' ) then
         read( LUCARD, 901, iostat=ierr ) nvel
         if( ierr .ne. 0 ) then
            write( LER, * ) '*** ERROR: cannot read velocity card 2 ***'
            ierr = 2003
            return
         endif
      else if( card(1:5) .eq. 'MODEL' ) then
         read( card, 901, iostat=ierr ) nvel
         if( ierr .ne. 0 ) then
            write( LER, * ) '*** ERROR: cannot read velocity card 2 ***'
            ierr = 2003
            return
         endif
      endif
cmat
      write( LUPRT, 911 ) nvel

      if( nvel .le. 0 ) then
         write( LER, * ) '*** ERROR: invalid number of velocities ***'
         ierr = 2004
         return
      endif

      read( LUCARD, 900, iostat=ierr ) card
      if( ierr .ne. 0 ) then
         write( LER, * ) '*** ERROR: cannot read velocity card 3 ***'
         ierr = 2005
         return
      endif

      if( card(1:10) .ne. 'VELOCITIES' ) then
         write( LER, * ) '*** ERROR: invalid velocity card 3 ***'
         ierr = 2006
         return
      endif

      ierr = 0

      return
      end
