C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: C3RDREC   CMMVZ3D READ USP RECORD                              *
C***********************************************************************

      subroutine c3rdrec( verbos, debug, luinp, jky, nkx, nw, trace,
     &                    header, psi, ierr )

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c input parameters:

      logical   verbos             ! verbose printout flag
      integer   debug              ! debug printout flag
      integer   luinp              ! logical unit of input file
      integer   jky                ! current ky (record) index
      integer   nkx                ! number of kx's
      integer   nw                 ! number of frequencies

c scratch parameters:

      real      trace(*)           ! trace (with header)

c output parameters:

      real      header(ITRWRD,nkx) ! trace header array
      complex   psi(nkx,nw)        ! wave field
      integer   ierr               ! completion code

c local variables:

      integer   jkx                ! kx loop index
      integer   nbytes             ! number bytes read
C
C-----------------------------------------------------------------------
C
  991 format( /' ', '***** Tape read error - record', I5, ' trace', I5,
     &              ' *****' /)
C
C-----------------------------------------------------------------------
C
      if( debug .gt. 0 ) write( LUPRT, * ) 'Entered subroutine c3rdrec'
         
      do jkx = 1, nkx
         nbytes = 0
         call rtape( luinp, trace, nbytes )
         if( nbytes .eq. 0 ) then
            write( LER, 991 ) jky, jkx
            ierr = -1
            return
         endif

         call vmov( trace, 1, header(1,jkx), 1, ITRWRD )
         call cvmov( trace(ITHWP1), 2, psi(jkx,1), 2*nkx, nw )
      enddo
C
      ierr = 0
      return
      end
