C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C======================================================================*
C NAME: MKNAME      MAKE A FULL PATH NAME                              *
C======================================================================*
C
C  PURPOSE:
C       Creates a new full path file name by concatenating a path, file
C       name, and suffix.
C
C-----------------------------------------------------------------------
C
      subroutine mkname( path, fname, suffix, newname )

      implicit none

c input parameters:

      character*(*) path     ! new name path
      character*(*) fname    ! new name base file name
      character*(*) suffix   ! new name suffix

c output parameters:

      character*(*) newname   ! new (derived) name

      integer       j         ! all-purpose character index
      integer       jn        ! newname character index

c-----------------------------------------------------------------------

      newname = ' '
      jn = 0

      j  = 0
  100 continue
         j = j + 1
         if( path(j:j) .ne. ' ' ) then
            jn = jn + 1
            newname(jn:jn) = path(j:j)
            go to 100
         endif

      if( newname(jn:jn) .ne. '/' ) then
         jn = jn + 1
         newname(jn:jn) = '/'
      endif

      j = 0
  200 continue
         j = j + 1
         if( fname(j:j) .ne. ' ' ) then
            jn = jn + 1
            newname(jn:jn) = fname(j:j)
            go to 200
         endif

      j = 0
  300 continue
         j = j + 1
         if( suffix(j:j) .ne. ' ' ) then
            jn = jn + 1
            newname(jn:jn) = suffix(j:j)
            go to 300
         endif

      return
      end
C
C======================================================================*
C NAME: GETLINE     GET AND PARSE TEXT LINE                            *
C======================================================================*
C
C  PURPOSE:
C       Read a line from a ASCII text file and parse it into tokens.
C       Maximum line length is 132 characters and maximum number of
C       tokens is 4.
C
C-----------------------------------------------------------------------
C
      subroutine getline( lun, tok, ntok )

      implicit none

c symbolic constants:

      integer MAXNTOK              ! maximum number of tokens less one
      parameter( MAXNTOK = 3 )

c input parameters:

      integer       lun

c ouput parameters:

      character*(*) tok(0:MAXNTOK) ! array of tokens
      integer       ntok           ! number of tokens

c local variables:

      character*132 buf            ! line buffer
      character*1   chr            ! a character
      integer       j              ! general purpose index
      integer       jb             ! buffer character index
      integer       jt             ! token character index
      logical       new            ! true if next non-blank starts a new
                                   ! token

c-----------------------------------------------------------------------

      ntok = -1
      read( lun, '(a132)', end=200 ) buf

      do j = 0, MAXNTOK
         tok(j) = ' '
      enddo

      new  = .true.
      do jb = 1, 132
         chr = buf(jb:jb)
         if( chr .eq. ' ' ) then
             new = .true.
             if( ntok .eq. MAXNTOK) return
         else if( new ) then
             new  = .false.
             ntok = ntok + 1
             jt   = 1
             tok(ntok)(jt:jt) = chr
         else
             jt   = jt + 1
             tok(ntok)(jt:jt) = chr
         endif
      enddo

  200 continue
      return
      end
C
C======================================================================*
C NAME: STR2INT     STRING TO INTEGER CONVERSION                       *
C======================================================================*
C
C  PURPOSE:
C       String to integer conversion.  String must be less than 132
C       characters.
C
C-----------------------------------------------------------------------
C
      integer function str2int( str )


      implicit none

c input parameters:

      character*(*) str       ! input string

c local variables:

      character*132 buf       ! work buffer
      integer       jb        ! buffer character index
      integer       js        ! string character index
      integer       js1       ! start value of js

c-----------------------------------------------------------------------

      js1 = len( str )
      do js = js1, 1, -1
         if( str(js:js) .ne. ' ' ) go to 200
      enddo

      str2int = 0
      return

  200 continue
      js1 = js
      jb  = 132
      buf = ' '
      do js = js1, 1, -1
         buf(jb:jb) = str(js:js)
         jb = jb - 1
      enddo

cmat      read( buf, '(i132)' ) str2int
      read( buf, '(100x,i32)' ) str2int
        
      return
      end
C
C======================================================================*
C NAME: STR2REAL    STRING TO REAL CONVERSION                          *
C======================================================================*
C
C  PURPOSE:
C       String to real conversion.  String must be less than 132
C       characters.
C
C-----------------------------------------------------------------------
C
      real function str2real( str )


      implicit none

c input parameters:

      character*(*) str       ! input string

c local variables:

      character*132 buf       ! work buffer
      integer       jb        ! buffer character index
      integer       js        ! string character index
      integer       js1       ! start value of js

c-----------------------------------------------------------------------

      js1 = len( str )
      do js = js1, 1, -1
         if( str(js:js) .ne. ' ' ) go to 200
      enddo

      str2real = 0.0
      return

  200 continue
      js1 = js
      jb  = 132
      buf = ' '
      do js = js1, 1, -1
         buf(jb:jb) = str(js:js)
         jb = jb - 1
      enddo

cmat      read( buf, '(f132.0)' ) str2real
      read( buf, '(100x,f32.0)' ) str2real
        
      return
      end
