C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c NAME: gcmdln
c PURPOSE: get command line arguments
c***********************************************************************
c  HISTORY:       MAR 95          REV 1.0         J. Cooperstein, CETech
c***********************************************************************
      subroutine gcmdln( LER, ntap, f1, f2, f3, f4, irec1, irec2,
     &           nrpad, itrc1, itrc2, ntpad, ismp1, ismp2, nspad,
     &           idt, dx, dy, mbytes, twod, verbos, dzgrid, dtgrid,
     &           outfil, fn_vel, datpth, datsfx, tmax, zmax, strch,
     &           output_type )
c***********************************************************************
      implicit none
c
c input parameters:
c
      integer   LER             ! logical unit number, error file
c
c output parameters:
c
      integer   debug           ! debug output flag
      real      dx              ! delta x
      real      dy              ! delta y
      real      dzgrid          ! delta z
      real      dtgrid          ! delta t
      real      f1              ! low  cutoff frequency (Hz) for filter
      real      f2              ! low  corner frequency (Hz) for filter
      real      f3              ! high corner frequency (Hz) for filter
      real      f4              ! high cutoff frequency (Hz) for filter
      real      zmax            ! maximum depth
      real      tmax            ! maximum time
      real      strch           ! stretch factor for velocities
      integer   idt             ! Sampling interval (milliseconds)
      integer   irec1           ! first input record to use
      integer   irec2           ! last  input record to use
      integer   ismp1           ! first input sample of trace to use
      integer   ismp2           ! last  input sample of trace to use
      integer   itrc1           ! beginning trace
      integer   itrc2           ! ending trace
      integer   mbytes          ! MBytes for scratch (default=32)
      integer   nrpad           ! number pad record
      integer   nspad           ! number pad sample
      integer   ntpad           ! number pad trace
      character ntap*(*)        ! name of input file
      logical   twod            ! if true, perform fft only on first 2 dim
      logical   verbos          ! verbose output flag
      character outfil*(*)      ! output data dictionary
      character fn_vel*(*)      ! velocity input file   
      character datpth*(*)      ! output data file path
      character datsfx*(*)      ! output data file suffix
      character output_type*4   ! output type: TIME or DEPT
c
c functions:
c
      integer   argis           ! is argument present function
      real      HUGE            ! deeper than the deepest depth
      parameter( HUGE = 1.0e15 )
c
c***********************************************************************
c
c===  get command line arguments
c
      call argi4( '-BR'   , irec1 ,      1,      1 )
      call argi4( '-ER'   , irec2 ,     -1,     -1 )
      call argi4( '-PR'   , nrpad ,      0,      0 )
      call argi4( '-BS'   , ismp1 ,      1,      1 )
      call argi4( '-ES'   , ismp2 ,     -1,     -1 )
      call argi4( '-PS'   , nspad ,      0,      0 )
      call argi4( '-BT'   , itrc1 ,      1,      1 )
      call argi4( '-ET'   , itrc2 ,     -1,     -1 )
      call argi4( '-PT'   , ntpad ,      0,      0 )
c
#ifdef CRAY
      call argi4( '-M'    , mbytes,     64,     64 )
#else
      call argi4( '-M'    , mbytes,     32,     32 )
#endif
c
      call argr4( '-fc'   , f2    ,    0.0,    0.0 )
      call argr4( '-f'    , f1    ,    0.0,    0.0 )
      call argr4( '-FC'   , f3    ,    0.0,    0.0 )
      call argr4( '-F'    , f4    ,    0.0,    0.0 )
c
      call argi4( '-DTMS' , idt   ,     -1,     -1 )
      call argr4( '-DX'   , dx    ,    0.0,    0.0 )
      call argr4( '-DT'   , dtgrid,    0.0,    0.0 )
      call argr4( '-DZ'   , dzgrid,    0.0,    0.0 )
      call argr4( '-DY'   , dy    ,    0.0,    0.0 )

c
      call argi4( '-D'    , debug ,     1 ,     0  )
      call argstr('-N'    , ntap  , ' '   , ' '    )
c
      twod = argis( '-2D' ) .gt. 0
      verbos = ( argis( '-V' ) .gt. 0 ) .or. ( debug .gt. 0 )
c
      call argstr( 'vel='         , fn_vel     , ' '    , ' '    )
      call argstr( 'data_path='   , datpth     , './'   , './'   )
      call argstr( 'data_suffix=' , datsfx     , '.usp' , '.usp' )
      call argstr( 'output_type=' , output_type, 'DEPT' , 'DEPT' )
      call argr4 ( 'zmax='        , zmax       ,    HUGE,   HUGE )
      call argr4 ( 'tmax='        , tmax       ,    HUGE,   HUGE )
      call argstr( 'out='         , outfil     , ' '    , ' '    )
      strch = 1.0

c
c===  error checking
c
      if( nspad .lt. 0 ) then
         write(LER,*)'***** ERROR: sample pad must not be negative ****'
         stop 1
      endif
c
      if( nrpad.lt.0) then
         write(LER,*)'***** ERROR: record pad must not be negative ****'
         stop 1
      endif
c
      if( ntpad .lt. 0 ) then
         write(LER,*)'***** ERROR: traces pad must not be negative ****'
         stop 1
      endif
      if( zmax .le. 0.0) then
         write(LER,*)'***** ERROR: zmax cannot be zero or negative*****'
         stop 1
      endif
      if( tmax .lt. 0.0) then
         write(LER,*)'***** ERROR: tmax cannot be negative*****'
         stop 1
      endif
c
c***********************************************************************
      return
      end
c***********************************************************************
