C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c Subroutine to compute 1-d extrapolation coefficients for f-x downward
c continuation
c
	subroutine coeffs(c_table,vmax,vmin,wmax,wmin,na,switch,dz,
     1			   nxaper,nkx,dx,awov0,dawov)
c
	implicit none
c
	integer	maxaper,maxna,nkxmax,atten
	parameter (maxaper=32,maxna=513,nkxmax=1024,atten=10)
	integer	nw,nv,nc,nkx,nxaper,na
	integer	tablec
	integer	ikx,ia,ixkx,size,istart
c
	complex c_table(maxaper,maxna)
	real	kx(nkxmax)
	real	wind(nkxmax)
	real	ww,disc1,fit_aa,fit_bb,xkx,rxprime,switch
	real	wmin,wmax,vmin,vmax,dawov,awov0
	real	amin,amax,awov
	real	pi,dz,dx,phi,amp
	real	rr,cc
c
	complex c_op(1024),c_test(1024),flata,myflata
c
	pi=3.14159265358979
c
	if(na.eq.0)na=maxna-1
	if(na.ge.maxna)na=maxna-1
c
c using an inverse fft, make the extrapolators for a range
c of indicies
c
	do ikx=2,nkx/2
          kx(ikx)=2*pi*(ikx-1)/(nkx*dx)
          kx(nkx+2-ikx)=-1.*kx(ikx)
	end do
c
	  kx(1)=0.
	  kx(nkx/2+1)=pi/dx
c
c construct the window function: raised cosine
c
	do ikx=1,nkx
	  wind(ikx)=0.
	end do
c
	wind(1)=1.
c
	do ikx=2,min(nxaper,nkx/2+1)
		wind(ikx)=.5*(cos((ikx-1)*pi/nxaper)+1.)
		wind(nkx+2-ikx)=.5*(cos((ikx-1)*pi/nxaper)+1.)
	end do
c
c figure out which values of the ratio w/v to build operators for
c
	amin=wmin/vmax
	amax=wmax/vmin
	dawov=(amax-amin)/(na-1)
	awov0=amin
c
c loop over "awov's", build the phase shift ops (awov=omega/vel)
c
	do ia=1,na
c
	  awov=(ia-1)*dawov+awov0
c
	  if(awov.eq.0.0)then
	    do ikx=1,nkx
		c_op(ikx)=cmplx(0.,0.)
	    end do
	  else
c
c figure out where the appropriate point to switch is
c
	  xkx=switch*awov
	  ixkx=int(xkx/kx(2))+1
	  rxprime=xkx/awov
	  fit_aa=-1./(sqrt(1.-rxprime**2)*2)
	  fit_bb=sqrt(1.-rxprime**2)+rxprime**2/(sqrt(1.-rxprime**2)*2)
c
	  if(ixkx.ge.5)then
	  do ikx=2,nkx/2
c
	    if(ikx.le.ixkx)then
	       disc1=1.-kx(ikx)*kx(ikx)/(awov*awov)
	       amp=1./(1.+(kx(ikx)/(2*xkx))**atten)
	       phi=1.*dz*awov*sqrt(disc1)
	       c_op(ikx)=cmplx(amp*cos(phi),amp*sin(phi))
	       c_op(nkx+2-ikx)=c_op(ikx)
	    else
	       disc1=kx(ikx)*kx(ikx)/(awov*awov)
	       amp=1./(1.+(kx(ikx)/(2*xkx))**atten)
	       phi=1.*dz*awov*(fit_bb+fit_aa*disc1)
	       c_op(ikx)=cmplx(amp*cos(phi),amp*sin(phi))
	       c_op(nkx+2-ikx)=c_op(ikx)
	    end if
c
	  end do
c
c fix up zero kx
c
          c_op(1)=cexp(cmplx(0.,1.*awov*dz))
c
	  flata=c_op(1)
c
c fix up nyquist
c
	  if(nkx/2+1 .le. ixkx)then
	       disc1=1.-kx(nkx/2+1)*kx(nkx/2+1)/(awov*awov)
	       amp=1./(1.+(kx(nkx/2+1)/(2*xkx))**atten)
	       phi=1.*dz*awov*sqrt(disc1)
	       c_op(nkx/2+1)=cmplx(amp*cos(phi),amp*sin(phi))
	  else
	       disc1=kx(nkx/2+1)*kx(nkx/2+1)/(awov*awov)
	       amp=1./(1.+(kx(nkx/2+1)/(2*xkx))**atten)
	       phi=1.*dz*awov*(fit_bb+fit_aa*disc1)
	       c_op(nkx/2+1)=cmplx(amp*cos(phi),amp*sin(phi))
	  end if
c
c very low normalized frequency case
c
	   else
c
	    do ikx=1,nkx
		c_op(ikx)=cmplx(0.,0.)
	    end do
c
	    flata=cmplx(1.,0.)
c
	   end if
c
c end check on 0 frequency
c
	  end if
c
c bring the operator to the space domain
c
c	   call cefft(c_op,nkx,1,1./float(nkx))
	   call cefft(c_op,nkx,1)
c
c apply the correct window function to each
c
	   do ikx=2,nkx/2
		c_op(ikx)=c_op(ikx)*wind(ikx)
		c_op(nkx+2-ikx)=c_op(nkx+2-ikx)*wind(ikx)
	   end do
		c_op(nkx/2+1)=c_op(nkx/2+1)*wind(nkx/2+1)
		c_op(1)=c_op(1)*wind(1)
c
	   do ikx=1,nkx
		c_test(ikx)=c_op(ikx)
	   end do
c
c now take the test back to kx to fix the zero wavenumber error
c
	   call cefft(c_test,nkx,-1)
c
	   if(ixkx.ge.5)then
	     myflata=c_test(1)
	   else
	     myflata=cmplx(1.,0.)
	   end if
c
c load the extrapolators into the table
c
	   rr=real(c_op(1))
	   cc=aimag(c_op(1))
	   c_table(1,ia)=cmplx(rr,cc)*flata/myflata
c
	   do ikx=2,nxaper
	     c_table(ikx,ia)=c_op(ikx)*2*flata/myflata
	   end do
c
c Ok, end for this "awov"
c
	end do
c
c all done
c
	return
	end
