C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c Subroutine to compute 1-d extrapolation coefficients for f-x downward
c continuation, using LEAST SQUARES. Ha, so there.
c
	subroutine coeffslsq(c_table,vmax,vmin,wmax,wmin,na,switch,dz,
     1			   nxaper,nkx,dx,awov0,dawov,matrix)
c
	implicit none
c
	integer	maxaper,maxna,nkxmax,order,m_wate
	parameter (maxaper=32,maxna=513,nkxmax=512,order=8,m_wate=8)
	integer	nw,nv,nc,nkx,nxaper,na
	integer	ikx,ia,size,istart,k,i
	integer	lenrw,leniw
	integer	iw
        integer istop,itnlim,nout
c
	integer	tablec

c
	complex c_table(maxaper,maxna)
c
	complex c_test(256)
c
	real	eps,dbdown
	parameter (eps=.01,dbdown=.99)
	real	switch
	real	wmin,wmax,vmin,vmax,dawov,awov0
	real	amin,amax
	real	pi,dz,dx,dkx,kx_nyq
c
        real    conlim,atol,btol,damp
c
c
	integer order_here(maxna),m_wate_here(maxna),ixkx(maxna)
c
	real	rxkx(maxna),wxkx(maxna),xkx(maxna),xnorm(maxna)
	real	anorm(maxna),acond(maxna),rnorm(maxna),arnorm(maxna)
	real	b(maxna),c(maxna),f(maxna),fp(maxna),awov(maxna)
	real    disc1(nkxmax,maxna),disc2(nkxmax,maxna)
	real	u(nkxmax,maxna)
	real	v(maxaper,maxna),w(maxaper,maxna)
	real	xr(maxaper,maxna),xi(maxaper,maxna),se(maxaper,maxna)
	real	kx(nkxmax),wate(nkxmax,maxna)
	real	hr(nkxmax,maxna),hi(nkxmax,maxna)
	real	amp(nkxmax,maxna),phi(nkxmax,maxna)
	real	rhsr(nkxmax,maxna),rhsi(nkxmax,maxna)
	real	cosey(nkxmax,maxaper),matrix(nkxmax,maxaper,maxna)
c
c
	pi=3.14159265358979
c
	lenrw=na*nkx
	leniw=1
	nout=-1
	itnlim=10*nxaper
	damp=.000001
c
c make the array of kx's and cos(kx*n)
c
	dkx=pi/(nkx*dx)
	kx_nyq=pi/dx
c
	    do ikx=1,nkx
                kx(ikx)=pi*(ikx-1)/(nkx*dx)
	    end do
c
          do ikx=1,nkx
              cosey(ikx,1)=1.
              do i=2,nxaper
                cosey(ikx,i)=2*cos(kx(ikx)*dx*float(i-1))
              end do
          end do
c
c figure out which values of the ratio w/v to build operators for
c
	amin=wmin/vmax
	amax=wmax/vmin
	dawov=(amax-amin)/(na-1)
	awov0=amin
c
c do all "awov's" simultaneously, build the phase shift ops (awov=omega/vel)
c
CC$PAR DOALL
C$DOACROSS LOCAL(ia,ikx,k)
	do ia=1,na
c
	  awov(ia)=(ia-1)*dawov+awov0
	  xkx(ia)=switch*awov(ia)
	  ixkx(ia)=int(xkx(ia)/dkx)+1
c
	  order_here(ia)=order
	  m_wate_here(ia)=m_wate
c
c figure out where the appropriate point to switch is
c
c
            if(awov(ia) .le. .4*kx_nyq)then
              order_here(ia)=min(order,4)
              m_wate_here(ia)=min(m_wate,4)
            end if
c
            if(awov(ia) .le. .2*kx_nyq)then
              order_here(ia)=min(order,2)
              m_wate_here(ia)=min(m_wate,2)
            end if
c
            if(awov(ia) .le. .1*kx_nyq)then
              order_here(ia)=1
              m_wate_here(ia)=1
            end if
c
            if(awov(ia) .le. .05*kx_nyq)then
              order_here(ia)=1
              m_wate_here(ia)=1
            end if
c
	end do
c
CC$PAR DOALL
C$DOACROSS LOCAL(ia,ikx,k)
	do ia=1,na
            rxkx(ia)=xkx(ia)/((1./dbdown-1.)**(1./(2.*order_here(ia))) )
c
            wxkx(ia)=xkx(ia)+10*dkx
c
            f(ia)=sqrt(1.-switch**2)
            fp(ia)=-switch/(awov(ia)*sqrt(1-switch**2))
c
            b(ia)=fp(ia)
            c(ia)=f(ia)-b(ia)*switch*awov(ia)
c
	    do ikx=1,nkx
	      disc1(ikx,ia)=1.-kx(ikx)*kx(ikx)/(awov(ia)*awov(ia))
	      disc2(ikx,ia)=kx(ikx)
c
            amp(ikx,ia)=1./(1.+(kx(ikx)/(rxkx(ia)))**(2*order_here(ia)))
	    end do
c
	    do ikx=1,ixkx(ia)
                 phi(ikx,ia)=dz*awov(ia)*sqrt(disc1(ikx,ia))
	    end do
c
	    do ikx=ixkx(ia)+1,nkx
                  phi(ikx,ia)=dz*awov(ia)*(b(ia)*disc2(ikx,ia)+c(ia))
	    end do
c
	    do ikx=1,nkx
	       hr(ikx,ia)=amp(ikx,ia)*cos(phi(ikx,ia))
	       hi(ikx,ia)=amp(ikx,ia)*sin(phi(ikx,ia))
c
	       wate(ikx,ia)=
     1      (1.-eps)/(1.+(kx(ikx)/(wxkx(ia)))**(2*m_wate_here(ia)))+eps
	    end do
	end do
c
c ok, now make the system of equations
c
CC$PAR DOALL
C$DOACROSS LOCAL(ia,ikx,k)
	do ia=1,na
	    do k=1,nxaper
	       do ikx=1,nkx
	          matrix(ikx,k,ia)=cosey(ikx,k)*wate(ikx,ia)
	       end do
	    end do
     1						
	    do ikx=1,nkx
              rhsr(ikx,ia)=hr(ikx,ia)*wate(ikx,ia)
              rhsi(ikx,ia)=hi(ikx,ia)*wate(ikx,ia)
	    end do
c
c end of preparatory stuff
c
	end do
                 
c
c now set up to call lsqr for the real part
c
            call plsqr(na,nkx,nxaper,damp,leniw,lenrw,iw,matrix,
     /			rhsr,v,w,xr,se,
     /            atol,btol,conlim,itnlim,nout,istop,
     /		  anorm,acond,rnorm,arnorm,xnorm,nkxmax,maxaper)
c
c now for the imaginary part of the solution
c
            call plsqr(na,nkx,nxaper,damp,leniw,lenrw,iw,matrix,
     /			rhsi,v,w,xi,se,
     /            atol,btol,conlim,itnlim,nout,istop,
     /		  anorm,acond,rnorm,arnorm,xnorm,nkxmax,maxaper)
c
c load the extrapolators into the table
c
CC$PAR DOALL
C$DOACROSS LOCAL (ia,ikx)
	  do ia=1,na
c
	    c_table(1,ia)=cmplx(xr(1,ia),xi(1,ia))
	    do ikx=2,nxaper
	       c_table(ikx,ia)=2*cmplx(xr(ikx,ia),xi(ikx,ia))
	    end do
c
	  end do
c
c all done
c
	return
	end
c
c The Aprod subroutine
c
        subroutine aprod(mode,m,n,x,y,leniw,lenrw,iw,rw,
     /		nsys,m_max,n_max)
c
        integer mode,leniw,lenrw,nsys,m_max,n_max
        integer iw(leniw)
        integer n,m
        real	rw(m_max,n_max,nsys)
	real	y(m_max,nsys)
	real	x(n_max,nsys)
c
        if(mode.eq.1)then
          call aprod2(rw,m,n,x,y,nsys,m_max,n_max)
        else
          call aprod2t(rw,m,n,x,y,nsys,m_max,n_max)
        end if
c
        return
        end
 
 
c
        subroutine aprod2(rw,m,n,x,y,nsys,m_max,n_max)
c
        integer n,i,j,m,ier,ia,m_max,n_max
c
        real	rw(m_max,n_max,nsys)
	real	y(m_max,nsys)
	real	x(n_max,nsys)
c
CC$PAR DOALL
C$DOACROSS LOCAL(ia,i,j)
	do ia=1,nsys
          do i=1,m
             do j=1,n
              y(i,ia)=y(i,ia)+rw(i,j,ia)*x(j,ia)
             end do
          end do
	end do
c
        return
        end
c
c
        subroutine aprod2t(rw,m,n,x,y,nsys,m_max,n_max)
c
        integer n,i,j,m,ia,m_max,n_max
c
        real	rw(m_max,n_max,nsys)
	real	y(m_max,nsys)
	real	x(n_max,nsys)
c
CC$PAR DOALL
C$DOACROSS LOCAL(ia,i,j)
	do ia=1,nsys
          do i=1,m
             do j=1,n
                x(j,ia)=x(j,ia)+rw(i,j,ia)*y(i,ia)
             end do
          end do
        end do
c
        return
        end
c

      SUBROUTINE PLSQR( NSYS,M,N,DAMP,
     1                 LENIW,LENRW,IW,RW,
     2                 U,V,W,X,SE,
     3                 ATOL,BTOL,CONLIM,ITNLIM,NOUT,
     4                 ISTOP,ANORM,ACOND,RNORM,ARNORM,XNORM,M_MAX,N_MAX)
c
	implicit none
c
	integer	ia,M_MAX,N_MAX
	integer NSYS_MAX
	parameter (NSYS_MAX=513)
C
      	INTEGER    NSYS,M,N,LENIW,LENRW,ITNLIM,NOUT,ISTOP
      	INTEGER    IW(LENIW)
c
      	real RW(M_MAX,N_MAX,NSYS)
      	real U(M_MAX,NSYS)
      	real V(N_MAX,NSYS),W(N_MAX,NSYS),X(N_MAX,NSYS),SE(N_MAX,NSYS)
      	real ANORM(NSYS),ARNORM(NSYS)
        real XNORM(NSYS),RNORM(NSYS),ACOND(NSYS)
c
      	REAL       ATOL,BTOL,CONLIM,DAMP
	real	t1max,t2max,t3max
c
C     ------------------------------------------------------------------
C
C     FUNCTIONS AND LOCAL VARIABLES
C
      	INTEGER    I,ITN,MOD,NCONV,NSTOP
	INTEGER count
c
	real	ALFA(NSYS_MAX),BETA(NSYS_MAX),BNORM(NSYS_MAX)
	real	CS(NSYS_MAX),CS1(NSYS_MAX),CS2(NSYS_MAX)
	real	BBNORM(NSYS_MAX),MALFA(NSYS_MAX),MBETA(NSYS_MAX)
	real	DDNORM(NSYS_MAX),DELTA(NSYS_MAX)
	real	GAMMA(NSYS_MAX),GAMBAR(NSYS_MAX)
	real	PHI(NSYS_MAX),PHIBAR(NSYS_MAX)
	real	PSI(NSYS_MAX),RES1(NSYS_MAX),RES2(NSYS_MAX)
	real	RHO(NSYS_MAX),RHOBAR(NSYS_MAX)
	real	RHBAR1(NSYS_MAX),RHBAR2(NSYS_MAX),RHS(NSYS_MAX)
	real	SN(NSYS_MAX),SN1(NSYS_MAX),SN2(NSYS_MAX)
	real	T(NSYS_MAX),TAU(NSYS_MAX)
	real	TEST1(NSYS_MAX),TEST2(NSYS_MAX),TEST3(NSYS_MAX)
	real	THETA(NSYS_MAX),T1(NSYS_MAX),T2(NSYS_MAX),T3(NSYS_MAX)
	real	XXNORM(NSYS_MAX)
	real	Z(NSYS_MAX),ZBAR(NSYS_MAX),RTOL(NSYS_MAX)
c
      	REAL       CTOL,DAMPSQ
C
C
C     INITIALIZE.
C
      	CTOL   = 0.
      	DAMPSQ = DAMP**2
      	ITN    = 0
      	ISTOP  = 0
      	NSTOP  = 0
c
CC$PAR DOALL
C$DOACROSS LOCAL(ia,I)
	do ia=1,nsys
c
      	   ANORM(ia)  = 0.
      	   ACOND(ia)  = 0.
      	   BBNORM(ia) = 0.
      	   DDNORM(ia) = 0.
      	   RES2(ia)   = 0.
      	   XNORM(ia)  = 0.
      	   XXNORM(ia) = 0.
      	   CS2(ia)    = -1.
      	   SN2(ia)    = 0.
      	   Z(ia)      = 0.
C
	   do I=1,N
	     V(I,ia)=0.
	     X(I,ia)=0.
	     SE(I,ia)=0.
	   end do
c
	end do
C
C     SET UP THE FIRST VECTORS FOR THE BIDIAGONALIZATION.
C     THESE SATISFY   BETA*U = B,   ALFA*V = A(TRANSPOSE)*U.
C
      	CALL NORMLZ( M,U,BETA,NSYS,M_MAX )
      	CALL APROD ( 2,M,N,V,U,LENIW,LENRW,IW,RW,NSYS,M_MAX,N_MAX )
      	CALL NORMLZ( N,V,ALFA,NSYS,N_MAX )
      	CALL SCOPY ( N,V,W,NSYS,N_MAX )
C
CC$PAR DOALL
C$DOACROSS LOCAL (ia)
	do ia=1,nsys
c
      	   RHOBAR(ia) = ALFA(ia)
     	   PHIBAR(ia) = BETA(ia)
      	   BNORM(ia)  = BETA(ia)
      	   RNORM(ia)  = BETA(ia)
      	   ARNORM(ia) = ALFA(ia)*BETA(ia)
c          IF (ARNORM .LE. ZERO) GO TO 800
c          IF (NOUT   .LT.  0  ) GO TO 100
c          IF (DAMPSQ .LE. ZERO) WRITE(NOUT, 1200)
c          IF (DAMPSQ .GT. ZERO) WRITE(NOUT, 1300)
           TEST1(ia)  = 1.
           TEST2(ia)  = ALFA(ia)/BETA(ia)
	end do
C
C     ------------------------------------------------------------------
C     MAIN ITERATION LOOP.
C     ------------------------------------------------------------------
  100 ITN = ITN + 1
C
C     PERFORM THE NEXT STEP OF THE BIDIAGONALIZATION TO OBTAIN THE
C     NEXT  BETA, U, ALFA, V.  THESE SATISFY THE RELATIONS
C                BETA*U  =  A*V  -  ALFA*U,
C                ALFA*V  =  A(TRANSPOSE)*U  -  BETA*V.
C
CC$PAR DOALL
C$DOACROSS LOCAL(ia)
	do ia=1,nsys
	   MALFA(ia)=-1.*ALFA(ia)
	end do
c
      CALL SSCAL ( M,MALFA,U,NSYS,M_MAX )
      CALL APROD ( 1,M,N,V,U,LENIW,LENRW,IW,RW,NSYS,M_MAX,N_MAX )
      CALL NORMLZ( M,U,BETA,NSYS,M_MAX )
c
CC$PAR DOALL
C$DOACROSS LOCAL(ia)
	do ia=1,nsys
           BBNORM(ia) = BBNORM(ia) + ALFA(ia)**2 + BETA(ia)**2 + DAMPSQ
           MBETA(ia)=-1.*BETA(ia)
        end do
c
      CALL SSCAL ( N,MBETA,V,NSYS,N_MAX )
      CALL APROD ( 2,M,N,V,U,LENIW,LENRW,IW,RW,NSYS,M_MAX,N_MAX )
      CALL NORMLZ( N,V,ALFA,NSYS,N_MAX )
C
C
C     USE A PLANE ROTATION TO ELIMINATE THE DAMPING PARAMETER.
C     THIS ALTERS THE DIAGONAL (RHOBAR) OF THE LOWER-BIDIAGONAL MATRIX.
C
CC$PAR DOALL
C$DOACROSS LOCAL(ia,I)
	do ia=1,nsys

           RHBAR2(ia) = RHOBAR(ia)**2 + DAMPSQ
           RHBAR1(ia) = SQRT(RHBAR2(ia))
           CS1(ia)    = RHOBAR(ia)/RHBAR1(ia)
           SN1(ia)    = DAMP/RHBAR1(ia)
           PSI(ia)    = SN1(ia)*PHIBAR(ia)
           PHIBAR(ia) = CS1(ia)*PHIBAR(ia)

C
C
C     USE A PLANE ROTATION TO ELIMINATE THE SUBDIAGONAL ELEMENT (BETA)
C     OF THE LOWER-BIDIAGONAL MATRIX, GIVING AN UPPER-BIDIAGONAL MATRIX.
C
      	   RHO(ia)    = SQRT(RHBAR2(ia) + BETA(ia)**2)
      	   CS(ia)     = RHBAR1(ia)/RHO(ia)
      	   SN(ia)     = BETA(ia)/RHO(ia)
      	   THETA(ia)  =  SN(ia)*ALFA(ia)
      	   RHOBAR(ia) = -CS(ia)*ALFA(ia)
      	   PHI(ia)    =  CS(ia)*PHIBAR(ia)
      	   PHIBAR(ia) =  SN(ia)*PHIBAR(ia)
      	   TAU(ia)    =  SN(ia)*PHI(ia)
C
C
C     UPDATE  X, W  AND THE STANDARD ERROR ESTIMATES.
C
      	   T1(ia) =    PHI(ia)/RHO(ia)
      	   T2(ia) = -THETA(ia)/RHO(ia)
      	   T3(ia) =    1./RHO(ia)
C
           DO 200 I = 1, N
              T(ia)     = W(I,ia)
              X(I,ia)  = T1(ia)*T(ia) + X(I,ia)
              W(I,ia)  = T2(ia)*T(ia) + V(I,ia)
              T(ia)     =(T3(ia)*T(ia))**2
              SE(I,ia) = T(ia) + SE(I,ia)
              DDNORM(ia)= T(ia) + DDNORM(ia)
  200      CONTINUE
C
C
C     USE A PLANE ROTATION ON THE RIGHT TO ELIMINATE THE
C     SUPER-DIAGONAL ELEMENT (THETA) OF THE UPPER-BIDIAGONAL MATRIX.
C     THEN USE THE RESULT TO ESTIMATE  NORM(X).
C
      	   DELTA(ia)  =  SN2(ia)*RHO(ia)
      	   GAMBAR(ia) = -CS2(ia)*RHO(ia)
      	   RHS(ia)    = PHI(ia) - DELTA(ia)*Z(ia)
      	   ZBAR(ia)   = RHS(ia)/GAMBAR(ia)
      	   XNORM(ia)  = SQRT(XXNORM(ia) + ZBAR(ia)**2)
      	   GAMMA(ia)  = SQRT(GAMBAR(ia)**2 + THETA(ia)**2)
      	   CS2(ia)    = GAMBAR(ia)/GAMMA(ia)
      	   SN2(ia)    = THETA(ia)/GAMMA(ia)
      	   Z(ia)      = RHS(ia)/GAMMA(ia)
      	   XXNORM(ia) = XXNORM(ia) + Z(ia)**2
C
C
C     TEST FOR CONVERGENCE.
C     FIRST, ESTIMATE THE NORM AND CONDITION OF THE MATRIX  ABAR,
C     AND THE NORMS OF  RBAR  AND  ABAR(TRANSPOSE)*RBAR.
C
      	   ANORM(ia)  = SQRT(BBNORM(ia))
      	   ACOND(ia)  = ANORM(ia)*SQRT(DDNORM(ia))
      	   RES1(ia)   = PHIBAR(ia)**2
      	   RES2(ia)   = RES2(ia) + PSI(ia)**2
      	   RNORM(ia)  = SQRT(RES1(ia) + RES2(ia))
      	   ARNORM(ia) = ALFA(ia)*ABS(TAU(ia))
C
C     NOW USE THESE NORMS TO ESTIMATE CERTAIN OTHER QUANTITIES,
C     SOME OF WHICH WILL BE SMALL NEAR A SOLUTION.
C
      	   TEST1(ia)  = RNORM(ia)/BNORM(ia)
      	   TEST2(ia)  = ARNORM(ia)/(ANORM(ia)*RNORM(ia))
      	   TEST3(ia)  = 1./ACOND(ia)
      	   T1(ia)     = TEST1(ia)/(1. + ANORM(ia)*XNORM(ia)/BNORM(ia))
      	   RTOL(ia)   = BTOL +  ATOL*ANORM(ia)*XNORM(ia)/BNORM(ia)
C
C     THE FOLLOWING TESTS GUARD AGAINST EXTREMELY SMALL VALUES OF
C     ATOL, BTOL  OR  CTOL.  (THE USER MAY HAVE SET ANY OR ALL OF
C     THE PARAMETERS  ATOL, BTOL, CONLIM  TO ZERO.)
C     THE EFFECT IS EQUIVALENT TO THE NORMAL TESTS USING
C     ATOL = RELPR,  BTOL = RELPR,  CONLIM = 1/RELPR.
C
      T3(ia) = 1. + TEST3(ia)
      T2(ia) = 1. + TEST2(ia)
      T1(ia) = 1. + T1(ia)

	end do
c
	t3max=T3(1)
	t2max=T2(1)
	t1max=T1(1)
	do ia=2,nsys
	   t3max=max(t3max,T3(ia))
	   t2max=max(t2max,T2(ia))
	   t1max=max(t1max,T1(ia))
	end do
c
      IF (ITN .GE. ITNLIM) ISTOP = 7
      IF (t3max  .LE. 1.  ) ISTOP = 6
      IF (t2max  .LE. 1.   ) ISTOP = 5
      IF (t1max  .LE. 1.   ) ISTOP = 4
C
C     ALLOW FOR TOLERANCES SET BY THE USER.
C
	t3max=TEST3(1)
	t2max=TEST2(1)
	t1max=TEST1(1)
	do ia=2,nsys
	   t3max=max(t3max,TEST3(ia))
	   t2max=max(t2max,TEST2(ia))
	   t1max=max(t1max,TEST1(ia))
	end do
      IF (t3max .LE. CTOL) ISTOP = 3
      IF (t2max .LE. ATOL) ISTOP = 2
c
	count=0
	do ia=1,nsys
           IF (TEST1(ia) .LE. RTOL(ia)) count=count+1
	end do
	if(count .EQ. nsys)ISTOP=1
C     ==================================================================
C
C     STOP IF APPROPRIATE.
C     THE CONVERGENCE CRITERIA ARE REQUIRED TO BE MET ON  NCONV
C     CONSECUTIVE ITERATIONS, WHERE  NCONV  IS SET BELOW.
C     SUGGESTED VALUE --   NCONV = 1, 2  OR  3.
C
  600 IF (ISTOP .EQ. 0) NSTOP = 0
      IF (ISTOP .EQ. 0) GO TO 100
      NCONV = 1
      NSTOP = NSTOP + 1
      IF (NSTOP .LT. NCONV  .AND.  ITN .LT. ITNLIM) ISTOP = 0
      IF (ISTOP .EQ. 0) GO TO 100
C     ------------------------------------------------------------------
C     END OF ITERATION LOOP.
C     ------------------------------------------------------------------
C
C
C     FINISH OFF THE STANDARD ERROR ESTIMATES.
C
CC$PAR DOALL
C$DOACROSS LOCAL(ia,I)
	do ia=1,nsys
      	   T(ia) = 1.
      	   IF (M .GT. N) T(ia) = M - N
      	   IF (DAMPSQ .GT. 0.) T(ia) = M
      	   T(ia) = RNORM(ia)/SQRT(T(ia))
C
      	   DO 700 I = 1, N
       	     SE(I,ia) = T(ia)*SQRT(SE(I,ia))
  700 	   CONTINUE
	end do
C
C     PRINT THE STOPPING CONDITION.
C
  800 IF (NOUT .LT. 0) GO TO 900
      WRITE(NOUT, 1900) ITN,ISTOP
      IF (ISTOP .EQ. 0) WRITE(NOUT, 2000)
      IF (ISTOP .EQ. 1) WRITE(NOUT, 2100)
      IF (ISTOP .EQ. 2) WRITE(NOUT, 2200)
      IF (ISTOP .EQ. 3) WRITE(NOUT, 2300)
      IF (ISTOP .EQ. 4) WRITE(NOUT, 2400)
      IF (ISTOP .EQ. 5) WRITE(NOUT, 2500)
      IF (ISTOP .EQ. 6) WRITE(NOUT, 2600)
      IF (ISTOP .EQ. 7) WRITE(NOUT, 2700)
  900 RETURN
C     ------------------------------------------------------------------
C
 1000 FORMAT(
     1   // 25X, 46HLSQR   --   LEAST-SQUARES SOLUTION OF  A*X = B
     2   // 25X, 18HTHE MATRIX  A  HAS, I6, 11H ROWS   AND, I6, 5H COLS
     3    / 25X, 36HTHE DAMPING PARAMETER IS    DAMP   =, 1PE10.2
     4   // 25X,  8HATOL   =, 1PE10.2, 10X, 8HCONLIM =, 1PE10.2
     5    / 25X,  8HBTOL   =, 1PE10.2, 10X, 8HITNLIM =, I10)
 1200 FORMAT(// 3X, 3HITN, 9X, 4HX(1), 14X, 8HFUNCTION, 7X,
     1   45HCOMPATIBLE INCOMPATIBLE    NORM(A)    COND(A) /)
 1300 FORMAT(// 3X, 3HITN, 9X, 4HX(1), 14X, 8HFUNCTION, 7X,
     1   45HCOMPATIBLE INCOMPATIBLE NORM(ABAR) COND(ABAR) /)
 1500 FORMAT(I6, 1PE20.10, 1PE19.10, 1P2E13.3, 1P2E11.2)
 1600 FORMAT(1X)
 1900 FORMAT(/ 20H NO. OF ITERATIONS =, I6,
     1   8X, 21H STOPPING CONDITION =, I3)
 2000 FORMAT(/ 52H THE EXACT SOLUTION IS  X = 0.                      )
 2100 FORMAT(/ 52H A*X - B  IS SMALL ENOUGH, GIVEN  ATOL, BTOL        )
 2200 FORMAT(/ 52H THE LEAST-SQRS SOLN IS GOOD ENOUGH, GIVEN  ATOL    )
 2300 FORMAT(/ 52H THE ESTIMATE OF  COND(ABAR)  HAS EXCEEDED  CONLIM  )
 2400 FORMAT(/ 52H A*X - B   IS SMALL ENOUGH FOR THIS MACHINE         )
 2500 FORMAT(/ 52H THE LEAST-SQRS SOLN IS GOOD ENOUGH FOR THIS MACHINE)
 2600 FORMAT(/ 52H COND(ABAR)   SEEMS TO BE TOO LARGE FOR THIS MACHINE)
 2700 FORMAT(/ 52H THE ITERATION LIMIT HAS BEEN REACHED               )
C     END OF LSQR
      END





      SUBROUTINE NORMLZ( N,X,BETA,NSYS,N_MAX )
c
      INTEGER    N,NSYS,ia,N_MAX
c
        integer NSYS_MAX
        parameter (NSYS_MAX=513)
c    
        real    OOBETA(NSYS_MAX)
c
	real	X(N_MAX,NSYS)
	real	BETA(NSYS)
c
C
      call PSNRM2( N,X,BETA,NSYS,N_MAX )
c
CC$PAR DOALL
C$DOACROSS LOCAL(ia)
	do ia=1,nsys
           if(BETA(ia) .eq. 0.) OOBETA(ia)=1.
	   OOBETA(ia)=1./BETA(ia)
        end do
c
c
      CALL SSCAL( N,OOBETA,X,NSYS,N_MAX )
      RETURN
C
      END






      SUBROUTINE SCOPY( N,X,Y,NSYS,N_MAX )
c
      INTEGER    N,NSYS,ia,N_MAX
c
	real X(N_MAX,NSYS),Y(N_MAX,NSYS)
C
      INTEGER    I
C
CC$PAR DOALL
C$DOACROSS LOCAL(ia,I)
	do ia=1,nsys
            DO 10 I = 1, N
                 Y(I,ia) = X(I,ia)
10          CONTINUE
	end do
      RETURN
      END







      SUBROUTINE PSNRM2( N,X,BETA,NSYS,N_MAX )
      INTEGER    N,INCX,NSYS,ia,N_MAX
c
	real	X(N_MAX,nsys)
	real	BETA(nsys)
c
      INTEGER    I
C
CC$PAR DOALL
C$DOACROSS LOCAL(ia,I)
	do ia=1,nsys
           BETA(ia) = 0.0
c
           DO 10 I = 1, N
              BETA(ia) = X(I,ia)**2 + BETA(ia)
 10        CONTINUE
           BETA(ia) = SQRT(BETA(ia))
	end do
C
      RETURN
      END







      SUBROUTINE SSCAL( N,A,X,NSYS,N_MAX )
      INTEGER    N,INCX,NSYS,ia,N_MAX
c
	real	X(N_MAX,nsys)
	real	a(nsys)
c
C
      INTEGER    I
C
CC$PAR DOALL
C$DOACROSS LOCAL(ia,I)
	do ia=1,nsys
      	   DO 10 I = 1, N
        	    X(I,ia) = A(ia)*X(I,ia)
   10 	   CONTINUE
	end do
c
      RETURN
C
C     END OF SSCAL
      END
