C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

c
c subroutine to downward continue a 3d wavefield using f-x,y convolution.
c Uses 1-d extrapolation operators and McClellan transforms
c
	subroutine dwn3dm(c_data,model,nx,ny,tablec,nzc,dawov,
     1		          awov0,nxaper,iz,nw_step,w0,dw,mult,
     2			  c_dtemp,c_d0,c_d1,c_d2,c_out,index,rem)
c
	implicit none
c
	integer	nx,nwc,ny,ic,nzc,iz,iwlc,iwlc1
	integer	iw,nxaper,nw_step,itest
	integer	ix,iy,ixaper
        integer nx_aper_max,nops_max
        parameter (nx_aper_max=32,nops_max=513)
c
	real	dawov,awov0,omega,dz,dw,w0,w0p
c
	complex c_data(nx,ny,nw_step)
	complex c_d0(nx,ny),c_d1(nx,ny),c_d2(nx,ny)
	complex c_dtemp(-2:nx+3,-2:ny+3)
	complex c_out(nx,ny)
	complex tablec(nx_aper_max,nops_max)
c
	integer	index(nx,ny)
c
	real	rem(nx,ny)
	real	mult(nx,ny)
	real    model(nx,ny,nzc)
c
c Start off the recursion by doing the
c table lookup of 0th coeff, find the initial index...
c
c
c outer loop ---------------------------------------------------------------
c
	  do iw=1,nw_step
c
	    omega=(iw-1)*dw+w0
c
c load up the coeffcient indices
c
C$PAR DOALL
C$DOACROSS LOCAL(iy,ix)
	    do iy=1,ny
	       do ix=1,nx
c
	          index(ix,iy)=int((omega/model(ix,iy,iz)-
     1			awov0)/dawov)+1
c
	          rem(ix,iy)=(omega/model(ix,iy,iz)
     1                   -((index(ix,iy)-1)*dawov+awov0))/dawov
c
	       end do
c
c load up the data into the recursion
c
		do ix=1,nx
		   c_d0(ix,iy)=c_data(ix,iy,iw)
		end do
c
c Ok, apply the zeroth coefficient
c
	       do ix=1,nx
	          c_out(ix,iy)=c_d0(ix,iy)*
     1			((1.-rem(ix,iy))*tablec(1,index(ix,iy))
     2			+rem(ix,iy)*tablec(1,index(ix,iy)+1))
	       end do
	    end do
c
c apply the little McClellan filter
c
	    call mmcclellanri(c_d2,c_d0,nx,ny,c_dtemp)
c
c apply 1st coeff
c
C$PAR DOALL
C$DOACROSS LOCAL(iy,ix)
	    do iy=1,ny
	       do ix=1,nx
	          c_out(ix,iy)=c_out(ix,iy)+c_d2(ix,iy)*
     1			((1.-rem(ix,iy))*tablec(2,index(ix,iy))
     2			+rem(ix,iy)*tablec(2,index(ix,iy)+1))
	       end do
	    end do
c
c now loop over the remaining parts of the recursion
c
	   do ic=3,nxaper,3
c
c apply the little McClellan filter
c
	      call mmcclellanri2(c_d1,c_d2,nx,ny,c_dtemp)
c
c Chebychev recursion
c
C$PAR DOALL
C$DOACROSS LOCAL(iy,ix)
	      do iy=1,ny
                 do ix=1,nx
	            c_d1(ix,iy)=c_d1(ix,iy)-c_d0(ix,iy)
	         end do
c
c apply the ic'th coeff
c
	         do ix=1,nx
	            c_out(ix,iy)=c_out(ix,iy)+c_d1(ix,iy)*
     1			((1.-rem(ix,iy))*tablec(ic,index(ix,iy))
     2			+rem(ix,iy)*tablec(ic,index(ix,iy)+1))
	          end do
	      end do
c
c next part of unroll
c do the mcclellan thing
c
	      call mmcclellanri2(c_d0,c_d1,nx,ny,c_dtemp)
c
c Chebychev recursion
c
C$PAR DOALL
C$DOACROSS LOCAL(iy,ix)
	      do iy=1,ny
                 do ix=1,nx
	            c_d0(ix,iy)=c_d0(ix,iy)-c_d2(ix,iy)
	         end do
c
c apply the ic+1'th coeff
c
	         do ix=1,nx
	            c_out(ix,iy)=c_out(ix,iy)+c_d0(ix,iy)*
     1			((1.-rem(ix,iy))*tablec(ic+1,index(ix,iy))
     2			+rem(ix,iy)*tablec(ic+1,index(ix,iy)+1))
	         end do
	      end do
c
c last part of unroll
c do the mcclellan
c
	      call mmcclellanri2(c_d2,c_d0,nx,ny,c_dtemp)
c
c Chebychev recursion
c
C$PAR DOALL
C$DOACROSS LOCAL(iy,ix)
	      do iy=1,ny
                 do ix=1,nx
	            c_d2(ix,iy)=c_d2(ix,iy)-c_d1(ix,iy)
                 end do
c
c apply the ic+2'th coeff
c
                 do ix=1,nx
                    c_out(ix,iy)=c_out(ix,iy)+c_d2(ix,iy)*
     1			((1.-rem(ix,iy))*tablec(ic+2,index(ix,iy))
     2			+rem(ix,iy)*tablec(ic+2,index(ix,iy)+1))
	         end do
	      end do
c
c end of loop over recursion
c
	  end do
c
c now assign the new level of the wave field
c
C$PAR DOALL
C$DOACROSS LOCAL(iy,ix)
	  do iy=1,ny
             do ix=1,nx
                c_data(ix,iy,iw)=c_out(ix,iy)*mult(ix,iy)
             end do
	  end do
c
c end outer loop over w
c
	end do
c
c all done with this little frequency chunk
c
	return
	end
c
c
c subroutine to apply the mcclellan transform filter to a single
c 2-d array (improved 16pt mcclellan transform)
c
	subroutine mmcclellanri(data_out,data_in,nx,ny,dtemp)
c
	implicit none
c
	integer	nx,ny,nw_step,ix,iy
	integer	code
c
	real	c0,c1,c2,c3,c4
c
	parameter (c0=-.5075,c1=.25,c2=.125,c3=.00375,c4=-.001875)
c
	complex	data_in(nx,ny),data_out(nx,ny)
	complex dtemp(-2:nx+3,-2:ny+3)
c
C$PAR DOALL
C$DOACROSS LOCAL(iy,ix)
	do iy=1,ny
	   do ix=1,nx
		dtemp(ix,iy)=data_in(ix,iy)
	   end do
	end do
c
C$PAR DOALL
C$DOACROSS LOCAL(iy,ix)
          do iy=1,ny
             do ix=1,nx
                data_out(ix,iy)=c0*dtemp(ix,iy)+
     1              c1*(dtemp(ix+1,iy)+dtemp(ix-1,iy)+
     2                  dtemp(ix,iy+1)+dtemp(ix,iy-1))+
     1              c3*(dtemp(ix+2,iy)+dtemp(ix-2,iy)+
     2                  dtemp(ix,iy+2)+dtemp(ix,iy-2))+
     1              c2*(dtemp(ix+1,iy+1)+dtemp(ix-1,iy+1)+
     2                  dtemp(ix+1,iy-1)+dtemp(ix-1,iy-1))+
     1              c4*(dtemp(ix+2,iy+2)+dtemp(ix-2,iy+2)+
     2                  dtemp(ix+2,iy-2)+dtemp(ix-2,iy-2))
             end do
c
          end do
c
	return
	end
c
c
c
c subroutine to apply the mcclellan transform filter to a single
c 2-d array (improved 16pt mcclellan transform)
c
	subroutine mmcclellanri2(data_out,data_in,nx,ny,dtemp)
c
	implicit none
c
	integer	nx,ny,nw_step,ix,iy
c
	real	c0,c1,c2,c3,c4
c
	parameter (c0=-1.015,c1=.5,c2=.25,c3=.0075,c4=-.00375)
c
	complex	data_in(nx,ny),data_out(nx,ny)
	complex dtemp(-2:nx+3,-2:ny+3)
c
C$PAR DOALL
C$DOACROSS LOCAL(iy,ix)
	do iy=1,ny
	   do ix=1,nx
		dtemp(ix,iy)=data_in(ix,iy)
	   end do
	end do
c
C$PAR DOALL
C$DOACROSS LOCAL(iy,ix)
          do iy=1,ny
             do ix=1,nx
                data_out(ix,iy)=c0*dtemp(ix,iy)+
     1              c1*(dtemp(ix+1,iy)+dtemp(ix-1,iy)+
     2                  dtemp(ix,iy+1)+dtemp(ix,iy-1))+
     1              c3*(dtemp(ix+2,iy)+dtemp(ix-2,iy)+
     2                  dtemp(ix,iy+2)+dtemp(ix,iy-2))+
     1              c2*(dtemp(ix+1,iy+1)+dtemp(ix-1,iy+1)+
     2                  dtemp(ix+1,iy-1)+dtemp(ix-1,iy-1))+
     1              c4*(dtemp(ix+2,iy+2)+dtemp(ix-2,iy+2)+
     2                  dtemp(ix+2,iy-2)+dtemp(ix-2,iy-2))
             end do
c
          end do
c
	return
	end
c
c
