C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c    NAME: fxpcmdln
c PURPOSE: get command line arguments
c***********************************************************************
c
      subroutine fxpcmdln( LER, verbos, ntape, otape, gitape, gotape
     &                   , increc, irec1, irec2, maxsta )
c
      implicit none
c
c input parameters:
c
      integer   LER             ! logical unit number, error file
c
c output parameters:
c
      character gitape*(*)      ! name of geometry file from PREPMIG
      character gotape*(*)      ! name of output geometry file for FXSMIG
      character ntape*(*)       ! name of input file
      character otape*(*)       ! name of output file
      integer   increc          ! increment between input records
      integer   irec1           ! first input record to use
      integer   irec2           ! last  input record to use
      integer   maxsta          ! maximum number of stations
      logical   verbos          ! verbose output flag
c
c functions:
c
      integer   argis           ! is argument present function
c
c***********************************************************************
c
c===  read parameters from command line
c
      call argi4( '-BR'   , irec1 ,      1,      1 )
      call argi4( '-ER'   , irec2 ,     -1,     -1 )
      call argi4( '-IR'   , increc,      1,      1 )
      call argstr('-N'    , ntape , ' '   , ' '    )
      call argstr('-O'    , otape , ' '   , ' '    )
      call argstr('-GIN'  , gitape , ' '   , ' '    )
      call argstr('-GOUT' , gotape , 'fxgeo.dat', 'fxgeo.dat')
      call argi4('-MAXSTA', maxsta, 10000, 10000 )
c
      verbos = argis( '-V' ) .gt. 0
c
      if( gitape .eq. ' '  ) then
         write( LER, * )
     &           ' ***** ERROR: geometry file (in)be specified *****'
         stop 1
      endif
c
c***********************************************************************
      return
      end
c***********************************************************************
