C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE genvel(IERR,VMIN,VMAX,SLOP,NUMVEL,velist,
     &                 indrec,DXTAP,DZTAP,maxna,MAXNV,LUV)
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
CABCD 123456
C * * * * * * * COMPUTE VELOCITY INDEX DATASET  * * * * * * * * * *
C

C * * * BEGIN MEMORY SPACE ALLOCATION * * * * * *

C * * * PWMBS COMMON (BEGIN) * * *

C     DEPTH COMMON ---------------------------------------------------
      INTEGER IZMAX,IZSEGM
      PARAMETER (IZMAX=100,IZSEGM=20)

      INTEGER IZSEG,IZB(IZSEGM),JZROW(IZSEGM),IZLN,IZXTR,JZLN
      REAL ZBEG(IZSEGM),ZEND(IZSEGM),DZ(IZSEGM),DZOUT
      REAL ZMAX,ZDEP,ZTABLE(IZMAX*IZSEGM)

      COMMON /DEPTH/ IZSEG,IZB,JZROW,IZLN,IZXTR,JZLN,
     &               ZBEG,ZEND,DZ,DZOUT,ZMAX,ZDEP,ZTABLE
C     DEPTH COMMON ---------------------------------------------------


C     WIDTH COMMON ---------------------------------------------------
      INTEGER JBMAX,IXSEGM,IXMAX
      PARAMETER (JBMAX=200,IXSEGM=5,IXMAX=4096)

      INTEGER IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
      INTEGER IXLN(IXSEGM),IXLN0(IXSEGM),IXLN1(IXSEGM)
      INTEGER IXBIAS(IXSEGM),IXST(IXSEGM),IXST0(IXSEGM)
      REAL XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT

      COMMON /WIDTH/ IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,
     &               JXBLK,JXNTR,JXSKIP,
     &               IXLN,IXLN0,IXLN1,IXBIAS,IXST,IXST0,
     &               XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C     WIDTH COMMON ---------------------------------------------------


C     TIME COMMON ------------------------------------------------------
      INTEGER ISI,NSAMP,ITPAD,NDFT,ITBEG
      REAL DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES

      COMMON /TIME/ ISI,NSAMP,ITPAD,NDFT,ITBEG,
     &              DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES,TDFT,T0
C     TIME COMMON ------------------------------------------------------


C     FREQ COMMON ------------------------------------------------
      INTEGER IWSEGM,IWMAX
      PARAMETER (IWSEGM=5,IWMAX=600)

      INTEGER IWSEG,IWBEG(IWSEGM),IWEND(IWSEGM),IWMIN,NW
      REAL FILT(IWMAX),F0,FMIN,F2,F3,FMAX,DF,SCALF
      REAL OMMIN,OMMAX,DOMEGA,OMEGA(IWMAX),PI

      COMMON /FREQ/  IWSEG,IWBEG,IWEND,IWMIN,NW,
     &               FILT,F0,FMIN,F2,F3,FMAX,DF,SCALF,
     &               OMMIN,OMMAX,DOMEGA,OMEGA,PI
C     FREQ COMMON ------------------------------------------------


C     LUNITS ---LOGICAL UNITS
C     LUNITS -----------------------------------------------------
      INTEGER         LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7
      INTEGER         LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14
      INTEGER         LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21
      INTEGER         LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX
      INTEGER         LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99

      COMMON /LUNITS/ LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
C     DEFINED IN PWBLOC (BLOCK DATA) AS:
C                        1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
C                        8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
C                       15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
C                       22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
C                       55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99
C     LUNITS -----------------------------------------------------


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS------------------
      INTEGER NSMAX
      PARAMETER (NSMAX=7500)

      INTEGER ihead(1500)
ccms  INTEGER*2 THEAD(3000),ITRH(128)
CCRAY
      INTEGER THEAD(3000)
      INTEGER*2 ITRH(LNTRHD)
ccms  REAL TRACE(NSMAX+64),DATA(NSMAX)
CCRAY
      REAL TRACE(NSMAX+ITRWRD),DATA(NSMAX)

      EQUIVALENCE (ITRH(1),TRACE(1)),(IHEAD(1),THEAD(1))
ccms  EQUIVALENCE (TRACE(65),DATA(1))
CCRAY
      EQUIVALENCE (TRACE(ITHWP1),DATA(1))

      COMMON /TAPE/  IHEAD,TRACE
C     TAPE COMMON ------------------------------------------------


C     MISCL COMMON ---------------------------------------------------
      INTEGER ISYS,IFMT,ITPFMT,MTXNAM(2),LINNUM(2)
      INTEGER MSK,NA,NAPMIN,NAPMAX,NV,NATOP,NABOT
      REAL VELRFL(50),VELINC(50),SLORFL(50),SLOINC(50),VELREF
      REAL ANGL(JBMAX),PRAY

      COMMON /MISCL/ ISYS,IFMT,ITPFMT,
     &               MTXNAM,LINNUM,
     &               MSK,NA,NAPMIN,NAPMAX,NATOP,NABOT,
     &               NV,VELRFL,VELINC,SLORFL,SLOINC,VELREF,
     &               ANGL,PRAY
C     MISCL COMMON ---------------------------------------------------


      INTEGER INDREC(IXMAX*ixsegm)

C * * * PWMBS COMMON (END) * * * *

C * * DATA ARRAYS NOT IN COMMON * *


C     MINIMUM AND MAXIMUM VELOCITIES
      REAL VMIN(IZSEGM),VMAX(IZSEGM)
      PARAMETER(NZMAX=900,NXMAX=1500)
      REAL VEL(NXMAX,NZMAX),VELIST(300*maxnv),SLOP(MAXNV,IZSEGM)
      INTEGER NUMVEL(IZSEGM)


C * * * END MEMORY SPACE ALLOCATION * * * * * * *


C     READ LINE HEADER TO DETERMINE VELOCITY TAPE DIMENSIONS

C*******************************************************************
C     READ LINE HEADER -  tape must be open exterior to this routine
C*******************************************************************
      JEOF = 0
      CALL RTAPE(LUV,IHEAD,JEOF)
      IF(JEOF.EQ.0)THEN
         WRITE(LUPRT,*)' ERROR READING LINE HEADER'
         STOP 75
      ENDIF
c     LTR   = IHEAD(11) = no of traces
c     LREC  = IHEAD(12) = no of rec = 1
c     KSAMP = IHEAD(14) = no of samples
c     DXN   = IHEAD(53) = trace spacing
c     DZN   = IHEAD(54) = depth spacing
c     VMINT = IHEAD(123) = minimum velocity on tape
c     VMAXT = IHEAD(124) = maximum velocity on tape
      CALL SAVER(IHEAD, 'NumTrc', LTR, LINHED)
      CALL SAVER(IHEAD, 'NumRec', LREC, LINHED)
      CALL SAVER(IHEAD, 'NumSmp', KSAMP, LINHED)
      CALL SAVER(IHEAD, 'Dx1000', IDX, LINHED)
      CALL SAVER(IHEAD, 'Dz1000', IDZ, LINHED)
      CALL SAVER(IHEAD, 'MinVel', IVMIN, LINHED)
      CALL SAVER(IHEAD, 'MaxVel', IVMAX, LINHED)
      DXN = FLOAT(IDX)/1000.
      DZN = FLOAT(IDZ)/1000.
      VMINT = IVMIN
      VMAXT = IVMAX
cmat  LTR   = IHEAD(11)
cmat  LREC  = IHEAD(12)
cmat  KSAMP = IHEAD(14)
cmat  DXN   = IHEAD(53)/1000.
cmat  DZN   = IHEAD(54)/1000.
      IF(DZTAP.GT.0.0) DZN = DZTAP
      IF(DXTAP.GT.0.0) DXN = DXTAP
cmat  VMINT = IHEAD(123)
cmat  VMAXT = IHEAD(124)
      ivmov = 1
      if(ksamp.gt.nzmax-5 ) then
       dzn  = dzn*2.
       ivmov = 2
       ksamp = ksamp/2
      endif

      if(ksamp.gt.nzmax-5) then
       dzn  = dzn*2.
       ivmov = 4
       ksamp = ksamp/2
      endif

      ixmov = 1
      ixchk = jxntr*dx/dxn + 1.5
      if(ltr.gt.nxmax-5 .or. ixchk.gt.nxmax-5) then
       dxn  = dxn*2.
       ixmov = 2
       ltr   = ltr/2
      endif

      ixchk = jxntr*dx/dxn + 1.5
      if(ltr.gt.nxmax-5 .or. ixchk.gt.nxmax-5) then
       dxn  = dxn*2.
       ixmov = 4
       ltr = ltr/2
      endif
c     write(ler,*) 'ixmov,ivmov,dxn,dzn,ksamp,ixchk,ltr'
c     write(ler,*) ixmov,ivmov,dxn,dzn,ksamp,ixchk,ltr
C*******************************************************************
C     READ VELOCITY TAPE INTO VEL
C*******************************************************************
      LA = 1
      DO 300 L=1,LTR*IXMOV
         JEOF=0
         CALL RTAPE(LUV,TRACE,JEOF)
         IF(JEOF.EQ.0)THEN
            WRITE(LUPRT,*)' ERROR READING TRACE',L
            STOP 75
         ENDIF
         CALL SAVER(ITRH, 'StaCor', I125, TRCHED)
cmat     IF(ITRH(125).EQ.30000)THEN
         IF(I125.EQ.30000)THEN
            WRITE(LUPRT,*) 'DEAD TRACE ON VELOCITY TAPE, trace = ', L
            WRITE(LUPRT,*) 'JOB TERMINATED'
            STOP 75
         ENDIF
         IF((L-1)/IXMOV*IXMOV .EQ. L-1) THEN
         JA=1
         DO 310 JZ=1,KSAMP*IVMOV,IVMOV
         VEL(LA,JA) = DATA(JZ)
  310    JA=JA+1
         LA=LA+1
         ENDIF
  300 CONTINUE

         DO 312 JX=1,LA-1
  312    VEL(JX,LA+1) = VEL(JX,LA)
C     CLOSE VELOCITY TAPE
      CALL LBCLOS(LUV)

c     write(ler,*) 'velocity tape read'
      XWTH=LTR*DXN
      ZDEP=KSAMP*DZN
      WRITE(LUPRT,*)'                                       '  
      WRITE(LUPRT,*)'INPUT VELOCITY MODEL WIDTH AND DEPTH = ',XWTH,ZDEP
      WRITE(LUPRT,*)'                                       '  
      IF(ZDEP.GT.ZMAX) ZDEP=ZMAX

C     XBEGIN BIAS
      LXBIAS= (XBEGIN/DXN+.5) +1
      IF(XBEGIN.LT.0.0) LXBIAS= (XBEGIN/DXN-.5) +1
C     ACTUAL NEEDED WIDTH IN DX0 UNITS
      IXLEN = (JXNTR*DX+XSHFT)/DX0 +.5
      JXBYT = IXLEN*4
      LXLEN  = IXLEN*DX0/DXN +2.5
      IF(LXBIAS.GT.LA-1) THEN
       WRITE(LUPRT,*) 'MODEL ORIGIN OUT OF RANGE OF VEL TAPE'
       CALL CCEXIT(200)
      ENDIF

C     ALIGN VELOCITY MODEL WITH TRACE ORIGIN AND PAD TO ZMAX
      LZMAX = ZMAX/DZN +2.5
      NZLOOP = MIN0(LZMAX,KSAMP)
c     write(ler,*) 'lzmax,nzloop,ixlen,lxlen,lxbias'
c     write(ler,*) lzmax,nzloop,ixlen,lxlen,lxbias

      DO 315 JZ=1,NZLOOP

       if(lxbias.lt.1) then

       DO 316 JX=1,-LXBIAS+1
  316  DATA(JX) = VEL(1,JZ)
       LXBEG = -LXBIAS+2
cndw01 LXEND = LXLEN - LXBEG + 1
       LXEND = LXLEN 
cndw10 IF(LXEND.GT.LTR) THEN
cndw10  LXPAD = LXEND - LTR
cndw10  LXEND = LTR
cndw10 ENDIF
       IF(LXEND-LXBEG +1 .GT.LA-1) THEN
        LXPAD = LXEND - LXBEG +1 - (LA-1)
        LXEND = LXBEG +(LA-1) -1
       ENDIF
       if(jz.eq.1) then
c      write(ler,*) 'lxpad,lxend,lxbeg'
c      write(ler,*) lxpad,lxend,lxbeg
       endif
       IF(LXEND.GE.LXBEG) THEN
        DO 317 JX=LXBEG,LXEND
  317   DATA(JX) = VEL(JX-LXBEG+1,JZ)
       ENDIF
       IF(LXPAD.GT.0) THEN
        DO 318 JX=LXEND+1,LXEND+LXPAD+1
  318   DATA(JX) = DATA(LXEND)
       ENDIF

       else

       LXBEG = LXBIAS
       LXEND = LXLEN + LXBEG -1
cndw01 IF(LXEND.GT.LTR) THEN
cndw01  LXPAD = LXEND - LTR
cndw01  LXEND = LTR
cndw01 ENDIF
       IF(LXEND.GT.LA-1) THEN
        LXPAD = LXEND - (LA-1)
        LXEND = LA-1
       ENDIF
       IF(LXEND.GE.LXBEG) THEN
        DO 320 JX=LXBEG,LXEND
  320   DATA(JX-LXBEG+1) = VEL(JX,JZ)
       ENDIF
       IF(LXPAD.GT.0) THEN
        DO 321 JX=LXEND+1,LXEND+LXPAD
  321   DATA(JX-LXBEG+1) = DATA(LXEND-LXBEG+1)
       ENDIF

       endif
c      if(jz.eq.1) then
c      write(ler,*) 'lxpad,lxend,lxbeg,la-1,lxlen'
c      write(ler,*) lxpad,lxend,lxbeg,la-1,lxlen
c      endif

       DO 322 JX=1,LXLEN
c      if(jz.eq.1) write(ler,*) jx,data(jx)
  322  VEL(JX,JZ) = DATA(JX)

  315 CONTINUE

C     VELOCITY MODEL ALIGNED WITH TRACE DATA
C     PAD TO LZMAX IF NECESSARY

      IF(NZLOOP.LT.LZMAX) THEN
      DO 330 JZ = NZLOOP+1,LZMAX
      DO 330 JX = 1,LXLEN
  330  VEL(JX,JZ) = VEL(JX,NZLOOP)
      ENDIF

      NXPRT = lxlen/3
      NZPRT = 10
      n2 = lxlen/2
      n3 = lxlen
c     do 331 jz = 1,lzmax
c 331 write(luprt,*) jz,vel(1,jz),vel(n2,jz),vel(n3,jz)
c     write(ler,*) 'velocity matrix filled'
      ZSLICE=ZDEP/IZSEG
      ZBEG(1)=0.0
      ZEND(1)=ZSLICE
      iibeg = zbeg(1)/dzn + 1
      iiend = zend(1)/dzn
      JZCNT=0

      DO 10 IZS=1,IZSEG

c     write(ler,*) 'seg num =',izs
C     SET BEGINNING AND ENDING DEPTHS FOR A VERTICAL SEGMENT

      IF(IZS.GT.1) THEN
       ZBEG(IZS)=ZEND(IZS-1)
       ZEND(IZS)=ZBEG(IZS)+ZSLICE
cv8d   WRITE(LUPRT,*) 'IZS,ZBEG,ZEND,IZS=',IZS,ZBEG(IZS),ZEND(IZS)
      ENDIF

       IIBEG = ZBEG(IZS)/DZN + 1
       IIEND = ZEND(IZS)/DZN

C     SCAN FOR MININUM VELOCITY WITHIN A VERTICAL SEGMENT
       vmin(izs) = 10000000.
       vmax(izs) = 0.0
       do 400 jz=iibeg,iiend
       do 400 jx=1,lxlen
       if(vmin(izs).gt.vel(jx,jz)) vmin(izs)=vel(jx,jz)
400    if(vmax(izs).lt.vel(jx,jz)) vmax(izs)=vel(jx,jz)

c      write(ler,*) 'vmin,vmax=',vmin(izs),vmax(izs)

C     SET DZ TO 1/2 SPATIAL NYQUIST

C**** DZ(IZS)=.25*(VMIN/((FMAX+F3)/2.))
      DZ(IZS)=.25*( VMIN(IZS) /FMAX)
      if(izs.gt.1) dz(izs) = .5 * (dz(izs)+dz(izs-1))
      if(dz(izs).lt.dzout) dz(izs) = dzout
      THICK=ZEND(IZS)-ZBEG(IZS)
      ITEMP=THICK/DZ(IZS)
cv6   make # extrap steps divisible by 1,2,3,4 and 6
c**   itemp = (itemp + 6)/12*12
cv6   make # extrap steps divisible by 1,2
      itemp = (itemp + 1)/2*2
      if(itemp.le.0) itemp=1

cv8d  WRITE(LUPRT,*)
cv8d &'MIN VEL & # EXTRP. STEPS IN SEG ',IZS,'=',VMIN(IZS),ITEMP
      DZ(IZS)=THICK/ITEMP
c     write(ler,*) 'DZ FOR SEGMENT',IZS,'=',DZ(IZS)
      JZCNT=JZCNT+ITEMP
      IF(DZOUT.GT.DZ(IZS))
     &WRITE(LUPRT,*)'WARNING: delz > spatial nyquist'

   10 CONTINUE

      IZXTR=0
      IF( ZMAX.GT.ZEND(IZSEG) ) IZXTR=( ZMAX-ZEND(IZSEG) )/DZ(IZSEG)
      JZCNT=JZCNT+IZXTR
      IZLN=JZCNT
cv8d  WRITE(LUPRT,*) 'NUMBER OF Z-EXTRAPOLATION STEPS=',JZCNT

C     ADD A FEW ROWS FOR GOOD MEASURE

      JZCNT=JZCNT+10

C     ALLOCATE/OPEN LUMTX

      OPEN(UNIT=LUMTX,FORM='UNFORMATTED',
     1        STATUS='SCRATCH',ACCESS='DIRECT',RECL=IXLEN*ISZBYT)


C     BUILD AND WRITE OUT INDICES AND ZTABLE FOR EACH VERTICAL SEGMENT

      IZCNT=0
      ZTEMP=-DZ(1)
      DO 20 IZS=1,IZSEG
CCRAY
cv8d  write(luprt,*) 'building indices for segment',izs

C     compute index table and velocity list from vel
      IZB(IZS)=IZCNT
      IZLEN=(ZEND(IZS)-ZBEG(IZS)-1.)/DZ(IZS)+.5
c     set velocity binning interval
      delv = -3.
      iztemp = izcnt
c     set velocity binning interval
 810  delv = delv +4.0
c     initialize velocity list
      izcnt = iztemp
      IVLIST    = 1
      JZ=(ZBEG(IZS))/DZN+1.5
      VELIST(1) = ifix( (delv/2.+vel(1,jz))/delv )*delv
      Z=ZBEG(IZS)-DZ(IZS)
      DO 801 IZ=1,IZLEN
       Z=Z+DZ(IZS)
       JZ=Z/DZN+1.5
c      for each x check to see if new member of velist and set index
        DO 802 IX=1,IXLEN
        JX = (IX-1)*DX0/DXN+1.5
        vtemp = ifix( (delv/2.+vel(jx,jz))/delv )*delv
        ivltmp= ivlist
         do 803 iv=1,ivltmp
         if(abs(vtemp-velist(iv)) .lt. delv ) then
          indrec(ix) = iv
          go to 802
         endif
  803   continue
        ivlist = ivlist + 1
        velist(ivlist) = vtemp
        indrec(ix) = ivlist
  802   continue
      IZCNT=IZCNT+1
      CALL DAWRTE(IZCNT,INDREC,LUMTX,JXBYT)
  801 CONTINUE
c     write(ler,*) 'ivlist',ivlist
      if(ivlist.gt.maxnv) go to 810
                                           
C     PUT RECIPROCAL OF VELOCITIES IN SLOP:
      DO 900 IV=1,IVLIST
c     write(ler,*) 'iv,izs,vel',iv,izs,velist(iv)
  900 SLOP(IV,IZS) = 1./VELIST(iv)
c     write(ler,*) 'ivlist,izs',ivlist,izs

C     PUT IVLIST INTO NUMVEL
      NUMVEL(IZS) = IVLIST

      JZROW(IZS)=IZCNT-IZB(IZS)


C     BUILD ZTABLE
      J1=IZB(IZS)+1
      J2=IZB(IZS)+JZROW(IZS)
       DO 30 JZ=J1,J2
       ZTEMP=ZTEMP+DZ(IZS)
  30   ZTABLE(JZ)=ZTEMP

  20  CONTINUE


C     Z-PAD EXTRA ROWS ON INDEX DATASET

      IF(IZXTR.GT.0) THEN

       J1=J2+1
       J2=J1+IZXTR

       DO 40 JZ=J1,J2
       CALL DAWRTE(JZ,INDREC,LUMTX,JXBYT)
       ZTEMP=ZTEMP+DZ(IZSEG)
  40   ZTABLE(JZ)=ZTEMP

      ENDIF

      RETURN
      END
C****************************************************************************
