C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c fxsns - Read the fxsmig output (shot migration in depth) and stak
c       - stak by lining up the GI's
c       - Also produce a sorted dataset, sorted by gi(RecInd) 
c Mary Ann Thornton           Version 1.0          Date:   March 20, 1995
c Mary Ann Thornton           Version 2.0          Date: October 10, 1995
c       - Add the sort_by_GI option
c**********************************************************************c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
      integer     lhed ( SZLNHD )
      integer * 2 itr  ( SZLNHD )
      real        head ( SZLNHD )

      integer nsamp, nsi, ntrc, nrec, iform, obytes
      integer luin , luout, luout2, lbytes, nbytes, lbyout
      integer lugeom
 
c------
c  dynamic memory allocation for big arrays, eg whole records
      real    bigar1
      pointer (wkadr1, bigar1(1))

c------
c  dynamic memory allocation for table to hold recind's in sequential order
c  and table to hold recind's in sorted order - 
c  gicnt will contain the number of gi's per output sorted record
      integer gitab1, gitab2, gicnt
      pointer (pgitab1,gitab1(1)),(pgitab2,gitab2(1))
      pointer (pgicnt, gicnt (1))

c------
      integer     gi1, gi2, ginc
      integer     recind, stacor
c-----
      real        tri ( SZLNHD ), zero(SZLNHD)
      character   ntap  * 100, otap * 100, name*5, version*4
      character   otap2 * 100, geom * 100
      logical     verbos, hlp, query, heap1, vsp
      integer     argis
 
      equivalence ( itr( 1), lhed (1), head(1) )

      data lbytes / 0 /, nbytes / 0 /, name/'FXSNS'/, version /' 2.0'/ 
      data lugeom /62/
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      hlp = ( argis ( '-h' ) .gt. 0 )
      if ( query .or. hlp )then
            call help()
            stop
      endif
c-----
c     open printout files
c-----
#include <f77/mbsopen.h>
 
      call gcmdln(ntap,otap,otap2,geom,gi1,gi2,ginc,verbos)

      if(geom.ne.' ')then
         open(lugeom,file=geom,status='OLD',iostat=ioerror,
     &        form='FORMATTED')
         if(ioerror .ne. 0) then
            write(LOT,*) '****************ERROR****************'
            write(LOT,*) 'geometry file = ',geom
            write(LOT,*) 'cannot access/read file'
            go to 100
         endif
         read(lugeom,*,err=9000)
         read(lugeom,*,err=9000) n1,d1,n2,ioversion
         read(lugeom,*,err=9000)
         if(ioversion.eq.1 .or.ioversion.eq.2)then
            read(lugeom,*,err=9000) n1,gi1,gi2,d1,vsp
         endif
         if(ioversion.eq.3)then
            read(lugeom,*,err=9000) n1,gi1,gi2,d1,d2,d3,vsp
         endif
         close(lugeom)
      endif
      go to 100
 9000 continue
      write(LOT,*)' *************ERROR************** '
      write(LOT,*)' Error reading geometry file ',geom
      write(LOT,*)' ******************************** '
  100 continue
      if(gi1.eq.0 .and. gi2.eq.0)then
         write(LOT,*)' starting and ending gis cannot both be zero'
         write(LOT,*)'JOB TERMINATED'
         stop
      endif
      maxgi = gi2 - gi1 + 1
      nrecout =  nint((gi2-gi1+1.)/ginc+.5)
 
c-----
c     get logical unit numbers for input and output of seismic data
      call getln(luin  , ntap ,'r', 0)
      call getln(luout , otap ,'w', 1)
 
c-----
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'FXSNS: no lineheader read from unit ',luin
         write(LOT,*)'JOB TERMINATED'
         stop
      endif
c------
c     save certain place header parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header

      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c------
      write(LERR,*)'RecInd,ifmt,l_RecInd,length= ',
     1             ifmt_RecInd,l_RecInd,ln_RecInd
      write(LERR,*)'StaCor,ifmt,l_StaCor,length= ',
     1             ifmt_StaCor,l_StaCor,ln_StaCor
 
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'Dz1000', idz  , LINHED)
      dz = idz/1000.
 
c------
      call hlhprt (itr, lbytes, name, 5, LERR)
c-----
c---------------------------------------------------
c  malloc only space we're going to use for big work array for stak
      heap1 = .true.
c--------------------------
      iwords = maxgi * (nsamp+ITRWRD)
      item1  = maxgi * (nsamp+ITRWRD) * SZSMPD
      abort1 = 0.0
      call galloc (wkadr1, item1, ierr1, abort1)
      if (ierr1 .ne. 0) heap1 = .false.
      if (.not. heap1) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
      endif
      call vclr(bigar1,1,iwords)
c---------------------------------------------------
c  malloc space for gi sort tables
      heap1  = .true.
      maxtra = nrec*ntrc
      iwords = maxtra*2
      item1  = iwords * SZSMPD
      abort1 = 0.0
      ierr1  = 0
      call galloc(pgitab1, item1, ierr1, abort1)
      if(ierr1.ne.0)heap1 = .false.
      if(.not. heap1)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate sort table workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating sort table workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
      endif
      call vclr(gitab1,1,iwords)

      heap1  = .true.
      iwords = maxtra
      item1  = iwords * SZSMPD
      abort1 = 0.0
      ierr1  = 0
      call galloc(pgitab2, item1, ierr1, abort1)
      if(ierr1.ne.0)heap1 = .false.
      if(.not. heap1)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate sort table workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating sort table workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
      endif
      call vclr(gitab2,1,iwords)
      
      heap1  = .true.
      iwords = maxtra
      item1  = maxtra * SZSMPD
      abort1 = 0.0
      ierr1  = 0
      call galloc(pgicnt, item1, ierr1, abort1)
      if(ierr1.ne.0)heap1 = .false.
      if(.not. heap1)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate sort table workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating sort table workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*)' '
      endif
      call vclr(gicnt,1,iwords)

c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', maxgi  , LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into historical LH:
      call savhlh(itr,lbytes,lbyout)
c----------------------
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout )
c-----
      if( verbos ) then
        call verbal(nsamp,nsi,ntrc,nrec,maxgi,nrecc,iform,gi1,gi2,
     &              ginc,ntap,otap,otap2,geom)
      end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      if (nsi .le. 32) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING AND STAK
c-----
c--------------------------------------------------
      begstk = timer(0.0)
      itrcnt = 0
      do 1000 jj = 1, nrec
         do 1001  kk = 1, ntrc
            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
            call saver2(lhed,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                  recind , TRACEHEADER)
            call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                  stacor , TRACEHEADER)
            itrcnt = itrcnt + 1
            gitab2(itrcnt) = recind
            if (stacor .eq. 30000) then
               call vclr (tri,1,nsamp)
c              Mark this trace so later we know not to use it in the sort
               gitab2(itrcnt) = 30000
            else
cmat           at this point gicnt is counting live traces for
cmat           the scalar on the stak 
               gicnt(recind-gi1+1) = gicnt(recind-gi1+1)+1
            endif
            m = (recind - gi1) * nsamp + 1
            call vadd (tri,1,bigar1(m),1,bigar1(m),1,nsamp)
 1001    continue
 1000 continue
c-----
c     The summing is finished, now write out the traces
c-----
      call vclr(lhed,1,ITRWRD)
      recind = gi1
      do 1002 kk = 1, maxgi
         istrc = (kk-1) * nsamp
         itr(106) = 1
         itr(107) = kk
         itr(118) = recind
         scale = 1.0/gicnt(kk)
         call vsmul(bigar1(istrc+1),1,scale,tri,1,nsamp)
         call vmov (tri,1,lhed(ITHWP1),1, nsamp)
         call wrtape (luout, itr, obytes)
         recind = recind + 1
 1002 continue
      begstk = timer(begstk)
      write(LERR,*)' time for stack = ',begstk
 
c--------------------------------------------------
c-----
c     BEGIN SORT
c-----
c--------------------------------------------------
      begsort=timer(0.0)
      call sortab(gitab1,maxtra,gitab2,gicnt,maxgi,gi1,gi2,ginc,
     &            nrecout, ntrtot)
      write(LERR,*) ' records per line output      =  ', nrecout
      begsort=timer(begsort)
      write(LERR,*)' time for sort table',begsort
c-----
c     close luin and reopen with sislgbuf off
      call lbclos(luin)
c-----
c     get logical unit numbers for input and output of seismic data
      begio=timer(0.0)
      call lbopen(luin, ntap, 'r')
      call lbopen(luout2, otap2,'w')
      call sislgbuf (luin, 'off' )
c-----
      lbytes = 0
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'FXSNS: no lineheader read from unit ',luin
         write(LOT,*)'JOB TERMINATED'
         stop
      endif
c     modify line header to reflect actual number of traces output
c-----
      call savew(itr, 'NumRec', nrecout, LINHED)
      call savew(itr, 'NumTrc', ntrtot , LINHED)
c----------------------
c----------------------
c  inject command line into historical LH:
      call savhlh(itr,lbytes,lbyout)
c----------------------
c------
c     build a zero data trace
      call vclr(zero,1,nsamp)
c     write to unit number luout2 lbyout bytes - lineheader
c------
c     Now read the traces according to the sorted table and write them
c------
      call wrtape (luout2, itr, lbyout )
      inc=0
      irec = 0
      do 2000 i=1,maxgi,ginc
         irec = irec + 1
         do 2001 j=1,gicnt(i)
            inc = inc + 1
            num=gitab2(inc)
            call sisseek(luin,num)
            nbytes=0
            call rtape(luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            itr(106) = irec
            itr(107) = j
            call wrtape(luout2, itr, obytes)
 2001    enddo
         if(gicnt(i).lt.ntrtot)then
            do 2002 k=gicnt(i)+1,ntrtot
               itr(106) = irec
               itr(107) = k
               itr(125) = 30000
               call vmov (zero,1,lhed(ITHWP1),1,nsamp)
               call wrtape(luout2, itr, obytes)
 2002       enddo
         endif
 2000 enddo
      begio = timer(begio)
      write(LERR,*)' time for io sort =',begio

c--------------------------------------------------

  999 continue
 
c--------------------------------------------------
c-----
c     close data files
c-----
      call lbclos ( luin )
      call lbclos ( luout )
      call lbclos ( luout2)
 
            write(LERR,*)'end of fxsns, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
        write(LER,*) 'fxsns sums and sorts migrated shots by GI'
        write(LER,*)
     :'see manual pages by typing man fxsns (or mman, tman, uman fxsns)'
        write(LER,*)
     :'see more cryptic online help by typing fxsns -h or fxsns "-?" '
        write(LER,*)
     :'see pattern file by typing catpat fxsns'
        write(LER,*)
     :'build an executable script by typing catpat fxsns > fxsns.job'
        write(LER,*)
     :'execute fxsns by typing fxsns and the program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]   : input data file name'
        write(LER,*)
     :' -O [otap]   : output filename of summed section'
        write(LER,*)
     :' -O2[otap2]  : output filename of sort'
        write(LER,*)
     :' -gis[gi1]   : first GI on input data'
        write(LER,*)  '(this can be read from the -GEOM file)'
        write(LER,*)
     :' -gie[gi2]   : last live GI on input data'
        write(LER,*)  '(this can be read from the -GEOM file)'
        write(LER,*)
     :' -ginc[inc]  : GI increment on sort output (No Default)'
        write(LER,*)
     :' -GEOM[geom] : input filename of the geometry file'
        write(LER,*)'(If this file is available, the program will'
        write(LER,*)' read gis & gie from this file, rather than from'
        write(LER,*)' the command line'
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   fxsns -N[ntap] -O[otap] -O2[otap2] -GEOM[geom]',
     :               '-ginc[inc] [-V]'
        write(LER,*) '       -OR-'
        write(LER,*)
     :'usage:   fxsns -N[ntap] -O[otap] -O2[otap2] ',
     :               '-gis[gis] -gie[gie] -ginc[inc] [-V]'
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,otap2,geom,gi1,gi2,ginc,verbos)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name stack
c     otap2 - C*100    output file name sort
c     geom  - C*100    geometry file name
c     gi1   - I*4      starting GI 
c     gi2   - I*4      ending GI
c     ginc  - I*4      gi increment
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), otap2*(*), geom*(*)
      integer     gi1,gi2,ginc
      logical     verbos
      integer     argis
 
c-------
            call argstr( '-N' , ntap , ' ', ' ' )
            call argstr( '-O' , otap , ' ', ' ' )
            call argstr( '-O2', otap2, ' ', ' ' )
            call argstr( '-GEOM', geom, ' ', ' ' )
            call argi4 ( '-gis', gi1,0 ,0     )
            call argi4 ( '-gie', gi2,0 ,0     )
            call argi4 ( '-ginc', ginc,1 ,1   )
            verbos =   (argis('-V') .gt. 0)
 
c-------
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp,nsi,ntrc,nrec,maxgi,nrecc,iform,gi1,gi2,
     &                  ginc,ntap,otap,otap2,geom)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples input
c     nsi   - I*4     sample interval in ms input
c     ntrc  - I*4     traces per record on input
c     nrec  - I*4     number of records per line on input
c     otap  - C*100   output file name stack
c     maxgi - I*4     traces per record on stack output
c     nrecc - I*4     number of records per line on stack output
c     iform - I*4     format of data
c     gi1   - I*4     first GI on input
c     gi2   - I*4     last GI on input
c     ntap  - C*100   input file name
c     otap2 - C*100   output file name sort
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, nrecc, maxgi
      integer     gi1, gi2, ginc
      character   ntap*(*), otap*(*), otap2*(*), geom*(*)
 
      write(LERR,*)' '
      write(LERR,*)' line header values after default check '
      write(LERR,*) ' # of samples/trace input     =  ', nsamp
      write(LERR,*) ' sample interval input        =  ', nsi
      write(LERR,*) ' traces per record input      =  ', ntrc
      write(LERR,*) ' records per line input       =  ', nrec
      write(LERR,*) ' format of data               =  ', iform
      write(LERR,*) ' input data set name          =  ', ntap
      write(LERR,*) ' first GI                     =  ', gi1
      write(LERR,*) ' last GI                      =  ', gi2
      write(LERR,*) ' GI increment                 =  ', ginc
      write(LERR,*)' '
      write(LERR,*) ' output stack dataset name    =  ', otap
      write(LERR,*) ' records per line output      =  ', nrecc
      write(LERR,*) ' traces per record output     =  ', maxgi
      write(LERR,*)' '
      write(LERR,*) ' output sort dataset name     =  ', otap2
      if(geom.ne.' ')then
      write(LERR,*) ' geometry file name           =  ', geom
      endif
      write(LERR,*)' '
 
      return
      end
 
