C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fillmap(nz,nx,datao,tdead,tbig)

c     fill tt map                            
c     Dan Whitmore

      parameter (nzmax=20000)

      real datao(nz,nx)
      integer izf(nzmax)

c ------------------------------------------------------

c
c     scan travel-time map and fill in missing times
c   

      iflag = 0
c     horizontal scan
      do jz=1,nz
       if(datao(jz,nx) .ne. tdead) iflag = iflag+1
       icount = 0
       do jx=1,nx
        if(datao(jz,jx) .ne. tdead) then
         icount = icount+1
         izf(icount) = jx
        endif
       enddo
       if(icount.gt.1) then
        do jc=1,icount-1
         jx1 = izf(jc)
         jx2 = izf(jc+1)
          if(jx1.ne.jx2) then
           do jx=jx1,jx2
            a = float(jx-jx1)/float(jx2-jx1)
            datao(jz,jx)=datao(jz,jx1)+a*(datao(jz,jx2)-datao(jz,jx1))
           enddo
          endif
c         if any rays go out the side fill last row to the corner
          if(jx2.lt.nx .and. iflag.gt.0 .and. jz.eq.nz) then
           do jx=jx2+1,nx
            a = float(jx-jx1)/float(jx2-jx1)
            datao(jz,jx)=datao(jz,jx1)+a*(datao(jz,jx2)-datao(jz,jx1))
           enddo
          endif
        enddo
       endif
      enddo

c     vertical scan
      do jx=1,nx 
       icount = 0 
       do jz=1,nz
        if(datao(jz,jx) .ne. tdead) then
         icount = icount+1
         izf(icount) = jz
        endif
       enddo
       if(icount.gt.1) then
        do jc=1,icount-1
         jz1 = izf(jc)
         jz2 = izf(jc+1)
          if(jz1.ne.jz2) then
           do jz=jz1,jz2
            a = float(jz-jz1)/float(jz2-jz1)
            dataO(jz,jx)=datao(jz1,jx)+a*(datao(jz2,jx)-datao(jz1,jx))
           enddo
          endif
        enddo
       endif
      enddo

1000  continue

      do jx=1,nx
       do jz=1,nz
        if(datao(jz,jx) .eq. tdead) datao(jz,jx) = tbig
       enddo
      enddo
 
      return
      end
