C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getslo(slow,p2,nz,nx,luv,trace,rtrd,lprt,ismv,ismh,
     &            scale_slow,ierr,iheada,itrh,itrwrd)
      real      trace(*),rtrd(*),slow(nz,nx),p2(nz,nx)
      integer   iheada(*),itrh(*)

c     read velocity dataset and put reciprocal into slow
c     shift down one node to allow for ray trace boundary conditions
      do jx=1,nx
            jeof=0
            call rtape(luv,trace,jeof)
              if(jeof.le.0) then
                 write(lprt,*)'error in reading input velocity'
                 write(lprt,*)'trace=',jx
                 ierr = 1000
                 return
              endif
            call vmov(itrh,1,iheada( 1+itrwrd*(jx-1) ),1,itrwrd)
            do jz=1,nz-1
             slow(jz+1,jx) = scale_slow/rtrd(jz)
            enddo
            slow(1,jx) = slow(2,jx)
      enddo
      
c     smooth slowness field in the x direction
      if(ismh.gt.0) then
       do js = 1,ismh

        scale = 1./3.
        do jx=2,nx-1
         do jz=2,nz-1
          p2(jz,jx)= scale *                                      
     &       (slow(jz,jx-1)+slow(jz,jx)+slow(jz,jx+1))
         enddo
        enddo

        do jx=2,nx-1
         do jz=2,nz-1
           slow(jz,jx)= p2(jz,jx)                                       
         enddo
        enddo

       enddo
      endif

c     smooth slowness field in the z direction
      if(ismv.gt.0) then
       do js = 1,ismv

        scale = 1./3.
        do jx=2,nx-1
         do jz=2,nz-1
          p2(jz,jx)= scale *                                      
     &      ( slow(jz-1,jx)+slow(jz,jx)+slow(jz+1,jx) )
         enddo
        enddo

        do jx=2,nx-1
         do jz=2,nz-1
           slow(jz,jx)= p2(jz,jx)                                       
         enddo
        enddo

       enddo
      endif

      return
      end
