C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c getputdw - Either get or put dw,w0 in lineheader
c getputdw.F
c************************************************************************
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
      integer     lhed (SZLNHD)
      integer * 2 itr  (SZLNHD)
      real        head (SZLNHD)

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin, luout, lbytes, nbytes, lbyout
      integer     ns, ne, irs, ire
      real        dw, w0

      character   ntap  * 100, otap * 100, name*8, version*4
      logical     verbos, hlp, query, get, put
      integer     argis
      equivalence (itr( 1), lhed (1), head(1))
      data lbytes/ 0 /, nbytes/ 0 /, name/'GETPUTDW'/, version/' 1.0'/ 
 
c-----
c     read program parameters from command line card image file
      query = ( argis ( '-?' ) .gt. 0 )
      hlp = ( argis ( '-h' ) .gt. 0 )
      if ( query .or. hlp )then
            call help()
            stop
      endif
c-----
c     open printout
#include <f77/mbsopen.h>
c-----
c     read command line arguments
      call gcmdln(ntap,otap,get,put,dw,w0,verbos)
c-----
c     open input and output files
      call getln(luin , ntap ,'r', 0)
      if(put)then
         call getln(luout, otap ,'w', 1)
      endif
c-----
      lbytes = 0
      call rtape(luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'getputdw: no line header read from unit ',luin
         write(LOT,*)'JOB TERMINATED ABNORMALLY'
         stop
      endif
c------
c     save values from velocity line header
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
c------
c------
c     print line header into printer listing
      call hlhprt(itr, lbytes, name, 5, LERR)
c-----
c     check validity of these arguments
      ns = 1
      ne = 0
      irs = 1
      ire = 0
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c-----
c     modify line header to reflect actual number of traces output
      nrecc = ire - irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr   = ne - ns + 1
      call savew(itr, 'NumTrc', jtr  , LINHED)
      write(LERR,*)' w0, dw to put into lineheader ', w0, dw
      if(put)then
         call putfp(itr, 'ReSpFm', w0, LINHED)
         call putfp(itr, 'RATTrc', dw, LINHED)
      endif
      if(get)then
         call getfp(itr, 'ReSpFm', w0, LINHED)
         call getfp(itr, 'RATTrc', dw, LINHED)
         call lbclos(luin)
         if(verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     &               ntap,otap,get,put,dw,w0,verbos)
         endif
         write(6,*) ' omega_zero, delta_omega = ',w0, dw
         go to 2000
      endif
c----------------------
c     determine obytes as the number of bytes in output trace
      obytes = SZTRHD + nsamp * SZSMPD
c----------------------
c     save command line arguments in the historical part of line header
      call savhlh(itr,lbytes,lbyout)
c----------------------
c     write the output line header
      call wrtape(luout, itr, lbyout )
 
c-----
      if( verbos ) then
         call verbal(nsamp, nsi, ntrc, nrec, iform,
     &               ntap,otap,get,put,dw,w0,verbos)
      endif

c-----
c--------------------------------------------------
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c-----
c--------------------------------------------------
c--------------------------------------------------

c-----skip unwanted records
      call recskp(1,irs-1,luin ,ntrc,itr)

c-----LOOP ON RECORDS
      do 1000 jj = irs, ire
         call trcskp(jj,1,ns-1,luin ,ntrc,itr)

c--------LOOP ON TRACES
         do 1003  nn = ns, ne

c           read the velocity traces into itr then write
            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on velocity input:',luin
               write(LERR,*)'  rec= ',jj,'  trace= ',nn
               go to 999
            endif
            call wrtape (luout, itr, obytes)
 1003    continue
c-----
c        skip to end of record
         call trcskp(jj,ne+1,ntrc,luin ,ntrc,itr)
 1000 continue

c--------------------------------------------------
c--------------------------------------------------
c-----
c     END PROCESSING
c-----
c--------------------------------------------------
c--------------------------------------------------
 
  999 continue
 
c-----
c     close data files
      call lbclos(luin)
      call lbclos(luout)
c-----
 2000 continue
      write(LERR,*)'end of getputdw, processed ',nrec,' record(s)',
     &               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
C***********************************************************************
C***********************************************************************
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)'getputdw reads a lineheader and either puts w0 and'
        write(LER,*)'dw into the lineheader, or gets dw and w0 from  '
        write(LER,*)'the lineheader and prints it '
        write(LER,*)'Users enter the following parameters '
        write(LER,*)' '
        write(LER,*)'-N[ntap] : input dataset'    
        write(LER,*)'-O[otap] : output dataset'    
        write(LER,*)'-get     : retrieve & print w0,dw from lineheader'
        write(LER,*)'-put     : put dw,w0 in lineheader'
        write(LER,*)'-dw      : Delta-omega to put in lineheader'
        write(LER,*)'-w0      : Omega-zero to put in lineheader'
        write(LER,*)'-V       : for verbose printout'
        write(LER,*)' '
        write(LER,*)'usage:  '
        write(LER,*)'getputdw -N[ntap] -get [-V] - OR - '
        write(LER,*)'getputdw -N[ntap] -put -dw[] -w0[] [-V]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
C***********************************************************************
C***********************************************************************
C***********************************************************************
      subroutine gcmdln(ntap,otap,get,put,dw,w0,verbos)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     get   - L        flag indicating get from lineheader
c     put   - L        flag indicating put in lineheader
c     dw    - real     delta-omega to  put in lineheader
c     w0    - real     omega-zero  to  put in lineheader
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      logical     verbos, get, put
      real        dw, w0
      integer     argis
 
c-------
c     last 2 arguments are values used when:
c     (1) if ONLY the key is present (no value attached to it)
c     (2) if NO key & no value are present
c-------
            call argstr('-N', ntap, ' ', ' ')
            call argstr('-O', otap, ' ', ' ')
            call argr4 ('-dw', dw ,0.0 ,0.0 )
            call argr4 ('-w0', w0 ,0.0 ,0.0 )
            verbos =   (argis('-V') .gt. 0)
            get    =   (argis('-get') .gt. 0)
            put    =   (argis('-put') .gt. 0)
      if(put)then
         if(dw.le.0.0 .or. w0.le.0.0)then
            write(LERR,*)'dw & w0 may not be zero with the put option'
            stop 100
         endif
      endif
c-------
      return
      end
 
C***********************************************************************
C***********************************************************************
C***********************************************************************
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     &               ntap,otap,get,put,dw,w0,verbos)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name velocity
c     otap  - C*100   output file name
c     get   - L       flag indicating get from lineheader
c     put   - L       flag indicating put in lineheader
c     dw    - real    delta-omega to  put in lineheader
c     w0    - real    omega-zero  t0  put in lineheader
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      logical     get,put
      real        dw,w0
      character   ntap*100, otap*100
 
      write(LERR,*)' '
      write(LERR,*)' line header values after default check '
      write(LERR,*)' # of samples/trace          =  ', nsamp
      write(LERR,*)' sample interval             =  ', nsi
      write(LERR,*)' traces per record           =  ', ntrc
      write(LERR,*)' records per line            =  ', nrec
      write(LERR,*)' format of data              =  ', iform
      write(LERR,*)' input dataset               =  ', ntap
      write(LERR,*)' output dataset              =  ', otap
      if(get)then
         write(LERR,*)' get w0,dw from lineheader '
      endif
      if(put)then
         write(LERR,*)' put w0,dw in lineheader '
      endif
      write(LERR,*)'    delta-omega           =  ', dw
      write(LERR,*)'    omega-zero            =  ', w0
      write(LERR,*)' '
 
      return
      end
 
