C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE MEDIAN (X,NX,NF,Y)                                     00158100
C********************************************************************** 00158200
C                                                                     * 00158300
C      SUBROUTINE - MEDIAN               ENTRY POINTS - MEDIAN        * 00158400
C                                                                     * 00158500
C                                                                     * 00158600
C      LANGUAGE - FORTRAN                                             * 00158700
C      SYSTEM - IBM                                                   * 00158800
C      AUTHOR - JH BODINE                                             * 00158900
C      DATE WRITTEN - NOVEMBER 1981                                   * 00159000
C                                                                     * 00159100
C  AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE  * 00159200
C  =================================================================  * 00159300
C                                                                     * 00159400
C      ABSTRACT -                                                     * 00159500
C         PERFORMS MEDIAN FILTERING WITH VARIABLE LENGTH FILTER       * 00159600
C                                                                     * 00159700
C      USAGE -                                                        * 00159800
C         CALL MEDIAN (X,NX,NF,Y)                                     * 00159900
C                                                                     * 00160000
C      PARAMETERS -                                                   * 00160100
C     X - INPUT ARRAY TO BE FILTERED                                  * 00160200
C    NX - LENGTH OF X                                                 * 00160300
C    NF - NO. POINTS IN MEDIAN FILTER (MUST BE ODD)                   * 00160400
C         MAX 99 POINTS                                               * 00160500
C     Y - FILTERED OUTPUT ARRAY                                       * 00160600
C                                                                     * 00160700
C                                                                     * 00160800
C      ERROR CONDITIONS:                                              * 00160900
C                                                                     * 00161000
C                                                                     * 00161100
C                                                                     * 00161200
C      SUBFUNCTIONS:  NONE.                                           * 00161300
C                                                                     * 00161400
C                                                                     * 00161500
C                                                                     * 00161600
C********************************************************************** 00161700
C                    | MODIFICATION HISTORY |                         * 00161800
C                     ======================                          * 00161900
C                                                                     * 00162000
C                                                                     * 00162100
C                                                                     * 00162200
C                                                                     * 00162300
C********************************************************************** 00162400
C                                                                       00162500
      DIMENSION F(100),X(1),Y(1)                                        00162600
      DIMENSION VMIN(100),VMAX(100)                                     00162700
C                                                                       00162800
      N = NF / 2                                                        00162900
      NS = N + 1                                                        00163000
      NE = NX - N                                                       00163100
C                                                                       00163200
      DO 10 I=1,NX                                                      00163300
         Y(I) = 0.                                                      00163400
 10   CONTINUE                                                          00163500
C                                                                       00163600
C-----------------------------------------------------------------------00163700
C          FIND MEDIAN VALUES                                           00163800
C-----------------------------------------------------------------------00163900
C                                                                       00164000
      DO 90 I=NS,NE                                                     00164100
         ISTRT = I - N                                                  00164200
         IEND = I + N                                                   00164300
         K = 0                                                          00164400
C                                                                       00164500
         DO 20 J=ISTRT,IEND                                             00164600
            K = K + 1                                                   00164700
            F(K) = X(J)                                                 00164800
 20      CONTINUE                                                       00164900
C                                                                       00165000
         VMIN(1) = F(1)                                                 00165100
         VMAX(1) = F(1)                                                 00165200
         KK = 1                                                         00165300
C                                                                       00165400
         NF1 = NF-1                                                     00165500
C                                                                       00165600
         DO 30 K=1,NF                                                   00165700
            IF (F(K).GT.VMAX(KK)) VMAX(KK) = F(K)                       00165800
            IF (F(K).LT.VMIN(KK)) VMIN(KK) = F(K)                       00165900
 30      CONTINUE                                                       00166000
C                                                                       00166100
         IF (KK.EQ.N) GO TO 70                                          00166200
C                                                                       00166300
         DO 40 K=2,N                                                    00166400
            VMIN(K) = VMAX(1)                                           00166500
            VMAX(K) = VMIN(1)                                           00166600
 40      CONTINUE                                                       00166700
C                                                                       00166800
         KK = 2                                                         00166900
 50      CONTINUE                                                       00167000
C                                                                       00167100
         DO 60 K=1,NF                                                   00167200
            IF (F(K).GT.VMAX(KK).AND.F(K).LT.VMAX(KK-1)) VMAX(KK) = F(K)00167300
            IF (F(K).LT.VMIN(KK).AND.F(K).GT.VMIN(KK-1)) VMIN(KK) = F(K)00167400
 60      CONTINUE                                                       00167500
C                                                                       00167600
         IF (KK.EQ.N) GO TO 70                                          00167700
         KK = KK + 1                                                    00167800
         GO TO 50                                                       00167900
C                                                                       00168000
 70      DO 80 K=1,NF                                                   00168100
            IF (F(K).GT.VMIN(N).AND.F(K).LT.VMAX(N)) Y(I) = F(K)        00168200
            IF (Y(I).EQ.0..AND.F(K).EQ.VMIN(N).OR.Y(I).EQ.0..AND.F(K)   00168300
     1      .EQ.VMAX(N)) Y(I) = F(K)                                    00168400
 80      CONTINUE                                                       00168500
C                                                                       00168600
 90   CONTINUE                                                          00168700
C                                                                       00168800
C-----------------------------------------------------------------------00168900
C  SET UP INITIAL AND LAST VALUES OF Y ARRAY                            00169000
C-----------------------------------------------------------------------00169100
C                                                                       00169200
      DO 100 K=1,N                                                      00169300
         KK = NE + K                                                    00169400
         Y(K) = Y(NS)                                                   00169500
         Y(KK) = Y(NE)                                                  00169600
 100  CONTINUE                                                          00169700
C                                                                       00169800
      RETURN                                                            00169900
      END                                                               00170000
