C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c
c    Subroutine scanvol
c
c    Scan the desired portion of an input volume and extract the min 
c    and max values.
c
c***********************************************************************
      subroutine scanvol (irecord,irs,ire,itrace,ns,ne,ntrc,ithed,
     1                   nbytes,nsamp,vmin,vmax,dtrace,luin,lthed)

#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>


      integer     irs, ire, ns, ne
      integer     ntrc, nbytes, nsamp, luin, stacor
c     integer * 2 ithed(nsamp +(int(SZTRHD/SZSMPD)) + 1)
      integer * 2 ithed(20000)
      integer     lthed(10000)

      real        dtrace(nsamp)
      real        vmin, vmax

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
c-----
c    Skip over unwanted initial records.
c

      call recskp(1,irs-1,luin,ntrc,ithed)
 
c
c-----
 
c-----
c    We're at the start of the correct record (gather)... now
c    skip to the desired starting trace within that record.
c
      DO 990 irecord = irs, ire

          if (ns .gt. 1) then
            call trcskp(irecord,1,ns-1,luin,ntrc,ithed)
          endif

c
c-----

c-----
c    Process desired traces within a record.
c----
            do 991  itrace = ns, ne
 
                  nbytes = 0
                  call rtape( luin, ithed, nbytes)
c                 call rtape4(luin,itr,nbyte,nbytes)
c------
c    If end-of-data encountered (nbytes=0) then return to main to
c    bail out gracefully. (In our case we know something's wrong 
c    with the input dataset if we hit the end-of-file here.)
c
                  if(nbytes .eq. 0) then
                     go to 990
                  endif
c
c-----
c*****************************************************************
c-----
c    Use previously derived pointers to get trace header values
c    efficiently.
c
                  call saver2(lthed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)
 
c
c    By convention, a "Station Correction" of 30000 is used as
c    a dead trace flag! If the trace is dead, don't use it.
c
                  if (stacor .ne. 30000) then
c*****************************************************************
c-----
c    Copy the data part of the trace across to dtrace. Then get the
c    min and max of the trace and keep track if these are global.
c
                     call vmov (lthed(ITHWP1),1,dtrace,1,nsamp)
                     call minv (dtrace,1,vmn,test,nsamp)
                     call maxv (dtrace,1,vmx,test,nsamp)

                     if (vmn .le. vmin) then
                        vmin = vmn
                     endif
                     if (vmx .ge. vmax) then
                        vmax = vmx
                     endif

                  endif
c
c-----
  991       continue
c-----
c    Skip to the end of the record.
c
          if (ne .lt. ntrc) then
            call trcskp(irecord,ne+1,ntrc,luin,ntrc,ithed)
          endif
c
c-----


  990 CONTINUE
 
      return
      end
