C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

      subroutine aopen (ntpv, ntap, otap, input, dxgrid, dzgrid,
     &                  strch, icos)

      integer       argis, icos
      real          dxgrid, dzgrid,strch
      logical       query
      character*128 ntpv, ntap, otap, input
 
      query  = (argis( '-h' ) .gt. 0) .or. (argis( '-?' ) .gt. 0)

      if (query) then
         call help
         stop
      endif

      call argstr ('-N'   , ntap  , ' ', ' ')
      call argstr ('-O'   , otap  , ' ', ' ')
      call argstr ('-VEL' , ntpv  , ' ', ' ')
      call argstr ('-C'   , input , ' ', ' ')
      call argr4  ('-S'   , strch , 1.0, 1.0)
      call argr4  ('-DZT' , dzgrid, 0.0, 0.0)
      call argr4  ('-DXT' , dxgrid, 0.0, 0.0)
      call argi4  ('-IOBL', icos  , 0  , 0  )


      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C***********************************************************************
C  ROUTINE:       ZEROCK                                       ZEROCK
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       CHECK FOR AN ALL ZERO SEISMIC TRACE
C                 IZ = 0 = TRACE IS ALL ZEROES
C                 IZ = 1 = VALID TRACE
C  LANGUAGE:      FORTRAN_4
C  AUTHOR:        M.A.THORNTON
C  ORIGIN DATE:   80/06/10
C***********************************************************************
C  CATEGORY:      GENERAL PURPOSE
C  ENTRY TYPE:    SINGLE_ENTRY
C  PARAMETERS:
C      LPRT         I*4    LOGICAL UNIT NUMBER FOR PRINT OUTPUT
C      TR       (*) R*4    INPUT TRACE TO CHECK
C      NTR          I*4    LENGTH OF TRACE
C      ITR          I*4    TRACE NUMBER
C      IZ           I*4    0 = ALL ZERO TRACE, 1 = VALID TRACE
C  KEYWORDS:
C  LOGICAL UNITS:
C      6       (WRITE SEQUENTIAL)
C  FORTRAN SUPPLIED ROUTINES:
C**************************************************  END SCAN INFO  ****
C  GENERAL DESCRIPTION:
C  DESCRIPTION OF KEY VARIABLES:
C  ERROR HANDLING:
C  SPECIAL CONSIDERATIONS:
C***********************************************************************
C
      subroutine zerock (lprt, tr, ntr, itr, iz)

      real tr(*)

c-----------------------------------------------------------------------

      do 110 j = 1, ntr
         if (tr(j) .ne. 0.0) then
            iz = 1
	    return
	 endif
  110 continue

      if (lprt .ge. 0) write (lprt, 900) itr
  900 format (20x, 'TRACE', i5, '  ALL ZEROS')

      iz = 0
      return
      end
      subroutine anmute (v, nzmax, nxmax, nzgrid, nxgrid, nzout, dzout,
     &                   dzgrid, dxout, angle, work, nzst, nap, velmax,
     &                   nzfrst,nz2nd )

#include <f77/iounit.h>

c     Compute angle dependent mute - D. Whitmore

      real    v(nzmax,nxmax), work(*), velmax
      integer nzst(*)

c     v              = velocity matrix
c     nzmax, nxmax   = max dimensions of v
c     nzgrid, nxgrid = actual dimensions of v
c     nzout          = max no of z samples at dzout
c     dzgrid, dxgrid = sample, trace spacings of v
c     dzout          = migration depth spacing
c     angle          = emergent angle
c     nzst           = returned z index for each x
c     2*nap+1        = number of x coordinates in nzst
c     velmax         = maximum velocity
c     nzfrst         = minimum depth to migrate
c     nz2nd          = maximum depth to migrate
c
      data pi / 3.141592653589793 /

c-----------------------------------------------------------------------
c
      radian = pi / 180.0

c     initialize nzst = 1

      do 10 jx = 1, 2*nap+1
         nzst(jx) = 1
   10 continue

c     produce average velocity trace in work

      velmax  = -99999.
      scale = 1.0 / float( nxgrid )
      write(LERR,*)' '
      write(LERR,*)'anmute: nzgrid,nxgrid= ',nzgrid,nxgrid
      write(LERR,*)'anmute: nzmax,nxmax= ',nzmax,nxmax
      do 30 jz = 1, nzgrid
         work(jz) = 0.0
         do 20 jx = 1, nxgrid
            if (v(jz,jx) .gt. velmax) velmax = v(jz,jx)
            work(jz) = work(jz) + v(jz,jx)
   20    continue
         work(jz) = work(jz) * scale
   30 continue

      write(LERR,*)'anmute: velmax= ', velmax

      if (abs( angle ) .ge. 90.0) go to 100

c     compute ray parameter

      pray = abs( sin( angle * radian ) )/work(1)

      if (abs( pray ) .lt. 0.00000001) go to 100

c     compute the dz0 = cot(angle)*dxout as a function of z

      do 40 jz = 1, nzgrid
         temp = pray * work(jz)
         if (abs( temp ) .gt. 1.0) temp = 1.0
         work(jz) = dxout * sqrt( 1.0 - temp ** 2 ) / temp
   40 continue

c     determine nzst as a function of x

      z = dzgrid + 0.000001
      do 50 jx = nap+1, 2*nap+1
         indz = z / dzgrid
         nzst(jx) = z / dzout
         if (nzst(jx) .lt. 1     ) nzst(jx) = 1
         if (nzst(jx) .gt. nzout ) nzst(jx) = nzout
         if (indz     .gt. nzgrid) indz     = nzgrid
         z = z + work(indz)
   50 continue

c     fill first half of nzst with reciprocal mute pattern

      nbig = 2 * nap + 2
      do 60 jx = 1, nap
         nzst(jx) = nzst(nbig-jx)
   60 continue

  100 continue

      do 70 jx = 1, 2*nap + 1
         if(nzst(jx).lt. nzfrst) nzst(jx) = nzfrst
         if(nzst(jx).gt. nz2nd ) nzst(jx) = nz2nd
   70 continue

      return
      end
      subroutine cosamp1(a,nz,nap,dz,dx,theta)

c     computes cosine obliquity factor for migration

      real a(*)

      data pi / 3.141592653589793 /

c-----------------------------------------------------------------------

      halfpi = pi / 2.0
      therad = theta * pi  / 180.0

      jzst   = 0
      ka     = 2 * nap + 1
      do 10 ja = 1, ka
         x = - float( nap - ja + 1 ) * dx

         do 20 jz = 1, nz
            z     = float( jz ) * dz
            ang   = asin( x / sqrt( x**2 + z**2 ) )
            andif = abs( ang - therad )
            if (andif .gt. halfpi) andif = halfpi
            a(jzst+jz) = cos( andif )
   20    continue

         jzst = jzst + nz
   10 continue

      return
      end
      subroutine fftflt (data, datao, mdati, mdato, mrsmp, dtsec,
     &                   f1, f2, f3, f4, phase, expon, ifinit, lprt)

c     D. Whitmore

c     data   = input data
c     datao  = output data
c     mdati  = length of input data
c     mdato  = length of output data = mdati*mrsmp
c     mrsmp  = resampling rate (must be a power of 2)
c     dtsec  = delta t in seconds of input
c     f1-f4  = frequency filtering points
c     phase  = phase angle in degrees
c     expon  = frequency exponent
c     ifinit = initialization flag ( = 1 to inititalize)

      real data(*), datao(*)
      complex filt(16384)

      save m1, m4, lfilt, filt
c
c-----------------------------------------------------------------------
c
c     INITIALIZE FILTER

      if (ifinit .ne. 1) go to 210

c     compute power of 2 length

      m1 = 16
  110 continue
      if (m1 .le. mdati) then
         m1 = m1 + m1
         go to 110
      endif

c     compute df = incremental frequency

      df = 1.0 / (dtsec * m1)

c     compute scalf = 1/(2*m1)

      scalf = 1.0 / (2.0 * float( m1 ))
      lfilt = m1 / 2

c     define expanded samples

      m4    = m1 * mrsmp
      mdato = mdati * mrsmp

c     compute frequency filter:

      call ctrpfl (filt, lfilt, f1, f2, f3, f4, df, scalf, expon, phase,
     &             lprt)

  210 continue
      call vmov (data, 1, datao, 1, mdati)
      call vclr (datao(1+mdati), 1, m1-mdati)

c     execute forward fft

      call rfft (datao, m1, 1)

c     multiply by filt

      call cvmul (datao, 2, filt, 2, datao, 2, lfilt, 1)

c     execute inverse fft

      if (mrsmp .gt. 1) call vclr (datao(1+m1), 1, (mrsmp-1)*m1)
      call rfft (datao, m4, -1)

      return
      end
      subroutine ctrpfl (filt, lfilt, f1, f2, f3, f4, df, scalf, expon,
     &                   phase, lprt)

C     THIS ROUTINE COMPUTES A TRAPEZOIDAL FREQUENCY SCALING VECTOR

c     D. Whitmore

      complex filt(1), scale

      data pi / 3.141592653589793 /

C     FILT, LFILT   = FILTER AND LENGTH OF FILTER
C     F1, F2, F3, F4  = TRAPEZOIDAL FILTER POINTS
C     DF           = FREQUENCY SPACING
C     SCALF        = SCALAR MULTIPLIER
C     EXPON        = FREQUENCY EXPONENT
C     PHASE        = PHASE ROTATION IN DEGREES

C-----------------------------------------------------------------------

C     SET REF FREQUENCY TO 30 HZ

      fref   = 30
      dfovfr = df / fref

C     BUILD PHASE SCALING

      theta = phase * pi / 180.0
      scale = scalf * cmplx( cos(theta), sin(theta) )

c     BUILD F1, F2, F3, F4 FILTER

      if (f4.lt.f3 .or. f3.lt.f2 .or. f2.lt.f1 .or. f1.lt.0.0) then
         write (lprt, *) 'FILTER ERROR: F1,F2,F3,F4 = ', f1, f2, f3, f4
         stop 1000
      endif

      j1 = f1 / df + 1
      j2 = f2 / df + 1
      j3 = f3 / df + 1
      j4 = f4 / df + 1

      if (j4 .gt. lfilt) then
         write (lprt, *) 'FILTER ERROR'
         write (lprt, *) 'F4 FREQUENCY GREATER THAN MAX FREQUENCY'
         stop 1000
      endif

      do 10 j = 1, lfilt
         filt(j) = (0.0, 0.0)
   10 continue

      if (j2 .gt. j1) then
         do 20 j = j1, j2-1
            ramp    = float(j-j1) / float(j2-j1)
            filt(j) = scale * ((float(j-1) * dfovfr) ** expon * ramp)
   20    continue
      endif

      do 30 j = j2, j3-1
         filt(j) = scale * (float(j-1) * dfovfr) ** expon
   30 continue

      if (j4 .gt. j3) then
         do 40 j = j3, j4-1
            ramp    = float(j4-j) / float(j4-j3)
            filt(j) = scale * ((float(j-1) * dfovfr) ** expon * ramp)
   40    continue
      endif

      return
      end
      subroutine gettim (jr, luprt, nrmax, ntmax, nxmax, nzmax,
     &                   nang, nrinc, nt, ntinc, ntskip, nxray,
     &                   nxap,  nxgrid, nzout, nzgrid,
     &                   dxout, dxgrid, dzout, dzgrid, dt, dtref,
     &                   ismoo, angle, apfeet, dipmax, strch, tmax,
     &                   xbeg, xinc, v,
c    &               theta, xray, zray, data2d,itmrfl, napmx,nzbig,
     &               theta, xray, zray, data2d,        napmx,nzbig,
     &               istrid,mray)

      real    v(nzmax,nxmax),  theta(*),
     &        xray(*), zray(*), data2d(nzbig,napmx,2)
c     integer itmrfl(nzout,nxap), mray(ntmax)
      integer mray(*)
      logical load

      save jr1, jr2, jrlast, idat1, idat2, init
      data jrlast / 0 /

c-----------------------------------------------------------------------

      if (jr .ne. 1 .and. jr .ne. jrlast+1) then
	 write (luprt, *) 'SEQUENCE ERROR IN GETTIM'
	 call ccexit (100)
      endif

      jrlast = jr

      if      (jr .eq.   1) then
	 init  = 0
	 jr1   = 0
	 jr2   = 1
	 idat1 = 2
	 idat2 = 1
	 load  = .true.
      else if (jr .gt. jr2) then
	 jr1   = jr2
	 jr2   = jr1 + nrinc
	 idtmp = idat1
	 idat1 = idat2
	 idat2 = idtmp
	 load  = .true.
      else
	 load  = .false.
      endif

      scal   = 2.0 / dt
CMAT  zsrc   = dzgrid * strch
      zsrc   = dzgrid * strch * 3.0
      xsrc   = xbeg + (jr2 - 1) * xinc
      xmax   = (nxgrid - 1) * dxgrid
      if (xsrc .gt. xmax) xsrc = xmax
CMAT  izsrc  = zsrc / dzout + 0.5
      izsrc  = zsrc / dzout
c     ix1    = (xsrc - apfeet - xinc * nrinc) / dxout + 0.0001
c     ix2    = (xsrc - apfeet               ) / dxout + 0.0001

      ix1    = 0
      ix2    = 0
      if (load) then
c        Ray Trace and grid traveltimes (init = 0 initializes tables)

         call timrfl (zsrc, xsrc, angle, nang, dtref, tmax,
     &                data2d(1,1,idat2), dzout, dxout, nzmax, nxmax,
     &                nrmax, ntmax, nzgrid, nxgrid, nray, nt, ntskip,
     &                ntinc, strch*dzgrid, dxgrid, dt, v, ismoo,
     &                init, theta, zray, xray, dipmax, luprt,
     &                napmx,apfeet,nzbig,nxap,nzout,mray)

c        DATA2D(., ., IDAT2) now contains new grided traveltimes
      endif

      call vclr (xray,1,nxmax,nxray)

      if (jr .eq. jr2) then

         do  120 jx = 1, nxap         ! TRACE LOOP
	    jx2 = jx + ix2
            do  110 jz = 1, nzout     ! SAMPLE LOOP
               jxjz = (jx-1)*nzout + jz
c              itmrfl(jz,jx) = scal * data2d(jz+izsrc,jx2,idat2)
               xray(jxjz) = scal * data2d(jz+izsrc,jx2,idat2)
  110       continue                  ! END SAMPLE LOOP
  120    continue                     ! END TRACE  LOOP

      else

         if (mod( jr, istrid ) .ne. 0 ) go to 6100
         beta  = float( jr - jr1 ) / float( nrinc )
         alpha = 1.0 - beta
         do 220 jx = 1, nxap          ! TRACE LOOP
	    jx1 = jx + ix1
	    jx2 = jx + ix2
            do 210 jz = 1, nzout      ! SAMPLE LOOP
               jxjz = (jx-1)*nzout + jz
c              itmrfl(jz,jx) = scal *
               xray(jxjz) = scal *
     &                           ( alpha * data2d(jz+izsrc,jx1,idat1)
     &                           + beta  * data2d(jz+izsrc,jx2,idat2) )
  210       continue                  ! END SAMPLE LOOP
  220    continue                     ! END TRACE  LOOP
 6100    continue                     ! END TRACE  LOOP

      endif

      return
      end
      subroutine timrfl (zsrc,xsrc,angle,nang,dtref,tmax,data2d,
     &                   dzout, dxout, nzmax, nxmax, nrmax, ntmax,
     &                   nz, nx, nray, nt, ntskip, ntinc, dz, dx, dt,
     &                   v, ismoo, init, theta,
     &                   zray, xray, dipmax, lprt,napmx,apfeet,nzbig,
     &                   nxap,nzout,mray)
c
c     N. D. Whitmore

c    zsrc  = z origin of the ray fan
c    xsrc  = x origin of the ray fan
c    angle = starting angle in rayfan
c    nang  = # of initial angles in the half the rayfan
c    dtref = time increment for refining the positions and
c            angles in the rayfan
c    tmax  = maximum time

c     MAXIMUM DIMENSIONS:
c             nzmax  = max # nz                        - input
      integer nzmax
c             nxmax  = max # nx                        - input
      integer nxmax
c             ntmax  = max # nt                        - input
      integer ntmax
c             nrmax  = max # of rays                   - input
      integer nrmax

c     DIMENSIONS:
c             nx = max # of nodes in x direction       - input
      integer nx
c             nz = max # of nodes in z direction       - input
      integer nz
c             nray = # of rays to trace                - computed
      integer nray
c             nt = # time steps                        - input
      integer nt
c             ntskip= interpolation increment          - input
      integer ntskip
c             ntinc = output skipping increment        - input
      integer ntinc

c     GRID SIZES:
c             dz = z grid spacing                      - input
      real    dz
c             dx = x grid spacing                      - input
      real    dx
c             dt = time increment                      - input
      real    dt

c     SPATIAL ARRAYS:
c             v    = interval velocity model           - input

      real    v(nzmax,nxmax)
c             ismoo= # of times to apply 9 pt smoother - input
c                    to input velocity model v
      integer ismoo
c             init   = initialization flag             - input
c                    = 0 smooth v
c                    = 1 do not smooth v
      integer init

c     COMPUTED WAVEFRONT SLOWNESS:
c             theta = incident angle                   - input / output
      real    theta(nrmax)

c     COMPUTED WAVEFRONT RAY POSITIONS:
c             xray = wavefront x positions at each dt  - input / output
      real    xray(nrmax,ntmax)
c             zray = wavefront z positions at each dt  - input / output
              real zray(nrmax,ntmax)

c     OUTPUT DATA ARRAY
      real data2d(nzout,nxap)

c     dzout = output depth interval for data2d
c     dxout = output width interval for data2d

c     LOCAL DECLARATIONS
      integer mray(*)

      data pi / 3.141592653589793 /
c
c-----------------------------------------------------------------------
c

c     program outline:

c     1. initialize starting parameters
c        a. compute initial conditions for rays(location, and angles)
c     2. loop over dtref time blocks
c        a. trace rays
c        b. resample ray positions and angles
c     3. interpolate rays onto a grid (in reverse time order)
c
c-----------------------------------------------------------------------
c
c     compute parameters for interpolation of rays
c     (at every ntdub interpolate rays and angles so that the
c     arclength between adjacent rays does not exceed nrsmp
c     times the output depth spacing)

      radian = pi / 180.0
      nt0    = dtref / dt + 0.00001
      ntdub  = (nt - 1) / nt0 + 1
      prtol  = 0.0
      pray   = 0.0

c     compute initial conditions of rayfans

      nray   = 2 * nang + 1
      ntbeg  = 1
      nrout  = nray
      angmax = dipmax * radian

      if (angle .gt. 90.0 .or. angle .lt. -90.0) then
         write (lprt, *) 'angle out of range'
         stop 100
      endif

      xbias = xsrc - apfeet
      dang   = abs( angle ) / nang
      angray = -abs( angle ) - dang
      do 1100 jray = 1, nray
         angray       = angray + dang
         zray(jray,1) = zsrc
         xray(jray,1) = xsrc
         theta(jray)  =  angray * radian
 1100 continue

c     Ray Tracing and Intepolation

c     for each in the next loop:
c     a. raytrace
c     b. if not the last pass interpolate rays and angles

c     begin ray trace and interpolation loop

      do 1110 jtl = 1, ntdub
         ntend = ntbeg + nt0
         if (ntend .gt. nt) ntend = nt
         ntstep = ntend - ntbeg + 1

c        Runge-Kutta Ray Tracing

         call rkrayn (nzmax, nxmax, nrmax, ntmax, nz, nx, nrout,
     &                ntstep, ntskip, dz, dx, dt, v, ismoo,init,
     &         theta,zray(1,ntbeg), xray(1,ntbeg), pray, prtol)

c        save number of rays used for this time segment

         do 1120 jt = ntbeg, ntend
            mray(jt) = nrout
 1120    continue


c        interpolate raypaths and angles if necessary
         nroutx = nrout
         call siftray (xray(1,ntend), zray(1,ntend), theta,
     &                 nroutx, nrout, angmax)

         ntbeg = ntend

 1110 continue
c     end ray trace and interpolation loop

c     cover data matrix with 1.5*tmax
      do 1140 jx = 1, nxap
         do 1130 jz = 1, nzout
            data2d(jz,jx) = tmax * 2.0
 1130    continue
 1140 continue

      nttop = nt / ntinc * ntinc

c     begin time step loop

      do 1400 jt = nttop, 2, -ntinc
         nrout  = mray(jt)
         timout = (float( jt ) + 1.0001) * dt

c        interpolate and find node of rays


         nrat = timout * 12 + 2
c        nrat = timout * 2 + 10
         call fxznod3 (xray(1,jt), zray(1,jt), nrout, nrout1, nrat,
     &                 dxout, dzout, data2d, nzbig, timout,xbias, nxap)

 1400 continue
c     end time step loop

      return
      end
       subroutine siftray (xin, zin, ang, nxin, nxout, angmax)

       real xin(*), xout(4000)
       real zin(*), zout(4000)
       real ang(*), aout(4000)
c
c-----------------------------------------------------------------------
c
c     remove any rays that with dips greater than dipmax

      nxtemp = nxin
      nxout  = 0

      do 10 j = 1, nxtemp
         if (abs(ang(j)) .le. angmax) then
            nxout = nxout + 1
            aout(nxout) = ang(j)
            xout(nxout) = xin(j)
            zout(nxout) = zin(j)
	 endif
   10 continue

      do 40 j = 1, nxout
         ang(j) = aout(j)
         xin(j) = xout(j)
         zin(j) = zout(j)
   40 continue

      return
      end

      subroutine wrrec2 (luout, luprt, nx, nzout, nztap, dzout, dztap,
     &                   jr, istrid, strch, a, trhdrs,
     &                     itr, trhead, trdata,
     &                   iz, work, tabl1, tabl2, zz)
c    &                   trace, trhead, trdata)

C     READ A HEADER FROM A DISK FILE and WRITE A SEISMIC RECORD

C     LUOUT  = TRACE DATA LOGICAL UNIT
C     LUPRT  = LOGICAL UNIT FOR PRINT FILE
C     NX     = NUMBER OF TRACES TO WRITE
C     NZOUT  = NUMBER OF SAMPLES PER TRACE IN ARRAY A
C     NZTAP  = NUMBER OF SAMPLES TO WRITE TO TAPE
C     DZOUT  = DELTA Z FOR DATA IN ARRAY A
C     DZTAP  = DELTA Z FOR DATA IN THE OUTPUT TRACE
C     JR     = RECORD NUMBER FOR OUTPUT TAPE
C     ISTRID = ?
C     STRCH  = STRETCH PARAMETER
C     A      = 2D TRACE DATA ARRAY
C     TRHDRS = 2D TRACE HEADER ARRAY
C     TRACE  = TRACE ARRAY
C     TRHEAD = HEADER OF TRACE ARRAY (EQUIVALENCED TO TRACE(1))
C     TRDATA = DATA   OF TRACE ARRAY (EQUIVALENCED TO TRACE(129))

#include <f77/lhdrsz.h>

c     parameter (nhead = 128, nbword = 8)

c     integer trhead(*), trhdrs(LNTRHD,*)
c     real    trace(*), trdata(*), a(nzout,*)

      integer*2 trhead(*), trhdrs(LNTRHD,*), itr(*)
      real      trdata(*), a(nzout,*)

c     integer iz(12000)
c     real    work(5000), tabl1(12000), tabl2(12000), zz(12000)
      integer iz(*)
      real    work(*), tabl1(*), tabl2(*), zz(*)

c-----------------------------------------------------------------------

c     nbytes = (nztap + LNTRHD) * nbword
      nbytes = nztap * SZSMPD + SZTRHD
      xstrid = istrid + 0.00001
      if (xstrid .le. 1.0) xstrid = 1.0

C     BUILD RESAMPLING TABLES

      icinit = 1

      temp = dzout / strch
      do 110 j = 1, nzout
         tabl1(j) = float( j - 1 ) * temp
  110 continue

      do 120 j = 1, nztap
         tabl2(j) = float( j - 1 ) * dztap
  120 continue

C     LOOP OVER TRACES

      do 220 jx = 1, nx

C        READ TRACE HEADER FROM ARRAY TRHDRS

	 call vmov (trhdrs(1,jx), 1, trhead, 1, LNTRHD)

C        GET DATA FROM ARRAY A

         if (jx .lt. nx .and. jx .gt. 1 .and. istrid .gt. 1) then
            do 210 jz = 1, nzout
               work(jz) = xstrid * ( 0.50 * a(jz,jx  )
     &                             + 0.25 * a(jz,jx-1)
     &                             + 0.25 * a(jz,jx+1) )
  210       continue
         else
	    call vsmul (a(1,jx), 1, xstrid, work, 1, nzout)
         endif

C        RESAMPLE TRACE INTO TRDATA

         if (nzout .ne. nztap) then
            call fcuint (tabl1, work, nzout, tabl2, trdata, nztap,
     &                   iz, zz, icinit)
            icinit = 0
         else
	    call vmov (work, 1, trdata, 1, nzout)
         endif

C        WRITE TRACE

         trhead(106) = jr
         trhead(107) = jx

         call wrtape (luout,   itr, nbytes)

         if (nbytes .le. 0) then
            write (luprt, *) 'TAPE I/O ERROR ON OUTPUT'
            call ccexit (100)
         endif

  220 continue

      return
      end
C********************************************************************C
C NAME: FCUINT  CUBIC INTERPOLATION             REV 1.0     JUN 88   C
C********************************************************************C
C
C  PURPOSE:
C       PERFORMS A CUBIC INTERPOLATION.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JUN 88          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL FCUINT (X1, Y1, N1, X2, Y2, N2, IZ, ZZ, INIT)
C
C  PARAMETERS:
C       X1      REAL INPUT VECTOR OF LENGTH N1
C               SOURCE VECTOR CONTAINING X COORDINATES CORRESPONDING
C               TO Y1.
C
C       Y1      REAL INPUT VECTOR OF LENGTH N1
C               SOURCE VECTOR CONTAINING Y COORDINATES.
C
C       N1      INTEGER INPUT SCALAR
C               ELEMENT COUNT FOR X1 AND Y1.  N1 MUST BE >= 4.
C
C       X2      REAL INPUT VECTOR OF LENGTH N2
C               SOURCE VECTOR CONTAINING X COORDINATES CORRESPONDING
C               TO Y2.
C
C       Y2      REAL OUTPUT VECTOR OF LENGTH N2
C               RESULT VECTOR.
C
C       N2      INTEGER INPUT SCALAR
C               ELEMENT COUNT FOR X2 AND Y2.
C
C       IZ      INTEGER INPUT/OUTPUT VECTOR OF LENGTH N2
C               INTERMEDIATE INDEX VECTOR CALCULATED IF INIT <> 0.
C
C       ZZ      REAL INPUT/OUTPUT VECTOR OF LENGTH 4*N2
C               INTERMEDIATE COEFFICIENT VECTOR CALCULATED IF INIT <> 0.
C
C       INIT    INTEGER INPUT SCALAR
C               INITIALIZATION FLAG.. IF INIT <> 0, THEN THE INTER-
C               MEDIATE VECTORS IZ AND ZZ ARE CALCULATED; OTHERWISE,
C               THEY ARE ASSUMED TO HAVE BEEN CALCULATED IN A PREVIOUS
C               CALL.
C
C  DESCRIPTION:
C       GIVEN A SET OF (X,Y) COORDINATES (X1,Y1), FCUINT PERFORMS A
C       CUBIC INTERPOLATION TO OBTAIN AN OUTPUT SET OF (X,Y)
C       COORDINATES (X2,Y2).  THE VALUES OF BOTH X1 AND X2 MUST BE IN
C       ASCENDING ORDER AND MAY HAVE ARBITRARY SPACING.  IF X2(I) <
C       X1(1) FOR SOME I, THEN Y2(I) = Y1(1).  SIMILARLY, IF X2(I) >
C       X1(N1), THEN Y2(I) = Y1(N1).
C
C       THE INTERMEDIATE RESULT VECTORS IZ AND ZZ ARE CALCULATE
C       IF THE INITIALIZATION FLAG INIT <> 0.  THESE VECTORS ARE
C       DEPENDENT ON N1, N2, X1, AND X2; I.E., THEY ARE DEPENDENT ON
C       ALL INPUT ARGUMENTS EXCEPT Y1.  WHEN A SEQUENCE OF CALLS ARE
C       MADE IN WHICH ONLY Y1 CHANGES, IT IS MOST EFFICIENT TO SET
C       INIT TO 1 FOR THE FIRST CALL THEN SET IT TO 0 FOR THE
C       SUBSEQUENT CALLS.
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       IF N1 < 4 OR N2 < 1, THE ROUTINE IS ABORTED.
C
C---------------------------------------------------------------------
C
      SUBROUTINE FCUINT (X1, Y1, N1, X2, Y2, N2, IZ, ZZ, INIT)
C
      INTEGER N1, N2, IZ(N2), INIT
      REAL    X1(N1), Y1(N1), X2(N2), Y2(N2), ZZ(N2,4), XX(64)
C
C-----------------------------------------------------------------------
C
      IF (N1 .LT. 4 .OR. N2 .LT. 1) GO TO 800
C
      IF (INIT .EQ. 0) GO TO 200
C
C     ----------------------
C     PERFORM INITIALIZATION
C     ----------------------
C
      X1LO = X1( 1)
      X1HI = X1(N1)
C
      J  = 3
      I2 = 0
  100 CONTINUE
      I1 = I2 + 1
      I2 = I2 + 64
      IF (I2 .GT. N2) I2 = N2
C
C     DO FIX UP FOR OUT-OF-RANGE VALUES OF X2
C
      II = 0
CDIR$ SHORTLOOP
      DO 110 I = I1, I2
         II = II + 1
C
         IF      (X2(I) .LT. X1LO) THEN
            XX(II) = X1LO
         ELSE IF (X2(I) .GE. X1HI) THEN
            XX(II) = X1HI
         ELSE
            XX(II) = X2(I)
         ENDIF
  110 CONTINUE
C
C     CALCULATE IZ
C
      II = 0
CDIR$ SHORTLOOP
      DO 130 I = I1, I2
         II = II + 1
C
  120    CONTINUE
         IF (XX(II) .GT. X1(J) .AND. J .LT. N1-1) THEN
            J = J + 1
            GO TO 120
         ENDIF
C
         IZ(I) = J - 2
  130 CONTINUE
C
C     CALCULATE ZZ
C
      II = 0
CDIR$ SHORTLOOP
      DO 140 I = I1, I2
         II = II + 1
C
         J1 = IZ(I)
         J2 = J1 + 1
         J3 = J2 + 1
         J4 = J3 + 1
C
         DX1 = XX(II) - X1(J1)
         DX2 = XX(II) - X1(J2)
         DX3 = XX(II) - X1(J3)
         DX4 = XX(II) - X1(J4)
         D12 = X1(J1) - X1(J2)
         D13 = X1(J1) - X1(J3)
         D14 = X1(J1) - X1(J4)
         D23 = X1(J2) - X1(J3)
         D34 = X1(J3) - X1(J4)
         D42 = X1(J4) - X1(J2)
C
         ZZ(I,1) = DX2 * DX3 * DX4 / (D12 * D13 * D14)
         ZZ(I,2) = DX1 * DX3 * DX4 / (D12 * D23 * D42)
         ZZ(I,3) = DX1 * DX2 * DX4 / (D13 * D23 * D34)
         ZZ(I,4) = DX1 * DX2 * DX3 / (D14 * D42 * D34)
  140 CONTINUE
      IF (I2 .LT. N2) GO TO 100
C
C     ---------------------
C     PERFORM INTERPOLATION
C     ---------------------
C
  200 CONTINUE
      DO 210 I = 1, N2
         J  = IZ(I)
         Y2(I) = ZZ(I,1) * Y1(J) + ZZ(I,2) * Y1(J+1) + ZZ(I,3) * Y1(J+2)
     &         + ZZ(I,4) * Y1(J+3)
  210 CONTINUE
C
C     ------------
C     EXIT ROUTINE
C     ------------
C
  800 CONTINUE
      RETURN
      END
C********************************************************************C
C NAME: FDSTK0  COMPUTE DIFFRACTION STACK       REV 1.0     MAR 90   C
C********************************************************************C
C
C  PURPOSE:
C       COMPUTES THE DIFFRACTION STACK.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY
C       ORIGINAL                MAR 90          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL FDSTK0 (IIB, IIN1, IIN2, NABIAS, NRBIAS, NZEND, NZOUT,
C      &             NZST, ITIME, XWORK, DEPTH)
C
C  PARAMETERS:
C       IIB     INTEGER INPUT SCALAR
C
C       IIN1    INTEGER INPUT SCALAR
C
C       IIN2    INTEGER INPUT SCALAR
C
C       NABIAS  INTEGER INPUT SCALAR
C
C       NRBIAS  INTEGER INPUT SCALAR
C
C       NZEND   INTEGER INPUT SCALAR
C
C       NZOUT   INTEGER INPUT SCALAR
C
C       NZST    INTEGER INPUT VECTOR
C
C       ITIME   INTEGER INPUT VECTOR
C
C       XWORK   REAL INPUT VECTOR
C
C       DEPTH   REAL INPUT/OUTPUT VECTOR
C
C  DESCRIPTION:
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
      SUBROUTINE FDSTK0 (iib, iin1, iin2, nabias, nrbias, nzend, nzout,
     &                   NZST, TIME, XWORK, DEPTH, ntime)
c    &                   NZST,iTIME, XWORK, DEPTH, ntime)
C
C   PARAMETERS:
C
      INTEGER iib, iin1, iin2, nabias, nrbias, nzend, nzout,
     &        NZST(*)
c    &        NZST(*), itime(*)
      REAL    TIME(*), DEPTH(*), XWORK(*)
c     REAL    DEPTH(*), XWORK(*)
C
C   LOCAL VARIABLES:
C
      INTEGER ja, ja1, jz, jz1, jz2, na, nibias, nz, nzbeg
C
C-----------------------------------------------------------------------
C
      na = iin2 - iin1 + 1
      IF (na .LE. 0) RETURN
C
      nibias = iib - nzout
      ja1    = iin1 + nabias
      DO 6300 ja = 1, na
         nzbeg = NZST(ja1)
         nz    = nzend - nzbeg + 1
         ja1   = ja1 + 1
         IF (nz .gt. 0) THEN
            nibias = nibias + nzout
            jz1    = nzbeg + nibias
            jz2    = jz1 - nrbias
            DO 6350 jz = 1, nz

               it = ifix( time(jz2) +.50)
               it = time(jz2)
               if (it .gt. 0 .AND. it .le. ntime) then
                  DEPTH(jz1) = DEPTH(jz1) + XWORK(it)
               endif
               jz1 = jz1 + 1
               jz2 = jz2 + 1
 6350       CONTINUE
         ENDIF
 6300 CONTINUE
C
      RETURN
      END
C********************************************************************C
C NAME: FDSTK1  COMPUTE DIFFRACTION STACK       REV 1.0     MAR 90   C
C********************************************************************C
C
C  PURPOSE:
C       COMPUTES THE DIFFRACTION STACK.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY
C       ORIGINAL                MAR 90          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL FDSTK1 (IIB, IIN1, IIN2, NABIAS, NRBIAS, NZEND, NZOUT,
C      &             NZST, ITIME, XWORK, COSWGT, DEPTH)
C
C  PARAMETERS:
C       IIB     INTEGER INPUT SCALAR
C
C       IIN1    INTEGER INPUT SCALAR
C
C       IIN2    INTEGER INPUT SCALAR
C
C       NABIAS  INTEGER INPUT SCALAR
C
C       NRBIAS  INTEGER INPUT SCALAR
C
C       NZEND   INTEGER INPUT SCALAR
C
C       NZOUT   INTEGER INPUT SCALAR
C
C       NZST    INTEGER INPUT VECTOR
C
C       ITIME   INTEGER INPUT VECTOR
C
C       XWORK   REAL INPUT VECTOR
C
C       COSWGT  REAL INPUT VECTOR
C
C       DEPTH   REAL INPUT/OUTPUT VECTOR
C
C  DESCRIPTION:
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
      SUBROUTINE FDSTK1 (iib, iin1, iin2, nabias, nrbias, nzend, nzout,
     &                   NZST,  TIME, XWORK, COSWGT, DEPTH, ntime)
c    &                   NZST, iTIME, XWORK, COSWGT, DEPTH, ntime)
C
C   PARAMETERS:
C
      INTEGER iib, iin1, iin2, nabias, nrbias, nzend, nzout,
     &        nzst(*)
c    &        itime(*),nzst(*)
      real    time(*)
      REAL    COSWGT(*), DEPTH(*), XWORK(*)
C
C   LOCAL VARIABLES:
C
      INTEGER ja, ja1, jz, jz1, jz2, na, nibias, nz, nzbeg
C
C-----------------------------------------------------------------------
C
      na = iin2 - iin1 + 1
      IF (na .LE. 0) RETURN
C
      nibias = iib - nzout
      ja1    = iin1 + nabias
      DO 6300 ja = 1, na
         nzbeg = NZST(ja1)
         nz    = nzend - nzbeg + 1
         ja1   = ja1 + 1
         IF (nz .gt. 0) THEN
            nibias = nibias + nzout
            jz1    = nzbeg + nibias
            jz2     = jz1 - nrbias
            DO 6350 jz = 1, nz
c              it = ifix(time(jz2) + .50)
               it = time(jz2)
               if (it .gt. 0 .AND. it .le. ntime ) then
                   DEPTH(jz1) = DEPTH(jz1) + XWORK(it)
     &                          * COSWGT(jz2)
               endif
               jz1 = jz1 + 1
               jz2 = jz2 + 1
 6350       CONTINUE
         ENDIF
 6300 CONTINUE
C
      RETURN
      END
*********************************************************************
C NAME: FXZNOD3	                           REL 1.0	    NOV 91   *
C*********************************************************************
C
C  PURPOSE:
C
C  LANGUAGE:
C	FORTRAN 77
C
C  HISTORY:
C	Original	Nov 91			Dan Whitmore
C
C  CALLING FORMAT:
C	CALL FXZNOD3 (XIN, ZIN, NXIN, NXOUT, NRSMP, DX, DZ,
C      &              DATA2D, NZBIG, TIMOUT, XBIAS, NXAP)
C
C  PARAMETERS:
C	XIN	Real input vector of length NXIN
C		X position of rays.
C
C	ZIN	Real input vector of length NXIN
C		Z position of rays.
C
C	NXIN 	Integer input scalar
C		Element count of vectors XIN and ZIN.
C
C	NXOUT	Integer input scalar
C		Number of elements updated in DATA2D.
C
C	NRSMP 	Integer input scalar
C		Resampling rate.
C
C	DX    	Real input scalar
C		Delta x.
C
C	DZ    	Real input scalar
C		Delta z.
C
C	DATA2D	Real input/output matrix of dimension NZMIG by NAPMX
C		Result matrix.
C
C	NZBIG	Integer input scalar
C		Leading dimension of matrix DATA2D
C
C	TIMOUT	Real input scalar
C		Value of time to output.
C
C	XBIAS 	Real input scalar
C		relative spatial shift of input coordinates
C
C	NXAP  	Integer input scalar
C		Number of x samples in an aperture
C
C  DESCRIPTION:
C	See FORTRAN equivalent.
C
C  SUBPROGRAMS CALLED:
C	None
C
C  ERROR CONDITIONS:
C	None
C
C---------------------------------------------------------------------
C
      subroutine fxznod3 (xin, zin, nxin, nxout, nrsmp, dx, dz,
     &                    data2d, nzbig, timout, xbias , nxap )
c
      real xin(*), zin(*), data2d(0:*)
      real xout(8000), zout(8000)
c
c------------------------------------------------------------------
c
      zover = 1.0 / dz
      xover = 1.0 / dx
      xbias2 = nxap*dx
      zbig   = nzbig*dz

c    check limits of ray endpoints
      nxout  = 0
      do 10 j = 1, nxin
      if (  (xin(j)-xbias) .ge. dx 
     &.and. (xin(j)-xbias) .lt. xbias2 
     &.and.  zin(j)        .ge. dz 
     &.and.  zin(j)        .lt. zbig    ) then
            nxout = nxout + 1
            xout(nxout) = xin(j)-xbias 
            zout(nxout) = zin(j)
         endif
   10 continue

c
c     grid rays

      nxin1  = nxout - 1
      if(nrsmp.gt.0) then
      step   = 1.0 / float( nrsmp )
      else
      step   = 0.0
      endif
      stepz  = zover * step
      stepx  = xover * step
      alphaz = zover
      alphax = xover
      betaz  = 0.0
      betax  = 0.0
      do 30 i = 0, nrsmp
         alphaz = alphaz - stepz
         alphax = alphax - stepx
         betaz  = betaz  + stepz
         betax  = betax  + stepx
         do 20 j = 1, nxin1
            jz = ifix( alphaz * zout(j) + betaz * zout(j+1)  )
            jx = ifix( alphax * xout(j) + betax * xout(j+1)  )
            jd = jz + jx * nzbig
            data2d(jd) = timout
   20    continue
   30 continue
      return
      end

      subroutine getvel(lprt, luv, ihead, itr, irx, data, dxout,
     &                  nap, v, nzmax, nxmax, nzgrid, nxgrid,
     &                          nzout, nx,
     &                  dzgrid, dxgrid, strch, xbegin)

#include <f77/lhdrsz.h>

c     THIS ROUTINE READS A VELOCITY TAPE AND MAPS IT INTO
c     A VELOCITY MATRIX WHICH IS IN LOCAL COORDINATES WITH PADS

c     MEMORY ALLOCATION

c     integer ihead(*), irx(*)
c     real    rxx(*), data(*), v(nzmax,nxmax)

      integer*2 ihead(*), irx(*), itr(*)
      real      data(*), v(nzmax,nxmax)

      write(lprt,*)' '
      write(lprt,*)'getvel:'
      write(lprt,*)'dxout= ',dxout,' nap= ',nap,' nzmax= ',nzmax,
     1' nxmax= ',nxmax,' nzout= ',nzout,' nx= ',nx
      write(lprt,*)' '
C*******************************************************************
C     READ LINE HEADER -  tape must be open exterior to this routine
C*******************************************************************

      jeof = 0
      call rtape (luv, ihead, jeof)

      if (jeof .eq. 0) then
         write (lprt, *) ' ERROR READING LINE HEADER'
         stop 75
      endif

c     ltr   = ihead(11)                ! number of traces
c     ksamp = ihead(14)                ! number of samples
c     dxn   = ihead(53) / 1000.0       ! trace spacing
c     dzn   = ihead(54) / 1000.0       ! depth spacing

      linhed = 0
      call saver(ihead, 'NumTrc',ltr, linhed)
      call saver(ihead, 'NumSmp',ksamp, linhed)
      call saver(ihead, 'Dx1000',idxn, linhed)
      call saver(ihead, 'Dz1000',idzn, linhed)

      write(lprt,*)' Vtape Header'
      write(lprt,*)'     ltr= ',ltr
      write(lprt,*)'   ksamp= ',ksamp
      write(lprt,*)'    idxn= ', idxn
      write(lprt,*)'    idzn= ', idzn
      write(lprt,*)' '
      dxn   = idxn / 1000.0       ! trace spacing
      dzn   = idzn / 1000.0       ! depth spacing
      write(lprt,*) 'dxn,dzn ',dxn,dzn
      if (dzgrid .gt. 0.0) dzn = dzgrid
      if (dxgrid .gt. 0.0) dxn = dxgrid

      if (dzn .eq. 0.) then
         write(lprt,*)'No depth interval either on vtape or on cmd line'
         write(lprt,*)'Supply value on cmd line with -DZT[] entry'
         stop
      endif
      if (dxn .eq. 0.) then
         write(lprt,*)'No horz interval either on vtape or on cmd line'
         write(lprt,*)'Supply value on cmd line with -DXT[] entry'
         stop
      endif

c     set bias to model origin (in velocity tape traces)
      lxbias = (xbegin/dxn +.5)
      write(lprt,*)'xbegin= ',xbegin,' lxbias= ',lxbias
      if(lxbias.gt.ltr) then
         write(lprt,*) 'model origin out of range of velocity tape'
         stop 200
      endif
c     if model origin is positive skip traces on vel tape
      if(lxbias.gt.0) then
         call skipt(luv, lxbias, ksamp*SZSMPD + SZTRHD)
         ltr = ltr-lxbias
      endif

C    check for z limits of the velocity array
      izmov = 1
c89    if (ksamp .gt. nzmax-5) then
c         dzn   = dzn * 2.0
c         izmov = izmov*2
c         ksamp = ksamp / 2
c         go to 89
c      endif
      write(lprt,*)'ksamp= ',ksamp,' izmov= ',izmov,' dzn= ',dzn

C    check for x limits of the velocity array
      ixmov = 1
  90  ixchkd = (nx +  2 * nap) * dxout / dxn + 0.5
      ixchkv = ltr + (2 * nap) * dxout / dxn + 0.5
      write(lprt,*)'ixchkd= ',ixchkd,' ixchkv= ',ixchkv
      if (ixchkd.gt. nxmax-5 .or. ixchkv.gt. nxmax ) then
         dxn   = dxn * 2.0
         ixmov = ixmov*2
         ltr = ltr / 2
         go to 90
      endif
      write(lprt,*)'ltr= ',ltr,' ixmov= ',ixmov,' dxn= ',dxn


C     define node spacings

      dxgrid = dxn
      dzgrid = dzn
      nxgrid = ixchkd
      nzgrid = ksamp

      write(lprt,*)'Node spacings: dxgrid,dzgrid,nxgrid,nzgrid=  ',
     1              dxgrid,dzgrid,nxgrid,nzgrid

C*******************************************************************

C     READ DATA INTO ARRAY V
C*******************************************************************

c     check to see if data or velocity tape is bigger and set parms
      lread = ltr
      if(ixchkd.gt.ixchkv) then
      ixtra = ixchkd - ixchkv
      else
      lread = ixchkd - ixchkv + ltr
      ixtra = 0
      endif
      ixpad   = nap * dxout / dxgrid + 0.5
      if(lxbias.lt.0) ixpad = ixpad - lxbias
      la      = ixpad
      write(lprt,*) 'ixpad=',ixpad,'ixtra=',ixtra
      write(lprt,*) 'ixchkd=',ixchkd,'ixchkv=',ixchkv
      if(la.lt.0) la = 0
      do 110 l = 1, lread*ixmov
         jeof = 0
         call rtape (luv, itr, jeof)

         if (jeof .eq. 0) then
            write (lprt, *) ' ERROR READING TRACE', l
            stop 75
         endif

         if (irx(125) .eq. 30000) then
            write (lprt, *) 'DEAD TRACE ON VELOCITY TAPE, trace = ', l
            write (lprt, *) 'JOB TERMINATED'
            stop 75
         endif

         if((l-1)/ixmov*ixmov.eq.l-1) then
             la = la +1
             ja = 3
             do 105 jz=1,ksamp*izmov,izmov
                 v(ja,la) = data(jz)
  105        ja = ja +1
             v(1,la) = v(3,la)
             v(2,la) = v(3,la)
         endif
  110 continue

C*******************************************************************
C     PAD V IN X DIRECTIONS - to fit data and to allow pads
C*******************************************************************

c     expand velocity to fit the data if necessary
      lleft = la + 1
      if(ixtra.gt.0) then
          do 210 lx = lleft, lleft+ixtra
              do 220 lz = 1,ksamp+2
  220              v(lz,lx) = v(lz,la)
  210     continue
      endif

c     pad lead in
      if(ixpad.gt.0) then
          do 230 lx = 1, ixpad
          do 240 lz = 1,ksamp+2
  240          v(lz,lx) = v(lz,ixpad+1)
  230     continue
      endif

c     pad lead out
      lleft = lleft + ixtra -1
      if(ixpad.gt.0) then
      do 250 lx = lleft+1, lleft+ixpad+1
      do 260 lz = 1,ksamp+2
  260  v(lz,lx) = v(lz,lleft)
  250 continue
      endif

C*******************************************************************
C     CHECK VELOCITY GRID FOR ZEROES
C*******************************************************************

      izz = 0
      do 340 i = 1, nxgrid
         call zerock (lprt, v(1,i), nzgrid, i, iz1)
         izz = izz + iz1
  340 continue

      if (izz .eq. 0) then
          write(lprt,*) 'something wrong with velocity input'
          stop 500
      endif

C*******************************************************************
C     STRETCH VELOCITY VALUES
C*******************************************************************

      do 440 jx = 1, nxgrid
         do 430 jz = 1, nzgrid+2
         v(jz,jx) = v(jz,jx) * strch
         if(v(jz,jx).le.0.0) write(lprt,*) '0 v at',jz,jx
  430    continue
  440 continue


      nzgrid = nzgrid + 2

      write(lprt,*)'nxgrid= ',nxgrid,' nzgrid= ',nzgrid,' stch= ',
     1              strch

C*******************************************************************
C     EXPAND VELOCITIES TO FILL UP V
C*******************************************************************

c     if (nxgrid .lt. nxmax) then
c        do 460 jx = nxgrid+1, nxmax
c           do 450 jz = 1, nzgrid
c              v(jz,jx) = v(jz,nxgrid)
c 450       continue
c 460    continue
c        nxgrid = nxmax
c     endif

c     if (nzgrid .lt. nzmax) then
c        do 480 jx = 1, nxmax
c           do 470 jz = nzgrid+1, nzmax
c              v(jz,jx) = v(nzgrid,jx)
c 470       continue
c 480    continue
c        nzgrid = nzmax
c     endif

       call lbclos (luv)
       return
       end
c     FIXED DT RAYTRACING IN HETEROGENEOUS MEDIA -- RUNGE-KUTTA
      SUBROUTINE RKRAYN ( nzmax,nxmax  ,nrmax,ntmax,
     &                   nz   ,nx     ,nray ,nt   ,ntskip,
     &                   dz   ,dx           ,dt   ,
     &                   v    ,ismoo  ,init ,
     &                   theta,
     &                   zray ,xray, pray, prtol )
c
c     N. D. Whitmore

c     MAXIMUM DIMENSIONS:
c             nzmax  = max # nz                        - input
      integer nzmax
c             nxmax  = max # nx                        - input
      integer nxmax
c             ntmax  = max # nt                        - input
      integer ntmax
c             nrmax  = max # of rays                   - input
      integer nrmax

c     DIMENSIONS:
c             nx = max # of nodes in x direction       - input
      integer nx
c             nz = max # of nodes in z direction       - input
      integer nz
c             nray = # of rays to trace                - input
      integer nray
c             nt = # time steps                        - input
      integer nt
c             ntskip= output time increment            - input
      integer ntskip

c     GRID SIZES:
c             dz = z grid spacing                      - input
      real    dz
c             dx = x grid spacing                      - input
      real    dx
c             dt = time increment                      - input
      real    dt

c     SPATIAL ARRAYS:
c             v    = interval velocity model           - input

      real    v(nzmax,nxmax)
c             ismoo= # of times to apply 9 pt smoother - input
c                    to input velocity model v
      integer ismoo
c             vdsx  = v*v * partial(d( 1/v )/dx) * dt  - computed
c     real    vdsx(nzmax,nxmax)
c             vdsz  = v*v * partial(d( 1/v )/dz) * dt  - computed
c     real    vdsz(nzmax,nxmax)
c             vdt  = (v * dt)                          - computed
c     real    vdt(nzmax,nxmax)
c             init   = initialization flag             - input
c                    = 0 intialize vdsx,vdsz,vdt
c                    = 1 do not intialize vdsx,vdsz,vdt
      integer init

c     COMPUTED WAVEFRONT SLOWNESS:
c             theta = incident angle                   - input / output
      real    theta(nrmax)

c     COMPUTED WAVEFRONT RAY POSITIONS:
c             xray = wavefront x positions at each dt  - input / output
      real    xray(nrmax,ntmax)
c             zray = wavefront z positions at each dt  - input / output
              real zray(nrmax,ntmax)

c     CONSTANT ANGLE RAY PARAMETER AND TOLERANCE
c             pray  = ray parameter                    - input
      real    pray
c             prtol = ray parameter tolerance          - input
      real    prtol

c     LOCAL DECLARATIONS (assume that:  max # rays < 5000)
      real   wcos(5000)  , wsin(5000) , work(5000)


c     program outline:

c      * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

c     0. smooth v (if init=0)

c     1. initialize starting parameters
c        a. find starting node indices
c        b. table starting sin,cos

c     2. loop over time steps, at each time step
c      a. compute node indices of previous ray endpoints
c      b. gather vdt->work
c      c. compute dtheta,thetmp
c      dtheta  =   cos(theta(n-1))*vdsx - sin(theta(n-1))*vdsz
c      b. gather cos(thetmp)->wcos sin(thetmp)->wsin
c      d. compute temp wavefronts
c      XT(t(n)) = X(t(n-1)) + sin( thetmp )*Vdt
c      ZT(t(n)) = Z(t(n-1)) + cos( thetmp )*Vdt
c      e. compute temp node indices
c      f. compute Runge-Kutta update of theta
c      g. gather cos(theta)->wcos sin(theta)->wsin
c      h. update wavefront with an Euler recursion:
c      X(t(n)) = X(t(n-1)) + sin(theta(n))*Vdt
c      Z(t(n)) = Z(t(n-1)) + cos(theta(n))*Vdt
c     end time step loop

c      * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

c     0. smooth v (if init=0)

      if(init.eq.0) then
c       compute dtray
        dtray=dt*ntskip
c       smooth v
        if(ismoo.gt.0) then
        do 400 jsmoo=1,ismoo
  400   call smvel(v,work,wcos,nz,nx,nzmax,nxmax)
        endif

c       pad v from nz to nzmax
        do 520 j2=1,nx
        do 510 j1=nz,nzmax
  510   v(j1,j2)  = v(nz-1,j2)
  520   continue

c       reset init
        init = 1

      endif

c     1. initialize starting parameters
c     a. find starting node indices
      dtray=dt*ntskip
      prdt = pray/dtray
      jout = 1
      dxover = 1./dx
      dzover = 1./dz
c      gather cos(theta)->wcos sin(theta)->wsin
       do 12 j=1,nray
       wcos(j) = cos(theta(j))
   12  wsin(j) = sin(theta(j))

c     2. loop over time steps
c
c     compute number of time steps
      nt1=(nt+ntskip)/ntskip*ntskip

      jtkont = 0
      do 100 jt=1+ntskip,nt1+ntskip,ntskip
      jtkont = jtkont + 1

       do 200 j=1,nray
c      find temp node indices
       jxx = ifix(xray(j,jt-ntskip)*dxover + 1.5)
       jzz = ifix(zray(j,jt-ntskip)*dzover + 1.5)
       if(jxx.lt.3) jxx=3
       if(jxx.gt.nx-2) jxx=nx-2
       if(jzz.lt.2) jzz=2
       if(jzz.gt.nzmax-2) jzz=nzmax-2
c      compute thetmp
       thetmp    = theta(j)
     &           + wcos(j)*v(jzz,jxx)**2 *
     &   .5*( 1./v(jzz,jxx+1) -1./v(jzz,jxx-1) )/dx*dtray
     &           - wsin(j)*v(jzz,jxx)**2 *
     &   .5*( 1./v(jzz+1,jxx) -1./v(jzz-1,jxx) )/dz*dtray
       wcos(j)   = cos(thetmp)
       wsin(j)   = sin(thetmp)
       work(j)   = v(jzz,jxx)*dtray
       jzz =
     & ifix( (zray(j,jt-ntskip) + wcos(j)*work(j))*dzover + 1.5)
       jxx =
     & ifix( (xray(j,jt-ntskip) + wsin(j)*work(j))*dxover + 1.5)
       if(jxx.lt.3) jxx=3
       if(jxx.gt.nx-2) jxx=nx-2
       if(jzz.lt.2) jzz=2
       if(jzz.gt.nzmax-2) jzz=nzmax-2
c      compute update theta
       theta(j) = .5*
     &          ( theta(j) + thetmp
     &          + wcos(j)*v(jzz,jxx)**2 *
     &   .5*( 1./v(jzz,jxx+1) -1./v(jzz,jxx-1) )/dx*dtray
     &          - wsin(j)*v(jzz,jxx)**2 *
     &   .5*( 1./v(jzz+1,jxx) -1./v(jzz-1,jxx) )/dz*dtray)
       wcos(j) = cos(theta(j))
       wsin(j) = sin(theta(j))
       xray(j,jt) = xray(j,jt-ntskip) + wsin(j)*work(j)
       zray(j,jt) = zray(j,jt-ntskip) + wcos(j)*work(j)
  200  continue

c      d. purge rays that are not within prtol of a Snell ray
c         (discard if sin(theta) is not close to pray*V)
       if(prtol.gt.0.0) then
        if(jtkont/8*8.eq.jtkont) then
        do 221 j=1,nray
         if( abs( wsin(j)-prdt*work(j) ) .gt. prtol ) then
         xray(j,jt) = 0.49
         zray(j,jt) = 0.49
         endif
  221   continue
        endif
       endif

c     end time step loop
 100  continue

c      interpolate ntskip time steps
       if(ntskip.gt.1) then
      do 101 jt=1,nt1,ntskip

       do 300 jt1=1,ntskip-1
       beta = float(jt1)/float(ntskip)
       alpha = 1. - beta
       do 310 j=1,nray
       xray(j,jt+jt1) = alpha*xray(j,jt) + beta*xray(j,jt+ntskip)
 310   zray(j,jt+jt1) = alpha*zray(j,jt) + beta*zray(j,jt+ntskip)
 300   continue
 101  continue

       endif
c      end time interpolation
      return

      end
      subroutine smvel(v,work,work2,nz,nx,nzmax,nxmax)
C     CALCULATES A 9 POINT RECIPROCAL SMOOTHING OF A VELOCITY MATRIX
C     INPUT  V  -VELOCITY MATRIX
C     OUTPUT V  -SMOOTHED VELOCITY MATRIX
C     WORKSPACE WORK
c     D. Whitmore

      real v(nzmax,nxmax),work(*),work2(*)

      scale = 1./9.

c     store first column of v in work
       do 10 jz=1,nz
   10  work(jz) = v(jz,1)

c     for each 3 columns smooth and put result into first column
      do 20 jx=2,nx-1

       do 30 jz=2,nz-1
       work2(jz)  =
     & scale *
     & ( 1./v(jz-1,jx-1) + 1./v(jz,jx-1) + 1./v(jz+1,jx-1)
     & + 1./v(jz-1,jx  ) + 1./v(jz,jx  ) + 1./v(jz+1,jx  )
     & + 1./v(jz-1,jx+1) + 1./v(jz,jx+1) + 1./v(jz+1,jx+1)  )
   30  continue
       do 31  jz=2,nz-1
   31  v(jz,jx-1) = 1./work2(jz)

   20 continue

c     move columns over one and take reciprocals
      do 40 jx=nx-1,2,-1
       do 40 jz=2,nz-1
   40  v(jz,jx) = v(jz,jx-1)

c     restore first column
      do 50 jz=1,nz
   50 v(jz,1) = work(jz)

       RETURN
       END
      subroutine rdtrac (luinp, luprt, nx, ntsmp, itbeg, imute,
     &              itr, trhead, trdata, tscale,time, trhdrs,jx)

C     READ A SEISMIC TRACE

C     LUINP  = TRACE DATA LOGICAL UNIT
C     LUPRT  = LOGICAL UNIT FOR PRINTER
C     NX     = NUMBER OF TRACES TO READ
C     NTSMP  = NUMBER OF SAMPLES TO READ
C     ITBEG  = BEGINNING SAMPLE NUMBER TO USE
C     IMUTE  = NUMBER OF SAMPLES TO MUTE
C     TRACE  = TRACE ARRAY
C     TRHEAD = HEADER OF TRACE ARRAY (EQUIVALENCED WITH TRACE(1))
C     TRDATA = DATA   OF TRACE ARRAY (EQUIVALENCED WITH TRACE(129))
C     TSCALE = WORK SPACE FOR TIME SCALING VECTOR
C     TIME   = SCALED OUTPUT TRACE
C     TRHDRS = 2D OUTPUT ARRAY TO HOLD TRACE HEADERS
C     JX     = Trace counter

#include <f77/lhdrsz.h>

c     parameter (nhead = 128, nbword = 8)

c     real    trace(*), trdata(*), tscale(*), time(*)
c     integer trhead(*), trhdrs(LNTRHD,*)

      real      trdata(*), tscale(*), time(*)
      integer*2 trhead(*), trhdrs(LNTRHD,*), itr(*)
C
C-----------------------------------------------------------------------
C
C     BUILD SCALING VECTOR

      if(jx.eq.1) then
      if (imute .ge. 1) then
         do 110 jt = 1, imute
            tscale(jt) = 0.0
  110    continue
         do 120 jt = imute+1, ntsmp
CMAT        tscale(jt) = -1.0 / sqrt( float( jt ) )
            tscale(jt) =  1.0 / sqrt( float( jt ) )
  120    continue
      else
         itabs    = iabs( itbeg )
         tscale(1) = 0.0
         do 130 jt = 2, ntsmp+itabs
CMAT        tscale(jt) = -1.0 / sqrt( float( jt ) )
            tscale(jt) =  1.0 / sqrt( float( jt ) )
  130    continue
      endif

      endif

c        read trace
         nbytes = 0
         call rtape (luinp,   itr, nbytes)

         if (nbytes .le. 0) then
            write (luprt, *) 'TAPE I/O ERROR ON INPUT'
            call ccexit (100)
         endif

         ndata = nbytes / SZSMPD - LNTRHD

C        CLEAR DEAD TRACE

         if (trhead(125) .eq. 30000) then
            call vclr (trdata, 1, ndata)
            trhead(125) = 0
         endif

C        CLEAR END OF TRACE IF NECESSARY

         nxtra = ntsmp - ndata
         if (nxtra .gt. 0) call vclr (trdata(ndata+1), 1, nxtra)

C        SCALE DATA INTO TIME

         if (itbeg .gt. 0) then
            call vmul (trdata(itbeg), 1, tscale, 1, time(1), 1, ntsmp)
         else
         nclr = 1 - itbeg
         call vclr (time, 1, nclr)
          call vmul (trdata, 1, tscale(1+nclr), 1, time(1+nclr), 1,
     &                 ntsmp-nclr)
         endif

C        PUT HEADER INTO ARRAY TRHDRS

         call vmov (trhead, 1, trhdrs(1,jx), 1, LNTRHD)

  210 continue

      return
      end
