C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
 
      subroutine anmute(v, nzmax, nxmax, nzgrid, nxgrid, nzout, dzout,
     &            dzgrid, dxout, angle, work, nzst, nap, vmina,
     &            angl, velref, nirec, nzen, vmax, tmxtmp, nzfrst,nz2nd,
     &lprt)


c     Compute angle dependent mute - D. Whitmore

      real dzout, dzgrid, dxout, angle, velref, vmax, tmxtmp
      integer nzmax, nxmax, nzgrid, nxgrid, nzout, nap, nirec
      integer nz2nd
      real v(nzmax,nxmax), work(*), vmina(*), angl(*)
      integer nzst(*), nzen(*)

      data pi / 3.141592653589793 /

c     v              = velocity matrix
c     nzmax, nxmax   = max dimensions of v
c     nzgrid, nxgrid = actual dimensions of v
c     nzout          = max no of z samples at dzout
c     dzgrid, dxgrid = sample, trace spacings of v
c     dzout          = migration depth spacing
c     angle          = emergent angle
c     nzst           = returned z index for each x
c     vmina          = an array to hold the vmin(z)
c     angl           = array of beam angles
c     velref         = reference velocity
c     nirec          = number of angles (records)
c     nzen           = returned arrays of critical depths
c     vmax           = returned maximum velocity
c     tmxtmp         = returned average traveltime to zmax
c     nzfrst         = first depth to migrate                

c-----------------------------------------------------------------------

      radian = pi / 180.0

c     initialize nzst = 1

      do  5 jx = 1, 2*nap + 1
         nzst(jx) = 1
    5 continue


c     produce average velocity trace in work
c             minimum velocity trace in vmina
c             maximum velocity in vmax

      vmax   = 0.0
      nzbran = (nzout * dzout) / dzgrid + 1
      tmxtmp = 0.0
      scale  = 1.0 / float( nxgrid )
      do 10 jz = 1, nzgrid
         vmina(jz) = 100000000.0
         work(jz)  = 0.0
         do 20 jx = 1, nxgrid
            if (vmina(jz) .gt. v(jz,jx)) vmina(jz) = v(jz,jx)
            if (vmax      .lt. v(jz,jx)) vmax      = v(jz,jx)
            work(jz) = work(jz) + v(jz,jx)
   20    continue

         work(jz) = work(jz) * scale
         if (nzbran .gt. jz) tmxtmp = tmxtmp + 2.0 * dzgrid / work(jz)
   10 continue

        timtmp = 0.0
       do jz = 3,nzgrid
cdan     write(lprt,*) 'jz,z,t=  ',jz-3,dzgrid*(jz-3),timtmp/2.
         if (nzbran .gt. jz) timtmp = timtmp + 2.0 * dzgrid / work(jz)
      enddo

      if (abs( angle ) .gt. 90.0) go to 100

c     compute ray parameter

      pray = abs( sin( angle * radian ) ) / work(1)

      if (abs( pray ) .lt. 0.00000001) go to 100

c     compute the dz0 = cot(angle)*dxout as a function of z

      do 40 jz = 1, nzgrid
         temp = pray * work(jz)
         if (abs(temp) .gt. 1.0) temp = 1.0
         work(jz) = dxout * sqrt( 1.0 - temp ** 2 ) / temp
   40 continue

c     determine nzst as a function of x

      z = dzgrid + 0.000001
      do 50 jx = nap+1, 2*nap+1
         indz = z / dzgrid
         nzst(jx) = z / dzout
         if (nzst(jx) .lt. 1     ) nzst(jx) = 1
         if (nzst(jx) .gt. nzout ) nzst(jx) = nzout
         if (indz     .gt. nzgrid) indz     = nzgrid
         z = z + work(indz)
   50 continue

c     fill first half of nzst with reciprocal mute pattern

      nbig = 2 * nap + 2
      do 60 jx = 1, nap
         nzst(jx) = nzst(nbig-jx)
   60 continue

c     determine the critical depth for each angle

      fudge = 1.2
      do 70 ja = 1, nirec
         pray = abs( sin( angl(ja) * radian ) ) / velref

         do 80 jz = 1, nzgrid
            nzcrit = jz
            if (pray*vmina(jz)  .ge.  1.0) go to 90
   80    continue
   90    continue

         zcrit    = (nzcrit - 1) * dzgrid
         nzen(ja) = fudge * zcrit / dzout + 1
         if (nzen(ja) .gt. nzout) nzen(ja) = nzout
         if (nzen(ja) .gt. nz2nd) nzen(ja) = nz2nd
cdan     write(lprt,*) 'critical depth,nzen=',zcrit,nzen(ja)
   70 continue

  100 continue
      
      do 110 jx = 1, 2*nap + 1
         if(nzst(jx).lt.nzfrst) nzst(jx) = nzfrst
  110 continue

      return
      end
      subroutine cosamp1(a,nz,nap,dz,dx,theta)

c     computes cosine obliquity factor for migration

      integer nz, nap
      real a(*)
      real dz, dx, theta

      real halfpi, therad, pi, x, z, ang, andif
      integer ka, jzst, ja, jz 

      data pi / 3.141592653589793 /

c-----------------------------------------------------------------------

      halfpi = pi / 2.0
      therad = theta * pi  / 180.0

      jzst   = 0
      ka     = 2 * nap + 1
      do 10 ja = 1, ka
         x = - float( nap - ja + 1 ) * dx

         do 20 jz = 1, nz
            z     = float( jz ) * dz
            ang   = asin( x / sqrt( x**2 + z**2 ) )
            andif = abs( ang - therad )
            if (andif .gt. halfpi) andif = halfpi
            a(jzst+jz) = cos( andif )
   20    continue

         jzst = jzst + nz
   10 continue

      return
      end
      subroutine ctrpfl (filt, lfilt, f1, f2, f3, f4, df, scalf, expon,
     &                   phase, lprt)

C     THIS ROUTINE COMPUTES A TRAPEZOIDAL FREQUENCY SCALING VECTOR

c     D. Whitmore

      complex filt(*), scale
      real f1, f2, f3, f4, df, scalf, expon, phase, pi
      integer lfilt, lprt

      data pi / 3.141592653589793 /

C     FILT, LFILT   = FILTER AND LENGTH OF FILTER
C     F1, F2, F3, F4  = TRAPEZOIDAL FILTER POINTS
C     DF           = FREQUENCY SPACING
C     SCALF        = SCALAR MULTIPLIER
C     EXPON        = FREQUENCY EXPONENT
C     PHASE        = PHASE ROTATION IN DEGREES

      real fref, dfovfr, theta, ramp
      data fref/30./
      integer j1, j2, j3, j4, j

C-----------------------------------------------------------------------

C     SET REF FREQUENCY TO 30 HZ

c     fref   = 30
      dfovfr = df / fref

C     BUILD PHASE SCALING

      theta = phase * pi / 180.0
      scale = scalf * cmplx( cos(theta), sin(theta) )

c     BUILD F1, F2, F3, F4 FILTER

      if (f4.lt.f3 .or. f3.lt.f2 .or. f2.lt.f1 .or. f1.lt.0.0) then
         write (lprt, *) 'FILTER ERROR: F1,F2,F3,F4 = ', f1, f2, f3, f4
         stop 1000
      endif

      j1 = f1 / df + 1
      j2 = f2 / df + 1
      j3 = f3 / df + 1
      j4 = f4 / df + 1

      if (j4 .gt. lfilt) then
         write (lprt, *) 'FILTER ERROR'
         write (lprt, *) 'F4 FREQUENCY GREATER THAN MAX FREQUENCY'
         stop 1000
      endif

      call vclr( filt, 1, 2*lfilt )

      if (j2 .gt. j1) then
         do 20 j = j1, j2-1
            ramp    = float(j-j1) / float(j2-j1)
            filt(j) = scale * ((float(j-1) * dfovfr) ** expon * ramp)
   20    continue
      endif

      do 30 j = j2, j3-1
         filt(j) = scale * (float(j-1) * dfovfr) ** expon
   30 continue

      if (j4 .gt. j3) then
         do 40 j = j3, j4-1
            ramp    = float(j4-j) / float(j4-j3)
            filt(j) = scale * ((float(j-1) * dfovfr) ** expon * ramp)
   40    continue
      endif

      return
      end
      subroutine fftflt (data, datao, mdati, mdato, mrsmp, dtsec,
     &                   f1, f2, f3, f4, phase, expon, ifinit, lprt)

c     D. Whitmore

c     data   = input data
c     datao  = output data
c     mdati  = length of input data
c     mdato  = length of output data = mdati*mrsmp
c     mrsmp  = resampling rate (must be a power of 2)
c     dtsec  = delta t in seconds of input
c     f1-f4  = frequency filtering points
c     phase  = phase angle in degrees
c     expon  = frequency exponent
c     ifinit = initialization flag ( = 1 to inititalize)

      integer mdati, mdato, mrsmp, ifinit, lprt
      real    f1, f2, f3, f4, dtsec, phase, expon
      real    data(*), datao(*)


      complex filt(8192)
      integer m1, lfilt, m4
      real    df, scalf
c
      save    filt, m1, lfilt, m4, scalf, df

c-----------------------------------------------------------------------

c     INITIALIZE FILTER

      if (ifinit .eq. 1 ) then

c        compute power of 2 length

	 m1 = 16
 110     continue
         if (m1 .le. mdati) then
            m1 = m1 + m1
            go to 110
         endif

c        compute df = incremental frequency

         df = 1.0 / (dtsec * m1)

c        compute scalf = 1 / (2 * m1)

         scalf = 1.0 / (2.0 * float( m1 ))
         lfilt = m1 / 2

c        define expanded samples

         m4    = m1 * mrsmp
         mdato = mdati * mrsmp

c        compute frequency filter:

         call ctrpfl (filt, lfilt, f1, f2, f3, f4, df, scalf, expon,
     &                phase, lprt)

      end if

c     execute forward fft

      call vclr (data(1+mdati), 1, m1-mdati)
      call rfft (data, m1, 1)

c     multiply by filt

      call cvmul (data, 2, filt, 2, datao, 2, lfilt, 1)

c     execute inverse fft

      if (mrsmp .gt. 1) call vclr (datao(1+m1), 1, (mrsmp-1)*m1)
      call rfft (datao, m4, -1)

      return
      end
      subroutine pnode3 (xin, zin, tray, nxin, nxout, dxout, dzout,
     &           timout, nrayc, nxap, data2d, nzmax, nxmax, jxbia,
     &           napmx, zbias)

      integer nxin, nxout, nrayc, nxap, nzmax, nxmax, jxbia, napmx
      real xin(*), zin(*), tray(*), data2d(nzmax,nxmax+napmx)
c     real data2d(nzmax,nxmax+napmx)
      real dxout, dzout, timout, dzover, dxover 

      integer j, jz, jx, kont1, j1, j2
      real    alpha, beta, scalar

c----------------------------------------------------------------------

      nxout  = 0
      
      dzover = 1.0 / dzout
      dxover = 1.0 / dxout


      if (nrayc .ge. 2) then
         kont1  = nxin - 1
         nxout  = 0
         scalar = 1.0 / float( nrayc )
         do 20 j1 = 2, nrayc
            beta  = float( j1 - 1 ) * scalar
            alpha = 1.0 - beta

            do 30 j2 = 1, kont1
               jx = nint((alpha*xin(j2) + beta*xin(j2+1))*dxover )
     &            + jxbia
               jz = nint(  (-zbias +
     &              alpha*zin(j2) + beta*zin(j2+1) )*dzover) +1
               data2d(jz,jx) = alpha * tray(j2) + 
     &                                  beta * tray(j2+1) + timout
   30       continue

            nxout = nxout + kont1
   20    continue
      endif

c     grid original rays

c
c   An optimization error occurs in do loop 40.  The compiler directive
c   SUPPRESS is used to prevent any optimization error from occuring.
c
      if (nrayc .eq. 1) then
         do 40 j = 1, nxin
            jx =  nint(xin(j) * dxover ) + jxbia
            jz =  nint( (-zbias+zin(j))* dzover)  + 1
            data2d(jz,jx) = tray(j) + timout
   40    continue
      nxout = nxout + nxin
      endif


      return
      end
      subroutine rdrecm (lu, rxx, irx, data, work, ntsmp, itbeg, nx,
     &                   lut, luhdr, nhead, lprt, imute)

C     READ A SEISMIC RECORD AND WRITE HEADER TO A DISK FILE

C     LU    = TRACE DATA LOGICAL UNIT
C     RXX   = TRACE ARRAY
C     IRX   = HEADER OF TRACE ARRAY
C     DATA  = DATA   OF TRACE ARRAY
C     NTSMP = NUMBER OF SAMPLES TO READ
C     ITBEG = BEGINNING SAMPLE NUMBER TO USE
C     NX    = NUMBER OF TRACES TO READ
C     LUT   = LOGICAL UNIT TO HOLD TRACE DATA
C     LUHDR = LOGICAL UNIT TO HOLD TRACE HEADER
C     NHEAD = RECORD BIAS NUMBER OF HEADER GROUP TO BE WRITTEN
C     LPRT  = LOGICAL UNIT FOR PRINTER

#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      real scalt(6000)
      real rxx(*), data(*), work(*)
      integer*2 irx(*)
      integer lu, ntsmp, itbeg, nx, lut, luhdr, nhead, lprt
      integer imute
c     data scalt/6000*0./

      integer nbytes, itabs, j, jntr, nxtra, jt, istart, ndata, ii

C-----------------------------------------------------------------------

C     PROCESS INPUT TRACES

      nbytes = 0
      itabs  = iabs( itbeg )

      if (imute .ge. 1) then
         do 49 j = 1, imute
            scalt(j) = 0.0
   49    continue
         do 50 j = imute+1, ntsmp+itabs
            scalt(j) =  1.0 / sqrt( float( j ) )
   50    continue
      else
         scalt(1) = 0.0
         do 51 j = 2, ntsmp+itabs
            scalt(j) = 1.0 / sqrt( float( j ) )
   51    continue
      endif

      do 100 jntr = 1, nx
         call rtape (lu, rxx, nbytes)
         ndata = (nbytes-SZTRHD)/SZSMPD
         if (nbytes .le. 0) then
            write (lprt, *) 'TAPE I/O ERROR ON INPUT'
            call ccexit (100)
         endif

C        CLEAR DEAD TRACE

         call saver(irx, 'StaCor', istat, TRCHED)
         if (istat .eq. 30000) then
            call vclr (data, 1, ndata)
            call savew(irx, 'StaCor', 0, TRCHED)
         endif

C        CLEAR END OF TRACE IF NECESSARY
         nxtra = ntsmp + itabs - ndata
         if (nxtra .gt. 0) call vclr (data(ndata+1), 1, nxtra)

C        SCALE DATA INTO WORK

         if (itbeg .gt. 0) then
            call vmul (data(itbeg), 1, scalt, 1, work, 1, ntsmp)
         else
            do 201 jt = 1, 1-itbeg
               work(j) = 0.0
  201       continue
            istart = 1 - itbeg
            call vmul(data, 1, scalt(istart), 1, work(istart), 1, ntsmp)
         endif

C        WRITE TRACE HEADER TO DISK
         write(luhdr)(irx(ii), ii=1, ITRWRD)

C        WRITE TRACE TO DISK

	 write(unit=lut)(work(ii), ii=1, ntsmp )
  100 continue

        return
        end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RESIZ                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  THIS ROUTINE WILL RESIZE A DATASET IN THE TRACE OR THE    *
C         -  SAMPLE DIRECTION BY USING A CUBIC INTERPOLATOR            *
C  ENTRY POINTS:                                                       *
C      RESIZ  (TABL1,TABL2,LTR,KSAMP,IDIR,ITOT,MXTOT,IZ,ZZ,A,B)        *
C  ARGUMENTS:                                                          *
C      TABL1   REAL     ??IOU*  (*)     - TABLE OF INPUT SAMPLE RATES  *
C      TABL2   REAL     ??IOU*  (*)     - TABLE OF OUTPUT SAMPLE RATES *
C      LTR     INTEGER  ??IOU*          - NO. OF TRACES                *
C      KSAMP   INTEGER  ??IOU*          - NO. OF SAMPLES               *
C      IDIR    INTEGER  ??IOU*          - 1=SAMPLE-DIR. ; 2=TRACE-DIR. *
C      ITOT    INTEGER  ??IOU*          - NO. OUTPUT SAMPLES OR TRACES *
C      MXTOT   INTEGER  ??IOU*          - MAXIMUM SIZE FOR IN/OUT ARRAY*
C      IZ      INTEGER  ??IOU*  (*)     - WORK ARRAY                   *
C                                       - MUST BE (MAX0(LTR,KSAMP)*2)  *
C      ZZ      REAL     ??IOU*  (*)     - WORK ARRAY                   *
C                                       - MUST BE (MAX0(LTR,KSAMP)*4)  *
C      A       REAL     ??IOU*  (MXTOT) - INPUT ARRAY                  *
C      B       REAL     ??IOU*  (MXTOT) - OUTPUT ARRAY                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 89/03/10  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 89/03/10  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VCLR   - ZERO AN ARRAY                                          *
C      RMTRAN - TRANSPOSE AN ARRAY                                     *
C      CCUINT - CUBE INTERPOLATION ROUTINE                             *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C
      subroutine resiz (tabl1, tabl2, ltr, ksamp, idir, itot, mxtot, 
     &                  iz, zz, a, b)

      integer iz(*), ltr, ksamp, idir, itot, mxtot
      real    a(*), b(*), tabl1(*), tabl2(*), zz(*)

      integer lnew, init, la, lb, knew, k, l
C
C-----------------------------------------------------------------------
C
C     IDIR .GT. 1 MEANS TO INTERPOLATE IN THE X-DIRECTION (TRACE)
C     ARRAY A CONTAINS ONE RECORD LTR TRACES, KSAMP SAMPLES EACH
C     TRANSPOSE A(KSAMP, LTR) INTO B(LTR, KSAMP)

      if (idir .le. 1) go to 300

      lnew = itot
      call vclr   (b, 1, mxtot)
      call rmtran (a, ksamp, b, ltr, ksamp, ltr)
      call vclr   (a, 1, mxtot)

C     RESIZE B INTO A ( IN X DIRECTION (TRACES) FIRST)

      init = 1
      la   = 1
      lb   = 1
      do 200 k = 1, ksamp
         call ccuint (tabl1, b(lb), ltr, tabl2, a(la), lnew, iz, zz,
     &                init)
         init = 0
         la   = la + lnew
         lb   = lb + ltr
  200 continue

C     ARRAY A NOW CONTAINS 1 RECORD OF KSAMP COLUMNS, LNEW POINTS EA.
C     TRANSPOSE A(LNEW, KSAMP) INTO B(KSAMP, LNEW)

      call vclr   (b, 1, mxtot)
      call rmtran (a, lnew, b, ksamp, lnew, ksamp)
      return

C     IDIR .LE. 1 MEANS TO INTERPOLATE IN THE Z-DIRECTION (SAMPLES)
C     ARRAY A CONTAINS ONE RECORD LTR TRACES, KSAMP SAMPLES EACH

  300 continue

C     RESULTING TRACES FOR OUTPUT WILL BE KSAMP2*8+128 BYTES LONG

      knew = itot
      call vclr (b, 1, mxtot)
      init = 1
      la   = 1
      lb   = 1
      do 400 l = 1, ltr
         call ccuint (tabl1, a(la), ksamp, tabl2, b(lb), knew, iz, zz,
     &                init)
         init = 0
         la   = la + ksamp
         lb   = lb + knew
  400 continue

      return
      end
      subroutine rkrayp (nzmax, nxmax, nrmax, ntmax, nz, nx, nray, nt,
     &                   ntskip, dz, dx, dt, v, ismoo, vdsz, vdsx, vdt,
     &                   init, theta, zray, xray, pray, prtol,
     &                   zrjct,xrjct)                         
c
c     FIXED DT RAYTRACING IN HETEROGENEOUS MEDIA -- RUNGE-KUTTA
c     N. D. Whitmore

c     MAXIMUM DIMENSIONS:
c             maxtab = max # entries in cos/sin table   - declared
      integer maxtab
      parameter (maxtab = 240001)
c             nzmax  = max # nz                         - input
      integer nzmax
c             nxmax  = max # nx                         - input
      integer nxmax
c             ntmax  = max # nt                         - input
      integer ntmax
c             nrmax  = max # of rays                    - input
      integer nrmax

c     DIMENSIONS:
c             nx = max # of nodes in x direction        - input
      integer nx
c             nz = max # of nodes in z direction        - input
      integer nz
c             nray = # of rays to trace                 - input
      integer nray
c             nt = # time steps                         - input
      integer nt
c             ntskip = output time increment            - input
      integer ntskip

c     GRID SIZES:
c             dz = z grid spacing                       - input
      real    dz
c             dx = x grid spacing                       - input
      real    dx
c             dt = time increment                       - input
      real    dt

c     SPATIAL ARRAYS:
c             v    = interval velocity model            - input

      real    v(nzmax,nxmax)
c             ismoo = # of times to apply 9 pt smoother - input
c                    to input velocity model v
      integer ismoo
c             vdsx  = v*v * partial(d( 1/v )/dx) * dt   - computed
      real    vdsx(nzmax,nxmax)
c             vdsz  = v*v * partial(d( 1/v )/dz) * dt   - computed
      real    vdsz(nzmax,nxmax)
c             vdt  = (v * dt)                           - computed
      real    vdt(nzmax,nxmax)
c             init   = initialization flag              - input
c                    = 0 intialize vdsx, vdsz, vdt
c                    = 1 do not intialize vdsx, vdsz, vdt
      integer init

c     COMPUTED WAVEFRONT SLOWNESS:
c             theta = incident angle                    - input / output
      real    theta(nrmax)

c     COMPUTED WAVEFRONT RAY POSITIONS:
c             xray = wavefront x positions at each dt   - input / output
      real    xray(nrmax,ntmax)
c             zray = wavefront z positions at each dt   - input / output
              real zray(nrmax,ntmax)

c     CONSTANT ANGLE RAY PARAMETER AND TOLERANCE
c             pray  = ray parameter                     - input
      real    pray
c             prtol = ray parameter tolerance           - input
      real    prtol
c             zrjct = z spacing for purging rays        - input
      real    zrjct
c             xrjct = x spacing for purging rays        - input
      real    xrjct

c     LOCAL DECLARATIONS (assume that:  max # rays < 15000)
      real   wcos(15000), wsin(15000), work(15000)
      data wcos/15000*0./, wsin/15000*0./, work/15000*0./
      save wcos, wsin
c
      integer ierr
      real*8 cstab(maxtab+5)
      real xmax, xmin, dmy
      save cstab, first, xmax, xmin, dmy, ierr
      logical first

      data first / .true. /, dmy / 0. /, ierr / 0 /
      data pi / 3.141592653589793 /
c
c-----------------------------------------------------------------------
c
c     program outline:
c
c     0. smooth v and compute vdsz, vdsx, vdt (if init = 0)
c
c     1. initialize starting parameters
c        a. find starting node indices
c        b. table starting sin, cos
c
c     2. loop over time steps, at each time step
c      a. compute node indices of previous ray endpoints
c      b. gather vdt->work
c      c. compute dtheta, thetmp
c         dtheta = cos(theta(n-1))*vdsx - sin(theta(n-1))*vdsz
c      b. gather cos(thetmp)->wcos sin(thetmp)->wsin
c      d. compute temp wavefronts
c         XT(t(n)) = X(t(n-1)) + sin( thetmp )*Vdt
c         ZT(t(n)) = Z(t(n-1)) + cos( thetmp )*Vdt
c      e. compute temp node indices
c      f. compute Runge-Kutta update of theta
c      g. gather cos(theta)->wcos sin(theta)->wsin
c      h. update wavefront with an Euler recursion:
c         X(t(n)) = X(t(n-1)) + sin(theta(n))*Vdt
c         Z(t(n)) = Z(t(n-1)) + cos(theta(n))*Vdt
c     end time step loop
c
c-----------------------------------------------------------------------
c
c  if first entry to this routine, build cos/sin table
c

      if (first) then
         first = .false.
         xmax  =  3.0 * pi
         xmin  = -3.0 * pi
         call gcftlp (dmy, dmy, 0, maxtab, xmin, xmax, 1, cstab, ierr)
      endif

c     0. smooth v and compute vdsz, vdsx, vdt (if init = 0)

      if (init .eq. 0) then
         dtray = dt * ntskip
         if (ismoo .gt. 0) then
            do 110 jsmoo = 1, ismoo
               call smoothk (v, vdt, nz, nx, nzmax, nxmax)
  110       continue
         endif

c        interior dsz

         do 125 j2 = 1, nx
            do 120 j1 = 2, nz-1
               temp        = 1.0 / v(j1+1,j2) - 1.0 / v(j1-1,j2)
               vdsz(j1,j2) = 0.5 * v(j1,j2)**2 * temp / dz  * dtray
  120       continue
  125    continue

         if (ismoo .gt. 0) then
            do 130 jsmoo = 1, ismoo
               call zsmoo (vdsz, vdt, nz, nx, nzmax, nxmax)
  130       continue
         endif

c        interior dsx

         do 145 j2 = 2, nx-1
            do 140 j1 = 1, nz
               temp        = 1.0 / v(j1,j2+1) - 1.0 / v(j1,j2-1)
               vdsx(j1,j2) = 0.5 * v(j1,j2)**2 * temp / dx * dtray
  140       continue
  145    continue

         if (ismoo .gt. 0) then
            do 150 jsmoo = 1, ismoo
               call xsmoo (vdsx, vdt, nz, nx, nzmax, nxmax)
  150       continue
         endif

c        compute vdt

         do 165 j2 = 2, nx-1
            do 160 j1 = 1, nz-1
               vdt(j1,j2) = v(j1,j2) * dtray
  160       continue
  165    continue

c        pad vdt, vdsz, vdsx from nz to nzmax-1

         do 175 j2 = 1, nx
            do 170 j1 = nz, nzmax-1
               vdt (j1,j2) = vdt(nz-1,j2)
               vdsz(j1,j2) = 0.0
               vdsx(j1,j2) = 0.0
  170       continue
  175    continue

c        set vdsx and vdsz and vdt on model edges

         do 180 j1 = 1, nzmax
            vdt(j1,1)   = 0.0
            vdt(j1,2)   = 0.0
            vdt(j1,3)   = 0.0
            vdt(j1,nx)  = 0.0
            vdsx(j1,1)  = 0.0
            vdsx(j1,nx) = 0.0
  180    continue

         do 190 j2 = 1, nx
            vdt(nzmax,j2)  = 0.0
            vdt(1,j2)      = 0.0
            vdsz(1,j2)     = 0.0
            vdsz(nz,j2)    = 0.0
  190    continue

c        reset init

         init = 1
      endif

c     1. initialize starting parameters
c     a. find starting node indices

      dtray  = dt * ntskip
      prdt   = pray / dtray
      dxover = 1.0 / dx
      dzover = 1.0 / dz

c     gather cos(theta)->wcos sin(theta)->wsin

      call ccftlp (cstab, theta, 1, wcos, wsin, 1, nray, 0, ierr)

c     2. loop over time steps
c
c     compute number of time steps

      nt1 = (nt + ntskip) / ntskip * ntskip

      jtkont = 0
      do 220 jt = 1+ntskip, nt1+ntskip, ntskip
         jtkont = jtkont + 1

         call crkrayd (nrmax, nzmax, nray, ntskip, jt, 
     &                 dxover, dzover, vdsx, vdsz, vdt, cstab, 
     &                 theta, wcos, wsin, work, xray, zray)

c        d. purge rays that are not within prtol of a Snell ray
c           (discard if sin(theta) is not close to pray*V)

         if (prtol .gt. 0.0) then
            if ((jtkont/8)*8 .eq. jtkont) then
               do 210 j = 1, nray
                  if (abs( wsin(j) - prdt * work(j) ) .gt. prtol ) then
                     xray(j,jt) = 0.51*xrjct
                     zray(j,jt) = 0.51*zrjct
                  endif
  210          continue
            endif
         endif

c     end time step loop
  220 continue

c     interpolate ntskip time steps

      if (ntskip .gt. 1) then
         do 330 jt = 1, nt1, ntskip
            do 320 jt1 = 1, ntskip-1
               beta  = float( jt1 ) / float( ntskip )
               alpha = 1.0 - beta
               do 310 j = 1, nray
                  xray(j,jt+jt1) = alpha * xray(j,jt) +
     &                             beta  * xray(j,jt+ntskip)
                  zray(j,jt+jt1) = alpha * zray(j,jt) +
     &                             beta  * zray(j,jt+ntskip)
  310          continue
  320       continue
  330    continue

      endif

c     end time interpolation

      return
      end
      subroutine siftpw (xin, zin, ang, tim, nxin, nxout, angmax, dzout)

      real xin(*), xout(20000)
      real zin(*), zout(20000)
      real ang(*), aout(20000)
      real tim(*), tout(20000)
c     data xout/20000*0./, zout/20000*0./, aout/20000*0./ 
c     data tout/20000*0./

      integer nxin, nxout
      real angmax, dzout

      integer nxtemp, j
c
c-----------------------------------------------------------------------
c
c     remove any rays that with dips greater than dipmax

      nxtemp = nxin
      nxout  = 0

      do 10 j = 1, nxtemp
         if (abs(ang(j)) .le. angmax .and. zin(j) .ge. dzout) then
            nxout = nxout + 1
            tout(nxout) = tim(j)
            aout(nxout) = ang(j)
            xout(nxout) = xin(j)
            zout(nxout) = zin(j)
	 endif
   10 continue

      do 40 j = 1, nxout
         tim(j) = tout(j)
         ang(j) = aout(j)
         xin(j) = xout(j)
         zin(j) = zout(j)
   40 continue

      return
      end
       subroutine siftray (xin, zin, ang, nxin, nxout, angmax)

       real xin(*), xout(20000)
       real zin(*), zout(20000)
       real ang(*), aout(20000)

c      data xout/20000*0./, zout/20000*0./, aout/20000*0./

       real    angmax
       integer nxin, nxout

       integer nxtemp, j
c
c-----------------------------------------------------------------------
c
c     remove any rays that with dips greater than dipmax

      nxtemp = nxin
      nxout  = 0

      do 10 j = 1, nxtemp
         if (abs(ang(j)) .le. angmax) then
            nxout = nxout + 1
            aout(nxout) = ang(j)
            xout(nxout) = xin(j)
            zout(nxout) = zin(j)
	 endif
   10 continue

      do 40 j = 1, nxout
         ang(j) = aout(j)
         xin(j) = xout(j)
         zin(j) = zout(j)
   40 continue

      return
      end
C
      subroutine timpwi (zsrc, xsrc, width, angle, velref, tmax, data2d,
     &                   dzout, dxout, nzmax, nxmax, nrmax, ntmax, 
     &                   nz, nx, nray, nt, ntskip, ntinc, dz, dx, dt, 
     &                   v, ismoo, vdsz, vdsx, vdt, init, theta, 
     &                   zray, xray, nxap, dipmax ,nzout , napmx, 
     &                   mray, tray )
c
c     N. D. Whitmore

c    zsrc  = z origin of the planar ray fan
c    xsrc  = x origin of the planar ray fan
c    width = width of the planar ray fan
c    angle = beam angle of the planar ray fan
c    tmax  = maximum time

c     MAXIMUM DIMENSIONS:
c             nzmax  = max # nz                        - input
      integer nzmax
c             nxmax  = max # nx                        - input
      integer nxmax
c             ntmax  = max # nt                        - input
      integer ntmax
c             nrmax  = max # of rays                   - input
      integer nrmax

c     DIMENSIONS:
c             nx = max # of nodes in x direction       - input
      integer nx
c             nz = max # of nodes in z direction       - input
      integer nz
c             nray = # of rays to trace                - computed
      integer nray
c             nt = # time steps                        - input
      integer nt
c             ntskip= interpolation increment          - input
      integer ntskip
c             ntinc = output skipping increment        - input
      integer ntinc

c     GRID SIZES:
c             dz = z grid spacing                      - input
      real    dz
c             dx = x grid spacing                      - input
      real    dx
c             dt = time increment                      - input
      real    dt

c     SPATIAL ARRAYS:
c             v    = interval velocity model           - input

      real    v(nzmax,nxmax)
c             ismoo= # of times to apply 9 pt smoother - input
c                    to input velocity model v
      integer ismoo
c             vdsx  = v*v * partial(d( 1/v )/dx) * dt  - computed
      real    vdsx(nzmax,nxmax)
C             vdsz  = v*v * partial(d( 1/v )/dz) * dt  - computed
      real    vdsz(nzmax,nxmax)
c             vdt  = (v * dt)                          - computed
      real    vdt(nzmax,nxmax)
c             init   = initialization flag             - input
c                    = 0 intialize vdsx, vdsz, vdt
c                    = 1 do not intialize vdsx, vdsz, vdt
      integer init

c     COMPUTED WAVEFRONT SLOWNESS:
c             theta = incident angle                   - input / output
      real    theta(nrmax)

c     COMPUTED WAVEFRONT RAY POSITIONS:
c             xray = wavefront x positions at each dt  - input / output
      real    xray(nrmax,ntmax)
c             zray = wavefront z positions at each dt  - input / output
              real zray(nrmax,ntmax)

c     OUTPUT DATA ARRAY
      real data2d(nzmax,nxmax+napmx)

c     dzout = output depth interval for data2d
c     dxout = output width interval for data2d

c     LOCAL DECLARATIONS
      parameter (nwork = 10000)
      integer mray(nwork)
      real xwork(nwork), tray(nrmax,ntmax)

      data pi / 3.141592653589793 /
c
c-----------------------------------------------------------------------
c
c     program outline:
c
c     1. initialize starting parameters
c        a. compute initial conditions for rays(location and angles)
c     2. loop over dtref time blocks
c        a. trace rays
c        b. resample ray positions and angles
c     3. interpolate rays onto a grid (in reverse time order)
c
c-----------------------------------------------------------------------
c
c     (init = 0 initializes the tables)

      init = 1

c     cover data matrix with 4*tmax

      radian = pi / 180.0
      pray   = sin( angle * radian ) / velref
      tdata  = abs( pray ) * (width - dxout) + tmax * 2.0


      do 130 jx = 1, nxmax+napmx
         do 120 jz = 1, nzout
            data2d(jz,jx) = tdata
  120    continue
  130 continue

      ntube = 1
      rtube = 0.5 * float( ntube )
      anbi  = 0.0
      danbi = 0.0

      if (ntube .gt. 1) then
         tuwdth = 0.50
         danbi  = tuwdth / rtube
         anbi   = -danbi
      endif

c     raytrace and interpolate for each ray in a raytube

      nxppad = 200
      nxppad = 0
      do 270 jtube = 1, ntube

c        compute initial conditions of rayfans

         ntbeg  = 1
         dxray  = dxout
         nray   = width / dxray + 1.001
         xbig   = (nray - 1) * dxray
         nray   = nray + (nxppad / 2) * dxout / dxray
         nrout  = nray
         angtol = dipmax * radian
         prtol  = 0.5 + 0.5 * abs( sin( angle * radian ) )

         do 210 jray = 1, nray
            zray(jray,1) = zsrc

            if (pray .ge. 0) then
               xray(jray,1) = xsrc + (jray - nxppad / 2 - 1) * dxray
               tray(jray,1) = (xray(jray,1) - xsrc) * pray
            else
               xtemp               = xsrc + (jray - 1) * dxray
               xray(nray-jray+1,1) = xtemp
               tray(nray-jray+1,1) = (xtemp - xsrc - xbig) * pray
            endif

            ixnod = xray(jray,1) / dx + 1.5
            aang  = v(1,ixnod) / velref * sin( (anbi + angle) * radian )

            if (abs( aang ) .lt. 1.0) then
               theta(jray) =  asin( aang )
            else
               theta(jray)  = pi / 2.0
               zray(jray,1) = 0.0
            endif

  210    continue

c        Ray Tracing

         dtray = dt * ntskip
         itref = 0.064 / dtray
         dtref = float( itref ) * dtray
         nt0   = dtref / dt + 0.00001
         ntdub = (nt - 1) / nt0 + 1

c        Ray Tracing and Intepolation

c        for each in the next loop:
c        a. raytrace
c        b. if not the last pass interpolate rays and angles

         do 240 jtl = 1, ntdub
            ntend = ntbeg + nt0
            if (ntend .gt. nt) ntend = nt

            ntstep = ntend - ntbeg + 1

c           FIXED DT RAYTRACING IN HETEROGENEOUS MEDIA
c           Runge-Kutta Ray Tracing

            call rkrayp (nzmax, nxmax, nrmax, ntmax, nz, nx, nrout,
     &                   ntstep, ntskip, dz, dx, dt, v, ismoo, 
     &                   vdsz, vdsx, vdt, init, theta, 
     &                   zray(1,ntbeg), xray(1,ntbeg), pray, prtol,
     &                   dzout, dxout)

c           save number of rays used for this time segment

            do 230 jt = ntbeg, ntend
               do 220 jray = 1, nrout
                  tray(jray,jt) = tray(jray,ntbeg)
  220          continue
               mray(jt) = nrout
  230       continue

c           sift raypaths and angles if necessary

            if (jtl .lt. ntdub) then
               nrtmp = nrout
               call siftpw (xray(1,ntend), zray(1,ntend), theta, 
     &                      tray(1,ntend), nrtmp, nrout, angtol, dz)
            endif

            ntbeg = ntend

c        end ray trace loop
  240    continue

c        interpolate rays onto a grid

c        begin time step loop (dense interpolation)

         do 250 jt = nt, 1, -ntinc

            timout = float( jt-1 ) * dt
            nrout  = mray(jt)
            do jray=1,nrout
            if(zray(jray,jt).lt.zsrc) zray(jray,jt) = zsrc
            enddo

c           interpolate and find node of rays (itol < 64)

            itol = 5 
c           jxbia = -1
c           call pnode3 (xray(1,jt), zray(1,jt), tray(1,jt),
c    &                 nrout, nrout1, dxout, dzout, timout, itol,
c    &                 nxap, data2d, nzmax, nxmax,jxbia,napmx,zsrc)
c           jxbia = +1
c           call pnode3 (xray(1,jt), zray(1,jt), tray(1,jt),
c    &                 nrout, nrout1, dxout, dzout, timout, itol,
c    &                 nxap, data2d, nzmax, nxmax,jxbia,napmx,zsrc)
            jxbia = +0
            call pnode3 (xray(1,jt), zray(1,jt), tray(1,jt),
     &                 nrout, nrout1, dxout, dzout, timout, itol,
     &                 nxap, data2d, nzmax, nxmax,jxbia,napmx,zsrc)
  250    continue


c        begin time step loop (sparse interpolation)

         do 260 jt = nt, 1, -ntinc
            timout = float(jt-1) * dt
            nrout  = mray(jt)

c           interpolate and find node of rays

            itol = 1
            jxbia = +0
            call pnode3 (xray(1,jt), zray(1,jt), tray(1,jt),
     &                 nrout, nrout1, dxout, dzout, timout, itol,
     &                 nxap, data2d, nzmax, nxmax,jxbia,napmx,zsrc)
  260    continue

         anbi = anbi + danbi
  270 continue

c     end time step loop * * * * *

c     fill time grid horizontally with linear interpolation
c     and put ray density scale factor in xray                
      nxstr = xsrc/dxout -1

      do 340 jz = 1, nzout

         ix1 = 0
         do 310 jx = nxstr, nxmax+1
            if(data2d(jz,jx).lt.tdata) then
               ix1 = ix1+1
               mray(ix1) = jx
               xwork(ix1) = data2d(jz,jx)
            endif
            data2d(jz,jx) = tdata
            xray(jz,jx) = 0.
  310    continue

         if(ix1.gt.1) then

          ix1 = ix1+1
          mray(ix1) = mray(ix1-1)+1
          xwork(ix1) = xwork(ix1-1)


          do 320 jx = 1,ix1-1
    
            if( ( mray(jx+1)-mray(jx) ) .lt. 40) then
            ampscl = 1./float(mray(jx+1)-mray(jx))
            do 330 jx1 = mray(jx),mray(jx+1)-1
               data2d(jz,jx1) = xwork(jx) +
     &         float( jx1-mray(jx) ) / float( mray(jx+1)-mray(jx) ) *
     &         (xwork(jx+1) - xwork(jx))
            xray(jz,jx1) = ampscl
  330       continue
            endif

  320     continue

         endif

  340 continue
 
      if ( nzout .lt. nrmax ) then
         do 360 jx=1, min0( nxmax+nxap, ntmax )
         xray(nzout,jx) = 0.
         xray(nzout+1,jx) = 0.
  360    continue
      end if

      return
      end
      subroutine timrfl (zsrc, xsrc, angle, nang, dtref, tmax, data2d,
     &                   dzout, dxout, nzmax, nxmax, nrmax, ntmax, 
     &                   nz, nx, nray, nt, ntskip, ntinc, dz, dx, dt, 
     &                   v, ismoo, vdsz, vdsx, vdt, init, theta, 
     &                   zray, xray, dipmax, lprt, napmx, mray)
c
c     N. D. Whitmore

c    zsrc  = z origin of the ray fan
c    xsrc  = x origin of the ray fan
c    angle = starting angle in rayfan
c    nang  = # of initial angles in the half the rayfan
c    dtref = time increment for refining the positions and
c            angles in the rayfan
c    tmax  = maximum time

c     MAXIMUM DIMENSIONS:
c             nzmax  = max # nz                        - input
      integer nzmax
c             nxmax  = max # nx                        - input
      integer nxmax
c             ntmax  = max # nt                        - input
      integer ntmax
c             nrmax  = max # of rays                   - input
      integer nrmax

c     DIMENSIONS:
c             nx = max # of nodes in x direction       - input
      integer nx
c             nz = max # of nodes in z direction       - input
      integer nz
c             nray = # of rays to trace                - computed
      integer nray
c             nt = # time steps                        - input
      integer nt
c             ntskip= interpolation increment          - input
      integer ntskip
c             ntinc = output skipping increment        - input
      integer ntinc

c     GRID SIZES:
c             dz = z grid spacing                      - input
      real    dz
c             dx = x grid spacing                      - input
      real    dx
c             dt = time increment                      - input
      real    dt

c     SPATIAL ARRAYS:
c             v    = interval velocity model           - input

      real    v(nzmax,nxmax)
c             ismoo= # of times to apply 9 pt smoother - input
c                    to input velocity model v
      integer ismoo
c             vdsx  = v*v * partial(d( 1/v )/dx) * dt  - computed
      real    vdsx(nzmax,nxmax)
c             vdsz  = v*v * partial(d( 1/v )/dz) * dt  - computed
      real    vdsz(nzmax,nxmax)
c             vdt  = (v * dt)                          - computed
      real    vdt(nzmax,nxmax)
c             init   = initialization flag             - input
c                    = 0 intialize vdsx, vdsz, vdt
c                    = 1 do not intialize vdsx, vdsz, vdt
      integer init

c     COMPUTED WAVEFRONT SLOWNESS:
c             theta = incident angle                   - input / output
      real    theta(nrmax)

c     COMPUTED WAVEFRONT RAY POSITIONS:
c             xray = wavefront x positions at each dt  - input / output
      real    xray(nrmax,ntmax)
c             zray = wavefront z positions at each dt  - input / output
              real zray(nrmax,ntmax)

c     OUTPUT DATA ARRAY
      real data2d(nzmax,nxmax+napmx)

c     dzout = output depth interval for data2d
c     dxout = output width interval for data2d

c     LOCAL DECLARATIONS
      parameter (nwork = 40000)
      integer mray(ntmax)

      data pi / 3.141592653589793 /
c
c-----------------------------------------------------------------------
c
c     program outline:
c
c     1. initialize starting parameters
c        a. compute initial conditions for rays(location and angles)
c     2. loop over dtref time blocks
c        a. trace rays
c        b. resample ray positions and angles
c     3. interpolate rays onto a grid (in reverse time order)
c
c-----------------------------------------------------------------------
c

c     compute parameters for interpolation of rays
c     (at every ntdub interpolate rays and angles so that the
c     arclength between adjacent rays does not exceed nrsmp
c     times the output depth spacing)

      radian = pi / 180.0
      nt0    = dtref / dt + 0.00001
      ntdub  = (nt - 1) / nt0 + 1
      prtol  = 0.0
      pray   = 0.0

c     compute initial conditions of rayfans

      nray   = 2 * nang + 1
      ntbeg  = 1
      nrout  = nray
      angmax =  dipmax * radian

      if (angle .gt. 90.0 .or. angle .lt. -90.0) then
         write (lprt, *) 'angle out of range'
         stop 100
      endif

      dang   = abs( angle ) / nang
      angray = -abs( angle ) - dang

      do 110 jray = 1, nray
         angray       = angray + dang
         zray(jray,1) = zsrc
         xray(jray,1) = xsrc
         theta(jray)  =  angray * radian
  110 continue


c     Ray Tracing and Intepolation

c     for each in the next loop:
c     a. raytrace
c     b. if not the last pass interpolate rays and angles

         if(init.eq.0) initb=0
      do 220 jtl = 1, ntdub
         ntend = ntbeg + nt0
         if (ntend .gt. nt) ntend = nt

         ntstep = ntend - ntbeg + 1

c        FIXED DT RAYTRACING IN HETEROGENEOUS MEDIA
c        Runge-Kutta Ray Tracing
         call rkrayp (nzmax, nxmax, nrmax, ntmax, nz, nx, nrout,
     &                ntstep, ntskip, dz, dx, dt, v, ismoo, 
     &                vdsz, vdsx, vdt, init, theta, 
     &                zray(1,ntbeg), xray(1,ntbeg), pray, prtol,
     &                dzout, dxout)

c        save number of rays used for this time segment

         do 210 jt = ntbeg, ntend
            mray(jt) = nrout
  210    continue

         call siftray (xray(1,ntend), zray(1,ntend), theta,
     &                 nrout, nrout, angmax)

         ntbeg = ntend

c     end ray trace and interpolation loop
  220 continue

c     cover data matrix with 2*tmax

      do 330 jx = 1, nxmax+napmx
         do 320 jz = 1, nzmax
            data2d(jz,jx) = 2.0*tmax
  320    continue
  330 continue

      nttop = nt / ntinc * ntinc

c     begin time step loop

      do 340 jt = nttop, 1, -ntinc
         nrout  = mray(jt)
         timout = float( jt-1 ) * dt

c        interpolate and find node of rays

cdan     nrat = timout * 2.0 + 1
         nrat = timout * 10.0 + 2.0
         xbias = dxout
         do jray=1,nrout
         if(zray(jray,jt).lt.zsrc) zray(jray,jt) = zsrc
         enddo
         call cxznod (xray(1,jt), zray(1,jt), nrout, nrout1, nrat,
     &                 dxout, dzout, data2d, nzmax, timout,
     &                 xbias, zsrc)
  340 continue


      n_2 = nang+1
      if(initb.eq.0) then
       do jz = 1,nzmax
       timdata = data2d(jz,napmx/2+1)   
cdan   write(lprt,*) 'jz,Z,t=',jz,(jz-1)*dzout,timdata
       enddo
       do jt=1,nttop
         timout = float( jt-1) * dt
cdan     write(lprt,*) 'z,t=  ',zray(n_2,jt),timout,jt
cdan     write(lprt,*) 'x,t=  ',xray(n_2,jt),timout,jt
       enddo
      endif

c     end time step loop * * * * *

      return
      end
      subroutine cmdlin (ntpv, ntap, otap, otpr, otpi, input,
     &                  dxgrid, dzgrid, ipipiv, ipipi, ipipo, ipipor,
     &                  ipipoi, strch, strcht, istrid, migblk, ltrm,
     &                  ntskip )
c
      integer ipipiv, ipipi, ipipo, ipipor, ipipoi, istrid, ltrm
      real    dxgrid, dzgrid, strch, strcht
      integer argis
      logical help
      character*128 ntpv, ntap, otap, input, otpr, otpi
c
c-----------------------------------------------------------------------
c
  900 format ('COMMAND LINE ARGUMENTS -- TRACE RAYS'//
     &        ' INPUT '/
     &        '-N[ntap]   .. input dataset name'/
     &        '-O[otap]   .. output dataset name'/
     &        '-VEL[ntpv] .. input velocity dataset name'/
     &        '-C[input]  .. external card file  (or inline)'/
     &        '-S[strch]  .. Velocity Perturbation '/
     &        '-DZT[]     .. dz veloc tape  (default-use tape)'/
     &        '-DXT[]     .. dx veloc tape  (default-use tape)'/
     &        'USAGE:'/
     &        'kmpw -N[] -O[] -VEL[] -C[] -DZT[] -DXT[] -S[]')
c
c-----------------------------------------------------------------------
c
      help = (argis( '-h' ) .gt. 0) .or. (argis( '-?' ) .gt. 0)

      if (help) then
         write (ltrm, 900)
         stop
      endif

      call argstr ('-N'  , ntap  , ' ', ' ')
      call argstr ('-O'  , otap  , ' ', ' ')
      call argstr ('-VEL', ntpv  , ' ', ' ')
      call argstr ('-RT' , otpr  , ' ', ' ')
      call argstr ('-IT' , otpi  , ' ', ' ')
      call argstr ('-C'  , input , ' ', ' ')
      call argr4  ('-S'  , strch , 1.0, 1.0)
      call argr4  ('-DZT', dzgrid, 0.0, 0.0)
      call argr4  ('-DXT', dxgrid, 0.0, 0.0)
      call argr4  ('-T'  , strcht, 1.0, 1.0)
      call argi4  ('-MIGBLK'  , migblk,0, 0)
      call argi4  ('-ntskip'  , ntskip,1, 1)

      if(migblk.le.0 .or. migblk.gt.8)migblk = 8

c     SET DEFAULTS TO NO PIPES

      ipipi  = 0
      ipipo  = 0
      ipipiv = 0
      ipipor = 0

c     SET FLAGS FOR PIPES AND 'NO INPUT OR OUTPUTS'
c     PIPES

      if (ntap   .eq. ' ') ipipi  = 1
      if (otap   .eq. ' ') ipipo  = 1

c     INVALID 'NO INPUT'

      if (ntpv   .eq. ' ') ipipiv = 1

c     NO OUTPUT

      if (otpr   .eq. ' ') ipipor = 1
      if (otpi   .eq. ' ') ipipoi = 1
      if (istrid .le.   0) istrid = 1
      if (istrid .ge.  31) istrid = 1

      return
      end
      subroutine velrd (lprt, luv, ihead, rxx, irx, data, dxout,
     &                  nap, v, nzmax, nxmax, nzgrid, nxgrid,
     &                  dzgrid, dxgrid, a, b, mxtot, iz, zz,
     &                  tabl1, tabl2, strch)

c     THIS ROUTINE READS A VELOCITY TAPE AND MAPS IT INTO
c     A VELOCITY MATRIX WHICH IS IN LOCAL COORDINATES WITH PADS

#include <localsys.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

c     MEMORY ALLOCATION

      integer lprt, luv, nap, nzmax, nxmax, nzgrid, nxgrid, mxtot
      real    dxout, dzgrid, dxgrid, strch
      integer iz(*), ihead(*) 
      integer *2 irx(*) 

      real    rxx(*), data(*), v(nzmax,nxmax), tabl1(*), tabl2(*),
     &        a(*), b(*), zz(*)

      integer jeof, ltr, ksamp, ivmov, itr, ltr2, ksamp2, l, la, ntab
      integer j, jx, j1, j2, jz, ipad, iz1, izz, i, idir
      real    dxn, dzn, xgft, rx, rz 
C*******************************************************************
C     READ LINE HEADER -  tape must be open exterior to this routine
C*******************************************************************

      jeof = 0
      call rtape (luv, ihead, jeof)

      if (jeof .eq. 0) then
         write (lprt, *) ' ERROR READING LINE HEADER'
         stop 75
      endif

      call saver( ihead, 'NumTrc', ltr,   LINHED )
      call saver( ihead, 'NumSmp', ksamp, LINHED )
      call saver( ihead, 'Dx1000', jx,    LINHED )
      call saver( ihead, 'Dz1000', jz,    LINHED )
      dxn   = float(jx)/1000.0
      dzn   = float(jz)/1000.0
      jx    = 0
      jz    = 0

      if (dzgrid .gt. 0.0) dzn = dzgrid
      if (dxgrid .gt. 0.0) dxn = dxgrid

      ivmov = 1
      if (ksamp .gt. nzmax-5) then
         dzn   = dzn * 2.0
         ivmov = 2
         ksamp = ksamp / 2
      endif

      if (ksamp .gt. nzmax-5) then
         dzn   = dzn * 2.0
         ivmov = 4
         ksamp = ksamp / 2
      endif

C     DEFINE NODE SPACINGS

      dxgrid = dxn * 2.0
      dzgrid = dzn
      nxgrid = ltr / 2
      nzgrid = ksamp

C     CHECK TO SEE IF DESIRED MODEL WIDTH IS LARGER THAN TAPE

      itr  = ltr
      xgft = nxgrid * dxgrid
      itr  = xgft / dxn + 0.5
      if (itr .gt. ltr) itr = ltr

C     SET REGRIDDING PARAMETERS

      rx     = dxn / dxgrid
      rz     = dzn / dzgrid
      ltr2   = itr * rx
      ksamp2 = ksamp * rz

      write (lprt, *) ' NXGRID', nxgrid

      nxgrid = nxgrid + 2 * nap * dxout / dxgrid + 1.0

      write (lprt, *) ' NXGRID WITH PADS', nxgrid

      if (nxgrid .gt. nxmax) then
         write (lprt, *) ' NXGRID .GT. NXMAX, NXMAX = ', nxmax
         write (lprt, *) '**************JOB TERMINATED***********'
         stop 100
      endif

      ntab = max0( ltr, ksamp, ltr2, ksamp2 )

C*******************************************************************
C     READ DATA INTO ARRAY A
C*******************************************************************

      la = 1
      do 110 l = 1, itr
         jeof = 0
         call rtape (luv, rxx, jeof)

         if (jeof .eq. 0) then
            write (lprt, *) ' ERROR READING TRACE', l
            stop 75
         endif

         call saver(irx, 'StaCor', istat, TRCHED)
         if (istat .eq. 30000) then
            write (lprt, *) 'DEAD TRACE ON VELOCITY TAPE, trace = ', l
            write (lprt, *) 'JOB TERMINATED'
            stop 75
         endif

         call vmov (data, ivmov, a(la), 1, ksamp)
         la = la + ksamp
  110 continue

C*******************************************************************
C     RESAMPLE A INTO B IN THE X-DIRECTION
C*******************************************************************

      do 210 j = 1, ntab
         tabl1(j) = float( j - 1 )
         tabl2(j) = float( j - 1 ) / rx
  210 continue

      idir = 2
      call resiz (tabl1, tabl2, itr, ksamp, idir, ltr2, mxtot, 
     &            iz, zz, a, b)

C******************************************************************
C      RESAMPLE B INTO A IN THE Z-DIRECTION
C******************************************************************

      do 220 j = 1, ntab
         tabl1(j) = float( j - 1 )
         tabl2(j) = float( j - 1 ) / rz
  220 continue

      idir = 1
      call resiz (tabl1, tabl2, ltr2, ksamp, idir, ksamp2, mxtot, 
     &           iz, zz, b, a)

      ipad = nap * dxout / dxgrid
      la   = 1
      do 310 jx = 1, ipad
         call vmov (a(la), 1, v(1,jx), 1, ksamp2)
  310 continue

      j1 = ipad + 1
      j2 = ltr2 + ipad
      do 320 jx = j1, j2
         call vmov (a(la), 1, v(1,jx), 1, ksamp2)
         la = la + ksamp2
  320 continue

      la = la - ksamp2
      j1 = j2 + 1
      j2 = nxgrid
      do 330 jx = j1, j2
         call vmov (a(la), 1, v(1,jx), 1, ksamp2)
  330 continue

      do 340 i = 1, nxgrid
         call zerock (lprt, v(1,i), nzgrid, i, iz1)
         izz = izz + iz1
  340 continue

      if (izz .eq. 0) stop 500

C*******************************************************************
C     STRETCH VELOCITY VALUES AND SHIFT3DOWN 2 Z VALUES
C*******************************************************************

      do 440 jx = 1, nxgrid

         do 410 jz = 1, 2
            a(jz) = v(jz,jx)
  410    continue

         do 420 jz = 1, nzgrid
            a(jz+3) = v(jz,jx)
  420    continue

         do 430 jz = 1, nzgrid+2
            v(jz,jx) = a(jz) * strch
  430    continue

  440 continue

      nzgrid = nzgrid + 2

      if (nxgrid .lt. nxmax) then
         do 460 jx = nxgrid+1, nxmax
            do 450 jz = 1, nzgrid
               v(jz,jx) = v(jz,nxgrid)
  450       continue
  460    continue
         nxgrid = nxmax
      endif

      if (nzgrid .lt. nzmax) then
         do 480 jx = 1, nxmax
            do 470 jz = nzgrid+1, nzmax
               v(jz,jx) = v(nzgrid,jx)
  470       continue
  480    continue
         nzgrid = nzmax
      endif

       call lbclos (luv)
       return
       end
      subroutine wrrec (lu, rxx, irx, data, nzout, nx, a, luhdr, nhead,
     &                  lprt, jr, nztap, istrid, dztap, dzout, strch)

C     READ A HEADER FROM A DISK FILE and WRITE A SEISMIC RECORD

C     LU    = TRACE DATA LOGICAL UNIT
C     RXX   = TRACE ARRAY
C     IRX   = HEADER OF TRACE ARRAY
C     DATA  = DATA   OF TRACE ARRAY
C     NZOUT = NUMBER OF SAMPLES TO WRITE
C     NX    = NUMBER OF TRACES TO WRITE
C     A     = 2D ARRAY TO HOLD TRACE DATA
C     LUHDR = LOGICAL UNIT TO HOLD TRACE HEADER
C     NHEAD = RECORD BIAS NUMBER OF HEADER GROUP TO BE READ
C     LPRT  = LOGICAL UNIT FOR PRINTER
C     JR    = RECORD NUMBER FOR OUTPUT TAPE
C     STRCHT = TIME STRETCH

#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer*2 irx(*)
      real    rxx(*), data(*), a(*)
      integer lu, nzout, nx, luhdr, nhead, lprt, jr, nztap, istrid
      real    dztap, dzout, strch

      integer iz(12000), jz, ii
      real    work(2500), tabl1(12000), tabl2(12000), zz(12000)

      real xstrid
      integer icinit, j, nbytes, nxbias, nhbias, jntr, nxbia1, nxbia2

c-----------------------------------------------------------------------

      xstrid = istrid + 0.00001
      if (xstrid .le. 1.0) xstrid = 1.0

c     build resampling tables

      icinit = 1

      do 300 j = 1, 4000
         tabl1(j) = float( j - 1 ) * dzout / strch
  300 continue

      do 301 j = 1, 4000
         tabl2(j) = float( j - 1 ) * dztap
  301 continue

C     PROCESS INPUT TRACES

      nbytes = (512 + 4 * nztap) * 2
      nbytes = nztap * SZSMPD + SZTRHD
      nxbias = -nzout
      nhbias = (nhead - 1) * nx

      do 100 jntr = 1, nx

C        READ TRACE HEADER FROM DISK

         read( luhdr )(irx(ii), ii=1, ITRWRD)

C        GET DATA FROM ARRAY A

         nxbias = nxbias + nzout
         nxbia1 = nxbias + nzout
         nxbia2 = nxbias - nzout

         if (jntr .lt. nx .and. jntr .gt. 1 .and. istrid .gt. 1) then
            do 200 jz = 1, nzout
               work(jz) = xstrid * ( 0.50 * a(nxbias+jz)
     &                             + 0.25 * a(nxbia2+jz)
     &                             + 0.25 * a(nxbia1+jz) )
  200       continue
         else
            do  201 jz = 1, nzout
               work (jz) = a(nxbias+jz) * xstrid
  201       continue
         endif

         if (nzout .ne. nztap) then
            call ccuint (tabl1, work(1), nzout, tabl2, data(1), nztap,
     &                   iz, zz, icinit)
            icinit = 0
         else
            do 202 jz = 1, nzout
               data(jz) = work(jz)
  202       continue
         endif

         Call savew(irx, 'RecNum', jr, TRCHED)
         call savew(irx, 'TrcNum', jntr, TRCHED)

         call wrtape (lu, rxx, nbytes)

         if (nbytes .le. 0) then
            write (lprt, *) 'TAPE I/O ERROR ON OUTPUT'
            call ccexit (100)
         endif

  100 continue

        return
        end
      subroutine xsmoo (a, b, nz, nx, nzmax, nxmax)

C     CALCULATES A 3 POINT HORIZONTAL SMOOTHING OF A MATRIX
C     INPUT  A  - MATRIX
C     OUTPUT A  - SMOOTHED MATRIX
C     WORKSPACE B

      integer nzmax, nxmax, nx, nz
      real a(nzmax,nxmax), b(nzmax,nxmax)

      real scale
      data scale/.3333333333333333/
      integer jx, jz

c-----------------------------------------------------------------------

c     scale = 1.0 / 3.0

      do 120 jx = 2, nx-1
         do 110 jz = 2, nz-1
            b(jz,jx) = scale * ( a(jz,jx-1) + a(jz,jx) + a(jz,jx+1) )
  110    continue
  120 continue

      do 220 jx = 2, nx-1
         do 210 jz = 2, nz-1
            a(jz,jx) = b(jz,jx)
  210    continue
  220 continue

       return
       end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SMOOTHK                                              *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SMOOTH  (V,SLOW,NZ,NX,NZMAX,NXMAX)                              *
C  ARGUMENTS:                                                          *
C      V       REAL     ??IOU*  (NZMAX,NXMAX) -                        *
C      SLOW    REAL     ??IOU*  (NZMAX,NXMAX) -                        *
C      NZ      INTEGER  ??IOU*                -                        *
C      NX      INTEGER  ??IOU*                -                        *
C      NZMAX   INTEGER  ??IOU*                -                        *
C      NXMAX   INTEGER  ??IOU*                -                        *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   N.D. WHITMORE, JR.                 ORIGIN DATE: 89/03/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 89/03/13  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  James Childress               REVISION DATE: 91/06/04  *
C
C     This routine had its name changed for the 91/06/04 version to    *
C     prevent a name conflict with another library function.
C
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C
      subroutine smoothk (v, slow, nz, nx, nzmax, nxmax)

C     CALCULATES A 9 POINT RECIPROCAL SMOOTHING OF A VELOCITY MATRIX
C     INPUT  V  - VELOCITY MATRIX
C     OUTPUT V  - SMOOTHED VELOCITY MATRIX
C     WORKSPACE SLOW

      integer nzmax, nxmax, nz, nx
      real v(nzmax,nxmax), slow(nzmax,nxmax)

      real scale
      integer jx, jz
      data scale/.1111111111111111 / 
c
c-----------------------------------------------------------------------
c
c     scale = 1.0 / 9.0

      do 20 jx = 2, nx-1
         do 10 jz = 2, nz-1
            slow(jz,jx) =
     &         scale *
     &         ( 1.0/v(jz-1,jx-1) + 1.0/v(jz,jx-1) + 1.0/v(jz+1,jx-1)
     &         + 1.0/v(jz-1,jx  ) + 1.0/v(jz,jx  ) + 1.0/v(jz+1,jx  )
     &         + 1.0/v(jz-1,jx+1) + 1.0/v(jz,jx+1) + 1.0/v(jz+1,jx+1)  )
   10    continue
   20 continue

      do 40 jx = 2, nx-1
         do 30 jz = 2, nz-1
            v(jz,jx) = 1.0 / slow(jz,jx)
   30    continue
   40 continue

       return
       end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C***********************************************************************
C  ROUTINE:       ZEROCK                                       ZEROCK
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       CHECK FOR AN ALL ZERO SEISMIC TRACE
C                 IZ = 0 = TRACE IS ALL ZEROES
C                 IZ = 1 = VALID TRACE
C  LANGUAGE:      FORTRAN_4
C  AUTHOR:        M.A.THORNTON
C  ORIGIN DATE:   80/06/10
C***********************************************************************
C  CATEGORY:      GENERAL PURPOSE
C  ENTRY TYPE:    SINGLE_ENTRY
C  PARAMETERS:
C      LPRT         I*4    LOGICAL UNIT NUMBER FOR PRINT OUTPUT
C      TR       (*) R*4    INPUT TRACE TO CHECK
C      NTR          I*4    LENGTH OF TRACE
C      ITR          I*4    TRACE NUMBER
C      IZ           I*4    0 = ALL ZERO TRACE, 1 = VALID TRACE
C  KEYWORDS:
C  LOGICAL UNITS:
C      6       (WRITE SEQUENTIAL)
C  FORTRAN SUPPLIED ROUTINES:
C**************************************************  END SCAN INFO  ****
C  GENERAL DESCRIPTION:
C  DESCRIPTION OF KEY VARIABLES:
C  ERROR HANDLING:
C  SPECIAL CONSIDERATIONS:
C***********************************************************************
C
      subroutine zerock (lprt, tr, ntr, itr, iz)

      real tr(*)
      integer lprt, ntr, itr, iz

      integer j

c-----------------------------------------------------------------------

      do 110 j = 1, ntr
         if (tr(j) .ne. 0.0) then
            iz = 1
	    return
	 endif
  110 continue

      if (lprt .ge. 0) write (lprt, 900) itr
  900 format (20x, 'TRACE', i5, '  ALL ZEROS')

      iz = 0
      return
      end
      subroutine zsmoo (a, b, nz, nx, nzmax, nxmax)

C     CALCULATES A 3 POINT HORIZONTAL SMOOTHING OF A MATRIX
C     INPUT  A  - MATRIX
C     OUTPUT A  - SMOOTHED MATRIX
C     WORKSPACE B

      integer nzmax, nxmax, nx, nz
      real a(nzmax,nxmax), b(nzmax,nxmax)

      real scale
      data scale/.3333333333333333/
      integer jx, jz

c-----------------------------------------------------------------------

c     scale = 1.0 / 3.0

      do 120 jx = 2, nx-1
         do 110 jz = 2, nz-1
            b(jz,jx) = scale * ( a(jz-1,jx) + a(jz,jx) + a(jz+1,jx) )
  110    continue
  120 continue

      do 220 jx = 2, nx-1
         do 210 jz = 2, nz-1
            a(jz,jx) = b(jz,jx)
  210    continue
  220 continue

       return
       end

