C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:  KNIMOD                                                    *
C  PURPOSE:  KIRCHHOFF DIFRACTION STACK MODELING                       *
C  AUTHOR:   DAN WHITMORE                       ORIGIN DATE: 08/07/93  *
C***********************************************************************
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>


C     Memory Space Allocation

      parameter (nxmax=2500,nzmax=1500,napmx=1000,lrtrd=8192)
      parameter (lhead=1536,len_trace =itrwrd+lrtrd)
cdan  parameter (llist = 27, lprt = 26, lcrd=25, ltmp= 28)
      parameter (llist = 27, lcrd=25, ltmp= 28)

c     header and traces arrays
      dimension ihead(lhead)
      dimension trace(len_trace),rtrd(lrtrd)
      integer*2 itrh(lntrhd)
      equivalence (trace(1),itrh(1)),(trace(ithwp1),rtrd(1))

      real slow(1),p1(1),p2(1),p3(1)
      pointer(pslow,slow)
      pointer(pp1,p1)
      pointer(pp2,p2)
      pointer(pp3,p3)

      integer itime(nzmax*(2*napmx+1))
      integer iheada(1)
      pointer(piheada,iheada)

      character*1 parr(66)
      character*2 pname
      character*4 version
      character*6 ppname

      character*128 otap,ntap,ntapv
      equivalence (pname,ppname)
          
      real junka(8192)

      logical verbos

      data version/' 1.0'/
      data ppname/'KNIMOD'/
      data parr/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     3' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     3          ' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/
 

c     Get Command Line Arguments
      ltrm  = 0
      call cmdlin(ntap,otap,ntapv,ipipi,ipipo,ipipv,ltrm,
     &verbos,dt,nt,nap,dipmax,angle,ismv,ismh,inc_ray,
     &f1,f2,f3,f4,ntskip,itest)
C     Open printout
      call openpr(llist,lprt,pname,jerr)
      if(jerr.ne.0)stop 200
#include <mbsdate.h>
      nlin=1
      call gamoco(parr,nlin,lprt)
 
c     open velocity dataset
      call lbopen(luv,ntapv,'r')
      
      write(lprt,37)ntapv
   37 format(' VELOCITY DATASET = ',/,A128,/)

c     read velocity line header and get parameters
      jeof = 0
      call rtape(luv,ihead,jeof)
        if(jeof.le.0) then
           call lbclos(luv)
           write(0,*)'error in reading input line header'
           stop 73
        endif
      call saver(ihead, 'NumSmp', nz, linhed)
      call saver(ihead, 'NumTrc', nx, linhed)
      call saver(ihead, 'NumRec', num_rec_v, linhed)
      call saver(ihead, 'Dx1000', idx_1000, linhed)
      call saver(ihead, 'Dz1000', idz_1000, linhed)
      dx = idx_1000/1000.
      dz = idz_1000/1000.

c     Open Input Dataset
      if(ipipi.eq.0) then
C        luin is an input dataset
         call lbopen(luin,ntap,'r')
      else
C        we know luin is a pipe
         luin = 0
         ltrm = 2
      endif

c     Open Output Dataset
      if(ipipo.eq.0)then
C        luout is an output dataset
         call lbopen(luout,otap,'w')
      else
C        we know luout is a pipe
         luout=1
      endif

      write(lprt,38)ntap,otap
   38 format(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)

C     Open Input Tape, Get parameters
      jeof = 0
      call rtape(luin,ihead,jeof)
        if(jeof.le.0) then
           call lbclos(luin)
           call lbclos(luout)
           call lbclos(luv)
           write(0,*)'error in reading input line header'
           stop 73
        endif
      len=5

c     Update Historical line header
      call hlhprt(ihead,jeof,ppname,len,lprt)

c     Bring in Input Line Header Values
      smp_int = dt*1000.
      call saver(ihead, 'NumSmp', num_smp, linhed)
      call saver(ihead, 'NumTrc', num_trc, linhed)
      call saver(ihead, 'NumRec', num_rec, linhed)
      call saver(ihead, 'Format', iform, linhed)

      if(iform.ne.3)then
         write(lprt,*)'  INPUT TAPE MUST BE FORMAT 3'
         stop 100
      endif

      num_smpo = nt
      nbytes = nt * SZSMPD + SZTRHD
      if(itest.ne.0) then
        nbytes = nz * SZSMPD + SZTRHD
        num_smpo = nz
      endif
      
C
C     Set Output Header Info
C
      ismp_int = smp_int
      call savew(ihead, 'NumSmp', num_smpo, LINHED)
      call savew(ihead, 'NumTrc', num_trc,  LINHED)
      call savew(ihead, 'NumRec', num_rec,  LINHED)
      call savew(ihead, 'SmpInt', ismp_int, LINHED)
      call savew(ihead, 'Format', iform,    LINHED)
      call wrtape(luout,IHEAD,JEOF)

c     allocate space for 1./velocity array
      jerr = 0
      isize_slow = nz*nx
      call galloc( pslow, isize_slow*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(0,*)'galloc error: ', jerr
         stop
      endif

c     allocate trace header arrays
      jerr = 0
      isize_iheada = itrwrd*num_trc
      call galloc( piheada, isize_iheada*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(0,*)'galloc error: ', jerr
         stop
      endif

c     allocate data arrays 
      jerr = 0
      isize_p1 = nx*nz
      call galloc( pp1, isize_p1*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(0,*)'galloc error: ', jerr
         stop
      endif
      call vclr(p1,1,isize_p1)

      jerr = 0
      isize_p2 = nx*nt
      if(nz.gt.nt) isize_p2 = nx*nz
      call galloc( pp2, isize_p2*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(0,*)'galloc error: ', jerr
         stop
      endif
c     allocate data arrays 
      jerr = 0
      isize_p3 = nx*nz
      call galloc( pp3, isize_p3*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(0,*)'galloc error: ', jerr
         stop
      endif


c     Get slowness data and smooth 
      scale_slow = 2.
      ierr = 0
      call sloget(slow,p2,nz,nx,luv,trace,rtrd,lprt,ismv,ismh,
     &            scale_slow,ierr)
      if(ierr.gt.0) go to 1000
      
      do 500 jrec=1,num_rec
         if(VERBOS)write(lprt,*) 'PROCESSING RECORD ',jrec
        
c        process input traces for this record
         do jtrc=1,num_trc
            jeof=0
            call rtape(luin,trace,jeof)
              if(jeof.le.0) then
                 call lbclos(luin)
                 call lbclos(luout)
                 write(0,*)'error in reading input'
                 write(0,*)'rec,trace=',jrec,jtrc
                 stop 74
              endif
            call vmov(itrh,1,iheada( 1+itrwrd *(jtrc-1) ),1,itrwrd)
            rtrd(1)       =   0.0
            rtrd(num_smp) =   0.0
            if(nz.gt.num_smp) then
            do jjj=num_smp,nz 
            rtrd(jjj) = 0.0
            enddo
            endif
            call vmov(rtrd,1,    p1( 1+nz     *(jtrc-1) ),1,nz)
         enddo
 
c        clear output
         call vclr(p2,1,isize_p2)
         call vclr(p3,1,isize_p3)

c        diffraction modeling
         call difmod(p1,p2,nz,nt,nx,itime,nap,slow,dz,dt,dx,
     &                  dipmax,angle,inc_ray,ntskip,itest,p3)

c        process output traces for this record
         init = 1
         mrsmp = 1
         phase = 45.
         expon = 0.5
         do jtrc=1,num_trc
          call vmov(iheada( 1+itrwrd*(jtrc-1) ),1,itrh,1,itrwrd)
          if(itest.eq.0) then
          call vmov(p2(1+nt*(jtrc-1)),1,junka,1,nt)
          junka(1) = 0.0
          junka(nt) = 0.0
          call fftflt (junka, rtrd, nt, ntout, mrsmp, dt,
     &                 f1, f2, f3, f4, phase, expon, init, lprt)
          init = 0
           do jt = 1,nt
           rtrd(jt) = sqrt( float(nt)/ float(jt) ) * rtrd(jt)
           enddo
           rtrd(nt) = 0.0
           else
           call vmov(p3(1+nz*(jtrc-1)),1,rtrd,1,nz)
           endif

          call savew(itrh, 'RecNum', jrec, TRCHED)
          call savew(itrh, 'TrcNum', jtrc, TRCHED)
          call savew(itrh, 'StaCor',    0, TRCHED)
           call wrtape(luout,trace,nbytes)
             if(jeof.le.0) then
                call lbclos(luin)
                call lbclos(luout)
                write(0,*)'error in writing output'
                write(0,*)'rec,trace=',jrec,jtrc
                stop 75
             endif
         enddo

500   continue

c     Close Seismic Datasets

1000  continue
      call lbclos(luin)
      call lbclos(luout)
      call lbclos(luv)
 
c     End Of Job

      stop
      end
C***********************************************************************
      subroutine cmdlin(ntap,otap,ntapv,ipipi,ipipo,ipipv,ltrm,
     &verbos,dt,nt,nap,dipmax,angle,ismv,ismh,inc_ray,
     &f1,f2,f3,f4,ntskip,itest)
      integer argis
      logical help,verbos
      character*128 ntap,otap,ntapv
      help  = (argis( '-h' ).gt.0) .OR. (argis( '-?').gt.0)
      if(help)then
        write(ltrm,*)'KIRCHHOFF DIFFRACTION STACK MODELING'
        write(ltrm,*)' '
        write(ltrm,*)' INPUT '
        write(ltrm,*)'-N       .. Reflectivity DATASET NAME'
        write(ltrm,*)'-VT      .. Velocity DATASET NAME'
        write(ltrm,*)'-O       .. Normal Incidence Time Section'
        write(ltrm,*)'-dt      .. sample interval (ms) def = 4'
        write(ltrm,*)'-t       .. max time (ms) def=4000'
        write(ltrm,*)'-nap     .. half aperture def=150'
        write(ltrm,*)'-edip    .. emergent dip (for rays def=50) '   
        write(ltrm,*)'-mdip    .. max subsurface dip (for rays def=105)'
        write(ltrm,*)'-rinc    .. surface ray increment ( def = 3)'
        write(ltrm,*)'-ismh    .. apply 3 pt x smoother ismh times'
        write(ltrm,*)'-ismv    .. apply 3 pt z smoother ismz times'
        write(ltrm,*)'-f1      .. first  filter point, default = 3 '
        write(ltrm,*)'-f2      .. second filter point, default = 6 '
        write(ltrm,*)'-f3      .. third  filter point, default = 30 '
        write(ltrm,*)'-f4      .. fourth filter point, default = 60'
        write(ltrm,*)'-V       .. VERBOSE PRINTOUT'
        write(ltrm,*)'USAGE:'
        write(ltrm,*)'knimod -N[] -VT[] -O[] -dt[] -t[] -nap[] -rinc[]
     &  -edip[] -mdip[] -rinc[] -ismh[] -ismv[] -f1[] -f2[] -f3[] -f4[]'
        stop
      endif
      call argstr('-N',NTAP,' ',' ')
      call argstr('-O',OTAP,' ',' ')
      call argstr('-VT',NTAPV,' ',' ')
      call argr4  ('-dt', dt, 4.0, 4.0)
      call argr4  ('-t', t, 4000., 4000.)
      call argr4  ('-edip', angle, 50.0, 50.0)
      call argr4  ('-mdip', dipmax, 105.0, 105.0)
      call argi4  ('-nap', nap, 150, 150)
      call argi4  ('-ismv', ismv, 3, 3)
      call argi4  ('-ismh', ismh, 3, 3)
      call argi4  ('-ntskip', ntskip, 1, 1)
      call argi4  ('-itest', itest, 0, 0)
      call argi4  ('-rinc', inc_ray, 3, 3)
      call argr4  ('-f1', f1, 3.0, 3.0)
      call argr4  ('-f2', f2, 6.0, 6.0)
      call argr4  ('-f3', f3, 30.0, 30.0)
      call argr4  ('-f4', f4, 60.0, 60.0)
      nt = nint(t/dt)
      dt = dt/1000.
      if(nt.lt.100) nt=100
      inc_ray = inc_ray/2*2+1

      verbos = (argis( '-V' ).GT.0)
c
c     set pipe flags (0=no pipe,1=pipe)
      ipipi=0
      ipipo=0
      if(ntap.eq.' ' ) ipipi=1
      if(otap.eq.' ' ) ipipo=1
c
      RETURN
      END
C
      subroutine difmod(p1,p2,nz,nt,nx,itime,nap,slow,dz,dt,dx,
     &                  dipmax,angle,inc_ray,ntskip,itest,p3)
c     diffraction modeling  
      real    p1(nz,nx),p2(nt,nx),slow(nz,nx),p3(nz,nx)
      integer itime(nz,-nap:nap)

       iz1 = 1
       ix0 = 1
       vtest = 2000./2.
       ihalf = inc_ray/2
        do ix1 = 1,nx

        if(itest.eq.0) then

c       build travel time array (every inc_ray)
        ichk = ix1+ihalf
         if( (ichk+ihalf)/inc_ray*inc_ray.eq.ichk+ihalf
     &                         .and. ichk.le.nx ) then 
c         call timge0(nz,nt,nx,itime,nap,vtest,dz,dt,dx)
          call timget(ichk,iz1,nz,nt,nx,itime,nap,slow,dz,dt,dx,
     &                dipmax,angle,ntskip)
         endif
         nxlow  = max0(1,ix1-nap)
         nxhigh = min0(nx,ix1+nap)
         do ix = nxlow,nxhigh
           jx = ix-ix1
           do iz = 1, nz
             p2(itime(iz,jx),ix1) = p1(iz,ix)+ p2(itime(iz,jx),ix1)
           enddo
         enddo

        else

         if(ix1.eq.itest) then
          ichk = itest
          call timget(ichk,iz1,nz,nt,nx,itime,nap,slow,dz,dt,dx,
     &                dipmax,angle,ntskip)
          nxlow  = max0(1,ix1-nap)
          nxhigh = min0(nx,ix1+nap)
          do ix = nxlow,nxhigh
            jx = ix-ix1
            do iz = 1, nz
              p3(iz,ix) = itime(iz,jx)
            enddo
          enddo
         endif

        endif
        enddo

      return
      end
      subroutine sloget(slow,p2,nz,nx,luv,trace,rtrd,lprt,ismv,ismh,
     &            scale_slow,ierr)
      real      trace(*),rtrd(*),slow(nz,nx),p2(nz,nx)

c     read velocity dataset and put reciprocal into slow
c     shift down one node to allow for ray trace boundary conditions
      do jx=1,nx
            jeof=0
            call rtape(luv,trace,jeof)
              if(jeof.le.0) then
                 write(lprt,*)'error in reading input velocity'
                 write(lprt,*)'trace=',jx
                 ierr = 1000
                 return
              endif
            do jz=1,nz-1
             slow(jz+1,jx) = scale_slow/rtrd(jz)
            enddo
            slow(1,jx) = slow(2,jx)
      enddo
      
c     smooth slowness field in the x direction
      if(ismh.gt.0) then
       do js = 1,ismh

        scale = 1./3.
        do jx=2,nx-1
         do jz=2,nz-1
          p2(jz,jx)= scale *                                      
     &       (slow(jz,jx-1)+slow(jz,jx)+slow(jz,jx+1))
         enddo
        enddo

        do jx=2,nx-1
         do jz=2,nz-1
           slow(jz,jx)= p2(jz,jx)                                       
         enddo
        enddo

       enddo
      endif

c     smooth slowness field in the z direction
      if(ismv.gt.0) then
       do js = 1,ismv

        scale = 1./3.
        do jx=2,nx-1
         do jz=2,nz-1
          p2(jz,jx)= scale *                                      
     &      ( slow(jz-1,jx)+slow(jz,jx)+slow(jz+1,jx) )
         enddo
        enddo

        do jx=2,nx-1
         do jz=2,nz-1
           slow(jz,jx)= p2(jz,jx)                                       
         enddo
        enddo

       enddo
      endif

      return
      end
c    
      subroutine timge0(nz,nt,nx,itime,nap,vtest,dz,dt,dx)
      integer itime(nz,-nap:nap)
 
c      build travel time array
        do ix=-nap,nap
         x = ( ix - 1 ) * dx
          do iz = 1, nz
            z = (iz-1)*dz
            t = sqrt((x)**2 + z**2)/vtest
            itime(iz,ix)  = t/dt + 1.5
            if(itime(iz,ix) .ge. nt) itime(iz,ix) = nt
          enddo
        enddo

      return
      end
