C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c     READ (5, 100) IX1, IY1, IX2, IY2, DY, DX                          XFO00010
c 100 FORMAT (10X, 4I10, 2F5.0)                                         XFO00020
c     READ (5, 100) IX3, IY3                                            XFO00030
c     IX4 = IX1 + IX3 - IX2                                             XFO00040
c     IY4 = IY1 + IY3 - IY2                                             XFO00050
c     CALL XFMI(   IX1,    IY1,                                         XFO00060
c    &             IX2,    IY2,                                         XFO00070
c    &             IX3,    IY3,                                         XFO00080
c    &             IX4,    IY4, DY,DX,NX,NY,ISIGN,                      XFO00090
c    &          6,ICC)                                                  XFO00100
c 150 READ (5, 200, END=900) IRI, IDI, ILI                              XFO00110
c 200 FORMAT (3I5)                                                      XFO00120
c     XT = (IDI - 1) * DX + DX / 2.                                     XFO00130
c     YT = (ILI - 1) * DY + DY / 2.                                     XFO00140
c     CALL XFMINV(X,Y,XT,YT,X,Y,XT,YT,ICC)                              XFO00150
c     IX = X + .5                                                       XFO00160
c     IY = Y + .5                                                       XFO00170
c     WRITE (6, 300) IX, IY, IRI                                        XFO00180
c 300 FORMAT (1X, '2AZ3D', 5X, 2I10, I5)                                XFO00190
c     go to 150                                                         XFO00200
c 900 STOP                                                              XFO00210
c     END                                                               XFO00220
CPROG XFORM                                                             XFO00230
C***********************************************************************XFO00240
C     SUBROUTINE NAME: XFORM  (TRANSFORM COORDINATE SYSTEMS)            XFO00250
C     ENTRY POINTS:    XFMI   (INITIALIZATION)                          XFO00260
C                      XFMFWD (COMPUTE NEW COORDINATES - FORWARD)       XFO00270
C                      BINCTR (COMPUTE BIN CENTER COORDINATES)          XFO00280
C                      ILIDI  (COMPUTE LINE AND DEPTH INDECES ONLY)     XFO00290
C                      XFMINV (COMPUTE NEW COORDINATES - INVERSE)       XFO00300
C                                                                       XFO00310
C     LANGUAGE: FORTRAN                                                 XFO00320
C                                                                       XFO00330
C     AUTHOR: ?????                                                     XFO00340
C                                                                       XFO00350
C     DATE WRITTEN: ??/??/??                                            XFO00360
C                                                                       XFO00370
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       XFO00390
C     ABSTRACT: COMPUTE THE CONSTANTS NEEDED TO PERFORM THE FOLLOWING   XFO00400
C               TRANSFORMATION OF A PARALLELOGRAM TO A RECTANGLE:       XFO00410
C                 1- MAP CORNER 1 ONTO ORIGIN                           XFO00420
C                 2- MAP CORNER 2 ONTO POSITIVE Y-AXIS                  XFO00430
C                 3- MAP CORNER 3 ONTO QUADRANT 1                       XFO00440
C                 4- MAP CORNER 4 ONTO POSITIVE X-AXIS                  XFO00450
C               AND, GIVEN A PARTICULAR (X,Y), NEW COORDINATES (IN      XFO00460
C               LINE INDEX, DEPTH INDEX FORM) ARE RETURNED.             XFO00470
C                                                                       XFO00480
C     CALLING SEQUENCE: CALL XFMI  (IX1,  IY1, IX2, IY2, IX3, IY3,      XFO00490
C                                   IX4,  IY4, DY , DX , NX , NY ,      XFO00500
C                                   ISIGN,IPR, ICC)                     XFO00510
C                WHERE: IX1 - X-COORDINATE OF CORNER 1                  XFO00520
C                       IY1 - Y-COORDINATE OF CORNER 1                  XFO00530
C                       IX2 - X-COORDINATE OF CORNER 2                  XFO00540
C                       IY2 - Y-COORDINATE OF CORNER 2                  XFO00550
C                       IX3 - X-COORDINATE OF CORNER 3                  XFO00560
C                       IY3 - Y-COORDINATE OF CORNER 3                  XFO00570
C                       IX4 - X-COORDINATE OF CORNER 4                  XFO00580
C                       IY4 - Y-COORDINATE OF CORNER 4                  XFO00590
C                       DY  - CELL DIMENSION  ALONG SIDE 1-2            XFO00600
C                       DX  - CELL DIMENSION  ALONG SIDE 2-3            XFO00610
C                       NX  - NUMBER OF CELLS ALONG SIDE 2-3            XFO00620
C                       NY  - NUMBER OF CELLS ALONG SIDE 1-2            XFO00630
C                       ISIGN-                                          XFO00640
C                       IPR - LOGICAL UNIT OF PRINTER                   XFO00650
C                       ICC - ERROR STATUS                              XFO00660
C                             IF NO ERRORS, VALUE REMAINS UNCHANGED.    XFO00670
C                                                                       XFO00680
C     CALLING SEQUENCE: CALL XFMFWD (XC  , YC  , ILI, IDI, XT , YT)     XFO00690
C                                    XTBC, YTBC, IWARN)                 XFO00700
C            WHERE: XC    R*4 - X-COORDINATE OF POINT IN QUESTION       XFO00710
C                   YC    R*4 - Y-COORDINATE OF POINT IN QUESTION       XFO00720
C                   ILI   I*4 - LINE INDEX OF (XC,YC)                   XFO00730
C                   IDI   I*4 - DEPTH INDEX OF (XC,YC)                  XFO00740
C                   XT    R*4 - TRANSFORMED X-COORDINATE                XFO00750
C                   YT    R*4 - TRANSFORMED Y-COORDINATE                XFO00760
C                   XTBC  R*4 - TRANSFORMED X-COORDINATE BIN CENTER     XFO00770
C                   YTBC  R*4 - TRANSFORMED Y-COORDINATE BIN CENTER     XFO00780
C                   IWARN I*4 - WARNING FLAG                            XFO00790
C                               0 = ALL OK                              XFO00800
C                               1 = POINT NOT WITHIN GRID BOUNDARIES    XFO00810
C                                                                       XFO00820
C    CALLING SEQUENCE: CALL BINCTR (MIDX,MIDY,DX,DY,ILI,IDI,            XFO00830
C                                   IBINX,IBINY,IWARN)                  XFO00840
C            WHERE: MIDX  I*4 - X-COORDINATE OF POINT IN QUESTION       XFO00850
C                   MIDY  I*4 - Y-COORDINATE OF POINT IN QUESTION       XFO00860
C                   DY    R*4 - CELL INCREMENT ALONG SIDE 1-2           XFO00870
C                   DX    R*4 - CELL INCREMENT ALONG SIDE 2-3           XFO00880
C                   ILI   I*4 - LINE  INDEX OF (XC,YC)                  XFO00890
C                   IDI   I*4 - DEPTH INDEX OF (XC,YC)                  XFO00900
C                   IBINX I*4 - BIN CENTER OF (XC,YC)                   XFO00910
C                   IBINY I*4 - BIN CENTER OF (XC,YC)                   XFO00920
C                   IWARN I*4 - WARNING FLAG                            XFO00930
C                               0 = ALL OK                              XFO00940
C                               1 = POINT NOT WITHIN GRID BOUNDARIES    XFO00950
C                                                                       XFO00960
C     CALLING SEQUENCE: CALL XFMINV(XC  , YC  , XT  , YT  ,             XFO00970
C                                   XBC , YBC , XTBC, YTBC, JERR)       XFO00980
C                WHERE: XC   - INVERSED X-COORDINATE                    XFO00990
C                       YC   - INVERSED Y-COORDINATE                    XFO01000
C                       XT   - X-COORDINATE IN QUESTION                 XFO01010
C                       YT   - Y-COORDINATE IN QUESTION                 XFO01020
C                       XBC  - INVERSED X-COORDINATE BIN CENTER         XFO01030
C                       YBC  - INVERSED Y-COORDINATE BIN CENTER         XFO01040
C                       XTBC - X-COORDINATE BIN CENTER IN QUESTION      XFO01050
C                       YTBC - Y-COORDINATE BIN CENTER IN QUESTION      XFO01060
C                       JERR - ERROR FLAG                               XFO01070
C                                 0 = NO ERRORS                         XFO01080
C                                 1 = ERRORS ENCOUNTERED - MATRIX IS    XFO01090
C                                     SINGULAR                          XFO01100
C                                                                       XFO01110
C***********************************************************************XFO01120
C                                                                       XFO01130
      SUBROUTINE XFORM                                                  XFO01140
C                                                                       XFO01150
C-----------------------------------------------------------------------XFO01160
C     DECLARATIONS, DEFINITIONS, & INITIALIZATIONS                      XFO01170
C-----------------------------------------------------------------------XFO01180
C                                                                       XFO01190
      REAL*8    P41L                                                    XFO01200
      REAL*8    COS0  , SIN0  , SCOS0 , SSIN0                           XFO01210
      REAL*8    TANPHI, DYCPHI, CPHI                                    XFO01220
      REAL*8    X     , Y     , XX    , XY    , YX    , YY              XFO01230
      REAL*8                    XXT   , XYT   , YXT   , YYT             XFO01240
      REAL*8    DE,DF                                                   XFO01250
      REAL*8    E,F,XYYXXY                                              XFO01260
C                                                                       XFO01270
      ENTRY XFMI  (IX1a  , IY1a  , IX2a  , IY2a  , IX3a  , IY3a  ,      XFO01280
     $             IX4a  , IY4a  , DYa   , DXa   , NXa   , NYa   ,      XFO01290
     $             ISIGN , IPR   , ICC   )                              XFO01300
C                                                                       XFO01310
C-----------------------------------------------------------------------XFO01320
C     ENSURE THE COORDINATES DEFINE A PARALLELOGRAM                     XFO01330
C-----------------------------------------------------------------------XFO01340
C                                                                       XFO01350
      common/xformc/ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4,dx,dy,nx,ny,xyt,
     $              xxt, yxt, yyt, yx, yy, xx, xy, df, de
      ier=0
      ix1=ix1a
      iy1=iy1a
      ix2=ix2a
      iy2=iy2a
      ix3=ix3a
      iy3=iy3a
      ix4=ix4a
      iy4=iy4a
      dx=dxa
      dy=dya
      nx=nxa
      ny=nya
      COS0              = IX4  - IX1                                    XFO01360
      SIN0              = IY4  - IY1                                    XFO01370
      P41L              = COS0 * COS0  +  SIN0 * SIN0                   XFO01380
      XX                = IX2  - IX1                                    XFO01390
      YY                = IY2  - IY1                                    XFO01400
      IX                = P41L + 0.5                                    XFO01410
      IY                = XX   * XX    +  YY   * YY    +  0.5           XFO01420
C                                                                       XFO01430
      IF (IX .EQ. (IX3-IX2) * (IX3-IX2) +  (IY3-IY2) * (IY3-IY2)  .AND. XFO01440
     $    IY .EQ. (IX4-IX3) * (IX4-IX3) +  (IY4-IY3) * (IY4-IY3)    )   XFO01450
     $    GO TO 10                                                      XFO01460
C                                                                       XFO01470
      WRITE (IPR,5)                                                     XFO01480
 5    FORMAT ('0** M0401 ** ERROR DETECTED BY SUBROUTINE XFORM (ENTRY XFXFO01490
     $MI):'/                                                            XFO01500
     $ 13X,'THE COORDINATES SPECIFIED FOR THE FOUR CORNERS'/            XFO01510
     $ 13X,'OF THE SORTING GRID DOES NOT DEFINE A PARALLELOGRAM')       XFO01520
      ICC = 100                                                         XFO01530
      GO TO 20                                                          XFO01540
C                                                                       XFO01550
C-----------------------------------------------------------------------XFO01560
C     COMPUTE THE CONSTANTS TO PERFORM THE TRANSFORMATION               XFO01570
C-----------------------------------------------------------------------XFO01580
C                                                                       XFO01590
 10   P41L              = DSQRT(P41L)                                   XFO01600
      COS0              = COS0 / P41L                                   XFO01610
      SIN0              = SIN0 / P41L                                   XFO01620
C                                                                       XFO01630
      ISIGN             = 1                                             XFO01640
      IF (XX*SIN0 .GT. YY*COS0) ISIGN = -1                              XFO01650
C                                                                       XFO01660
      SCOS0             = ISIGN * COS0                                  XFO01670
      SSIN0             = ISIGN * SIN0                                  XFO01680
C                                                                       XFO01690
      X                 = YY * SIN0   +  XX * COS0                      XFO01700
      Y                 = YY * SCOS0  -  XX * SSIN0                     XFO01710
C                                                                       XFO01720
      TANPHI            = X / Y                                         XFO01730
      CPHI              =       DABS(Y)  / DSQRT(X*X  + Y*Y)            XFO01740
      DYCPHI            = DY  * CPHI                                    XFO01750
C                                                                       XFO01760
      XXT               = (COS0 + SSIN0 * TANPHI)                       XFO01770
      XYT               = (SIN0 - SCOS0 * TANPHI)                       XFO01780
      YXT               = -SSIN0        / CPHI                          XFO01790
      YYT               =  SCOS0        / CPHI                          XFO01800
C                                                                       XFO01810
      DE                = DFLOAT(IX1) * XXT + DFLOAT(IY1) * XYT         XFO01820
      DF                = DFLOAT(IX1) * YXT + DFLOAT(IY1) * YYT         XFO01830
C                                                                       XFO01840
      XX                = XXT   / DX                                    XFO01850
      XY                = XYT   / DX                                    XFO01860
      YX                =-SSIN0 / DYCPHI                                XFO01870
      YY                = SCOS0 / DYCPHI                                XFO01880
C                                                                       XFO01890
C-----------------------------------------------------------------------XFO01900
C     COMPUTE THE NUMBER OF IN-LINE CELLS & CROSS-LINE CELLS            XFO01910
C-----------------------------------------------------------------------XFO01920
C                                                                       XFO01930
      X                 = (IX4 - IX1) * XX  +  (IY4 - IY1) * XY  + 1.   XFO01940
      NX                =  X                                            XFO01950
      IF (X-NX .LT. 0.5)   NX = NX  - 1                                 XFO01960
      Y                 = (IX2 - IX1) * YX  +  (IY2 - IY1) * YY  + 1.   XFO01970
      NY                =  Y                                            XFO01980
      IF (Y-NY .LT. 0.5)   NY = NY  - 1                                 XFO01990
      nxa=nx
      nya=ny

C                                                                       XFO02000
 20   RETURN                                                            XFO02010
C                                                                       XFO02020
C***********************************************************************XFO02030
C                                                                       XFO02040
      ENTRY XFMFWD (XC  , YC  , ILI,   IDI, XT, YT,                     XFO02050
     $              XTBC, YTBC, IWARN )                                 XFO02060
C                                                                       XFO02070
      IWARN             = 0                                             XFO02080
C                                                                       XFO02090
      IXC               = XC + SIGN(0.5,XC)                             XFO02100
      IYC               = YC + SIGN(0.5,YC)                             XFO02110
C                                                                       XFO02120
      IDI               = (IXC-IX1) * XX  +  (IYC-IY1) * XY  + 0.999999 XFO02130
      ILI               = (IXC-IX1) * YX  +  (IYC-IY1) * YY  + 0.999999 XFO02140
C                                                                       XFO02150
      XT                = (IXC-IX1) * XXT +  (IYC-IY1) * XYT            XFO02160
      YT                = (IXC-IX1) * YXT +  (IYC-IY1) * YYT            XFO02170
C                                                                       XFO02180
      XTBC              = XT                                            XFO02190
      YTBC              = YT                                            XFO02200
C                                                                       XFO02210
C-----------------------------------------------------------------------XFO02220
C     SEE IF POINT IS WITHIN GRID BOUNDARIES                            XFO02230
C-----------------------------------------------------------------------XFO02240
C                                                                       XFO02250
      IF (ILI .LT. 1 .OR. ILI .GT. NY) IWARN = 1                        XFO02260
      IF (IDI .LT. 1 .OR. IDI .GT. NX) IWARN = 1                        XFO02270
C                                                                       XFO02280
      RETURN                                                            XFO02290
C                                                                       XFO02300
C***********************************************************************XFO02310
C                                                                       XFO02320
      ENTRY BINCTR (MIDX,MIDY,DXa,DYa,ILI,IDI,IBINX,IBINY,IWARN)
C                                                                       XFO02340
      IWARN = 0                                                         XFO02350
C                                                                       XFO02360
      IDI = DFLOAT(MIDX - IX1) * XX + DFLOAT(MIDY - IY1) * XY + 0.999999XFO02370
      ILI = DFLOAT(MIDX - IX1) * YX + DFLOAT(MIDY - IY1) * YY + 0.999999XFO02380
C                                                                       XFO02390
      IF (IDI .LT. 1 .OR. IDI .GT. NX) IWARN = 1                        XFO02400
      IF (ILI .LT. 1 .OR. ILI .GT. NY) IWARN = 1                        XFO02410
C                                                                       XFO02420
      E      = (DBLE(FLOAT(IDI)) - 0.5) * DXa + DE
      F      = (DBLE(FLOAT(ILI)) - 0.5) * DYa + DF
      XYYXXY = XYT * YXT - XXT * YYT                                    XFO02450
      IF (XYYXXY.NE.0) GO TO 40                                         XFO02460
      WRITE (IPR,30)                                                    XFO02470
 30   FORMAT ('0** M0402 ** ERROR DETECTED BY SUBROUTINE XFORM (ENTRY BIXFO02480
     $NCTR):'/                                                          XFO02490
     $ 13X,'ATTEMPTED TO SOLVE A PAIR OF EQUATIONS WHICH HAVE NO ',     XFO02500
     $     'UNIQUE SOLUTION')                                           XFO02510
      ICC = 100                                                         XFO02520
      GO TO 60                                                          XFO02530
C                                                                       XFO02540
 40   IBINX = (F * XYT - E * YYT) / XYYXXY                              XFO02550
      IF (XYT.NE.0.0) GO TO 50                                          XFO02560
C                                                                       XFO02570
      IBINY = (F - IBINX * YXT) / YYT                                   XFO02580
      GO TO 60                                                          XFO02590
C                                                                       XFO02600
 50   IBINY = (E - IBINX * XXT) / XYT                                   XFO02610
C                                                                       XFO02620
 60   RETURN                                                            XFO02630
C                                                                       XFO02640
C***********************************************************************XFO02650
C                                                                       XFO02660
      ENTRY ILIDI (MIDX,MIDY,ILI,IDI,IWARN)                             XFO02670
C                                                                       XFO02680
      IWARN = 0                                                         XFO02690
      IDI = DFLOAT(MIDX - IX1) * XX + DFLOAT(MIDY - IY1) * XY + 0.999999XFO02700
      ILI = DFLOAT(MIDX - IX1) * YX + DFLOAT(MIDY - IY1) * YY + 0.999999XFO02710
      IF (IDI .LT. 1 .OR. IDI .GT. NX) IWARN = 1                        XFO02720
      IF (ILI .LT. 1 .OR. ILI .GT. NY) IWARN = 1                        XFO02730
      RETURN                                                            XFO02740
C                                                                       XFO02750
C                                                                       XFO02760
C=======================================================================XFO02770
C                                                                       XFO02780
C                                                                       XFO02790
      ENTRY XFMINV(XC    , YC    , XT    , YT    ,                      XFO02800
     *             XBC   , YBC   , XTBC  , YTBC  , JERR)                XFO02810
C                                                                       XFO02820
C                                                                       XFO02830
C=======================================================================XFO02840
C                                                                       XFO02850
      JERR              = 0                                             XFO02860
C                                                                       XFO02870
      A                 = XTBC                                          XFO02880
      B                 = IX1                                           XFO02890
      C                 = IY1                                           XFO02900
      D                 = YTBC                                          XFO02910
C     E                 = XTBC + (IX1 * XXT) + (IY1 * XYT)              XFO02920
C     F                 = YTBC + (IX1 * YXT) + (IY1 * YYT)              XFO02930
      E                 = A    + (B   * XXT) + (C   * XYT)              XFO02940
      F                 = D    + (B   * YXT) + (C   * YYT)              XFO02950
C                                                                       XFO02960
      CALL SIMLEQ(XXT   , XYT   , E     ,                               XFO02970
     *            YXT   , YYT   , F     , XBC   , YBC   , JERR)         XFO02980
C                                                                       XFO02990
      A                 = XT                                            XFO03000
      D                 = YT                                            XFO03010
C     E                 = XT   + (IX1 * XXT) + (IY1 * XYT)              XFO03020
C     F                 = YT   + (IX1 * YXT) + (IY1 * XYT)              XFO03030
      E                 = A    + (B   * XXT) + (C   * XYT)              XFO03040
      F                 = D    + (B   * YXT) + (C   * YYT)              XFO03050
C                                                                       XFO03060
      CALL SIMLEQ(XXT   , XYT   , E     ,                               XFO03070
     *            YXT   , YYT   , F     , XC    , YC    , JERR)         XFO03080
C                                                                       XFO03090
C-----------------------------------------------------------------------XFO03100
C                                                                       XFO03110
C     THAT'S ALL -- RETURN TO CALLING ROUTINE                           XFO03120
C                                                                       XFO03130
C-----------------------------------------------------------------------XFO03140
C                                                                       XFO03150
      RETURN                                                            XFO03160
      END                                                               XFO03170
C***********************************************************************XFO03180
C                                                                       XFO03190
C     SUBROUTINE NAME: SIMLEQ  (SIMULTANEOUS EQUATIONS)                 XFO03200
C                                                                       XFO03210
C     LANGUAGE: FORTRAN                                                 XFO03220
C                                                                       XFO03230
C     AUTHOR: ?.?????                                                   XFO03240
C                                                                       XFO03250
C     DATE WRITTEN: ??/??/??                                            XFO03260
C                                                                       XFO03270
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                       XFO03290
C |               copyright 2001, Amoco Production Company             |
C |                           All Rights Reserved                      |
C |                   an affiliate of BP America Inc.                  |
C                                                                       XFO03310
C     ABSTRACT: GIVEN TWO LINEAR EQUATIONS IN TWO UNKNOWNS, SOLVE       XFO03320
C               FOR THE TWO UNKNOWNS SIMULTANEOUSLY.                    XFO03330
C                                                                       XFO03340
C                               AX + BY = E                             XFO03350
C                               CX + DY = F                             XFO03360
C                                                                       XFO03370
C     CALLING SEQUENCE: CALL SIMLEQ(A , B , E , C , D , F , X , Y)      XFO03380
C                                                                       XFO03390
C                WHERE: A - COEFFICIENT OF FIRST  UNKNOWN IN FIRST  EQ. XFO03400
C                       B - COEFFICIENT OF SECOND UNKNOWN IN FIRST  EQ. XFO03410
C                       E - CONSTANT TERM OF FIRST  EQ.                 XFO03420
C                       C - COEFFICIENT OF FIRST  UNKNOWN IN SECOND EQ. XFO03430
C                       D - COEFFICIENT OF SECOND UNKNOWN IN SECOND EQ. XFO03440
C                       F - CONSTANT TERM OF SECOND EQ.                 XFO03450
C                       X - FIRST  UNKNOWN                              XFO03460
C                       Y - SECOND UNKNOWN                              XFO03470
C                    IERR - ERROR FLAG                                  XFO03480
C                              0 = NO ERRORS                            XFO03490
C                              1 = ERROR DETECTED - MATRIX IS SINGULAR  XFO03500
C                                                                       XFO03510
C     MODIFICATION HISTORY: ??/??/??  -  INITIAL RELEASE                XFO03520
C                                                                       XFO03530
C***********************************************************************XFO03540
C                                                                       XFO03550
C                                                                       XFO03560
      SUBROUTINE SIMLEQ(A, B, E, C, D, F, X, Y, IERR)                   XFO03570
C                                                                       XFO03580
C                                                                       XFO03590
C-----------------------------------------------------------------------XFO03600
C                                                                       XFO03610
C     DECLARATIONS, DEFINITIONS, & INITIALIZATIONS                      XFO03620
C                                                                       XFO03630
C-----------------------------------------------------------------------XFO03640
C                                                                       XFO03650
      REAL*8    A     , B     , C     , D     , E     , F               XFO03660
      REAL*8    XX    , YY                                              XFO03670
C                                                                       XFO03680
      REAL*4    X     , Y                                               XFO03690
C                                                                       XFO03700
      IERR              = 0                                             XFO03710
C                                                                       XFO03720
C-----------------------------------------------------------------------XFO03730
C                                                                       XFO03740
C     SEE IF MATRIX IS SINGULAR                                         XFO03750
C                                                                       XFO03760
C-----------------------------------------------------------------------XFO03770
C                                                                       XFO03780
      IF((A*D) .NE. (B*C)) GO TO 100                                    XFO03790
      IERR              = 1                                             XFO03800
      GO TO 200                                                         XFO03810
C                                                                       XFO03820
C-----------------------------------------------------------------------XFO03830
C                                                                       XFO03840
C     COMPUTE X & Y                                                     XFO03850
C                                                                       XFO03860
C-----------------------------------------------------------------------XFO03870
C                                                                       XFO03880
  100 XX                = ((B*F) -  (D*E)) / ((B*C) - (A*D))            XFO03890
C                                                                       XFO03900
      IF(B .EQ. 0.0D0)      GO TO 150                                   XFO03910
      YY                =  (E    - (A*XX)) /   B                        XFO03920
      GO TO 160                                                         XFO03930
C                                                                       XFO03940
  150 YY                =  (F    - (C*XX)) /   D                        XFO03950
C                                                                       XFO03960
  160 X                 = XX                                            XFO03970
      Y                 = YY                                            XFO03980
C                                                                       XFO03990
C-----------------------------------------------------------------------XFO04000
C                                                                       XFO04010
C     THAT'S ALL -- RETURN TO CALLING ROUTINE                           XFO04020
C                                                                       XFO04030
C-----------------------------------------------------------------------XFO04040
C                                                                       XFO04050
  200 RETURN                                                            XFO04060
      END                                                               XFO04070
