C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      program LSQR                                 
c_______________________________________________________________________
c     Least Square Minimization using conjugate gradient algorithm.        
c
C***********************************************************************
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
#include <f77/sisdef.h>
#include <fdds.h>
c
#ifdef CRAYSYSTEM
      parameter (maxchar=200)
#else
      parameter (maxchar=32)
#endif
c___________________________________________________________________
c     pointer structure for dynamic memory allocation for 
c     major memory array s(lens)
c___________________________________________________________________
      parameter (maxp=64)       
      integer   argis
C
      dimension cputim(30) , waltim(30), ops(30)
C
      integer   stdin,stdout,stderr
C
      integer   niter
      real      decrease,weight
C
      logical   query
      logical   verbose
C
      character*6  name
      character*256 file_data,cmdforward,cmdbackward,file_prior
      character*256 subdir,olddir
c
C
      data      lugeom/62/,luzeta/63/,lucoord/64/
c____________________________________________________________________
c     include an audit/usage trail.
c____________________________________________________________________
      character*6 ppname
      data ppname/'lsqr'/
      character*4 version
      data version/'21.2'/
c$$$$#include <f77/audit.h>

      stdin  = LIN
      stdout = LOT
      stderr = LER

#ifdef RICE_DISTRIBUTION
c____________________________________________________________________
c     Call the protection software to make sure we are a valid user.
c____________________________________________________________________
      call prochk
#endif

c
c_______________________________________________________________________
c     read total number of nodes and current node number from command line.
c_______________________________________________________________________
c 
      name='LSQR'
c_______________________________________________________________________
c     get online help if necessary
c_______________________________________________________________________
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
         call help()
         call exitfu(0)
      endif
      call timstr(vtot,wtot)
      call vclr(cputim,1,30)
      call vclr(waltim,1,30)
      call vclr(ops,1,30)
c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>

c_______________________________________________________________________
C     read in command line arguements   
c_______________________________________________________________________
      call cmdlin(file_data,cmdforward,cmdbackward,file_prior,verbose,
     1            stderr,lerr)
c
c_______________________________________________________________________
C     override input data parameters by command line arguements.
c_______________________________________________________________________
      call rdparm(lerr,decrease,niter,subdir,olddir,weight)
c
      call timend(cputim(19),vtot,v2,waltim(19),wtot,w2)

C_______________________________________________________________________
C      call mainsub
C_______________________________________________________________________
       call mainsub(niter,decrease,weight,lerr,ler,file_data,cmdforward,
     1              cmdbackward,file_prior,subdir,olddir,verbose)
c
c
c
      do 87000 k=1,30
       ops(k)=1.e-6*ops(k)
87000 continue

      call timend(cputim(20),vtot,v2,waltim(20),wtot,w2)
      write(lerr,'(A30,3A15,/)') 'routine','cpu time','wall time',
     1                 'megaops'
      write(lerr,'(A30,3f15.3)')
     6         'total',cputim(20),waltim(20),ops(20)
c
      write(lerr,*)'Normal completion of LSQR'
      write(stderr,*)'Normal completion of LSQR'
C
      close(lerr)
      call exitfu(0)
90005 write(lerr,*) 'geometry file missing or unreadable'
      call exit(666)
      end


      subroutine  help
#include <f77/iounit.h>
c-----------------------------------------------------------------------
      write(ler,*)' '
      write(ler,*)'Command Line Arguments for lsqr:....................'
     1            //'...................'
      write(ler,*)'----------------------------------------------------'
     1            //'-------------------'
      write(ler,*)'LEAST SQUARE MINIMIZATION OF J(m) = J1 + J2'
      write(ler,*)'where J1 = || Fm - d ||**2' 
      write(ler,*)'      J2 = || m - m0 ||**2' 
      write(ler,*)'      m0 the a priori model'
      write(ler,*)'      F the forward modeling operator'
      write(ler,*)' '
      write(ler,*)'Input/output files:.................................'
     1            //'...................'
      write(ler,*)'----------------------------------------------------'
     1            //'-------------------'
      write(ler,*)'-N                       : Input data to be inverted'
     1            //' (no default)'
      write(ler,*)'-P                       : A priori model'
      write(ler,*)' '
      write(ler,*)'Input parameters:...................................'
     1            //'...................'
      write(ler,*)'----------------------------------------------------'
     1            //'-------------------'
      write(ler,*)'-iter                   -- number of iterations (4)'
      write(ler,*)'-decrease               -- stop minimization if obj'
     1            //'ective function beco'
      write(ler,*)'                           mes smaller than decrease'
     1            //'*norm of the data'
      write(ler,*)'                           (0.01)'
      write(ler,*)'-weight                 -- normalized weight of the '
     1            //'second term of the'
      write(ler,*)'                           objective function (0.05)'
      write(ler,*)'-sub                    -- subdirectory name where w'
     1            //'e write the'
      write(ler,*)'                           output files (result.idpr'
     1            //'ocess)'
      write(ler,*)'-prevsub                -- subdirectory name of resu'
     1            //'lts of a previous'
      write(ler,*)'                           minimization from which t'
     1            //'his minimization'
      write(ler,*)'                           will restart ('' '')'
      write(ler,*)'-FORWARD                -- write between quote, the '
     1            //'command line argu'
      write(ler,*)'                           ments (except -N and -O) '
     1            //'used for forward'
      write(ler,*)'                           modeling program (no defa'
     1            //'ult)'
      write(ler,*)'-BACKWARD               -- write between quote, the '
     1            //'command line argu'
      write(ler,*)'                           ments (except -N and -O) '
     1            //'used for backward'
      write(ler,*)'                           modeling program (no defa'
     1            //'ult)'
      write(ler,*)'-V                      -- if present, write verbose'
     1            //' printout'
      write(ler,*)' '
      write(ler,*)'Usage:..............................................'
     1            //'...................'
      write(ler,*)'----------------------------------------------------'
     1            //'-------------------'
      write(ler,*)'lsqr -N[] -P[] -iter[] -weight[] -decrease[] -sub[] '
     1            //'-prevsub[]'
      write(ler,*)'     -FORWARD[] -BACKWARD[] [-V]'
      write(ler,*)' '
      write(ler,*)'Example:............................................'
     1            //'...................'
      write(ler,*)'----------------------------------------------------'
     1            //'-------------------'
      write(ler,*)'lsqr -Ncrp -V -iter5 -weight0. -subresult1 -FORWARD"'
     1            //'radgamma -gammamin'
      write(ler,*)'     0.4 -gammamax3 -hmin-14000 -hmax-1520 -zmin1000'
     1            //' -zmax15000 -dh80'
      write(ler,*)'     -R -M200 -V" -BACKWARD"radgamma -gammamin0.4 -g'
     1            //'ammamax3.'
      write(ler,*)'     -hmin-14000 -hmax-1520 -zmin1000 -zmax15000 -nc'
     1            //'urve300 -M200 -V"'
      write(ler,*)' '
c-----------------------------------------------------------------------

      return
      end
