C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C      AUTHOR:  N. D. Whitmore, Jr.
C      REVISED: M. A. Thornton 9/20/91 moved code to sun
C      REVISED: M. A. Thornton 12/19/91 added subroutine rmemangs.c
C               which Dean Kopesky wrote so memangs would run on
C               the Cray2 when requested on XMP - code too large to
C               run on XMP.
C      REVISED: M. A. Thornton    V: 2.2    March 25, 1992         
C               Call openpr with full program name for OS 6.1
C      REVISED: M. A. Thornton    V: 3.0    October 14, 1992     
C               Changed code to allow program to use direct access
C               scratch files if there is not enough memory 
C               available (machnes other than crays will be limited 
C               to 4MW)
C      REVISED: M. A. Thornton    V: 4.0    April 7, 1993        
C               Changed code to make use of Dean Kopesky's (MSC) new
C               rmemangs.c subroutine.  This was changed because the sc
C               and sf machines now share file systems.  Also added 
C               logical unit for HP and changed length on line header (SZLNHD)
C      REVISED: M. A. Thornton    V: 4.1    August 10, 1993      
C               Changed code to make use of Dean Kopesky's (MSC) rmemangs.c
C               when on the crayc90.  Thea Leishman found that when running
C               this on the c90 and it needed more than the available 256Mgwords
C               it cost nearly 5 times as much to run on the c90 as on the cray2
C               so, when this code is executed on the c90 or on the xmp,
C               it will run on the cray2 instead.
C
C      MEMANGS does a constant angle sort of the data.
C
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

       parameter (LENTRC=2177, MAXSMP=2500)
       parameter (LUVEL=28,LPRT=26,llist=27)

       real buffer(1)
       pointer (pbuffer, buffer)

       real trc(LENTRC), trcd(MAXSMP)
       integer i, j, m, n, nrec, ntrc, nsamp, skip
       integer nnrec, nntrc
       integer lnhd(SZLNHD), nbytes
       integer*2 trchd(LNTRHD)
       integer si, jerr, verbos, argis, dalu
       integer stdout, solu, luin, len, nlin
       integer ierr, lid, offset(2)
       character *128 ntap, sotap
       character*1 parr(66)
       character*4 version
       character*7 ppname
       logical help,memory


       equivalence( trc(1), trchd(1) )
       equivalence( trc(ITHWP1), trcd(1) )

       data parr/6*' ','M','E','M','A',
     1'A','N','G','S',' ','S','O','R','T',' ',' ',' ',
     2' ',' ',' ',' ',' ',' ',' ',37*' '/


       data version/' 4.1'/
       data ppname/'MEMANGS'/

#ifdef CRAYXEA
       CALL RMEMANGS
#endif
#ifdef CRAYC90
       CALL RMEMANGS
#endif

       stdout = 0
       dalu = 13
       n = 1
       m = 0
       verbos = -1

C Print help is asked to

       help  = (argis( '-h' ).gt.0) 
       if (help) then
           write(stdout,*)' '
           write(stdout,*)'COMMAND LINE ARGUMENTS FOR MEMANGS'
           write(stdout,*)' '
           write(stdout,*)'INPUT'
           write(stdout,*)'-N[ntap]          .. INPUT DATASET NAME'
           write(stdout,*)'-O[sotap]         .. SORTED OUTPUT '
           write(stdout,*)'-V                .. VERBOS PRINTOUT'
           write(stdout,*)' '
           write(stdout,*)'USAGE:'
           write(stdout,*)'memangs -N[] -O[] -V'
           stop
        endif

C Get command line arguments

       call argstr('-N', ntap, ' ', ' ')
       call argstr('-O', sotap, ' ', ' ')
       skip = 1
       verbos = argis( '-V' )

C Check to see if input is piped

       if (ntap.eq.' ') then
           luin = 0                   
       else
           call lbopen(luin, ntap, 'r')
       endif

C Check to see if output files were specified

       if (sotap.eq.' ') then
           write(stdout,*)'no sorted output file specified, exiting.'
           write(stdout,*)'output cannot be a pipe.'
           call lbclos(luin)
           stop
       else
           call lbopen(solu, sotap, 'w')
       endif

C Open the printout file

       call openpr(llist, lprt, ppname, jerr)
       if (jerr.ne.0) then
           write(stdout, *) 'Error opening printout'
           write(lprt, *) 'Error opening printout'
           stop 200
       endif
#include <mbsdate.h>
       nlin = 1
       call gamoco(parr, nlin, lprt)
       write(lprt,5) ntap
    5  format('  INPUT DATA = ',/,a128,/)
       write(lprt,6) sotap
    6  format('  SORTED OUTPUT =',/,a128,/)
c
c Find an available unit number for the variable lid.
c Stop if no available unit number can be found
c
       lid = 0 
       i = 98
  17   if ( i .le. 7 ) then
          write(0,*) 'Too many open files, stop program.'
          stop
       endif
       inquire( unit=i, opened=help )
       if ( .not. help ) then
          lid = i
          goto 18
       endif
       i = i - 1
       goto 17
  18   continue

C Read in line header and get important values

       nbytes = 0
       call rtape(luin, lnhd, nbytes)
       if (nbytes.eq.0) then
           write(stdout,*)'could not read input line header, exiting.'
           write(lprt,7)
   7       format(1x,'BAD READ ON INPUT LINEHEADER',/,1x,'  END OF JOB')
           goto 1000
       endif
       call saver(lnhd, 'NumRec', nrec, LINHED)
       call saver(lnhd, 'NumTrc', ntrc, LINHED)
       call saver(lnhd, 'NumSmp', nsamp, LINHED)
       call saver(lnhd, 'SmpInt', si, LINHED)

       len = 7
       call hlhprt(lnhd, nbytes, ppname, len, lprt)


C Change line header to show changes for the sorted output

       nnrec = ntrc
       call savew(lnhd, 'NumRec', ntrc, LINHED)
       nntrc = nrec
       call savew(lnhd, 'NumTrc', nrec, LINHED)
       call wrtape(solu, lnhd, nbytes)
       if (verbos.gt.0) then
           write(lprt,*)'sorted output data'
           write(lprt,*)'# rec = ', nnrec   
           write(lprt,*)'# trc = ', nntrc   
           write(lprt,*)'# samp = ', nsamp
           write(lprt,*)'samp interval = ', si
           write(lprt,*)'    '
       endif

C Start looping to read in input data and process it as we go

       do 100 i=1,nrec,1
           m = 0
           do 80 j=1,ntrc,1

C Read in trace

               nbytes = 0
               call rtape(luin, trc, nbytes)
               if (nbytes.eq.0) then
                   write(stdout,*)'error reading trc ',j
                   write(stdout,*)'   of rec ',i,'   exiting'
                   goto 1000
               endif
               if (i.eq.1.and.j.eq.1) then
		  inbuf  = nbytes/ISZBYT + mod( (nbytes/ISZBYT)+1, 2 )
		  lbuffer= nnrec*nntrc*inbuf
c       sun: 1 mw; 
#ifdef CRAYSYSTEM
        ibuf = lbuffer*ISZBYT
#else
        ibuf = 4000000
#endif
                  if((lbuffer*ISZBYT).le.ibuf)then
		    call galloc( pbuffer, lbuffer*ISZBYT, jerr, iabort)
                    if(jerr.ne.0 .or. iabort.ne.0)then
                       write(lprt,*)'Error allocating memory: ', jerr
                       write(lprt,*)'Program will use scratch files'
                       memory = .false.
                    else
                       memory = .true.
                       write(lprt,*)'Program will sort in memory'
                    endif
                  else
                    memory = .false.
                    write(lprt,*)'Not enough memory'
                    write(lprt,*)'Program will use scratch files'
                  endif

                  if(.not.memory)then
                    open( unit=lid,status='scratch',access='direct',
     &              form='unformatted', recl=nbytes, iostat=ierr)
                    if (ierr.ne.0) then
                       write(lprt,*)'Could not open scratch file.'
                       goto 1000
                    endif
                  endif
               endif

               if (MOD(j-1, skip).eq.0) then
                 offset(1) = i + (m*nntrc)
                 if(memory)then
                   index = (offset(1) - 1)*inbuf + 1
                   call vmov( trc, 1, buffer(index), 1, nbytes/ISZBYT)
                 else
                   write(lid,rec=offset(1))
     &             (trc(iix), iix=1,nbytes/ISZBYT)
                 endif
                 m = m + 1
               endif
   80      continue
  100  continue



C     write it out with wrtape to a sorted sis file

       do 160 i=1,nnrec,1
           do 140 j=1,nntrc,1

             offset(1) = j + (nntrc*(i-1))
             if(memory)then
               index = (offset(1) - 1)*inbuf + 1
	       call vmov( buffer(index), 1, trc, 1, nbytes/ISZBYT )
             else
               read(lid, rec=offset(1))
     &         (trc(iix),iix=1,nbytes/ISZBYT)
             endif

               call savew(trchd, 'TrcNum', j, TRCHED)
               call savew(trchd, 'RecNum', i, TRCHED)
               call wrtape(solu, trc, nbytes)
  140      continue
  160  continue
               
C Close files and exit

 1000  write(lprt, 1010)
 1010  format(1x,'  END OF JOB')
       call lbclos(luin)
       call lbclos(solu)
       if(memory)then
         go to 5000
       else
         close(lid)
       endif

 5000  stop
       end
