C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ZMATRX(LUMXC,LPRT,DX,DZ,STARTX,NTBLK,ZBEGIN,ZEND,FH
     1,CON,INDREC,V,VEL,NZMAX,NXMAX,A,B,C,D,MSTS,VMULT)
#include <f77/hp.h>

C     THIS SUBROUTINE GENERATES A MATRIX OF VELOCITY INDICES
C     FH needs to be dimensioned (no. contours + 2) by nxmax
C
      DIMENSION A(*),B(*),C(*),D(*),VMULT(*)
      DIMENSION FH(502,NXMAX)
      DIMENSION SAVK(500,3004)
      DIMENSION TABX(500,3004),TABY(500,3004)
      INTEGER  CON(*),INDREC(*)
      REAL     V(NZMAX,NXMAX),VEL(*)
      INTEGER LC(500)
      INTEGER*4 NPC(500)
      REAL LF,RT,TP,BT
      INTEGER*4 TYP
      DIMENSION ZMIN(500),ZMAX(500),ICLIST(500)
      DIMENSION ZMINC(500),ZMAXC(500),ICCLST(500)
      DATA SAVE/1.0/
C*
C*  EXECUTION BEGINS
C*
C
C    CALCULATE THE BEGINNING AND ENDING X AND Z
C
      MAXCONT = 500
      MAXPNTS = 8000
      IZCNT=0
      NXPAD=0
      XBEGIN=STARTX
      IF(STARTX.LT.0) THEN
      XBEGIN=0.0
      NXPAD=-STARTX/DX
      ENDIF
      XEND=(NTBLK-1)*DX+STARTX
C
C     READ HEADER RECORD OF DIGITIZED POINTS
C
C*    REWIND LUMXC (DIGITIZED INPUT FILE) SO THAT IT CAN
C*    BE READ EACH TIME THIS ROUTINE IS CALLED --
      REWIND(LUMXC)
      READ(LUMXC,2000) TYP,NH,LF,RT,TP,BT,NC,IDIRT
 2000 FORMAT(4X,2I5,4F10.3,I5,8X,10X,2X,I1)
C
C     CALCULATE TABLE WIDTH AND DEPTH
C
      JMAX=(XEND-STARTX)/DX+1.01
      JMAXT=JMAX
      IF(JMAX.GT.MAXPNTS)THEN
         WRITE(LPRT,6000)JMAX
 6000    FORMAT(2X,I5,' EXCEEDS LIMIT OF 8000 POINTS PER SEGMENT')
         STOP
      ENDIF
      ZSTART = .005*(BT-TP)
      XSTART = .005*(RT-LF)
      XLIM = RT - XSTART
      ZLIM = BT - ZSTART
      NXPAD1=0
      IF(XEND.GT.RT) THEN
         WRITE(LPRT,6001) XEND,RT
 6001    FORMAT(1X,'COMPUTED XMAX',F8.1,' GT ACTUAL',F8.1)
         JMAXT=JMAX
         JMAX=(RT-STARTX)/DX+1.01
         NXPAD1=JMAXT-JMAX
      ELSE IF (ZEND.GT.BT) THEN
         WRITE(LPRT,6002) ZEND,BT
 6002    FORMAT(1X,'COMPUTED DEPTH',F8.1,' GT ACTUAL',F8.1)
      ENDIF
C
      IMAX=(BT-TP)/DZ+.5
CCMAT IMAX1=(ZEND-ZBEGIN-1.)/DZ+.5 zend passed in as the bottom
      IMAX1=(ZEND-ZBEGIN)/DZ+.5
      NZ=NH+NC
      IF(NZ .GT. MAXCONT) THEN
         WRITE(LPRT,6003) MAXCONT,NZ
         WRITE(ler,6003) MAXCONT,NZ
 6003    FORMAT(' LIMIT ON CONTOURS IS ',I5,';  NO. INPUT WAS ',I5)
         STOP 100
      ENDIF
C*
C*    READ DIGITIZED POINTS
C*
C*    the 102 loop goes from 1 to (no.pts/contour+4+3) in steps of 4
      MAXPP4 = MAXPNTS + 4
      DO 101 K=1,NZ
        YTE=0.
        DO 102 NSTR=1,MAXPP4,4
          IF(YTE.LT.0.) GO TO 103
          NSTR3=NSTR+3
          READ(LUMXC,2001)(TABX(K,J),TABY(K,J),J=NSTR,NSTR3)
          YTE=TABX(K,NSTR)
          IF(NSTR3.GE.MAXPP4 .AND. YTE.GT.0.) THEN
             WRITE(LPRT,6004)MAXPNTS,K
             WRITE(ler,6004)MAXPNTS,K
 6004        FORMAT(' LIMIT ON POINTS PER CONTOUR IS ',I5,
     1              '; LIMIT EXCEEDED ON CONTOUR NO. ',I3)
             STOP 100
          ENDIF
          NSTP=NSTR+4
  102   CONTINUE
  103   CONTINUE
C*
C*      CHECK FOR STRICT INEQUALITY
C*
        DO 104 J=1,NSTP
          IF(J.EQ.1) GO TO 125
          IF(TABX(K,J).LT.0.000001.AND.TABY(K,J).LT.0.000001) GO TO 105
  125     NPC(K)=J
  104   CONTINUE
  105   CONTINUE
        IF(NPC(K).GT.MINP) MINP=NPC(K)
  101 CONTINUE
 2001 FORMAT(F8.2,7F10.2)
      NP=MINP+1
      DO 106 I=1,NZ
      NPCI=NPC(I)
       DO 107 J=1,NPCI
       IF(TABX(I,J).GT.XLIM) TABX(I,J)=RT
       IF(TABX(I,J).LT.XSTART) TABX(I,J)=0.0
       IF(TABY(I,J).GT.ZLIM) TABY(I,J)=BT
       IF(TABY(I,J).LT.ZSTART) TABY(I,J)=0.0
  107 CONTINUE
      IF(I.LE.NH) GO TO 106
      IF(TABX(I,NPCI).EQ.TABX(I,1) .AND.
     1TABY(I,NPCI).EQ.TABY(I,1)) GO TO 106
      NPCI =NPCI+1
      NPC(I) = NPCI
      TABX(I,NPCI) = TABX(I,1)
      TABY(I,NPCI) = TABY(I,1)
  106 CONTINUE
C*
C*
C*  CALCULATE DISTANCE BETWEEN GRID POINTS IN Z DIRECTION (VERTICAL)
C*
C*
C*  PERTURB EXACT POINTS ON GRID LINE
C*
      Z=TP-DZ
      DO 201 K=1,IMAX
      Z=Z+DZ
       DO 202 I=1,NZ
       NPCI=NPC(I)
       DO 202 J=1,NPCI
       IF(TABY(I,J).EQ.Z) TABY(I,J)=TABY(I,J)*1.00001
  202 CONTINUE
  201 CONTINUE
      IER=0
C
C     INITIALIZE ALL INDICES TO '1'
C
      DO 257 JJ=1,JMAX
  257 CON(JJ)=1
C*
C*  CALCULATE DISTANCE BETWEEN GRID POINTS IN X DIRECTION (HORIZONTAL)
C*
      NH2=NH+2
      NH21=NH2-1
      NH1=NH+1
C*
C*  GENERATE TOP AND BOTTOM OF MODEL
C*
      DO 401 J=1,JMAX
      FH(1,J)=ZBEGIN
      FH(NH2,J)=ZEND
  401 CONTINUE
      IF (NH.LE.0)  GO TO 701
      DO 700 I=1,NH
C*
C*  GENERATE LINES FOR 2 POINT HORIZONTAL CONTOURS
C*
C*   IF------
      IF(NPC(I).NE.2.OR.TABY(I,1).NE.TABY(I,2)) GO TO 501
      X=XBEGIN-DX+.01
       DO 502 J=1,JMAX
       X=X+DX
       IF(X.GE.TABX(I,1).AND.X.LE.TABX(I,2))
     1 FH(I+1,J)=TABY(I,1)
  502 CONTINUE
      GO TO 700
  501 CONTINUE
C*
C*  GENERATES LINES FOR HORIZONTAL CONTOURS
C*
      X=XBEGIN-DX+.01
       DO 601 J=1,JMAX
       FH(I+1,J)=0.
       X=X+DX
       NPCI1=NPC(I)-1
        DO 602 K=1,NPCI1
C*    IF------
        IF(X.LT.TABX(I,K).OR.X.GT.TABX(I,K+1)) GO TO 602
        SLOPE=(TABY(I,K)-TABY(I,K+1))/(TABX(I,K)-TABX(I,K+1))
        FH(I+1,J)=SLOPE*(X-TABX(I,K))+TABY(I,K)
  602 CONTINUE
  601 CONTINUE
  700 CONTINUE
  701 CONTINUE
C
C     FIND ZMIN,ZMAX PER CONTOUR (TO MINIMIZE INDX SEARCH ZONE)
C
      DO 7000 L=1,NH2
      ZMIN(L)=ZBEGIN
      ZMAX(L)=DZ
      DO 7000 J=1,JMAX
      IF(FH(L,J).GT.ZMAX(L))ZMAX(L)=FH(L,J)
      IF(FH(L,J).LT.ZMIN(L))ZMIN(L)=FH(L,J)
 7000 CONTINUE
C
C*
C*  NO CLOSED CONTOURS SECTION
C*
C*    IF ---NC EQ 0 DO BLOCK IL1
      IF(NC.NE.0) GO TO 800
C* IL1:
C*   BEGIN;
C     STARTING Z AND INDX:
      Z=ZBEGIN-DZ
C*******************************************************************
C*  BLOCK  L1:
C*******************************************************************
C5/5 CHANGE LOOP FROM IMAX1 TO IMAX
      DO 801 I=1,IMAX
      Z=Z+DZ
      IZCNT=IZCNT+1
      IF(Z.GT.BT) GO TO 884
      X=XBEGIN-DX+.01
C
C     DETERMINE POTENTIAL CONTOUR NO.'S TO CHECK FOR THIS Z (DEPTH)
C
      KOUNT=0
      DO 7010 L=1,NH21
      IF(Z.LT.ZMIN(L) .OR. Z.GT.ZMAX(L+1))GO TO 7010
      KOUNT=KOUNT+1
      ICLIST(KOUNT)=L
      ICLIST(KOUNT+1)=L+1
 7010 CONTINUE
C
       DO 802 J=1,JMAX
       X=X+DX
        DO 803 L=1,KOUNT
        IF(Z.GT.FH(ICLIST(L),J).AND.FH(ICLIST(L+1),J).GE.Z)
     1  CON(J)=ICLIST(L)
  803 CONTINUE
  802 CONTINUE
      CON(JMAX)=CON(JMAX-1)
C     NEGATIVE X PAD
      IF(NXPAD.GT.0) THEN
       DO 881 M=1,NXPAD
  881  INDREC(M)=CON(1)
      ENDIF
       DO 882 M=1,JMAX-NXPAD
  882  INDREC(M+NXPAD)=CON(M)
       INDREC(JMAX)=INDREC(JMAX-1)
C     POSITIVE X PAD
      IF(NXPAD1.GT.0) THEN
       DO 883 M=JMAX,JMAXT
  883  INDREC(M)=INDREC(JMAX)
      ENDIF

  884 CONTINUE
      DO 1883 M=1,JMAXT
         IF(MSTS.GT.0)THEN
          MM = INDREC(M) - 1
         ELSE
          MM = INDREC(M)
         ENDIF
            V(IZCNT,M) = (1.0 - VMULT(MM)) *
     1                 ( A(MM) * (M-1) * DX +
     2                   B(MM) * (IZCNT-1) * DZ +
     3                   C(MM) )
     4                 + VMULT(MM)*V(IZCNT,M)
 1883 CONTINUE

  801 CONTINUE
C********************************************************************
C* END BLOCK L1;
C********************************************************************
C* END BLOCK IL1;
      GO TO 1000
C*
C*  CLOSED CONTOUR SECTION
C*
C*  (ELSE) IF NC NE 0 DO BLOCK N1
  800 CONTINUE
C*  BEGIN BLOCK N1:
C*
C*
C*  SET UP ARRAY TO SAVE CONTOUR CROSSINGS
C*
C*     ALLOCATE SAVK(NC,MINC);
C*
      Z=ZBEGIN-DZ
CMAT  FIND ZMINC AND ZMAXC FOR EACH CLOSED CONTOUR
C
      IC=0
      DO 8000 K=NH1,NZ
      IC=IC+1
      ZMINC(IC)=ZEND
      ZMAXC(IC)=DZ
      NPCK1=NPC(K)-1
      DO 8000 L=1,NPCK1
      IF(TABY(K,L).GT.ZMAXC(IC)) ZMAXC(IC)=TABY(K,L)
      IF(TABY(K,L).LT.ZMINC(IC)) ZMINC(IC)=TABY(K,L)
 8000 CONTINUE
C
C*
C*  FIND IF GRID ROW I CROSSES CONTOUR K IF IT DOES SAVE CROSSING
C*  VALUE */
C*
      DO 902 I=1,IMAX
      Z=Z+DZ
      IZCNT=IZCNT+1
      IF(Z.GT.BT) GO TO 984
CMAT  FIND THE POTENTIAL CONTOURS FOR THIS GRID ROW DEPTH
C
      KOUNTC=0
      DO 8022 L=1,NC
      IF(Z.LT.ZMINC(L) .OR. Z.GT.ZMAXC(L))GO TO 8022
      KOUNTC=KOUNTC+1
      ICCLST(KOUNTC)=L
 8022 CONTINUE
C*L1A:
       DO 903 KK=1,KOUNTC
       KMNH=ICCLST(KK)
       K=KMNH+NH
       LC(KMNH)=0
       NPCK1=NPC(K)-1
        DO 904 L=1,NPCK1
        IF(TABY(K,L).EQ.TABY(K,L+1)) GO TO 904
        IF(TABY(K,L).LE.Z.AND.TABY(K,L+1).GE.Z) GO TO 905
        IF(TABY(K,L).GE.Z.AND.TABY(K,L+1).LE.Z) GO TO 905
        GO TO 904
  905 CONTINUE
        LC(KMNH)=LC(KMNH)+1
        LCKMNH=LC(KMNH)
        SAVK(KMNH,LCKMNH)=((TABX(K,L)-TABX(K,L+1))/
     1  (TABY(K,L)-TABY(K,L+1)))*(Z-TABY(K,L+1))+TABX(K,L+1)
  904 CONTINUE
  903 CONTINUE
C*
C*  SCAN HORIZONTAL CONTOURS TO FILL ROW I WITH INDX DERIVED FROM
C* HORIZONTAL CONTOURS   */
C*
      X=XBEGIN-DX+.01
CMAT  DETERMINE POTENTIAL CONTOUR NO.'S TO CHECK FOR THIS Z (DEPTH)
C
      KOUNT=0
      DO 7020 L=1,NH21
      IF(Z.LT.ZMIN(L) .OR. Z.GT.ZMAX(L+1)) GO TO 7020
      KOUNT=KOUNT+1
      ICLIST(KOUNT)=L
      ICLIST(KOUNT+1)=L+1
 7020 CONTINUE
CMATEND
       DO 906 J=1,JMAX
       SAV=1.
       CON(J)=1.
       X=X+DX
        DO 907 L=1,KOUNT
        IF(Z.GT.FH(ICLIST(L),J).AND.FH(ICLIST(L+1),J).GE.Z)
     1  CON(J)=ICLIST(L)
  907 CONTINUE
C*
C*  SCAN CLOSED CONTOURS TO REPLACE ELEMENTS OF ROW I WITH CLOSED
C*  CONTOUR INDX NH+1 IF ELEMENT J IS WITHIN CLOSED CONTOUR K
C*
C**   L7:
CMAT  CHECK THE CONTOURS IN REVERSE ORDER, AND QUIT CHECKING
CMAT  CONTOURS WHEN ONE IS FOUND
      DO 908 KK=KOUNTC,1,-1
        K=ICCLST(KK)
        IF(ABS(SAV).LE.0.0000001) GO TO 909
        IF(LC(K).EQ.0) GO TO 910
        LCK=LC(K)
        DO 911 LC1=1,LCK
           IF(ABS(SAV).LE.0.00001)GO TO 912
           SAV=(SAVK(K,LC1)-X)*SAV
           IF(ABS(SAV).LT.(DX/5.)) SAV=0
           IF(ABS(SAV).GT.0.00001) SAV=SAV/ABS(SAV)
  911   CONTINUE
  912 CONTINUE
         IF(SAV.LE.0.0) THEN
            CON(J)=NH+1+K
            GO TO 909
         ENDIF
  910 CONTINUE
         SAV=1.0
  908 CONTINUE
  909 CONTINUE
  906 CONTINUE
      CON(JMAX)=CON(JMAX-1)
C     NEGATIVE X PAD
      IF(NXPAD.GT.0) THEN
       DO 981 M=1,NXPAD
  981  INDREC(M)=CON(1)
      ENDIF
      DO 982 M=1,JMAX-NXPAD
  982 INDREC(M+NXPAD)=CON(M)
      INDREC(JMAX)=INDREC(JMAX-1)
C     POSITIVE X PAD
      IF(NXPAD1.GT.0) THEN
       DO 983 M=JMAX,JMAXT
  983  INDREC(M)=INDREC(JMAX)
      ENDIF

  984 CONTINUE
      DO 1983 M=1,JMAXT
         IF(MSTS.GT.0)THEN
          MM = INDREC(M) - 1
         ELSE
          MM = INDREC(M)
         ENDIF
            V(IZCNT,M) = (1.0 - VMULT(MM)) *
     1                 ( A(MM) * (M-1) * DX +
     2                   B(MM) * (IZCNT-1) * DZ +
     3                   C(MM) )
     4                 + VMULT(MM)*V(IZCNT,M)
 1983 CONTINUE

  902 CONTINUE
C
C******************************************************************

 1000 CONTINUE

C     PAD OUT INDICES ADD
      IZPAD = IMAX1 - IMAX
      IF(IZPAD.LE.0) IZPAD = 0

      DO 950 N = 1,IZPAD
       IZCNT = IZCNT+1

       DO 1950 M=1,JMAXT
1950   V(IZCNT,M) = VEL(INDREC(M))
 950   CONTINUE


      RETURN
      END
