/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "nlx2lx.h"

void ComputeWarpTransform(source,warptran,min,max,nsamp,inntr,outntr)
float *source,*warptran;
float *min,*max;
int *inntr,*nsamp,*outntr;
{
  int i,j,k,ii,tn,one=1,lc;
  float inc,findval,testval,prevval;

  inc=((*max)-(*min))/(float)((*outntr)-1);

  /* for each destination index */
  for (i=0; i<(*outntr); i++) {
    k=i*(*nsamp);
    findval=(*min)+(i*inc);
    for (j=0; j<(*nsamp); j++) {
      /* find a source index */
      if (findval < source[j])
        warptran[k+j]=-1;
      else if (findval > source[(*inntr-1)*(*nsamp)+j])
        warptran[k+j]=-1;
      else {
        for (ii=0; ii<(*inntr); ii++) {
          testval=source[ii*(*nsamp)+j];
          if (findval < testval) {
            /* interpolate between indices */
            prevval=source[(ii-1)*(*nsamp)+j];
            warptran[k+j]=ii+((findval-prevval)/(testval-prevval));
            break;
          } else if (findval == testval) {
            warptran[k+j]=ii+1;
            break;
          }
        }
      }
    }
  }
}


void ApplyWarpTransform(source,destination,warptran,fill,nsamp,outntr)
float *source,*destination,*fill,*warptran;
int *nsamp,*outntr;
{
  int i,j,k,one=1,i1,i2;
  float f1,f2,index;

  for (i=0; i<(*outntr); i++) {
    k=i*(*nsamp);
    for (j=0; j<(*nsamp); j++) {
      i1=index=warptran[k+j];
      if (i1 == -1)
        /* use fill value */
        destination[k+j]=(*fill);
      else if ((float)i1 == index)
        /* right on the money */
        destination[k+j]=source[i1-1];
      else {
        /* interpolate */
        i2=i1+1;
        f1=(float)i2-index;
        f2=index-(float)i1;
        destination[k+j]=f1*source[(i1-1)*(*nsamp)+j]+f2*source[i1*(*nsamp)+j];
      }
    }
  }
}
