C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine trat2z(data1,data2,nzd,ntd,vel,dz,dt,iord,init)
      
c     Compute layered plane wave residual depth moveout
c     by Dan Whitmore
 
c     data1  = trace data (input)
c     data2  = trace data (output)
c     nzd    = number of z sample in data
c     ntd    = number of t sample in data
c     vel    = velocity trace
c     dz     = depth spacing
c     dt     = time  spacing
c     iord   = interpolation order, 0=linear otherwise cubic
c     init   = initialize interpolation tables if init = 1   

      real data1(ntd),data2(nzd) 
      real vel(nzd)           
 
      logical first

      integer tmp1
      real time,z,tmp2
      pointer (ptime,time(ntd))
      pointer (pz,z(nzd))
      pointer (ptmp1,tmp1(1))
      pointer (ptmp2,tmp2(1))

      data first/.true./

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c first time logic
      if(first)then
         first=.false.

c create output time array
         call galloc (pz,nzd*SZSMPD,errcd,abort)

c create input time array
         call galloc (ptime,ntd*SZSMPD,errcd,abort)
         do itd=1,ntd
            time(itd)=float(itd-1)*dt
         enddo

c create scratch buffers for interpolation
        call galloc (ptmp1,max(ntd,nzd)*SZSMPD,errcd,abort)
        call galloc (ptmp2,max(ntd,nzd)*SZSMPD*4,errcd,abort)
        itrace_num=0
      endif
         
      itrace_num=itrace_num+1
      if(init.eq.1)then
         z(1)=0.
         do izd=2,nzd
            z(izd)=z(izd-1)+2.*dz/vel(izd-1)
         enddo
         ntemp=z(nzd)/dt+1.5
         ntout=min(ntemp,ntd)
      endif

c if time "small", then clear data2 and return
       if(ntout.lt.5 .or. nzd.lt.5) then
          call vclr(data2(1),1,nzd)
          return
       endif

c resample data1 into data (using time and z) could use ccuint as well
       if(iord.eq.0) then
          call fliint(time,data1,ntout,z,data2,nzd,tmp1,tmp2,init)
       else
          call ccuint(time,data1,ntout,z,data2,nzd,tmp1,tmp2,init)
       endif

       return
       end
