C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PKMIG                                                *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  EVENT MIGRATES PICKS USING A VELOCITY DATASET             *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   DAN WHITMORE                       ORIGIN DATE: 92/01/28  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED:           *
C                                                                      *
C  MODIFIED: DAN WHITMORE                      DATE:  1/28/92          *
C  Recompile 10/26/92 for new rdpicks in library libmbs. V 1.2         *
C                                                                      *
C  MODIFIED: Mary Ann Thornton                 DATE:  5/25/93          *
C  Change line header size, add logical unit for HP      V:1.3         *
C  Changed all writes to lu 0 to writes to lu LER                      *
C                                                                      *
C  MODIFIED: Mary Ann Thornton  V: 1.4         DATE:  6/15/93          *
c      removed call to rdpics and added call to rdpick, this routine   *
c      returns an additional array (name) containing the segment names *
c      and returns an additional parameter (maxpik) which gives the    *
c      maximum number of picks in any one segment                      *
c      rdpick routine reads the new xsd format (files before 10/92 are *
c      probably in the old format. comment also added to tell user to  *
C      convert old format to new using program xsd2xsd.                *
C      Removed call to wrpics and added call to wrpick, which has the  *
C      same changes as rdpick.F                                        *
C  MODIFIED: N. D. Whitmore, Jr.   V: 1.5         DATE:  8/24/93       *
C      Added iunits flag, if iunits = 0, output picks will be in trace,
C      sample units.  If iunits <> 0, output picks will be in physical
C      x and z units.
C  MODIFIED: N. D. Whitmore, Jr.   V: 1.6         DATE:  2/22/94       *
C  MODIFIED: N. D. Whitmore, Jr.   V: 1.7         DATE:  3/02/94       *
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

#include "lpick.h"

C     Memory Space Allocation

      parameter (lprt=26, lpck=27, lpout=28, llist=25)
      parameter (nxmax=2000,nzmax=6001,len_trace =itrwrd+nzmax)
      parameter (nrm=500,ntm=2500)

c     header and traces arrays
      dimension ihead(SZLNHD)
      dimension trace(len_trace),rtrd(nzmax)
      integer*2 itrh(itrwrd)
      equivalence (trace(1),itrh(1)),(trace(ithwp1),rtrd(1))

      real veloc(1)
      real partx(1),partz(1),vdt(1)
      real xray(1),zray(1),theta(1)
      real    data2d(1)
      integer iheada(1)

      pointer (pdata2d,data2d)
      pointer (pveloc,veloc)
      pointer (ppartx,partx), (ppartz,partz), (pvdt,vdt)
      pointer (pxray,xray), (pzray,zray), (ptheta,theta)
      pointer (piheada,iheada)
 

      real units(3),offset(3)
      real rec(1),trac(1),samp(1)
      integer icolor(1)
      integer npts(1000)
      character*20 name(1000)

      character*1 parr(66)
      character*4 version
      character*5 ppname
      character*128 ntap,picks,pout,otap

      logical verbos

      data version/' 1.7'/
      data ppname/'PKMIG'/
      data parr/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ','M','I','G','R','A','T','E',' ','P','I','C','K','S',' ',
     3' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     3          ' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/

c     Get Command Line Arguments
      ltrm  = LER
      call cmdlin(ntap,ipipi,picks,pout,ltrm,verbos,dt,ismoo,ixpad
     &,otap,ipipo,ievent,iunits)

c     Open Input Dataset
      if(ipipi.eq.0) then
C        luin is an input dataset
         call lbopen(luin,ntap,'r')
      else
C        we know luin is a pipe
         luin = 0
         ltrm = 2
      endif

c     Open Output Dataset
      if(ipipo.eq.0)then
C        luout is an output dataset
         call lbopen(luout,otap,'w')
      else
C        we know luout is a pipe
         luout=1
      endif
 

C     Open printout
      call openpr(llist,lprt,ppname,jerr)
      if(jerr.ne.0)stop 200
#include <mbsdate.h>
      nlin=1
      call gamoco(parr,nlin,lprt)
      if(picks.ne.' ')then
         open(unit=lpck,file=picks,status='old',iostat=jerr)
         if(jerr.ne.0)then
            write(lprt,*)'  Error opening picks file'
            stop 50
         endif
      else
         write(lprt,*)' Picks filename must be supplied'
         write(LER,*)' job completed abnormally'
         stop 100
      endif
 
      if(pout.ne.' ')then
         open(unit=lpout,file=pout,iostat=jerr)
         if(jerr.ne.0)then
            write(lprt,*)'  Error opening output picks file'
            stop 50
         endif
      else
         write(lprt,*)' Output picks filename must be supplied'
         write(LER,*)' job completed abnormally'
         stop 100
      endif

      write(lprt,38)ntap,picks,pout
   38 format(' INPUT VELOCITY = ',/,A128,/,
     &   ' INPUT PICKS = ',/,A128,/,' OUTPUT PICKS = '/,A128)

C     Open Input Tape, Get parameters
      lhbyt = 0
      call rtape(luin,ihead,lhbyt)
        if(lhbyt.le.0) then
           call lbclos(luin)
           write(LER,*)'error in reading input line header'
           stop 73
        endif
      len=5
 
c     Bring in Input Line Header Values
      call saver(ihead, 'NumSmp', num_smp, linhed)
      call saver(ihead, 'NumTrc', num_trc, linhed)
      call saver(ihead, 'SmpInt', smp_int, linhed)
      call saver(ihead, 'Format', iform, linhed)
      call saver(ihead, 'Dx1000', idx_1000, linhed)
      call saver(ihead, 'Dz1000', idz_1000, linhed)
 
      if(iform.ne.3)then
         write(lprt,*)'  INPUT TAPE MUST BE FORMAT 3'
         stop 100
      endif
 

c     
c     Process parameters
c

      izpad = 1
      dx = float(idx_1000)/1000.
      dz = float(idz_1000)/1000.
      if(dx.le.0.0 .or. dz.le.0) then
       write(ler,*) 'error - either dx or dz is not set in'
       write(ler,*) ' line header - to fix:  run mbs pgm vtrsiz'
       write(ler,*) ' for command line help: vtrsiz -h'
       write(lprt,*) 'error - either dx or dz is not set in'
       write(lprt,*) '        line header - to set run vtrsiz'
       write(lprt,*) '        for command line help: vtrsiz -h'
       stop 1000
      endif
      nx = num_trc + 2*ixpad
      nz = num_smp + izpad
      num_rec = 1
      dtray = .002
      init  = 0

c 
c     allocate arrays 
c


c
      iabort = 0
      jerr = 0
      isize_data2d = nz*num_trc
      call galloc( pdata2d, isize_data2d*iszbyt, jerr, iabort )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
      call vclr(data2d,1,isize_data2d)
c
      jerr = 0
      isize_veloc = nz*nx
      call galloc( pveloc, isize_veloc*iszbyt, jerr, iabort )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( ppartx, isize_veloc*iszbyt, jerr, iabort )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( ppartz, isize_veloc*iszbyt, jerr, iabort )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( pvdt, isize_veloc*iszbyt, jerr, iabort )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( pxray, nrm*(ntm+5)*iszbyt, jerr, iabort )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( pzray, nrm*(ntm+5)*iszbyt, jerr, iabort )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( ptheta, nrm*iszbyt, jerr, iabort )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      isize_iheada = itrwrd*num_trc
      call galloc( piheada, isize_iheada*iszbyt, jerr, iabort )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif



c        Read velocities from the input dataset
         jxcol = -nz + 1
         do jtrc=1,num_trc
            jeof=0
            call rtape(luin,trace,jeof)
              if(jeof.le.0) then
                 call lbclos(luin)
                 call lbclos(luout)
                 write(LER,*)'error in reading velocity tape'
                 write(LER,*)'trace=',jtrc
                 stop 74
              endif
              call vmov(itrh,1,iheada( 1+itrwrd*(jtrc-1) ),1,itrwrd)

c           load 0.5 X VELOCITY into veloc for normal incidence
              sclr = .5
c             lead in pad
              if(jtrc.eq.1 .and. ixpad.gt.0) then
               do jpad=1,ixpad
               jxcol = jxcol + nz
               jxstr = jxcol + izpad
               call vsmul(rtrd,1,sclr,veloc(jxstr),1,num_smp)
               call vmov(veloc(jxstr),1,veloc(jxcol),1,izpad)
               enddo
              endif
c             interior trace
              jxcol = jxcol + nz
              jxstr = jxcol + izpad
              call vsmul(rtrd,1,sclr,veloc(jxstr),1,num_smp)
              call vmov(veloc(jxstr),1,veloc(jxcol),1,izpad)
c             trailing pad
              if(jtrc.eq.num_trc) then
               do jpad=1,ixpad
               jxcol = jxcol + nz
               jxstr = jxcol + izpad
               call vsmul(rtrd,1,sclr,veloc(jxstr),1,num_smp)
               call vmov(veloc(jxstr),1,veloc(jxcol),1,izpad)
               enddo
              endif
         enddo
 
c        Find minimum and maximum velocity
cdan     call minv(veloc,1,vmin,lc,nz*nx)
cdan     call maxv(veloc,1,vmax,lc,nz*nx)
cdan     write(LER,*) 'min,max veloc = ',vmin,vmax

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  read the picks file
C     arrays returned are: rec,trac,samp,npts,icolor,name,units,offset
C  variables returned are: jseg,maxpik,jerr
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
       call rdpick(cardl,cardd,cardx,prec,ptrac,psamp,pcolor,
     &      name,npts,units,offset,jseg,maxpik,SZSMPD,nrec,
     &      ntrac,nsamp,lprt,lpck,jerr)

        if(jerr.eq.300)then
         write(lprt,*)' Errors in reading the xsd picks indicate'
         write(lprt,*)'   the picks may be in the old format.  You'
         write(lprt,*)'   should run:'
         write(lprt,*)' '
         write(lprt,*)'   xsd2xsd -Pold_picks_filename -POnew_picks',
     &                   '_filename'
         write(lprt,*)' '
         write(lprt,*)'   to convert the picks to the new format'
         write(lprt,*)'   and then run pkmig again.'
         write(ltrm,*)' Errors in reading the xsd picks indicate'
         write(ltrm,*)'   the picks may be in the old format.  You'
         write(ltrm,*)'   should run:'
         write(ltrm,*)' '
         write(ltrm,*)'   xsd2xsd -Pold_picks_filename -POnew_picks',
     &                   '_filename'
         write(ltrm,*)' '
         write(ltrm,*)'   to convert the picks to the new format'
         write(ltrm,*)'   and then run pkmig again.'
      endif
      if(jerr.ne.0)then
         write(lprt,*)' Job Terminated '
         stop 100
      endif
 
c     SCALE EACH SEGMENT BY UNITS
       knt=0
       do j=1,jseg
        do jray=1,npts(j)
        knt=knt+1
        trac(knt) = trac(knt)/units(2)
        samp(knt) = samp(knt)/units(3)
        enddo
       enddo
      
c     PROCESS EACH SEGMENT
      knt = 0
      knt2 = 0
      do 100 j=1,jseg
cdan        write(LER,*)' segment = ',j,' color = ',icolor(j),
cdan &                   ' npts = ',npts(j)
         if(npts(j).lt.3) then  
         write(LER,*) 'need to have at least 3 points per segment'
         write(LER,*) 'error in seg=',j
         write(lprt,*) 'need to have at least 3 points per segment'
         write(lprt,*) 'seg=',j
         stop 100
         endif

C      Build initial conditions for rays        

       tmax = 0.0
       slope = 0.0
       do 200 jray=1,npts(j)
         knt = knt + 1
cdan     write(0,*) 'trac,samp,knt = ', trac(knt),samp(knt),knt
         xray(jray) = ( trac(knt) + float(ixpad-1) )*dx
         ixnod   = ifix( xray(jray)/dx ) + 1
         zray(jray) = dz
cdan     write(0,*) 'jray,xray,zray', jray,xray,zray
         timnod  = samp(knt)*dt
cdan     write(0,*) 'jray,timnod',jray,timnod
         if(tmax.lt.timnod) tmax=timnod
c        if(jray.le.1) go to 200
c        if(jray.ge.npts(j)) go to 200
         if(jray.le.1) then
           delx   =  dx*(trac(knt+1)-trac(knt))
           if(abs(delx).ge.dx) then 
           slope  = -dt*(samp(knt+1)-samp(knt))/delx
           endif
         elseif(jray.ge.npts(j)) then
           delx   =  dx*(trac(knt)-trac(knt-1))
           if(abs(delx).ge.dx) then
           slope  = -dt*(samp(knt)-samp(knt-1))/delx
           endif
         else
           slope1 = slope
           delx1  =  dx*(trac(knt)-trac(knt-1))
           if(abs(delx1).ge.dx) then
           slope1 = -dt*(samp(knt)-samp(knt-1))/delx1
           endif
           slope2 = slope1
           delx2  =  dx*(trac(knt+1)-trac(knt))
           if(abs(delx2).ge.dx) then
           slope2 = -dt*(samp(knt+1)-samp(knt))/delx2
           endif
           if(delx1.ge.dx .and. delx2.ge.dx) then
           alp = abs(delx2)/(abs(delx1)+abs(delx2))
           slope  = alp*slope1 + (1.-alp)*slope2
           endif
         endif
         go to 301
  300    continue
         write(LER,*) 'error - adjacent picks have repeated x value'
         write(LER,*) 'seg number =,point=',j,jray
         write(lprt,*) 'error - adjacent picks have repeated x value'
         write(lprt,*) 'seg number =,point=',j,jray
cdan     write(LER,*) 'delx,delx1,delx2',delx,delx1,delx2
cdan     write(LER,*) 'delx1,delx2',delx1,delx2
         stop 100
  301    continue
cdan     write(LER,*) 'seg number ,point,slope=',j,jray,slope
         siang = slope*veloc( 1+nz*(ixnod-1) )
         if(abs(siang).gt.1.0) then
         write(LER,*) 'time dip gives a surface angle beyond 90 degrees'
         write(LER,*) 'seg=,point=',j,jray
         write(lprt,*)'time dip gives a surface angle beyond 90 degrees'
         write(lprt,*) 'seg=,point=',j,jray
         stop 100
         endif
         theta(jray) = asin(siang)
  200  continue
c      theta(1) = theta(2)
       nray = npts(j)
c      theta(nray) = theta(nray-1)
       nt = tmax / dtray

       if(nray.gt.nrm) then
        write(LER,*) 'too many rays to trace'
        write(lprt,*) 'too many rays to trace'
        stop 100
       endif
       if(nt.gt.ntm) then
        write(LER,*) 'too many rays to trace'
        write(lprt,*) 'too many rays to trace'
        stop 100
       endif
c
c     Trace Rays
c

      prtol = 0.0
      iflag = 0
      ntskip = 1
      call       rkrayx( nz   ,nx     ,nray ,nt   ,
     &                   nz   ,nx     ,nray ,nt   , ntskip ,
     &                   dz   ,dx           ,dtray,
     &                   veloc,ismoo  ,
     &                   partz,partx  ,vdt  ,init ,
     &                   theta,
     &                   zray ,xray   ,p    ,prtol,      dz,dx )
 
c      reset initialization flag
       init = 1

c      select appropriate output picks
       do jray=1,nray
       knt2=knt2+1
       jtray = (samp(knt2)-1.)*dt/dtray
       jrjt  = jray+nray*(jtray-1)
       jxx =  ifix(xray(jrjt)/dx+.5) -(ixpad-1)
       jzz =  ifix( (zray(jrjt)-dz)/dz+.5)
       trac(knt2) = float(jxx)
       samp(knt2) = float(jzz)
       if(samp(knt2).lt.1) samp(knt2) = 1.
         if(jxx.ge.1 .and. jxx.le.num_trc .and.
     &      jzz.ge.1 .and. jzz.le.nz) 
     &      data2d(jzz + (jxx-1)*nz) = 1.0

c      grid raypaths for event ievent
       if(ievent.eq.j) then
         do jt=jtray,2,-1
          jrjt = jray+nray*(jt-1)
          jxx =  ifix(xray(jrjt)/dx+.5) -ixpad
          jzz =  ifix( (zray(jrjt)-dz)/dz+.5)
          if(jxx.ge.1 .and. jxx.le.num_trc .and.
     &       jzz.ge.1 .and. jzz.le.nz) 
     &       data2d(jzz + (jxx-1)*nz) = 0.1
          enddo
        endif

       enddo
        
100   continue

 
C
C     Set Output Header Info
C
      call savew(ihead, 'NumSmp', nz-izpad, LINHED)
      call savew(ihead, 'NumTrc', num_trc, LINHED)
      call savew(ihead, 'NumRec', num_rec, LINHED)
      call savew(ihead, 'SmpInt', smp_int, LINHED)
      call savew(ihead, 'Format', iform, LINHED)
      call savew(ihead, 'Dx1000', idx_1000, LINHED)
      call savew(ihead, 'Dz1000', idz_1000, LINHED)
      call wrtape(luout,ihead,lhbyt)
 


c        write out gridded rays for this time block
         jrec = 1
         do jtrc=1,num_trc
            call vmov(iheada( 1+itrwrd*(jtrc-1) ),1,itrh,1,itrwrd)
            call vmov(data2d( 1+nz*(jtrc-1) ),1,rtrd,1,nz-izpad)
            call savew(itrh, 'RecNum', jrec, TRCHED)
            call savew(itrh, 'TrcNum', jtrc, TRCHED)
            call savew(itrh, 'StaCor',    0, TRCHED)
            call wrtape(luout,trace,jeof)
              if(jeof.le.0) then
                 call lbclos(luin)
                 call lbclos(luout)
                 write(LER,*)'error in writing output'
                 write(LER,*)'rec,trace=',jrec,jtrc
                 stop 75
              endif
         enddo

c     SCALE EACH SEGMENT BY UNITS
      if(iunits.ne.0) then
         units(2) = dx
         units(3) = dz
         knt=0
         do j=1,jseg
            do jray=1,npts(j)
               knt=knt+1
               trac(knt) = trac(knt)*units(2)
               samp(knt) = samp(knt)*units(3)
            enddo
         enddo
      else
         units(3) = 1.0
      endif
c     write output picks
      nsout = nz
      call wrpick(rec,trac,samp,icolor,name,npts,units,offset,
     &            nrec,ntrac,nsout,jseg,maxpik,lprt,lpout,jerr)
      if(jerr.eq.0)then
         write(lprt,*)' job completed normally'
         write(LER,*)' job completed normally'
      else
         write(lprt,*)' job completed abnormally'
         write(LER,*)' job completed abnormally'
      endif


C     Close Seismic Dataset

      call lbclos(luin)
      call lbclos(luout)
 
c     End Of Job

      stop
      end
C***********************************************************************
      subroutine cmdlin(ntap,ipipi,picks,pout,ltrm,verbos,dt,ismoo,
     &ixpad,otap,ipipo,ievent,iunits)
      integer argis
      logical help,verbos
      character*128 ntap,picks,pout,otap
      help  = (argis( '-h' ).gt.0) .OR. (argis( '-?').gt.0)
      if(help)then
      write(ltrm,*)'# PKMIG   -  MIGRATE PICKS  '
      write(ltrm,*)'# '
      write(ltrm,*)'#-VEL[]    .. input velocity dataset '
      write(ltrm,*)'#-O[]      .. output event "tape"    '
      write(ltrm,*)'#-P[]      .. input normal incidence time picks '
      write(ltrm,*)'#-PO[]     .. output depth picks '
      write(ltrm,*)'#-dt[]     .. dt(ms) time sample increment '
      write(ltrm,*)'#-ismoo[]  .. # times to smooth model'
      write(ltrm,*)'#-ievent[] .. seg # of rays to plot on event tape'
      write(ltrm,*)'#-iunits[] .. =  0 output picks in trace,sample'
      write(ltrm,*)'#             <> 0 output picks in x,z   '
      write(ltrm,*)'#WARNING:  x origin of picks & vel tape must match' 
      write(ltrm,*)'#WARNING:  x spacing of picks & vel tape must match' 
      stop
      endif

      call argstr('-VEL',NTAP,' ',' ')
      call argstr('-O',OTAP,' ',' ')
      call argstr('-P',picks,' ',' ')
      call argstr('-PO',pout,' ',' ')
      call argr4  ('-dt', dt, 0.0, 0.0)
      call argi4 ('-ismoo',ismoo,0,0)
      call argi4 ('-ievent',ievent,0,0)
      call argi4 ('-iunits',iunits,0,0)
      call argi4 ('-ixpad',ixpad,50,50)
      dt     = dt/1000.
      verbos = (argis( '-V' ).GT.0)
c
c     set pipe flag (0=no pipe,1=pipe)
      ipipi=0
      if(ntap.eq.' ' ) ipipi=1
      ipipo=0
      if(ntap.eq.' ' ) ipipo=0
      if(dt.le.0.001) then
       write(ltrm,*) 'invalid dt'
       stop
      endif
c
      RETURN
      END
C
      subroutine rkrayx (nzmax, nxmax, nrmax, ntmax, nz, nx, nray, nt,
     &                   ntskip, dz, dx, dt, v, ismoo, vdsz, vdsx, vdt,
     &                   init, theta, zray, xray, pray, prtol,
     &                   zrjct,xrjct)                         
c
c     FIXED DT RAYTRACING IN HETEROGENEOUS MEDIA -- RUNGE-KUTTA
c     N. D. Whitmore

c     MAXIMUM DIMENSIONS:
c             maxtab = max # entries in cos/sin table   - declared
      integer maxtab
      parameter (maxtab = 240001)
c             nzmax  = max # nz                         - input
      integer nzmax
c             nxmax  = max # nx                         - input
      integer nxmax
c             ntmax  = max # nt                         - input
      integer ntmax
c             nrmax  = max # of rays                    - input
      integer nrmax

c     DIMENSIONS:
c             nx = max # of nodes in x direction        - input
      integer nx
c             nz = max # of nodes in z direction        - input
      integer nz
c             nray = # of rays to trace                 - input
      integer nray
c             nt = # time steps                         - input
      integer nt
c             ntskip = output time increment            - input
      integer ntskip

c     GRID SIZES:
c             dz = z grid spacing                       - input
      real    dz
c             dx = x grid spacing                       - input
      real    dx
c             dt = time increment                       - input
      real    dt

c     SPATIAL ARRAYS:
c             v    = interval velocity model            - input

      real    v(nzmax,nxmax)
c             ismoo = # of times to apply 9 pt smoother - input
c                    to input velocity model v
      integer ismoo
c             vdsx  = v*v * partial(d( 1/v )/dx) * dt   - computed
      real    vdsx(nzmax,nxmax)
c             vdsz  = v*v * partial(d( 1/v )/dz) * dt   - computed
      real    vdsz(nzmax,nxmax)
c             vdt  = (v * dt)                           - computed
      real    vdt(nzmax,nxmax)
c             init   = initialization flag              - input
c                    = 0 intialize vdsx, vdsz, vdt
c                    = 1 do not intialize vdsx, vdsz, vdt
      integer init

c     COMPUTED WAVEFRONT SLOWNESS:
c             theta = incident angle                    - input / output
      real    theta(nrmax)

c     COMPUTED WAVEFRONT RAY POSITIONS:
c             xray = wavefront x positions at each dt   - input / output
      real    xray(nrmax,ntmax)
c             zray = wavefront z positions at each dt   - input / output
              real zray(nrmax,ntmax)

c     CONSTANT ANGLE RAY PARAMETER AND TOLERANCE
c             pray  = ray parameter                     - input
      real    pray
c             prtol = ray parameter tolerance           - input
      real    prtol
c             zrjct = z spacing for purging rays        - input
      real    zrjct
c             xrjct = x spacing for purging rays        - input
      real    xrjct

c     LOCAL DECLARATIONS (assume that:  max # rays < 15000)
      real   wcos(15000), wsin(15000), work(15000)
      data wcos/15000*0./, wsin/15000*0./, work/15000*0./
      save wcos, wsin
c
      integer ierr
      real *8 cstab(maxtab+5), xmax, xmin, dmy
      save cstab, first, xmax, xmin, dmy, ierr
      logical first

      data first / .true. /, dmy / 0. /, ierr / 0 /
      data pi / 3.141592653589793 /
c
c-----------------------------------------------------------------------
c
c     program outline:
c
c     0. smooth v and compute vdsz, vdsx, vdt (if init = 0)
c
c     1. initialize starting parameters
c        a. find starting node indices
c        b. table starting sin, cos
c
c     2. loop over time steps, at each time step
c      a. compute node indices of previous ray endpoints
c      b. gather vdt->work
c      c. compute dtheta, thetmp
c         dtheta = cos(theta(n-1))*vdsx - sin(theta(n-1))*vdsz
c      b. gather cos(thetmp)->wcos sin(thetmp)->wsin
c      d. compute temp wavefronts
c         XT(t(n)) = X(t(n-1)) + sin( thetmp )*Vdt
c         ZT(t(n)) = Z(t(n-1)) + cos( thetmp )*Vdt
c      e. compute temp node indices
c      f. compute Runge-Kutta update of theta
c      g. gather cos(theta)->wcos sin(theta)->wsin
c      h. update wavefront with an Euler recursion:
c         X(t(n)) = X(t(n-1)) + sin(theta(n))*Vdt
c         Z(t(n)) = Z(t(n-1)) + cos(theta(n))*Vdt
c     end time step loop
c
c-----------------------------------------------------------------------
c
c  if first entry to this routine, build cos/sin table
c
      if (first) then
         first = .false.
         xmax  =  3.0 * pi
         xmin  = -3.0 * pi
         call gcftlp (dmy, dmy, 0, maxtab, xmin, xmax, 1, cstab, ierr)
      endif

c     0. smooth v and compute vdsz, vdsx, vdt (if init = 0)

      if (init .eq. 0) then
         dtray = dt * ntskip
         if (ismoo .gt. 0) then
            do 110 jsmoo = 1, ismoo
               call smoothk (v, vdt, nz, nx, nzmax, nxmax)
  110       continue
         endif

c        interior dsz

         do 125 j2 = 1, nx
            do 120 j1 = 2, nz-1
               temp        = 1.0 / v(j1+1,j2) - 1.0 / v(j1-1,j2)
               vdsz(j1,j2) = 0.5 * v(j1,j2)**2 * temp / dz  * dtray
  120       continue
  125    continue

         if (ismoo .gt. 0) then
            do 130 jsmoo = 1, ismoo
               call zsmoo (vdsz, vdt, nz, nx, nzmax, nxmax)
  130       continue
         endif
 
c        interior dsx
c
         do 145 j2 = 2, nx-1
            do 140 j1 = 1, nz
               temp        = 1.0 / v(j1,j2+1) - 1.0 / v(j1,j2-1)
               vdsx(j1,j2) = 0.5 * v(j1,j2)**2 * temp / dx * dtray
  140       continue
  145    continue

         if (ismoo .gt. 0) then
            do 150 jsmoo = 1, ismoo
               call xsmoo (vdsx, vdt, nz, nx, nzmax, nxmax)
  150       continue
         endif

c        compute vdt

         do 165 j2 = 2, nx-1
            do 160 j1 = 1, nz-1
               vdt(j1,j2) = v(j1,j2) * dtray
  160       continue
  165    continue

c        pad vdt, vdsz, vdsx from nz to nzmax-1

c        do 175 j2 = 1, nx
c           do 170 j1 = nz, nzmax-1
c              vdt (j1,j2) = vdt(nz-1,j2)
c              vdsz(j1,j2) = 0.0
c              vdsx(j1,j2) = 0.0
c 170       continue
c 175    continue

c        set vdsx and vdsz and vdt on model edges

         do 180 j1 = 1, nzmax
            vdt(j1,1)   = 0.0
            vdt(j1,2)   = 0.0
            vdt(j1,3)   = 0.0
            vdt(j1,nx)  = 0.0
            vdsx(j1,1)  = 0.0
            vdsx(j1,nx) = 0.0
  180    continue

         do 190 j2 = 1, nx
            vdt(nzmax,j2)  = 0.0
            vdt(1,j2)      = 0.0
            vdsz(1,j2)     = 0.0
            vdsz(nz,j2)    = 0.0
  190    continue

c        reset init

         init = 1
      endif

c     1. initialize starting parameters
c     a. find starting node indices

      dtray  = dt * ntskip
      prdt   = pray / dtray
      dxover = 1.0 / dx
      dzover = 1.0 / dz


c     gather cos(theta)->wcos sin(theta)->wsin

      call ccftlp (cstab, theta, 1, wcos, wsin, 1, nray, 0, ierr)

c     2. loop over time steps
c
c     compute number of time steps

      nt1 = (nt + ntskip) / ntskip * ntskip

      jtkont = 0
      do 220 jt = 1+ntskip, nt1+ntskip, ntskip
         jtkont = jtkont + 1

         call crkray1 (nrmax, nzmax, nray, ntskip, jt, 
     &                 dxover, dzover, vdsx, vdsz, vdt, cstab, 
     &                 theta, wcos, wsin, work, xray, zray)

c        d. purge rays that are not within prtol of a Snell ray
c           (discard if sin(theta) is not close to pray*V)

         if (prtol .gt. 0.0) then
            if ((jtkont/8)*8 .eq. jtkont) then
               do 210 j = 1, nray
                  if (abs( wsin(j) - prdt * work(j) ) .gt. prtol ) then
                     xray(j,jt) = 0.51*xrjct
                     zray(j,jt) = 0.51*zrjct
                  endif
  210          continue
            endif
         endif

c     end time step loop
  220 continue

c     interpolate ntskip time steps

      if (ntskip .gt. 1) then
         do 330 jt = 1, nt1, ntskip
            do 320 jt1 = 1, ntskip-1
               beta  = float( jt1 ) / float( ntskip )
               alpha = 1.0 - beta
               do 310 j = 1, nray
                  xray(j,jt+jt1) = alpha * xray(j,jt) +
     &                             beta  * xray(j,jt+ntskip)
                  zray(j,jt+jt1) = alpha * zray(j,jt) +
     &                             beta  * zray(j,jt+ntskip)
  310          continue
  320       continue
  330    continue

      endif

c     end time interpolation

      return
      end
      subroutine xsmoo (a, b, nz, nx, nzmax, nxmax)

C     CALCULATES A 3 POINT HORIZONTAL SMOOTHING OF A MATRIX
C     INPUT  A  - MATRIX
C     OUTPUT A  - SMOOTHED MATRIX
C     WORKSPACE B

      integer nzmax, nxmax, nx, nz
      real a(nzmax,nxmax), b(nzmax,nxmax)

      real scale
      integer jx, jz

c-----------------------------------------------------------------------

      scale = 1.0 / 3.0

      do 120 jx = 2, nx-1
         do 110 jz = 2, nz-1
            b(jz,jx) = scale * ( a(jz,jx-1) + a(jz,jx) + a(jz,jx+1) )
  110    continue
  120 continue

      do 220 jx = 2, nx-1
         do 210 jz = 2, nz-1
            a(jz,jx) = b(jz,jx)
  210    continue
  220 continue

       return
       end
      subroutine smoothk (v, slow, nz, nx, nzmax, nxmax)

C     CALCULATES A 9 POINT RECIPROCAL SMOOTHING OF A VELOCITY MATRIX
C     INPUT  V  - VELOCITY MATRIX
C     OUTPUT V  - SMOOTHED VELOCITY MATRIX
C     WORKSPACE SLOW

      implicit none
      integer nzmax, nxmax, nz, nx
      real v(nzmax,nxmax), slow(nzmax,nxmax)

      real scale
      integer jx, jz
c
c-----------------------------------------------------------------------
c
      scale = 1.0 / 9.0

      do 20 jx = 2, nx-1
         do 10 jz = 2, nz-1
            slow(jz,jx) =
     &         scale *
     &         ( 1.0/v(jz-1,jx-1) + 1.0/v(jz,jx-1) + 1.0/v(jz+1,jx-1)
     &         + 1.0/v(jz-1,jx  ) + 1.0/v(jz,jx  ) + 1.0/v(jz+1,jx  )
     &         + 1.0/v(jz-1,jx+1) + 1.0/v(jz,jx+1) + 1.0/v(jz+1,jx+1)  )
   10    continue
   20 continue

      do 40 jx = 2, nx-1
         do 30 jz = 2, nz-1
            v(jz,jx) = 1.0 / slow(jz,jx)
   30    continue
   40 continue

       return
       end
      subroutine zsmoo (a, b, nz, nx, nzmax, nxmax)

C     CALCULATES A 3 POINT HORIZONTAL SMOOTHING OF A MATRIX
C     INPUT  A  - MATRIX
C     OUTPUT A  - SMOOTHED MATRIX
C     WORKSPACE B

      implicit none
      integer nzmax, nxmax, nx, nz
      real a(nzmax,nxmax), b(nzmax,nxmax)

      real scale
      integer jx, jz

c-----------------------------------------------------------------------

      scale = 1.0 / 3.0

      do 120 jx = 2, nx-1
         do 110 jz = 2, nz-1
            b(jz,jx) = scale * ( a(jz-1,jx) + a(jz,jx) + a(jz+1,jx) )
  110    continue
  120 continue

      do 220 jx = 2, nx-1
         do 210 jz = 2, nz-1
            a(jz,jx) = b(jz,jx)
  210    continue
  220 continue

       return
       end

