C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdheader(firstshot,dshot,firstoff,doff,
     1                    minrecind,maxrecind,dsta,
     2                    nshot,ntrace,nlive,xs,ys,zs, xr,yr,zr,
     3                    xg,yg,zg,recind,lrecind,live,soptnm,stderr,
     4                    lerr,mingroup,maxgroup)
c
      implicit none
c
      integer minrecind,maxrecind,ntrace,nshot,lerr
      real    firstshot,dshot,firstoff,doff,dsta
      integer recind(ntrace,nshot)
      real    xr(ntrace,nshot)
      real    yr(ntrace,nshot)
      real    zr(ntrace,nshot)
      logical live(ntrace,nshot)
      real    xg(minrecind:maxrecind)
      real    yg(minrecind:maxrecind)
      real    zg(minrecind:maxrecind)
      integer lrecind(minrecind:maxrecind)
      integer mingroup,maxgroup
c
      real    xs(nshot)
      real    ys(nshot)
      real    zs(nshot)
      integer soptnm(nshot)
      integer nlive(nshot)
c
      integer stderr
c
      integer itra,ishot,itrace,ig
c
      mingroup=maxrecind
      maxgroup=minrecind
C__________________________________________________________________
c     loop over all the common shot records.
C__________________________________________________________________
      do 40000 ishot=1,nshot
       zs(ishot)=0.
C__________________________________________________________________
c      loop over all the traces.
c      calculate number of live traces for this shot gather.       
C__________________________________________________________________
       nlive(ishot)=ntrace
       xs(ishot) = (ishot-1)*dshot+firstshot
       ys(ishot) = 0.
       itra = nint(xs(ishot)/dsta)+1
       if ((itra.lt.minrecind).or.(itra.gt.maxrecind)) then
          write(lerr,*) 'physical location of shot ',ishot
          write(lerr,*) 'is out of range'
          call exit(999)
       endif
       soptnm(ishot) = itra

       do 10000 itrace=1,ntrace

           live(itrace,ishot)=.true.
           xr(itrace,ishot) = xs(ishot)+(itrace-1)*doff+firstoff
           yr(itrace,ishot) = 0.
           itra = nint(xr(itrace,ishot)/dsta)+1
           if ((itra.lt.minrecind).or.(itra.gt.maxrecind)) then
              write(lerr,*) 'physical location of receiver ',itrace
              write(lerr,*) 'of shot ',ishot,' is out of range'
              call exit(999)
           endif
           recind(itrace,ishot) = itra
           xg(itra) = xr(itrace,ishot)
           lrecind(itra) = itra
           mingroup = min(itra,mingroup)
           maxgroup = max(itra,maxgroup)
c
10000  continue

40000 continue       


      return 
      end
