C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
***********************************************************************
      program PUTZERO
c_______________________________________________________________________
c     read in data output stack in each plane
c                                 Bertrand Duquet
c                                   7/30/96
c_______________________________________________________________________
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
#include <save_defs.h>
      parameter (maxs  = 0 000 002)
      dimension s(maxs)
      pointer  (pntrs , s )
C
      integer argis
C
      integer   sheader(SZLNHD)

      character*(80) file_in
      character*(80) file_out

C
      logical      query
      logical      verbose
      character*9  name 
c
      data name/'PUTZERO'/
      data luout/81/ 
c_____________________________________________________________________
c     determine pointers necessary to read trace headers.
c_____________________________________________________________________
      call savelu('RecInd',ifmt,l_recind,length,TRACEHEADER)
c_____________________________________________________________________
c     get online help if necessary
c_____________________________________________________________________
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if(query) then
         call help(ler)
         call exit(0)
      endif
c_____________________________________________________________________
c  open printout file
c_____________________________________________________________________
#include <f77/open.h>
c_____________________________________________________________________
c     read command line arguements
c_____________________________________________________________________
      verbose=(argis('-V') .gt. 0)
      call argstr('-N',file_in, ' ', ' ')
      call argstr('-O' ,file_out, ' ', ' ')
c_____________________________________________________________________
c     open input and output seismic worktapes.
c_____________________________________________________________________
      call getln(luin,file_in,'r',0)
      call getln(luout,file_out,'w',1)
c
      write(lerr,'(A20,A10,t40,a50)') 'FILE UNIT', 'VALUE','FILE NAME'
      write(lerr,'(A20,I10,t40,a50)')
     1     'luin',luin,file_in,
     5     'luout',luout,file_out
c
c_____________________________________________________________________
c     read in line header from input input file
c_____________________________________________________________________
      lenheader=0
      call rtape(luin,sheader,lenheader)
      call wrtape(luout,sheader,lenheader)
c_____________________________________________________________________
c     print out the historical line header to dribble file lerr.
c_____________________________________________________________________
      call hlhprt(sheader,lenheader,name,len(name),lerr)
c_____________________________________________________________________
C     pull input data parameters oFF the line header.
C     these will serve as deFault input parameters.
c_____________________________________________________________________
      call saver(sheader,'NumTrc',ntr,LINEHEADER)
      call saver(sheader,'NumSmp',nsamp,LINEHEADER)
      call saver(sheader,'NumRec',nrec,LINEHEADER)
c
      write(lerr,'(a30,i10)') 'ntr',ntr,'nsamp',nsamp,'nrec',nrec
c
      l_free=1
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80A1)') ('_',I=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80A1)') ('_',I=1,80)
      write(lerr,'(A20,3A10)')'variable name','begin','end','length'
c
      call mapmem('uin',l_uin,l_free,(ITRWRD+nsamp),lerr)
      call mapmem('uout',l_uout,l_free,(ITRWRD+nsamp),lerr)
C_______________________________________________________________________
C     allocate dynamic memory.                      
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for PUTZERO: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(ler,'(//,a)') 'allocate dynamic memory for PUTZERO: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)                   
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'   
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)'program PUTZERO aborted'
         close(lerr)
         call exit(101)
      endif
      write(lerr,'(a20,10x,i10)') 'total vector length',lens       

C_______________________________________________________________________
c     form the inner product, record by record.
C_______________________________________________________________________
      call mainsub(luin,luout,s(l_uin),s(l_uout),nrec,ntr,
     1             nsamp,lerr,ITRWRD)
c
      write(lerr,*)'Normal completion of PUTZERO'
      write(ler,*)'Normal completion of PUTZERO'
C
C_______________________________________________________________________
c     close all files.
C_______________________________________________________________________
      call lbclos(luin)
      call lbclos(luout)
      close(lerr)
      call exit(0)
c
      end
      subroutine  help(ler)
      write(ler,*)' '
      write(ler,*)'Command Line Arguments for putzero:'
      write(ler,*)'zero the input data and output the result'
      write(ler,*)' '
      write(ler,*)'Input....................................... (def)'
      write(ler,*)' '
      write(ler,*)'-N [file_in] Input USP format'
     1                     //' (no default)'
      write(ler,*)'-O [file_out] Output USP format'
      write(ler,*)' '
      write(ler,*)'Usage:'
      write(ler,*)'        putzero -N[] -O[]'
      write(ler,*)' '

      return
      end
