C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C*********************************************************************
C NAME: PWMVZN  PWMVZN HEADER FILE              REV 9.9     NOV 95   *
C*********************************************************************
C
C  PURPOSE:
C     DEFINES SYMBOLIC CONSTANTS FOR PWMVZN.
C
C  HISTORY:
C       NOV 91          REV 9.0         R.D. COLEMAN, CETech
C       JUL 92          REV 9.2         R.D. COLEMAN, CETech
C               Removed the string constant PRNAME
C       OCT 92          REV 9.3         R.D. COLEMAN, CETech
C               Updated version number
C       FEB 93          REV 9.4         R.D. COLEMAN, CETech
C               Updated version number
C       MAY 93          REL 9.5         M.A. Thornton
C               Updated version number
C       JUNE 93         REL 9.6         M.A. Thornton
C               Updated version number
C       OCTOBER 93      REL 9.7         M.A. Thornton
C               Updated version number.
C               Changed ppname, version from parameter statement
C               to a data statement, so I could equivalence another
C               variable to them when I added the audting
C       AUGUST 95       REL 9.8         J. Cooperstein, CeTech
C               Updated version number.
C       NOV 95          REV 9.9         J. Cooperstein, CeTech
C               Updated version number.
C               Changed PPNAME and VERSION to parameters
C       NOV 95          REV 10.2        J. Cooperstein, CeTech
C---------------------------------------------------------------------
C
C  CONTROL FLAGS
C
      INTEGER PRESTACK, POSTSTACK, MIGRTYPE
      PARAMETER( PRESTACK = 0, POSTSTACK = 1 )
      PARAMETER( MIGRTYPE = PRESTACK )
C
C  DIMENSIONS
C
C     MAXNT = TIME SAMPLES, MAXSMP = TIME SAMPLES, MAXNW  = FREQUENCIES
C     MAXNX = TRACES      , MAXNK  = NO. K_S     , MAXNK1 = NO. K_S + 1
C     MAXNZ = DEPTH # z_s , MAXNZT = total # z_s , MAXSEG = NO. Z-SEG_S
C     MAXREC= NO. RECORDS
C     MAXN  = max(MAXNT/2,MAXSMP/2,MAXNW,MAXNX,MAXNK,MAXNZ,MAXNZT)
C
      INTEGER MAXNT, MAXNK, MAXNK1, MAXN, MAXNW, MAXNX, MAXNZ, MAXNZT,
     &        MAXREC, MAXSEG, MAXSMP
      PARAMETER( MAXNT  = 4096, MAXSMP = 4096, MAXNW  = 2048,
     &           MAXNX  = 2048, MAXNK  = 2048, MAXNK1 = 2049,
     &           MAXNZ  = 1500, MAXNZT = 1500, MAXSEG = 1000,
     &           MAXREC =  200, MAXN   = 2048 )
C
C  LOGICAL UNIT NUMBERS
C
      INTEGER LPRT, LUCRD, LUPRT, LUSUR, LUVEL
      PARAMETER( LUCRD = 25, LUPRT = 26, LUSUR = 27, LUVEL = 28 )
      PARAMETER( LPRT  = LUPRT )
C
C  PARAMETERS FOR GENERATING PHASE SHIFT TABLE
C     NOTE: 2.5 > (pi/2)**2
C
      INTEGER NTAB, ITABFG
      REAL    TABMIN, TABMAX
      PARAMETER( NTAB = 25001, ITABFG = 2, TABMIN = 0.0, TABMAX = 2.5 )
C
C  STRING CONSTANTS
C
      CHARACTER PPNAME*6, VERSION*4, TITLE*66
      PARAMETER( PPNAME = 'PWMVZN' )
      PARAMETER( VERSION = '10.2' )
      PARAMETER( TITLE =                                               '
     &                    V(Z) MIGRATION
     &' )
C
C  MISCELLANEOUS CONSTANTS
C
      REAL PI, HALFPI, TWOPI, DEG2RAD, RAD2DEG
      PARAMETER( PI = 3.141592653589793 )
      PARAMETER( HALFPI = 0.5 * PI, TWOPI = 2.0 * PI,
     &           DEG2RAD = PI / 180.0, RAD2DEG = 180.0 / PI )
C
