C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gammadef1(gammamin,gammamax,treshold,fmin,hmax,ngamma,
     1                     gamma,lerr)

      implicit none

c-----------------------------------------------------------------------
c     Declaration for arguments
      real    gammamin,gammamax,treshold,fmin,hmax
      integer ngamma,lerr
      real    gamma(ngamma)

c     Declaration for local variables
      real    val,mini,gammaold,dgamma,gammaold2,gammacur
      integer igam,igamma
c-----------------------------------------------------------------------


      val = abs(fmin/2./hmax)
      mini = max(gammamin,1.)

      gamma(ngamma) = gammamax
      gammacur = gammamax
      igamma = ngamma - 1
      gammaold = gammacur

10    continue
       gammaold2 = gammaold
       gammaold = gammacur
       gammacur = sqrt( ( sqrt(gammaold**2-1.) - val )**2 + 1. )
       gammacur = min(gammacur,gammaold-treshold)
       gamma(igamma) = gammacur
       igamma = igamma - 1
      if (gammacur.gt.mini) goto 10
      igamma = igamma + 1

      if (gammamin.lt.mini) then
       dgamma = gammaold2 - gammaold
       do 20 igam = igamma,1,-1
        gammaold = gammaold - dgamma
        gamma(igam) = gammaold
20     continue
      endif
 
      write(lerr,*) ' '
      do 30 igamma=1,ngamma
       write(lerr,*) igamma,gamma(igamma)
30    continue

      
      return
      end
