C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
***********************************************************************
      program RADGAMMA
c_______________________________________________________________________
c     read in data output stack in each plane
c                                 Bertrand Duquet
c                                   7/30/96
c_______________________________________________________________________
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
#include <save_defs.h>
      parameter (maxs  = 0 000 002)
      dimension s(maxs)
      pointer  (pntrs , s )
c
      integer argis
c
      integer   sheader(SZLNHD)

      character*(80) file_in
      character*(80) file_out
      character*(80) file_semb
c
      parameter (maxchar=256)
c
      logical      query
      logical      reverse,ldiag,lsemb,lfilesemb
      logical      verbose
      character*9  name 
      character*12 hostname
      character*2  int2str
      character*256 filename
      real         hmin,hmax,gammamin,gammamax,zmin,zmax,maxmem
      real         sigma1,sigma2
      integer      mode
      integer      nodenumber,totalnodes
c
      data luout/81/ 
c
c_____________________________________________________________________
c     determine pointers necessary to read trace headers.
c_____________________________________________________________________
      call savelu('RecInd',ifmt,l_recind,length,TRACEHEADER)
c
c_____________________________________________________________________
c     get online help if necessary
c_____________________________________________________________________
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if(query) then
         call help(ler)
         call exit(0)
      endif
c	
c_____________________________________________________________________
c     open printout file
c_____________________________________________________________________
      call argi4('-totalnodes',totalnodes,1,1)
      call argi4('-nodenumber',nodenumber,1,1)
      call gethostfu(hostname)
c
      name='RADG'//int2str(nodenumber,'_')
c
#include <f77/open.h>
c
      write(ler,*) 'nodenumber = ',nodenumber,' hostname = ',
     1              hostname,' totalnodes = ',totalnodes
      write(lerr,*) 'nodenumber = ',nodenumber,' hostname = ',
     1               hostname,' totalnodes = ',totalnodes
c
c_____________________________________________________________________
c     read command line arguements
c_____________________________________________________________________
      verbose=(argis('-V') .gt. 0)
      call argstr('-N',file_in, ' ', ' ')
      call argstr('-O' ,file_out, ' ', ' ')
      call argstr('-S' ,file_semb, ' ', ' ')
      call argi4('-mod',mode,4,4)
      call argr4('-hmin',hmin,0,0)
      call argr4('-hmax',hmax,0,0)
      call argr4('-zmin',zmin,0,0)
      call argr4('-zmax',zmax,0,0)
      call argr4('-gammamin',gammamin,0.7,0.7)
      call argr4('-gammamax',gammamax,4.,4.)
      call argr4('-sigma1',sigma1,0.1,0.1)
      call argr4('-sigma2',sigma2,0.2,0.2)
      call argi4('-nwinz',iwinz,1,1)
      call argr4('-fmin',fmin,0.,0.)
      call argi4('-M',imaxmem,10,10)
      reverse=(argis('-R') .gt. 0)
      ldiag=(argis('-diag') .gt. 0)
      lsemb=(argis('-semb') .gt. 0)
      if (reverse) call argr4('-dh',dh,0.0,0.0)
      if (.not.reverse) call argi4('-ncurve',ngamma,0,0)
c
c_______________________________________________________________________
c     Check consistency
c_______________________________________________________________________
      ierror = 0

c---->if iwinz=1 -> iwinz=0 , iwinz=2 -> iwinz=0 , iwinz=3 -> iwinz=1
      iwinz=(iwinz-1)/2

c---->define lfilesemb to true if we use the input semblance weighting
c---->file
      if (file_semb.ne.' ') lfilesemb=.true.

c---->We can't calculate the semblance weighting file and use it at the
c---->same time
      if ((lsemb).and.(lfilesemb)) then
       write(ler,*) '-semb and -S cannot be set together'
       ierror = ierror + 1
      endif

c---->using the diagonal of the hessian and the semblance weighting
c---->make no sense
      if ((lsemb).or.(lfilesemb)) ldiag=.false.

c---->Calculating the semblance weighting is equivallent to a radon
c---->transform and thus -R option is not valid
      if ((lsemb).and.(reverse)) then
       write(ler,*) '-semb and -R cannot be set together'
       ierror = ierror + 1
      endif

c---->For forward radon transform you need to enter the number of gamma
c---->curves.
      if ((.not.reverse).and.(ngamma.eq.0)) then
       write(ler,*) 'must enter ncurve'
       write(ler,*) 'program stopped'
       write(lerr,*) 'must enter ncurve'
       write(lerr,*) 'program stopped'
       ierror = ierror + 1
      endif

c---->For reverse radon transform you need to specify the offset
c---->sampling rate
      if (reverse.and.(dh.eq.0.)) then
       write(ler,*) 'must enter dh'
       write(ler,*) 'program stopped'
       write(lerr,*) 'must enter dh'
       write(lerr,*) 'program stopped'
       ierror = ierror + 1
      endif

c---->The default mode value is 4 and must be 1,2,3,4 or 5
      if ((mode.ne.1).and.(mode.ne.2).and.(mode.ne.4).and.(mode.ne.5))
     1then
       write(ler,*) 'bad mod number'
       write(ler,*) 'program stopped'
       write(lerr,*) 'bad mod number enter dh'
       write(lerr,*) 'program stopped'
       ierror = ierror + 1
      endif
      if ((mode.eq.3).and.(fmin.eq.0.)) then
       write(ler,*) 'must enter fmin'
       write(ler,*) 'program stopped'
       write(lerr,*) 'must enter fmin'
       write(lerr,*) 'program stopped'
       ierror = ierror + 1
      endif
      if (ierror.gt.0) call exit(44)
c
c_____________________________________________________________________
c     open and read in line header from input file
c_____________________________________________________________________
c---->Open semblance weighting file 
      if (lfilesemb) then
       call getln(lusemb,file_semb,'r',2)
       lenheader=0
       call rtape(lusemb,sheader,lenheader)
      endif
c---->Open input file 
      call getln(luin,file_in,'r',0)
      lenheader=0
      call rtape(luin,sheader,lenheader)
c
c_____________________________________________________________________
c     print out the historical line header to dribble file lerr.
c_____________________________________________________________________
      call hlhprt(sheader,lenheader,name,len(name),lerr)
c
c_____________________________________________________________________
C     pull input data parameters oFF the line header.
C     these will serve as deFault input parameters.
c_____________________________________________________________________
      call saver(sheader,'NumSmp',nz,LINEHEADER)
      call saver(sheader,'NumRec',nx,LINEHEADER)
      if (.not.reverse) then
       call saver(sheader,'NumTrc',noff,LINEHEADER)
      else
       call saver(sheader,'NumTrc',ngamma_in,LINEHEADER)
      endif
c
c_______________________________________________________________________
c     Define parameters
c_______________________________________________________________________
      dz = (zmax-zmin)/(nz-1)
      izmin = nint(zmin/dz)
      izmax = izmin+nz-1
c
c---->Define parameter for forward radon transfrom
      if (.not.reverse) then
       dh = (hmax-hmin)/(noff-1)
       ihmin = nint(hmin/dh)
       ihmax = ihmin+noff-1

c---->Define parameter for reverse radon transfrom
      else
       ihmin = nint(hmin/dh)
       ihmax = nint(hmax/dh)
       noff = ihmax-ihmin+1
      endif
c
c---->If reverse radontransform then ngamma is read in the input file 
c---->header
      if (reverse) ngamma = ngamma_in
c
c-----------------------------------------------------------------------
c     The good sampling rate for the gamma curve dgamma is not obvious.
c     if mode=1 dgamma is a linear function of ngamma,gammamin and gamma
c     max 
c     if mode=2 dgamma is a linear function of ngamma,sqrt(gammamin) and
c     sqrt(gammamax)
c     if mode=4 dgamma is a linear function of ngamma,log(gammamin) and
c     log(gammamax)
c     if mode=5 dgamma is a linear function of ngamma,sqrt(gammamin-1)
c     and sqrt(gammamax-1)
c-----------------------------------------------------------------------
      if (mode.eq.1) call ngammadef2(gammamin,gammamax,dgamma,ngamma)
      if (mode.eq.2) call ngammadef(gammamin,gammamax,dgamma,ngamma)
c      if (mode.eq.3) 
c     1   call ngammadef1(gammamin,gammamax,dgamma,fmin,hmax,ngamma)
      if (mode.eq.4) call ngammadef3(gammamin,gammamax,dgamma,ngamma)
      if (mode.eq.5) call ngammadef4(gammamin,gammamax,dgamma,ngamma)
c
      if ((reverse).and.(ngamma.ne.ngamma_in)) then
       write(lerr,*) 'inconsistent ngamma read in input file and '
     1               //'ngamma calculated'
       write(lerr,*) 'program stopped'
       call exit(44)
      endif

      write(lerr,'(a30,i10)') 'nz',nz,'noff',noff,'nx',nx,'ngamma',
     1                         ngamma
c
c_______________________________________________________________________
c     calculate memory requirements
c_______________________________________________________________________
      maxmem = imaxmem*1.e6
c
c---->Define the number of crp to be radon transformed for each node
      nxnode = nx/totalnodes
      if (mod(nx,totalnodes).gt.0) nxnode = nxnode + 1
      nxnode = min(nxnode,nx)
c
c---->Define the number of crp to be radon transformed for this current
c---->node
      nxprocess = min( nxnode , nx-(nodenumber-1)*nxnode )
c
c---->Define the number of crp that will be transformed simultaneously
c---->according to the memory size allowed
      nxbuf = int( maxmem / (nz*noff+nz*ngamma) / 4. )
      nxbuf = min(nxbuf,nxprocess)
      if (nxbuf.lt.1) then
       write(lerr,*) 'You must increase the memory'
       write(lerr,*) 'program stopped'
       call exit(4444)
      endif 
c
      write(lerr,*) ' '
      write(lerr,*) 'nx, nxprocess, nxbuf : ',nx,nxprocess,nxbuf
c
c_______________________________________________________________________
c     Define arrays
c_______________________________________________________________________
      l_free=1
      write(lerr,'(///,80A1)') ('_',I=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80A1)') ('_',I=1,80)
      write(lerr,'(A20,3A10)')'variable name','begin','end','length'
c
      call mapmem('uoff',l_uoff,l_free,nz*noff*nxbuf,lerr)
      call mapmem('ugamm',l_ugamm,l_free,nz*ngamma*nxbuf,lerr)
      call mapmem('gamma',l_gamma,l_free,ngamma,lerr)
      call mapmem('diag',l_diag,l_free,nz*ngamma,lerr)
      call mapmem('semb',l_semb,l_free,nxbuf,lerr)
      call mapmem('sum',l_sum,l_free,nxbuf,lerr)
      call mapmem('ncount',l_ncount,l_free,nxbuf,lerr)
      call mapmem('buffer',l_buffer,l_free,ITRWRD+nz,lerr)
c
c_______________________________________________________________________
c     allocate dynamic memory.                      
c_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for RADGAMMA: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(ler,'(//,a)') 'allocate dynamic memory for RADGAMMA: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)                   
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'   
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)'program RADGAMMA aborted'
         close(lerr)
         call exit(101)
      endif
      write(lerr,'(a20,10x,i10)') 'total vector length',lens       
c
c_______________________________________________________________________
c      open output file (possibly to pipes)
c_______________________________________________________________________
c
c---->Pipe result if there's only one node and no -O option specified
      if ((totalnodes.eq.1).and.(file_out.eq.' ')) then
       call getln(luout,file_out,'w',1)
      else
c
c----->If there's -O option specified and more than one node then the
c----->actual outfile name is file_out__1__nodenumber
       if ((file_out.ne.' ').and.(totalnodes.ne.1)) then
        filename=file_out(1:lnst(file_out))//'__1_'
     1         //int2str(nodenumber,'_')
        call chklen(filename,maxchar,lerr)
        write(lerr,*) 'file = ',filename
        write(lerr,*) 'record ',(nodenumber-1)*nxnode+1,
     1                ' through ',min(nodenumber*nxnode,nx)
        call lbopen(luout,filename,'w')
c
c----->If there's -O option specified and only one node then the actual
c----->outfile name is file_out
       elseif ((file_out.ne.' ').and.(totalnodes.eq.1)) then
        filename=file_out(1:lnst(file_out))
        call chklen(filename,maxchar,lerr)
        call lbopen(luout,filename,'w')
c
c----->There's no -O option and more than one node. This is not allowed
       else
        write(lerr,*) 'error in routine radgamma'
        write(lerr,*) 'multi pass solution cannot have a piped'
     1              //' output file!'
        write(lerr,*) 'rerun with -O option'
        close(lerr)
        call exitfu(13666)
       endif        
      endif
c
c_____________________________________________________________________
c     push data parameters in the line header.
c_____________________________________________________________________
      call savew(sheader,'NumRec',nxprocess,LINEHEADER)
c
c---->For forward radon transform we save the number of gamma curves in
c---->the output file line header
      if (.not.reverse) then
       call savew(sheader,'NumTrc',ngamma,LINEHEADER)
c
c---->For reverse radon transform we save the number of offsets in the
c---->output file line header
      else
       call savew(sheader,'NumTrc',noff,LINEHEADER)
      endif
      call savew(sheader,'MxUHTm',totalnodes,LINEHEADER)
      call savew(sheader,'MnUHTm',nodenumber,LINEHEADER)
c
c---->Multiple pass is done in the same program session
      kpass=1
      call savew(sheader,'MnLnIn',kpass,LINEHEADER)
      call savew(sheader,'MxLnIn',kpass,LINEHEADER)
      call wrtape(luout,sheader,lenheader)
c
c_______________________________________________________________________
c     Define the array gamma which gives the gamma value versus gamma
c     curve number
c_______________________________________________________________________
      if (mode.eq.1) 
     1   call gammadef2(gammamin,gammamax,dgamma,ngamma,s(l_gamma),lerr)
      if (mode.eq.2) 
     1   call gammadef(gammamin,gammamax,dgamma,ngamma,s(l_gamma),lerr)
      if (mode.eq.3)
     1   call gammadef1(gammamin,gammamax,dgamma,fmin,hmax,ngamma,
     1                  s(l_gamma),lerr)
      if (mode.eq.4) 
     1   call gammadef3(gammamin,gammamax,dgamma,ngamma,s(l_gamma),lerr)
      if (mode.eq.5) 
     1   call gammadef4(gammamin,gammamax,dgamma,ngamma,s(l_gamma),lerr)

      call writegam(s(l_gamma),ngamma,hmin,hmax,dh,zmin,zmax)
c
c_______________________________________________________________________
c     Diagonal hessian calculation
c_______________________________________________________________________
      if (ldiag) then
       call diagonal(s(l_diag),s(l_gamma),ngamma,izmin,izmax,dz,ihmin,
     1               ihmax,dh,ITRWRD)
      endif

c_______________________________________________________________________
c     Semblance weighting calculation
c_______________________________________________________________________
      if (lsemb) then
       nread = (nodenumber-1)*nxnode
c
c----->Pass the input crp that have been used by the previous nodes
       call readpass(luin,izmin,izmax,ITRWRD,ihmax-ihmin+1,nread,
     1               s(l_buffer),lerr)
c
c----->Calculate and output the semblance weighting
       call semblance(luin,luout,s(l_uoff),s(l_ugamm),nxprocess,nxbuf,
     1                s(l_gamma),ngamma,izmin,izmax,dz,ihmin,ihmax,dh,
     2                lerr,stderr,ITRWRD,s(l_buffer),verbose,
     3                nodenumber,totalnodes,s(l_sum),s(l_semb),
     4                s(l_ncount),sigma1,sigma2,iwinz)

c_______________________________________________________________________
c     Radon transform
c_______________________________________________________________________
      else
       if (.not.reverse) then
        nread = (nodenumber-1)*nxnode
c
c------>Pass the input crp that have been used by the previous nodes
        call readpass(luin,izmin,izmax,ITRWRD,ihmax-ihmin+1,nread,
     1 	              s(l_buffer),lerr)
c
c------>Pass the input semblance part that has been used by the previous
c------>nodes
        if (lfilesemb) call readpass(lusemb,izmin,izmax,ITRWRD,ngamma,
     1                               nread,s(l_buffer),lerr)
c
c------>Calculate and output the radon transform
        call mainsub1(luin,luout,s(l_uoff),s(l_ugamm),nxprocess,nxbuf,
     1                s(l_gamma),ngamma,izmin,izmax,dz,ihmin,ihmax,dh,
     2                lerr,stderr,ITRWRD,s(l_buffer),verbose,
     3                nodenumber,totalnodes,ldiag,s(l_diag),lusemb,
     4                lfilesemb)
c
c_______________________________________________________________________
c     Reverse radon transform
c_______________________________________________________________________
       else
        nread = (nodenumber-1)*nxnode
c
c------>Pass the input radon transformed crp that have been used by the
c------>previous nodes
        call readpass(luin,izmin,izmax,ITRWRD,ngamma,nread,
     1                s(l_buffer),lerr)
c
c------>Pass the input semblance part that has been used by the previous
c------>nodes
        if (lfilesemb) call readpass(lusemb,izmin,izmax,ITRWRD,ngamma,
     1                               nread,s(l_buffer),lerr)
c
c------>Calculate and output the reverse radon transform
        call mainsub2(luin,luout,s(l_ugamm),s(l_uoff),nxprocess,nxbuf,
     1                s(l_gamma),ngamma,izmin,izmax,dz,ihmin,ihmax,dh,
     2                lerr,stderr,ITRWRD,s(l_buffer),verbose,
     3                nodenumber,totalnodes,ldiag,s(l_diag),lusemb,
     4                lfilesemb)
       endif
      endif
c
c_______________________________________________________________________
c     Everything worked fine
c_______________________________________________________________________
      write(lerr,*)'Normal completion of RADGAMMA'
      write(ler,*)'Normal completion of RADGAMMA'
c
c_______________________________________________________________________
c     close all files.
c_______________________________________________________________________
      call lbclos(luin)
      call lbclos(luout)
      if (lfilesemb) call lbclos(lusemb)
      close(lerr)
      call exit(0)
c
      end
      subroutine  help(ler)
      write(ler,*)' '
      write(ler,*)'Command Line Arguments for radgamma:'
      write(ler,*)'Radon transform using gamma function'
      write(ler,*)' '
      write(ler,*)'Input....................................... (def)'
      write(ler,*)' '
      write(ler,*)'-N [file_in] Input USP format'
     1                     //' (no default)'
      write(ler,*)'-O [file_out] Output USP format'
      write(ler,*)'-S        -- USP format input semblance file'
      write(ler,*)'-semb     -- calculate and output semblance file'
      write(ler,*)'-sigma1   -- semblance parameter (0.1)'
      write(ler,*)'-sigma2   -- semblance parameter (0.2)'
      write(ler,*)'-nwinz    -- length of the window in the z direction'
     1            //' for'
      write(ler,*)'             semblance calculation (1)'
      write(ler,*)'-R        -- reverse transform'
      write(ler,*)'-hmin     -- minimum offset (0)'
      write(ler,*)'-hmax     -- maximum offset (0)'
      write(ler,*)'-zmin     -- minimum depth (0)'
      write(ler,*)'-zmax     -- maximum depth (0)'
      write(ler,*)'-gammamin -- (0.7)'
      write(ler,*)'-gammamax -- (4.0)'
      write(ler,*)'-ncurve   -- number of gamma curves if -R is not'
     1            //'present (no default)'
      write(ler,*)'-dh       -- offset increment if -R is present'
     1            //' (no default)'
      write(ler,*)'-M        -- maximum memory in megabytes (10)'
      write(ler,*)' '
      write(ler,*)'Usage:'
      write(ler,*)'       radgamma -N[] -O[] -S[] -hmin[] -hmax[] -zmin'
     1            //'[] -zmax[]'
      write(ler,*)'                -gammamin[] -gammamax[] -ncurve[] '
     1            //'-dh[] -R -semb'
      write(ler,*)'                -sigma1[] -sigma2[] nwinz[] -M[]'
      write(ler,*)' '

      return
      end
