C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine semblance(luin,luout,uin,uout,nx,nxbuf,gamma,ngamma,
     1                     izmin,izmax,dz,ihmin,ihmax,dh,lerr,ler,
     2                     ITRWRD,buffer,verbose,nodenumber,totalnodes,
     3                     sum,semb,ncount,sigma1,sigma2,iwinz)

      implicit none

c-----------------------------------------------------------------------
c---->Type declaration for arguments
      logical verbose
      integer luin,luout,lerr,ler
      integer nx,nxbuf,ITRWRD,ngamma,izmin,izmax,ihmin,ihmax,iwinz
      real    buffer(-ITRWRD+izmin:izmax)
      real    uin(nxbuf,izmin:izmax,ihmin:ihmax)
      real    uout(nxbuf,izmin:izmax,ngamma)
      real    gamma(ngamma)
      real    sum(nxbuf),semb(nxbuf),ncount(nxbuf)
      real    dz,dh,sigma1,sigma2
      integer nodenumber,totalnodes
c
c---->Type declaration for local varialbles
      integer ix,ih,iz,ixsi,igamma,izw
      real    sqr,gamma2,xsi2,denom,val
      integer nbytes_in,nxpass,npass,ipass,ival
      real    sigma(0:1000),dsigma,s3,s4
c-----------------------------------------------------------------------
c
c
c---->Define the semblance weighting parameter sigma(0:1) as a function
c---->of sigma1 and sigma2. This sigma array has a sampling rate of
c---->0.001
      s3=1.01
      s4=1.01
      dsigma=1./1000
      call gttapr(sigma,sigma1,sigma2,s3,s4,dsigma,1,1001)
c
c---->We have nx crp to perform for this node and nxbuf crp fit in 
c---->memory. There will thus be npass pass.
      npass = nx/nxbuf
      if (mod(nx,nxbuf).gt.0) npass=npass+1
c
c_______________________________________________________________________
c     loop over number of pass
c_______________________________________________________________________
      do 50000 ipass=1,npass

c----->Define the number of crp for this pass (it is not allways nxbuf)
c-----------------------------------------------------------------------
       nxpass = min(nxbuf,nx-(ipass-1)*nxbuf)


c----->Read input array 
c-----------------------------------------------------------------------
       do 40000 ix=1,nxpass
        do 40010 ih=ihmin,ihmax
         nbytes_in=0
         call rtape(luin,buffer(-ITRWRD+izmin),nbytes_in)
         if(nbytes_in .eq. 0) then
            write(lerr,*) 'end of file encountered in routine mainsub'
            write(lerr,*) 'input file, irec,itr:',ix,ih
            call exit(1666)
         endif
         do 40020 iz=izmin,izmax
          uin(ix,iz,ih) = buffer(iz)
40020    continue
40010   continue
40000  continue
 

c----->The semblane weighting is calculated for each gamma curve
c-----------------------------------------------------------------------
       do 30000 igamma=1,ngamma


c------>Clear output array
        do 5 ix=1,nxpass
         do 10 ixsi=izmin,izmax
          uout(ix,ixsi,igamma) = 0.
10       continue
5       continue
        
        gamma2 = ( gamma(igamma)**2 - 1. ) / 4.

        do 20 ixsi=izmin,izmax
         xsi2 = (ixsi*dz)**2

c------->We are now interested in the unique curve defined by igamma and
c------->ixsi
         do 999 ix=1,nxpass
          ncount(ix) = 0
          semb(ix) = 0.
          sum(ix) = 0.
999      continue

c------->We do the summation of this curce along the data. Thus for each
c------->offset, we calculate the corresponding depth of this curve
         do 30 ih=ihmin,ihmax
          sqr = xsi2 + gamma2*(ih*dh)**2
          if (sqr.gt.0.) then
           sqr = sqrt(sqr)
           iz = nint(sqr/dz)
c           if ((iz.ge.izmin).and.(iz.le.izmax)) then
            do 400 izw=max(izmin,iz-iwinz),min(izmax,iz+iwinz)
             do 40 ix=1,nxpass
              semb(ix) = semb(ix)+uin(ix,izw,ih)**2
              sum(ix) = sum(ix)+uin(ix,izw,ih)
              ncount(ix) = ncount(ix)+1
40           continue
400         continue
c           endif
          endif
30       continue

         do 998 ix=1,nxpass
c-------->Define the semblance as sum**2/ncount/semb
          denom = ncount(ix)*semb(ix)
          if (denom.gt.0.) then
           val = sum(ix)**2/denom
c--------->val ranges between 0 and 1
           ival=int(val*1000)
           uout(ix,ixsi,igamma) = sigma(ival)
          endif
998      continue
20      continue

c------>Write verbose printout
c-----------------------------------------------------------------------
        if (verbose) write(ler,'(3(a,i6,a,i6,4x))') 'curve ',igamma,
     1           ' of ',ngamma,' pass ',ipass,
     2           ' of ',npass,' node ',nodenumber,' of ',totalnodes

30000  continue


c----->Write output array
c-----------------------------------------------------------------------
       do 50 ix=1,nxpass
        do 60 igamma=1,ngamma
         do 70 iz=izmin,izmax
          buffer(iz) = uout(ix,iz,igamma)
70       continue
         call wrtape(luout,buffer(-ITRWRD+izmin),nbytes_in)
60      continue
50     continue



50000 continue


      return
      end
