C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       RMIX                                                 *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  EDIT SUM AND MIX RECORDS                                  *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 88/03/04  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/08/23  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      cmdlin         - ROUTINE TO GET COMMAND LINE ARGUMENTS          *
C      LBOPEN         - OPEN SEISMIC TAPE                              *
C      OPENPR         -                                                *
C      GAMOCO         -                                                *
C      ICOPEN  INTEGER -                                               *
C      RTAPE          - READ A TRACE                                   *
C      LBCLOS         - CLOSE SEISMIC TAPE                             *
C      HLHPRT         - UPDATE HISTORICAL PORTION OF THE LINE HEADER   *
C      WRTAPE         - WRITE A TRACE                                  *
C      VMOV           - MOVE A STRING                                  *
C      VCLR           - MOVE A STRING OF ZEROES                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IABS    INTEGER -                                               *
C  FILES:                                                              *
C      LCRD  ( INPUT  SEQUENTIAL ) -                                   *
C      LPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C      LLIST ( OUTPUT SEQUENTIAL ) -                                   *
C      LTRM  ( TERMINAL          ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      200      ( 1) - open printout errors                            *
C      50       ( 1) - input cards error                               *
C      100      ( 4) - user error                                      *
C      75       ( 2) - tapeio error                                    *
C      =BLANK=  ( 1) - no error                                        *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  READ ISUM/2 RECORDS AND WRITE OUT, & SUM 'ISUM**
C       - RECORDS - NO. RECORDS IN EQUALS NO. RECORDS OUT              *
C  REVISED:  Mary Ann Thornton                 DATE:  06/19/91         *
C       - Increase no. of traces to 5000                               *
C  REVISED:  Mary Ann Thornton                 DATE:  08/27/91         *
C       - Move code to sun for maintenance, distribution from sun      *
C  REVISED:  Mary Ann Thornton    V: 2.1       DATE:  04/06/92         *
C       - Add dynamic allocation and remove all word size references
C       - for 32 bit machine.  Call openpr with full program name for
C       - OS 6.1
C  REVISED:  Mary Ann Thornton    V: 2.2       DATE:  05/12/92         *
C       - Change topen to cmdlin routine (compile w/new compiler)
C  REVISED:  Mary Ann Thornton    V: 2.3       DATE:  05/26/93         *
C       - Increase line header size, add logical unit for HP     
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
C
      PARAMETER (MXSAM=3000,MXTRA=5000)
      PARAMETER (LPRT=26, LCRD=25, LLIST=27)
C
      DIMENSION IHEAD(SZLNHD)
      DIMENSION RXX (MXSAM+ITRWRD), DATA(MXSAM)
      DIMENSION RXXC(MXSAM+ITRWRD), C   (MXSAM)
C
      DIMENSION A(1), B(1)
      INTEGER THDR(1)
      POINTER (PA, A), (PB, B), (PT, THDR)
      INTEGER*2 IRX(LNTRHD),IRXC(LNTRHD)
C
      LOGICAL VERBOS
      CHARACTER*1 CARD(80),PARR(66)

      CHARACTER*4  PPNAME
      CHARACTER*4  VERSION
      CHARACTER*128 NTAP, OTAP
C
      EQUIVALENCE (RXX (1),IRX (1)),(RXX (ITHWP1),DATA(1))
      EQUIVALENCE (RXXC(1),IRXC(1)),(RXXC(ITHWP1),   C(1))
C
      DATA VERSION/' 2.3'/
      DATA PPNAME/'RMIX'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ',' ','M','I','X',' ','A','N','D',' ','S','U','M',' ','R',
     3'E','C','O','R','D','S',' ',' ',' ',' ',' ',
     3          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/
C
C     (LTRM) TERMINAL=0 or 7(ler) , EXCEPT WHEN USING PIPES, THEN TERMINAL=2
C     cmdlin PICKS UP ALL THE COMMAND LINE ARGUMENTS AND LETS YOU
C     KNOW IF PIPES ARE BEING USED
C
      LTRM = LER
      CALL cmdlin(NTAP,OTAP,ISUM,IPIPI,IPIPO,LTRM,VERBOS)
      IF(IPIPI.EQ.0) THEN
C        LUIN IS AN INPUT DATASET
         CALL LBOPEN(LUIN,NTAP,'r')
      ELSE
C        WE KNOW LUIN IS A PIPE
         LUIN=0
         LTRM=2
      ENDIF
      IF(IPIPO.EQ.0) THEN
C        LUOUT IS AN OUTPUT DATASET
         CALL LBOPEN(LUOUT,OTAP,'w')
      ELSE
C        WE KNOW LUOUT IS A PIPE
         LUOUT = 1
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     LLIST IS A FREE LOGICAL UNIT NUMBER FOR USE IN OPENPR
C     LPRT IS THE LOGICAL UNIT NUMBER FOR A PRINTOUT
C     OPEN PRINTOUT
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)
      WRITE(LPRT,38)NTAP,OTAP
   38 FORMAT(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     ICOPEN FUNCTION reads internal card file
C     IF THE BATCH JOB STREAM IS USED AS A CARD FILE, 'N' WILL BE .GT. 0
C     IF THERE ARE NO CARDS, IT IS ASSUMED THE PARAMETER VALUE CAME IN
C     ON THE COMMAND LINE (OR DEFAULT VALUE WILL BE USED)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      JERR = 0
    5 FORMAT(80A1)
   15 FORMAT(i10)
      IF(ISUM.LE.0)THEN
         N = ICOPEN('-rmix.crd',LCRD)
         IF(N.NE.0)THEN
            READ(LCRD,5)CARD
            READ(LCRD,15) ISUM
         ENDIF
      ENDIF
      IF(ISUM.LE.0)THEN
         WRITE(LPRT,*)' NO. RECORDS TO MIX MUST BE SPECIFIED'
         STOP 50
      ENDIF
      WRITE(LPRT,7)ISUM
    7 FORMAT(2X,'NO. RECORDS TO MIX = ',I3)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ THE LINE HEADER & PICK OUT PARAMETERS NEEDED TO READ TRACES
C     NTR   = NUMBER OF TRACES PER RECORD
C     NREC  = NUMBER OF RECORDS PER JOB
C     ISI   = SAMPLE RATE INTERVAL (I.E. 4 INDICATES 4 MILLISECONDS)
C     KSAMP = NUMBER OF DATA SAMPLES PER TRACE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      JEOF = 0
      CALL RTAPE(LUIN,IHEAD,JEOF)
      IF(JEOF.EQ.0)GO TO 1000
      CALL SAVER(IHEAD, 'NumTrc', NTR, LINHED)
      CALL SAVER(IHEAD, 'NumRec', MREC, LINHED)
      CALL SAVER(IHEAD, 'SmpInt', ISI, LINHED)
      CALL SAVER(IHEAD, 'NumSmp', KSAMP, LINHED)
      IF(KSAMP.GT.MXSAM)THEN
         WRITE(LPRT,*)' MAXIMUM NO. SAMPLES ALLOWED IS ',MXSAM
         CALL LBCLOS(LUIN)
         CALL LBCLOS(LUOUT)
         STOP 100
      ENDIF
      IF(NTR.GT.MXTRA)THEN
         WRITE(LPRT,*)' MAXIMUM NO. TRACES ALLOWED IS ',MXTRA
         CALL LBCLOS(LUIN)
         CALL LBCLOS(LUOUT)
         STOP 100
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     HLH WILL PRINT LINEHEADER AND UPDATE THE HISTORICAL PORTION
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      LEN=4
      CALL HLHPRT(IHEAD,JEOF,PPNAME,LEN,LPRT)
      CALL WRTAPE(LUOUT,IHEAD,JEOF)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     ALLOCATE SPACE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IABORT = 0
      JERR = 0
      LBYTES = KSAMP*NTR*ISUM * ISZBYT
      CALL GALLOC(PA, LBYTES, JERR, IABORT)
      IF (IABORT.NE.0) THEN
         WRITE(LPRT,*)' ERROR ALLOCATING SPACE = ', JERR
         STOP 150
      ENDIF
      LWORDS = LBYTES / ISZBYT
      CALL VCLR(A,1,LWORDS)
      IABORT = 0
      JERR = 0
      LBYTES = KSAMP*NTR * ISZBYT
      CALL GALLOC(PB, LBYTES, JERR, IABORT)
      IF (IABORT.NE.0) THEN
         WRITE(LPRT,*)' ERROR ALLOCATING SPACE = ', JERR
         STOP 150
      ENDIF
      LWORDS = LBYTES / ISZBYT
      CALL VCLR(B,1,LWORDS)
      IABORT = 0
      JERR = 0
      LBYTES = NTR*ITRWRD * ISZBYT
      CALL GALLOC(PT, LBYTES, JERR, IABORT)
      IF (IABORT.NE.0) THEN
         WRITE(LPRT,*)' ERROR ALLOCATING SPACE = ', JERR
         STOP 150
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     START PROCESSING
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IOUT = 0
      M = 1
      IS2=ISUM/2
      IF(VERBOS)WRITE(LPRT,*)' M,IS2,ISUM,NTR',M,IS2,ISUM,NTR
   50 CONTINUE
      DO 200 I=1,ISUM
         DO 100 N=1,NTR
            JEOF=0
            CALL RTAPE(LUIN,RXX,JEOF)
            IF(JEOF.EQ.0)GO TO 1500
            II = (N-1)*ITRWRD + 1
            CALL VMOV(IRX,1,THDR(II),1,ITRWRD)
            IA = (I-1)*NTR*KSAMP + (N-1)*KSAMP+1
            IF(IRX(125).EQ.30000)THEN
               CALL VCLR(A(IA),1,KSAMP)
            ELSE
               CALL VMOV(DATA,1,A(IA),1,KSAMP)
            ENDIF
            IF(M.LE.IS2)CALL WRTAPE(LUOUT,RXX,JEOF)
  100    CONTINUE
         IF(VERBOS.and.M.LE.IS2)THEN
            IOUT=IOUT+1
            WRITE(LPRT,*)IOUT,' RECORDS WRITTEN'
         ENDIF
         M=M+1
  200 CONTINUE
C
c     WE HAVE WRITTEN 'ISUM/2' RECORDS AS IS & 
C     WE HAVE FILLED ARRAY A WITH 'ISUM' RECORDS
C     WE ARE READY TO SUM INTO B(K,N)
C
      RISUM = FLOAT(ISUM)
      IF(VERBOS)THEN
         WRITE(LPRT,*)' M,RISUM',M,RISUM, 'SUMMING FIRST RECORD OUT'
      ENDIF
      DO 230 N=1,NTR
         DO 220 I=1,ISUM
            DO 210 K=1,KSAMP
               IB = (N-1)*KSAMP + K
               IA = (I-1)*NTR*KSAMP + (N-1)*KSAMP + K
               B(IB) = A(IA) + B(IB)
  210       CONTINUE
  220    CONTINUE
         DO 225 K=1,KSAMP
            IB = (N-1)*KSAMP + K
            C(K) = B(IB)/RISUM
  225    CONTINUE
         II = (N-1)*ITRWRD + 1
         CALL VMOV(THDR(II),1,IRXC,1,ITRWRD)
         IRXC(106) = IOUT
         CALL WRTAPE(LUOUT,RXXC,JEOF)
  230 CONTINUE
      IOUT=IOUT+1
C
C     READ NEXT RECORDS ONE TRACE AT A TIME INTO C
C     SUBTRACT OLD TRACE FROM B, ADD NEW TRACE TO B, SAVE NEW TRACE IN A
C
      M=ISUM + 1
      I=1
  240 CONTINUE
      IF(VERBOS)WRITE(LPRT,*)' SUMMING RECORD',M
      IF(VERBOS)WRITE(LPRT,*)' SUBTRACTING RECORD',I
      DO 350 N=1,NTR
         JEOF=0
         CALL RTAPE(LUIN,RXXC,JEOF)
         IF(JEOF.EQ.0)GO TO 1500
         IF(IRXC(125).EQ.30000)THEN
            CALL VCLR(C,1,KSAMP)
         ENDIF
         DO 300 K=1,KSAMP
            IB = (N-1)*KSAMP + K
            IA = (I-1)*NTR*KSAMP + (N-1)*KSAMP + K
            B(IB) = B(IB) - A(IA) + C(K)
  300    CONTINUE
         IA = (I-1)*NTR*KSAMP + (N-1)*KSAMP + 1
         CALL VMOV(C,1,A(IA),1,KSAMP)
         DO 310 K=1,KSAMP
            IB = (N-1)*KSAMP + K
            C(K)=B(IB)/RISUM
  310    CONTINUE
         IRXC(106) = IOUT
         CALL WRTAPE(LUOUT,RXXC,JEOF)
  350 CONTINUE
      IOUT=IOUT+1
      I=I+1
      IF(I.GT.ISUM)I=1
      M=M+1
      IF(M.LE.MREC) GO TO 240
C
c     IF M.EQ.MREC, ALL RECORDS HAVE BEEN READ.
C     'MREC-IS2' RECORDS SHOULD BE WRITTEN AS IS, FIND THEM IN A MATRIX
C
      IR=I-IS2
      IF(IR.EQ.0)IR=ISUM
      IF(IR.LT.0)IR=ISUM-IABS(IR)
      DO 400 M=1,IS2
         IF(VERBOS)WRITE(LPRT,*)' IR = ',IR
         DO 375 N=1,NTR
            II = (N-1)*ITRWRD+1
            CALL VMOV(THDR(II),1,IRXC,1,ITRWRD)
            IA = (IR-1)*NTR*KSAMP + (N-1)*KSAMP + 1
            CALL VMOV(A(IA),1,C,1,KSAMP)
            CALL WRTAPE(LUOUT,RXXC,JEOF)
  375    CONTINUE
         IR=IR+1
         IF(IR.GT.ISUM)IR=1
  400 CONTINUE
      WRITE(LPRT,*) ' JOB COMPLETE'
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(LPRT,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER FROM TAPE')
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(LPRT,1510)M,N
 1510 FORMAT(2X,'TAPEIO ERROR PROCESSING OUTPUT RECORD',I5,' TRACE',I5)
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                             END OF JOB                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 5000 CONTINUE
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       cmdlin                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  capture the command line arguments                        *
C  ENTRY POINTS:                                                       *
C      cmdlin  (NTAP,OTAP,INPUT,ISUM,IPIPI,IPIPO,LTRM)                  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/08/23  *
C***********************************************************************
      SUBROUTINE cmdlin(NTAP,OTAP,ISUM,IPIPI,IPIPO,LTRM,VERBOS)
      INTEGER ARGIS
      LOGICAL HELP,VERBOS
      CHARACTER*128 NTAP, OTAP
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      VERBOS=.FALSE.
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS--RECORD MIX   '
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[ntap]   . INPUT DATASET NAME'
         WRITE(LTRM,*)'-O[otap]   . OUTPUT DATASET NAME'
         WRITE(LTRM,*)'-I[sum]    . NO. RECORDS TO MIX, MAXIMUM IS 9'
         WRITE(LTRM,*)'-V         . VERBOSE PRINTOUT'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'rmix -N[] -O[] -I[] -V'
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP ,' ',' ')
      CALL ARGSTR('-O',OTAP ,' ',' ')
      CALL ARGI4 ('-I',ISUM,0,0)
      VERBOS =   (ARGIS( '-V' ).GT.0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END
