C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c   Read an xsd segment file and resample it to new x limits
c   Then sets the units and offset parameters to match user defined
c   values.
c   If an input tape is provided, the new delta-x and delta-z will be
c   set to the values of Dx1000 and Dz1000 from the input line header
c
c   Original:  Mike J. O'Brien   Version 1.0         February 14, 1996
c             (this code was SOOOO nice until MAT got ahold of it!)
c   Facsimile: Mary Ann Thornton Version 1.0         February 15, 1996
c   Revised:   Mary Ann Thornton Version 1.1         March 4, 1996    
c     format 12.6 changed to 12.3 - 12.6 too small to represent values
c**********************************************************************c

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/lpick.h>

      parameter (flag_min =-1.0e+20, flag_max =1.0e+20 )

c declare standard USP variables

      integer      itr  ( SZLNHD )

      integer     nsamp, nsi, nrec
      integer     luin , lbytes


c variables used in dynamic memory allocation
 
      integer iabort, ierr
      real         reco(1),traco(1),sampo(1)

      pointer      (preco,reco)
      pointer      (ptraco,traco)
      pointer      (psampo,sampo)

c program specific variables

      integer     numsamp, numtrac, numrec, jerr
      integer     icolor(1)
      integer     npts(5000), npts_save
      integer     argis

      real         units(3),offset(3)
      real         xmin,xmax,newx0,newdx,newz0,newdz
      real         rec(1),trac(1),samp(1)

      character*20 sname(5000)
      character   ntap*255, name*9, version*4
      character   ncards * 128, ocards * 128

      logical     RecordWise, verbos
 
c initialize variables

      data lbytes / 0 /
      data name/'RSAMP_XSD'/
      data version /' 1.0'/ 
      data iabort /0/
      data RecordWise /.true./
 
      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-H' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
      
#include <f77/mbsopen.h>
 
      call gcmdln(ntap,ncards,ocards,xmin,xmax,flag_min,
     &            flag_max,newx0,newdx,newz0,newdz,verbos)
     
      open( unit=LUCARD,file=ncards,status='old',iostat=ierr)
      open( unit=LUDISK,file=ocards,status='unknown',iostat=ierr)

c-----
c-pgag  no piping in allowed by the looks of it.
c
      if ( ntap .ne. ' ' ) then
        call lbopen(luin, ntap, 'r')
 
        call rtape  ( luin, itr, lbytes)
        if(lbytes .eq. 0) then
           write(LOT,*)'RSAMP_XSD: no header read from unit ',luin
           write(LOT,*)'FATAL'
           stop
        endif
 
c------
        call saver(itr, 'NumSmp', nsamp, LINHED)
        call saver(itr, 'SmpInt', nsi  , LINHED)
        call saver(itr, 'NumTrc', ntrc , LINHED)
        call saver(itr, 'NumRec', nrec , LINHED)
        call saver(itr, 'Dx1000', idx  , LINHED)
        call saver(itr, 'Dz1000', idz  , LINHED)
c------
        if(newdx.le.0.)newdx = idx/1000.
        if(newdz.le.0.)newdz = idz/1000. * (-1.0)

        call hlhprt (itr, lbytes, name, 4, LERR)

c-pgag: so he only grabs lineheader information and leaves the input
c       dataset.

        call lbclos(luin)
      endif
      
c---------------------------------------------------
C     read the picks file
c     cardl,cardd,cardx,prec,ptrc,psamp,pcolor are pointers, etc.
c     which are defined in rdpick  
C     The arrays returned are: rec,trac,samp,npts,icolor,units,offset
c     npts(1) = no. points in segment 1; icolor(1) = color of segment 1
c     npts(2) = no. points in segment 2; icolor(2) = color of segment 2,etc.
c     maxpik  = maximum no. picks in any one segment
C     Variables returned are: jseg(no. of segments) and jerr (error flag)
c------

      call rdpick(cardl,cardd,cardx,prec,ptrac,psamp,pcolor,
     &            sname,npts,units,offset,jseg,maxpik,SZSMPD,
     &            numrec,numtrac,numsamp,LERR,LUCARD,jerr)

c sort input segments to increasing X coordinate but watch for picks across record
c boundaries.

c determine if picks are made within records [RecordWise = .true.] or 
c if picks cross record boundaries [RecordWise = .false.]

      if ( rec(1) .ne. rec(npts(1) ) ) RecordWise = .false.

      if ( RecordWise ) then
         call PickSort ( trac, samp, npts, jseg )
      else
         call PickSort ( rec, samp, npts, jseg )
      endif
     

c     check for new output units and write output xsd header 

      if(newdx.le.flag_min)then
         newdx = units(2)
      else
         units(2) = newdx
      endif
      if(newdz.le.flag_min)then
         newdz = units(3)
      else
         units(3) = newdz
      endif
      if(newx0.eq.flag_min)then
         newx0 = offset(2)
      else
         offset(2) = newx0-newdx
      endif
      if(newz0.eq.flag_min)then
         newz0 = offset(3)
      else
         offset(3) = newz0-newdz
      endif

c     write parameters to printout

      if(xmin.ne.flag_min)then
         write(LERR,*)' output x-minimum         = ',xmin
      endif
      if(xmax.ne. flag_max)then
         write(LERR,*)' output x-maximum         = ',xmax
      endif

      write(LERR,*)' output x-sample interval    = ',newdx
      write(LERR,*)' output z-sample interval    = ',newdz
      write(LERR,*)' output x-origin             = ',newx0
      write(LERR,*)' output z-origin             = ',newz0
      write(LERR,*)' input xsd-segments          = ',ncards
      write(LERR,*)' output xsd-segments         = ',ocards

      if(ntap.ne.' ')then
         write(LERR,*)' velocity dataset input   = ',ntap
      else
         write(LERR,*)' No velocity dataset input'
      endif

c----- write out xsd header of output pickfile

      jerr = 0

      call xsdhdr(units,offset,
     &     numrec,numtrac,numsamp,jseg,maxpik,LUDISK,jerr)

      if(jerr.ne.0)then 
         write(LERR,*)' Error writing output xsd file header'
         write(LERR,*)' Abnormal completion of RSAMP_XSD'
         stop 100
      endif

c     resample the segments

      new_maxpik = 0
      jbeg = 1

      do j=1,jseg
         
         npts_save = npts(j)
         call rsamp_sub(rec(jbeg),trac(jbeg),samp(jbeg),npts(j),LUDISK,
     &        sname(j),icolor(j),j,
     &        xmin,xmax,newx0,newdx,new_maxpik)

         jbeg = npts_save+jbeg

      enddo

      if(verbos) write(LERR,*)' Resampled ',jseg,' segments'
c---------------------------------------------------
c---------------------------------------------------
      close ( LUCARD )
      rewind( LUDISK )
c---------------------------------------------------
c     Now read the new cards and correct the maxpik in header to 
c     indicate the value of new_maxpik that we didn't know until all
c     the picks were resampled
c     If we now have more cards to read than we had before, we need
c     to allocate more space to read them into. 
c     When decimating the input, we have enough space
c     When interpolating the input, we do not have enough space
c---------------------------------------------------
      if(verbos)write(LERR,*)' Read picks again and correct header'

      IF (new_maxpik.gt.maxpik)then
         iabort = 0
         ierr = 0

C array reco
         lbytes = jseg * new_maxpik * SZSMPD
         call galloc(preco, lbytes, ierr, iabort)
         if(ierr.ne.0)then
            write(LERR,*)' Error allocating space = ', ierr
            jerr = 150
            go to 200
         endif
         lwords = lbytes / SZSMPD
         call vclr(reco,1,lwords)

C array trac
         call galloc(ptraco, lbytes, ierr, iabort)
         if(ierr.ne.0)then
            write(LERR,*)' Error allocating space = ', ierr
            jerr = 150
            go to 200
         endif
         lwords = lbytes / SZSMPD
         call vclr(traco,1,lwords)

C array samp
         call galloc(psampo, lbytes, ierr, iabort)
         if(ierr.ne.0)then
            write(LERR,*)' Error allocating space = ', ierr
            jerr = 150
            go to 200
         endif
         lwords = lbytes / SZSMPD
         call vclr(sampo,1,lwords)


         jerr = 0
         no_pnt=new_maxpik
         call rdpic(reco,traco,sampo,icolor,sname,npts,
     &        units,offset,jseg,jseg,new_maxpik,no_pnt,SZSMPD,
     &        nrec,ntrac,nsamp,LERR,LUDISK,jerr)
         rewind( LUDISK )
         call wrpick(reco,traco,sampo,icolor,sname,npts,units,offset,
     &        nrec,ntrac,nsamp,jseg,new_maxpik,LERR,LUDISK,jerr)
         if(jerr.ne.0)go to 200

      ELSE 

         jerr = 0
         no_pnt=new_maxpik
         call rdpic(rec,trac,samp,icolor,sname,npts,
     &        units,offset,jseg,jseg,new_maxpik,no_pnt,SZSMPD,
     &        nrec,ntrac,nsamp,LERR,LUDISK,jerr)
         rewind( LUDISK )
         call wrpick(rec,trac,samp,icolor,sname,npts,units,offset,
     &        nrec,ntrac,nsamp,jseg,new_maxpik,LERR,LUDISK,jerr)
         if(jerr.ne.0)go to 200

      ENDIF

      if(verbos)write(LERR,*)' Header corrected in output picks'

200   if(jerr.ne.0)then
        write(LERR,*)' Error reading output xsd file'
        write(LERR,*)'ABNORMAL completion of RSAMP_XSD'
        stop 100
      endif

      close(LUDISK)

      write(LERR,*)'Normal completion of RSAMP_XSD'
      write(LER,*)'rsamp_xsd: Normal Termination'
      end
 
C***********************************************************************
c
c subroutines
c
C***********************************************************************

      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'rsamp_xsd reads and resamples xsd segments.'
        write(LER,*)
     :'see manual pages by typing man rsamp_xsd ',
     :' (or mman, tman, uman rsamp_xsd)'
        write(LER,*)
     :'see pattern file by typing catpat rsamp_xsd'
        write(LER,*)
     :'execute rsamp_xsd by typing rsamp_xsd and the program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -VEL[vtap]    (Optional)       : input velocity field'
        write(LER,*)
     :' -P[ncards]    (default = none) : input xsd segments'
        write(LER,*)
     :' -PO[ocards]   (default = none) : output xsd segments'
        write(LER,*)
     :' -xmin[xmin]   (default = none) : new minimum x value'
        write(LER,*)
     :' -xmax[xmax]   (default = last) : new maximum x value'
        write(LER,*)
     :' -newx0[newx0] (default = flat) : new trace origin'
        write(LER,*)
     :' -newz0[newz0] (default = flat) : new sample origin'
        write(LER,*)
     :' -newdx[newdx] (default = flat) : new trace distance interval'
        write(LER,*)
     :' -newdz[newdz] (default = flat) : new sample interval'
        write(LER,*) ' '
        write(LER,*)
     :'usage:  rsamp_xsd -VEL[vtap] -P[ncards] -PO[ocards] -xmin[xmin]'
        write(LER,*)
     :'                  -xmax[xmax] -newx0[newx0] -newz0[newz0] '
        write(LER,*)
     :'                  -newdx[newdx] -newdz[newdz] '
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,ncards,ocards,xmin,xmax,flag_min,
     &                  flag_max,newx0,newdx,newz0,newdz,verbos)

#include <f77/iounit.h>

       real    xmin, xmax, newx0, newdx, newz0, newdz
       character*255  ntap
       character*128  ncards,ocards
       integer argis
       logical verbos

C Get the command line arguments
c
      call argstr('-VEL', ntap  , ' ', ' ')
      call argstr('-P', ncards, ' ', ' ')
      call argstr('-PO', ocards, ' ', ' ')
      call argr4 ('-xmin', xmin, flag_min, flag_min)
      call argr4 ('-xmax', xmax,  flag_max,  flag_max)
      call argr4 ('-newx0', newx0, flag_min, flag_min)
      call argr4 ('-newdx', newdx, flag_min, flag_min)
      call argr4 ('-newz0', newz0, flag_min, flag_min)
      call argr4 ('-newdz', newdz, flag_min, flag_min)
      verbos = (argis( '-V' ).gt.0)

      if ( xmin .eq. flag_min .and.  xmax .eq. flag_max .and.
     :    newx0 .eq. flag_min .and. newdx .eq. flag_min .and.
     :    newz0 .eq. flag_min .and. newdz .eq. flag_min)then
        write (LER,*) ' '
        write (LER,*) 'RSAMP_XSD: No parameters. Nothing to be done.'
        write (LER,*) ' '
        stop
      endif

      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C NAME: RDPIC     READ  PICKS                          REV 1.0  AUG 93 *
C***********************************************************************
C                                                                      *
C  ROUTINE:       rdpic                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Read an 'xsd' pick file which consists of a 'Units' card       *
C       then sets of 'Segment' cards with the x, y, and z points       *
C       defining that segment.                                         *
C                                                                      *
C  AUTHOR:   Mary Ann Thornton                  ORIGIN DATE: 93/08/18  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/08/18  *
C                                                                      *
C  Revised:  Mary Ann Thornton                               96/02/19  *
C       This routine is a modified version of the rdpic.F found in     *
C       ~mbs/src/lib/libmbs. This routine can be used when space for   *
C       the xsd file has been allocated before calling this routine.   *
C                                                                      *
C  CALLING FORMAT:                                                     *
c                call rdpic(rec,trac,samp,icolor,name,npicks,          *
c    &           units,offset,maxseg,no_seg,maxpnt,no_pnt,szsmpd,      *
c    &           nrec,ntrac,nsamp,lprt,lpck,jerr)                      *
C                                                                      *
C  PARAMETERS:                                                         *
C    rec        real array input/output array of length maxseg*maxpnt  *
C               This must be dimensioned in the calling routine        *
C               This array will contain the x points                   *
C                                                                      *
C    trac       real array input/output array of length maxseg*maxpnt  *
C               This must be dimensioned in the calling routine        *
C               This array will contain the y points                   *
C                                                                      *
C    samp       real array input/output array of length maxseg*maxpnt  *
C               This must be dimensioned in the calling routine        *
C               This array will contain the z points                   *
C                                                                      *
C    icolor     integer array input/output array of length maxseg      *
C               This must be dimensioned in the calling routine        *
C               This array will contain the segments' color numbers    *
C                                                                      *
C    name       Character*20 array input/output array of length maxseg *
C               This must be dimensioned in the calling routine        *
C               This array will contain the segments' names            *
C                                                                      *
C    npicks     Integer input/output array of length maxseg            *
C               This must be dimensioned in the calling routine        *
C               npicks(1) = the number of points in segment one        *
C               npicks(2) = the number of points in segment two, etc.  *
C                                                                      *
C    units      Real input/output array of length 3                    *
C               This must be dimensioned 3 in the calling routine      *
C               Units measure for the x,y,z points read from file      *
C               units(1) = Units measure for the x points              *
C               units(2) = Units measure for the y points              *
C               units(3) = Units measure for the z points              *
C                                                                      *
C    offset     Real input/output array of length 3                    *
C               This must be dimensioned 3 in the calling routine      *
C               Offsets measure of x,y,z points read from file         *
C               offset(1) = offset measure for the x points            *
C               offset(2) = offset measure for the y points            *
C               offset(3) = offset measure for the z points            *
C                                                                      *
C    maxseg     Integer input scalar                                   *
C               Maximum number of segments allowable by main           *
C                                                                      *
C    no_seg     Integer output scalar                                  *
C               Actual number of segments in the pick file             *
C                                                                      *
C    maxpnt     Integer input scalar                                   *
C               Maximum number of points/segment allowed by main       *
C                                                                      *
C    no_pnt     Integer output scalar                                  *
C               Actual maximum number of points in any one segment     *
C                                                                      *
C    szsmpd     Integer input scalar (defined in lhdrsz.h)             *
C               Size of data sample                                    *
C                                                                      *
C    nrec       Integer output scalar                                  *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    ntrac      Integer output scalar                                  *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    nsamp      Integer output scalar                                  *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    lprt       Integer input scalar                                   *
C               Logical unit of printout                               *
C                                                                      *
C    lpck       Integer input scalar                                   *
C               Logical unit of pick file                              *
C                                                                      *
C    jerr       Integer input/output scalar                            *
C               Error flag                                             *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C      jerr =  0  =   No errors                                        *
C      jerr = 50  =   No Units card found                              *
C      jerr =100  =   No Segment card found for a segment              *
C      jerr =150  =   Error allocating space for segments              *
C      jerr =175  =   No valid segments found                          *
C      jerr =200  =   EOF encountered reading picks                    *
C      jerr =300  =   Error reading picks                              *
C                                                                      *
C***********************************************************************
      subroutine rdpic(rec,trac,samp,icolor,name,npicks,
     &           units,offset,maxseg,no_seg,maxpnt,no_pnt,szsmpd,
     &           nrec,ntrac,nsamp,lprt,lpck,jerr)

c     maxseg is maximum segments allowable
c     no_seg is maximum segments as read from the picks file
c     maxpnt is maximum points per segment allowable
c     no_pnt is maximum points per segment as read from the picks file
C
      integer szsmpd
      character*126 cardl
      character*80  card
      character*20  name(*)
      character*6   uword
      integer npicks(*), icolor(*)
      real rec(*), trac(*), samp(*), units(*), offset(*)
 
      jerr = 0

 50   format(a126)
 75   format(a80)
      read(lpck,50,end=200)cardl
      if(index(cardl,'U').ne.0)then
         go to 90
      else
         write(lprt,*)' No Units card found'
         jerr =  50
         return
      endif

C     We have just read a Units card

 90   continue
      read(cardl,60,end=200,err=300)uword,
     &     units(1), units(2), units(3),
     &     nrec, ntrac, nsamp,
     &     offset(1), offset(2), offset(3),
     &     no_seg, no_pnt
 60   format(a6,3(f12.3,1x),3(i5,1x),7x,3(f12.3,1x),6x,i5,1x,i5)

      if(no_seg.gt.maxseg)then
         write(lprt,*)' Error - There are ',no_seg,' segments'
         write(lprt,*)' The maximum number allowable is ',maxseg
         jerr = 100
         return
      endif

C     if (index(card,'S').ne.0) we read a Segment card

      k = 0
      do 150 i=1,no_seg
         read(lpck,75,end=200,err=300)card
         if(index(card,'S').ne.0)then
            read(card,70,err=300)nseg,name(i),icolor(i),npicks(i)
 70         format(10x,i5,6x,a20,10x,i5,9x,i5)
         else
            write(lprt,*)' No segment card found for segment ',i
            jerr = 100
            return
         endif

         do 100 j=1,npicks(i)
            k = k + 1
            read(lpck,80,end=200,err=300)rec(k),trac(k),samp(k)
 80         format(3(f12.3,1x))
 100     continue
 150  continue
cmat  write(lprt,*)no_seg,' segments read successfully '
      return

 200  continue
cmat  write(lprt,*)' reached end of file reading picks '
cmat  write(lprt,*)' job terminated'
      jerr = 200 

c-pgag: so they have read all the input but have done nothing to sort
c       for increasing picks

      return

 300  continue
      write(lprt,*)' Error reading picks.'
      write(lprt,*)' The picks may be in the old format.  You',
     &     ' should run:'
      write(lprt,*)' '
      write(lprt,*)'   xsd2xsd -Pold_picks_filename -POnew_picks',
     &     '_filename'
      write(lprt,*)' '
      write(lprt,*)'   to convert the picks to the new format'
      write(lprt,*)'   and then try running this program again.'
      jerr = 300 
      return
      end
