C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SPLITSS                                              *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  CREATE REGULAR SPLIT SPREADS AND INDEX                    *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   DAN WHITMORE                       ORIGIN DATE: 04/21/92  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED:           *
C  MODIFIED: DAN WHITMORE                      DATE:  04/21/92         *
C  MODIFIED: DAN WHITMORE   V 1.6              DATE:  11/09/92         *
C       changed code to allow for sample rate < 1 ms
C  MODIFIED: DAN WHITMORE   V 1.7              DATE:  11/10/92         *
C       changed code to allow more samples per trace
C  MODIFIED: DAN WHITMORE   V 1.8              DATE:  11/20/92         *
C       changed code for describing itmplt           
C  MODIFIED: Mary Ann Thornton V 2.0           DATE:  03/26/93         *
C       increased line header size and added logical unit (LER) for HP
C       and changed ltrm to equal ler rather than 0.
C  MODIFIED: Dan Whitmore      V 2.1           DATE:  10/21/93         *
C       Corrected subroutine call parameter list, and added a "hidden"
C       command line argument 'ignore'. If ignore is set some biases
C       will be set, also.                                
C       Also, included hp.h /M.A.Thornton                 
C  MODIFIED: Gary Murphy       V 2.2           DATE:   05/16/94        *
C       Uncovered hidden ignore parameter.
C  MODIFIED: Gary Murphy       V 2.3           DATE:   05/18/94
C       Made ignore parameter more general.
C  MODIFIED: Mary Ann Thornton V 2.4           DATE:   06/15/94
C       Corrected the endif problem introduced with the last change
C  MODIFIED: Mary Ann Thornton V 2.5           DATE:   05/04/95
C       Corrected code to allow verbose printout when requested    
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

c 
c     Memory Space Allocation
c 
      parameter (lhead=SZLNHD)
      parameter (llist = 27, lprt = 26, lcrd=25, ltmp= 28)
      parameter (nsmax=24000,len_trace =itrwrd+nsmax)

c     header and traces arrays
      integer     ihead(lhead)
      real        trace(len_trace),rtrd(nsmax)
      real        tracew(len_trace),rtrdw(nsmax)
      real        tracev(len_trace),rtrdv(nsmax)
      integer * 2 itrh(lntrhd)
      integer * 2 itrhw(lntrhd)
      integer * 2 itrhv(lntrhd)
      equivalence (trace(1),itrh(1)),(trace(ithwp1),rtrd(1))
      equivalence (tracew(1),itrhw(1)),(tracew(ithwp1),rtrdw(1))
      equivalence (tracev(1),itrhv(1)),(tracev(ithwp1),rtrdv(1))

c     base template
      real basex(1)
      pointer (pbasex,basex)
c
c     work arrays
      real tracea(1),velsq(1),xoff(1)
      pointer(ptracea,tracea),(pvelsq,velsq),(pxoff,xoff)

c     character arrays
      character*1 parr(66)
      character*4 version
      character*7 ppname
      character*128 otap,ntap,vtrms
      logical verbos

      data version/' 2.5'/
      data ppname/'SPLITSS'/
      data parr/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ',' ',' ',' ','C','O','M','P','U','T','E',' ','S','P','L',
     3'I','T',' ','S','R','E','A','D','S',' ',' ',' ',
     3          ' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/

c  
c     Open printout
c  
      call openpr(llist,lprt,ppname,jerr)
      if(jerr.ne.0)stop 200

c    
c     Gamoco
c
      nlin=1
      call gamoco(parr,nlin,lprt)
#include <mbsdate.h>

c
c     Get Command Line Arguments
c
      ltrm  = ler
      call cmdlin(ntap,otap,vtrms,ipipi,ipipo,ipipv,ltrm,lprt,
     &cdpinc,stainc,spskew,ncshot,xmax,xtol,xsgn,dxt,ignore,verbos)

c 
c     Open Input Dataset
c 
      if(ipipi.eq.0) then
c        luin is an input dataset
         call lbopen(luin,ntap,'r')
      else
c        we know luin is a pipe
         luin = 0
      endif

c 
c     Open RMS Velocity Dataset
c  
      if(ipipv.eq.0) then
       call lbopen (luv, vtrms, 'r')      
      endif
 
c 
c     Open Output Dataset
c 
      if(ipipo.eq.0)then
c        luout is an output dataset
         call lbopen(luout,otap,'w')
      else
c        we know luout is a pipe
         luout=1
      endif


      write(lprt,38)ntap,otap
   38 format(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
      if(ipipv.eq.0) then
      write(lprt,37)vtrms
   37 format(' RMS VELOCITY DATASET = ',/,A128)
      endif

C
C     Open Input Tape, Get parameters
C
      jeof = 0
      call rtape(luin,ihead,jeof)
       if(jeof.le.0) then
        write(ltrm,*)'error in reading input line header'
        write(lprt,*)'error in reading input line header'
        go to 1000
       endif

c
c     Update Historical line header
c
      len=7
      call hlhprt(ihead,jeof,ppname,len,lprt)

c
c     summarize user parameters
c

      if (verbos) then
         write(lprt,*)' cdp increment . . . . . . . . . . ', cdpinc
         write(lprt,*)' station increment . . . . . . . . ', stainc
         write(lprt,*)' number of cdps per shot . . . . . ', ncshot
         write(lprt,*)' maximum offset. . . . . . . . . . ', xmax
         write(lprt,*)' tolerance . . . . . . . . . . . . ', xtol
         write(lprt,*)' normal signed distance convention ', xsgn
         write(lprt,*)' trace spacing on velocity tape. . ', dxt
         write(lprt,*)' ignore. . . . . . . . . . . . . . ', ignore
         write(lprt,*)' verbose . . . . . . . . . . . . . ', verbos
      endif


c
c     Bring in Input Line Header Values
c
      call saver(ihead, 'NumSmp', num_smp, linhed)
      call saver(ihead, 'NumTrc', num_trc, linhed)
      call saver(ihead, 'NumRec', num_rec, linhed)
      call saver(ihead, 'SmpInt', ismp_int, linhed)
      call saver(ihead, 'Format', iform, linhed)
      smp_int = float(ismp_int)
      if(smp_int .gt. 32.) smp_int = smp_int/1000.
      len_in  = itrwrd+num_smp

      if(iform.ne.3)then
         write(lprt,*)'  INPUT TAPE MUST BE FORMAT 3'
         stop 100
      endif

c
c     Compute Base templates and lbasex, ntmplt, and num_trco
c
      call btmplt(pbasex,cdpinc,lbasex,
     &xmax,stainc,ncshot,spskew,iszbyt,lprt,ltrm)
      ntmplt   = lbasex - ncshot + 1
      num_trco = ntmplt/ncshot + 1

c
c     Set Output Header Info
c
      call savew(ihead, 'NumSmp', num_smp, LINHED)
      call savew(ihead, 'NumTrc', num_trco, LINHED)
      call savew(ihead, 'NumRec', num_rec, LINHED)
      call savew(ihead, 'SmpInt', ismp_int, LINHED)
      call savew(ihead, 'Format', iform, LINHED)
      call wrtape(luout,ihead,jeof)

c
c     Read Line Header from Velocity Tape - Get parameters
c      (if no velocity tape -- then no nmo)
c
      if(ipipv.eq.0) then

      jeofv = 0
      call rtape(luv,ihead,jeofv)
       if(jeof.eq.0) then
        write(ltrm,*)'error in reading velocity'
        write(ltrm,*)'trace=',jrec
        write(lprt,*)'error in reading velocity'
        write(lprt,*)'trace=',jrec
        go to 1000
       endif

c
c     Bring in velocity tape line header values
c
       call saver(ihead, 'NumSmp', num_smpv, linhed)
       call saver(ihead, 'NumTrc', num_trcv, linhed)
       call saver(ihead, 'NumRec', num_recv, linhed)
       lvelsq   = amax0(num_smp,num_smpv)
       nvxtra   = num_smp - num_smpv
       nvtotal  = num_trcv*num_recv

      else
      
       lvelsq = 1
      
      endif


c 
c     Allocate arrays 
c
 
      jerr = 0
      isize_tracea = len_in*num_trc
      call galloc( ptracea, isize_tracea*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(ltrm,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( pvelsq, lvelsq*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(ltrm,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( pxoff, num_trc*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(ltrm,*)'galloc error: ', jerr
         stop
      endif




c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
c                                                                    *
c     Begin Trace Processing                                         *
c                                                                    *
c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

c
c      START RECORD LOOP  * * * * * * * * * * * * * * * * * * * * * * *
c
      x_vt  = 0.0
      jx_vt = 0

      do 100 jrec=1,num_rec

      x_cdp = float(jrec-1)*cdpinc

c
c     if appropriate - read velocity trace and square
c  
      if(ipipv.eq.0) then

       if(x_vt .le. x_cdp .and. jx_vt.lt.nvtotal) then
        x_vt  = x_vt  + dxt
        jx_vt = jx_vt + 1
        jeofv=0
        call rtape(luv,tracev,jeofv)
         if(jeof.eq.0) then
          write(ltrm,*)'error in reading velocity trace=',jx_vt
          write(lprt,*)'error in reading velocity trace=',jx_vt
          go to 1000
         endif
        call vsq(rtrdv,1,velsq,1,num_smpv)
        if(num_smpv.lt.num_smp) then
         call vfill(velsq(num_smpv),velsq(num_smpv+1),1,nvxtra)
        endif
       endif

      endif

c
c      START INPUT TRACE LOOP  * * * * * * * * * * * * * * * * * * * * 
c

       idead = 0
       ichk1 = 0
       ilive = 0
       if(jrec.eq.1) xmin_first = 100000000.

       do 200 jtrc=1,num_trc

c       
c       read input trace, note if dead and keep offset
c       save trace and header in memory

        jeof=0
        call rtape(luin,trace,jeof)
         if(jeof.le.0) then
          write(ltrm,*)'error in reading input'
          write(ltrm,*)'rec,trace=',jrec,jtrc
          write(lprt,*)'error in reading input'
          write(lprt,*)'rec,trace=',jrec,jtrc
          go to 1000
         endif
         if(itrh(125).eq.30000) then
c         if dead trace, clear and make offset ridiculous 
          call vclr(rtrd,1,num_smp)
          itrh(125) = 0
          xoff(jtrc)= 100.* xmax
          if(jrec.eq.1) idead = idead+1
         else
          xoff(jtrc) = itrh(119)*xsgn
          ilive = 1
         endif
         call vmov(trace,1,tracea( 1+len_in*(jtrc-1) ),1,len_in)

c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
c  *     Begin 1st record checks                                     *
c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

c       
c        compute parameters which are constant for 1st record
c
         if(jrec.eq.1 .and. ilive.eq.1) then
          ichk1 = ichk1 + 1
          if(ichk1.eq.1) then

c       
c          find cdp limits & 1st (zero offset) group and shot index 
c  
           icdp_first = itrh(122)
           gi0_first  = float(icdp_first)*cdpinc
           icdp_last  = icdp_first + num_rec - 1
           xcdp_first = 0.0
           xcdp_last  = float(icdp_last-icdp_first)*cdpinc

c
c          check signed distance convention
c   
cndw       comment this check out due to so much DISCO indexing
cndw 09-07-92
c          prod = ((itrh(118)-(itrh(109)/10.))*stainc)/itrh(119)
c          sgnflg=sign(1.,prod)
c          if(sgnflg.eq.-1.0) then
c           write(ltrm,*) 
c    &     'WARNING - POSSIBLE ERROR IN SIGNED TRACE DISTANCE'
c           write(lprt,*) 
c    &     'WARNING - POSSIBLE ERROR IN SIGNED TRACE DISTANCE'
c          endif

          endif

         endif

          if(jrec.eq.1) then

c         check if trace is a better candidate for the 1st trace 
c         on the line -- if it is use and update starting input
c         group index and starting template position
c         
          if(abs(xoff(jtrc)).le.xmax) then 
           if(xoff(jtrc).lt.xmin_first) then 
            xmin_first  = xoff(jtrc)
            igi_first   = itrh(118)
            isi10_first = itrh(109) 
            isi_first   = isi10_first/10
cdan        itmplt      = (xmax + xmin_first)/stainc + 1.5
            itmplt      = (xmax + xmin_first)/(2.*cdpinc) + 1.5
           endif
          endif

c          if ignore is set then set starting biases to 0
            if(ignore.ne.0) then
cgary        igi_first     = 0
cgary        isi10_first   = 0
cgary        isi_first     = 0
             igi_first     = (icdp_first/2)+xoff(jtrc)/(4.*cdpinc)
     1                     + 1.5
             isi_first     = igi_first-(xoff(jtrc)/(2.*cdpinc))
             isi10_first   = isi_first*10
            endif

           endif

c
c        end reading of input traces
c

  200    continue

c
c      END INPUT TRACE LOOP  * * * * * * * * * * * * * * * * * * * * * *
c

c        if we have read the 1st record, then: 
c        1. if the whole record is dead,abort
c        2. find starting template pointer
c        3. compute line biases for indexing                    

         if(jrec.eq.1) then 

c
c         check to see if first record has any live traces
c   
          if(idead.ge.num_trc) then
           write(ltrm,*) 'first record has all dead traces'
           write(lprt,*) 'first record has all dead traces'
           go to 1000
          endif

c   
c         determine which template fits the 1st record best 
c   
          itmplt_first = mod(itmplt,ncshot)
          if(itmplt_first.eq.0) itmplt_first = ncshot

c         if longest offset trace is within range write it's group 
c         index and the index computed from the first template
c         And coupute line biases for indices
c  
          if(itmplt.gt.0) then
           xgi_first = xcdp_first + basex(itmplt)/2. 
           igicomp   = nint( (gi0_first+basex(itmplt)/2.)/stainc )
           isicomp   = nint( (gi0_first-basex(itmplt)/2.)/stainc )
           isi10comp = nint(10.*(gi0_first-basex(itmplt)/2.)/stainc )
           igi_bias  = igi_first   - igicomp
           isi_bias  = isi_first   - isicomp
           is10_bias = isi10_first - isi10comp
cdan       write(ltrm,*)'itmplt,xgi_first,basex(itmplt)'
cdan       write(ltrm,*)itmplt,xgi_first,basex(itmplt)
cdan       write(ltrm,*)'is10,igi,isi bi',is10_bias,igi_bias,isi_bias
cdan       write(ltrm,*) 'first computed group index =',igicomp+igi_bias
cdan       write(ltrm,*) 'first group index from input data=',igi_first
cdan       write(ltrm,*) 'first computed si*10 =',isi10comp+is10_bias
cdan       write(ltrm,*) 'first si*10  =        ',isi10_first
          endif

         endif
 
c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
c       End 1st record checks -- normal record processing begins     *
c        Note: whether the 1st record or not, all the trace data     *
c               and trace headers are stored in tracea.  And the     *
c               and trace offsets are stored in xoff.                *
c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 




c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
c                                                                    *
c        Process output traces for this record                       *
c                                                                    *
c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

c
c       set initial parameters for this record
c
        xcdp_rec   = xcdp_first + (jrec-1)*cdpinc
        icdp       = icdp_first + jrec - 1
        gi0        = float(icdp)*cdpinc
        si0        = gi0
        isi0       = nint(si0/stainc) + isi_bias
        itmplt_rec = mod(jrec-1+itmplt_first,ncshot)
        if(itmplt_rec.eq.0) itmplt_rec = ncshot

   
c
c       BEGIN OUTPUT TRACE LOOP * * * * * * * * * * * * * * * * * * * 
c

        do 300 jtrco=1,num_trco

c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 

c  
c        set parameters for this trace
c
         jtmplt  = itmplt_rec + (jtrco-1)*ncshot
         yoff    = basex(jtmplt)
         igi     = nint(    (gi0+basex(jtmplt)/2.)/stainc )+igi_bias
         isi10   = nint(10.*(si0-basex(jtmplt)/2.)/stainc )+is10_bias
         y_group = xcdp_rec + yoff/2.
         y_shot  = xcdp_rec - yoff/2.
 
c
c        clear trace
c       
         call vclr(trace,1,len_in)
   

c  
c        build output trace headers
c  
         itrh(106) = jrec
         itrh(107) = jtrco
         itrh(108) = 0
         itrh(109) = isi10
         itrh(110) = 0
         itrh(111) = 0
         itrh(117) = abs(yoff)
         itrh(118) = igi
         itrh(119) = yoff
         itrh(122) = icdp
         itrh(125) = 0
         itrh(126) = 0
         itrh(127) = 0

c        Note:
c        ITRH(126&127) are set in mess to indicate fabricated trace
c        Not in this code!

c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

c      
c  * * * dead trace processing 
 
c        if y_shot < 1st cdp or >  last cdp or out of range of tmplt,
c          or y_group < 1st group of flag dead, and branch to loop end
c  
         if(y_shot.lt.xcdp_first .or. y_shot.gt.xcdp_last .or.
     &      jtmplt.gt.ntmplt .or. y_group.lt.xgi_first) then
          itrh(125) = 30000

c         branch to writing a trace
          go to 299

         endif
 

c      
c  * * * "close" trace processing 

c   
c        scan input traces for closest trace
c   
         xydiff  = 100000000.
         do j=1,num_trc
          diff = abs(yoff - xoff(j))
          if (diff.le.xydiff) then
           xydiff = diff
           jxy    = j
          endif
         enddo
         jxa = 1+len_in*(jxy-1)

c        If there is an input trace which is very close or nearby 
c        use it to create the output trace
c
         sgnx=sign(1.,xoff(jxy))
         sgny=sign(1.,yoff     )
         if(xydiff.le.xtol .and. sgnx.eq.sgny ) then

c         nmo from offset xoff to yoff

          call vmov(tracea(jxa),1,tracew,1,len_in)
          call xynmo(rtrdw, rtrd, num_smp, velsq, lvelsq,
     &    xoff(jxy),yoff,cdpinc,smp_int,iszbyt)                

c         if close enough - restore some orignial headers

          if(xydiff.lt.stainc) then
           itrh(110) = itrhw(110)
           itrh(111) = itrhw(111)
           itrh(127) = itrhw(127)
          endif

c         restore live trace flag and spdi
           itrh(108) = itrhw(108)

c         branch to writing a trace
          go to 299

         endif

c      
c  * * * "reciprocal" trace processing 

c
c        If you've gotten this far check reciprocal traces
c
         xydiff  = 100000000.
         do j=1,num_trc
          diff = abs(abs(yoff) - abs(xoff(j)))
          if (diff.le.xydiff) then
           xydiff = diff
           jxy    = j
          endif
         enddo
         jxa = 1+len_in*(jxy-1)

c        If there is a reciprocal trace which is very close or nearby 
c        use it to create the output trace
c  
         if(xydiff.le.xtol) then

c         nmo from offset xoff to yoff

          call vmov(tracea(jxa),1,tracew,1,len_in)
          call xynmo(rtrdw, rtrd, num_smp, velsq, lvelsq,
     &    xoff(jxy),yoff,cdpinc,smp_int,iszbyt)                

          itrh(108) = itrhw(108)

         endif

c      
c  * * * "fall through" trace processing (trace is zeroed above)

c         if you've gotten this far, there're no useful traces around
c         and the trace is already zeroed -- so use it
c

c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 

  299    continue

c
c       write output trace
c
        call wrtape(luout,trace,jeof)
         if(jeof.le.0) then
          write(ltrm,*)'error in writing output'
          write(ltrm,*)'rec,trace=',jrec,jtrco
          write(lprt,*)'error in writing output'
          write(lprt,*)'rec,trace=',jrec,jtrco
          go to 1000
         endif

  300   continue

c
c       END OUTPUT TRACE LOOP * * * * * * * * * * * * * * * * * * * * 
c

      if (verbos) then
         write(lprt,*)'input/output record = ', jrec
      endif

  100 continue

c
c      END RECORD LOOP  * * * * * * * * * * * * * * * * * * * * * * *
c




c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
c                                                                    *
c     End processing all of the output records                       *
c                                                                    *
c  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

c     Close Seismic Datasets

      write(ltrm,*) 'Normal Completion'
      write(lprt,*) 'Normal Completion'
      call lbclos(luin)
      call lbclos(luout)
      call lbclos(luv)
      stop

 1000 continue
      call lbclos(luin)
      call lbclos(luout)
      call lbclos(luv)
      write(ltrm,*) 'ABORT'
      write(lprt,*) 'ABORT'
      stop 1000
 
c     End Of Job
      end
      subroutine cmdlin(ntap,otap,vtrms,ipipi,ipipo,ipipv,ltrm,lprt,
     &cdpinc,stainc,spskew,ncshot,xmax,xtol,xsgn,dxt,ignore,verbos)
      integer argis
      logical help,verbos
      character*128 ntap,otap,vtrms
c     set defaults to no pipes
      ipipi = 0
      ipipo=0
      ipipv=0
      help = (argis( '-h' ).gt. 0) .or. (argis('-?') .gt. 0)
      if(help)then
        WRITE(LTRM,*)' SPLITSS -  SPLIT SPREAD SYNTHESIS'        
        WRITE(LTRM,*)' '
        WRITE(LTRM,*)' Input Specifications : '
        WRITE(LTRM,*)' '
        WRITE(LTRM,*)'-N[]      . INPUT DATASET'
        WRITE(LTRM,*)'-cdp[]    . CDP INTERVAL '
        WRITE(LTRM,*)'             (REQUIRED)'
        WRITE(LTRM,*)'-vt[]     . RMS VELOCITY DATASET'
        WRITE(LTRM,*)'          . (IF NONE - no nmo applied)'
        WRITE(LTRM,*)'-dxt[]    . TRACE SPACING ON VELOCITY DATASET'
        WRITE(LTRM,*)'             (default = cdp interval)'
        WRITE(LTRM,*)'-ignore[] . CDP (i.e. di) and GI/SP registration'
        WRITE(LTRM,*)'             (0 = perform normal registration)'
        WRITE(LTRM,*)'             (1 = GIs are wrong, override output)'
        WRITE(LTRM,*)' '
        WRITE(LTRM,*)'Output Specifications :'
        WRITE(LTRM,*)' '
        WRITE(LTRM,*)'-O[]      . OUTPUT DATASET NAME'
        WRITE(LTRM,*)'-ncs[]    . NUMBER OF CDP s PER SHOT'
        WRITE(LTRM,*)'             (must be 1,2,3,4,5,6,7,8,...)'
        WRITE(LTRM,*)'             (default = 2)'
        WRITE(LTRM,*)'-xmax[]   . MAXIMUM OFFSET ON OUTPUT'
        WRITE(LTRM,*)'             (required)'
        WRITE(LTRM,*)'-xtol[]   . FABRICATION TOLERANCE'
        WRITE(LTRM,*)'             (default = 8*CDP)'
        WRITE(LTRM,*)'-xsgn[]   . SIGNED TRACE DISTANCE MULTIPLIER'
        WRITE(LTRM,*)'             (should be -1 or +1. default=1.)'
        WRITE(LTRM,*)'-V        . INCLUDE ON COMMAND LINE FOR '
        WRITE(LTRM,*)'            VERBOSE PRINTOUT'
        WRITE(LTRM,*)'-?        . INCLUDE ON COMMAND LINE FOR '
        WRITE(LTRM,*)'            THIS MESSAGE'
        WRITE(LTRM,*)'-h        . INCLUDE ON COMMAND LINE FOR '
        WRITE(LTRM,*)'            THIS MESSAGE'
        WRITE(LTRM,*)
        STOP
      ENDIF
      call argstr('-N',ntap ,' ',' ')
      call argstr('-O',otap ,' ',' ')
      call argstr('-vt',vtrms ,' ',' ')
      call argr4 ('-cdp', cdpinc, 0.0, 0.0)
      call argr4 ('-dxt', dxt, cdpinc, cdpinc)
      call argi4 ('-ignore',ignore,0,0)
      toltem = 8.*cdpinc
      call argr4 ('-xtol', xtol, toltem, toltem)
      call argr4 ('-xmax', xmax, 0.0,0.0)
      call argr4 ('-xsgn', xsgn, 1.0,1.0)
      call argi4 ('-ncs', ncshot,0,0)
      verbos =   (argis('-V') .gt. 0)

      if(cdpinc.le.0.0) then
       write(lprt,*) 'cdp spacing in error --abort'
       write(ltrm,*) 'cdp spacing in error --abort'
       stop 100
      endif

      if(xmax.le.0.0) then
       write(lprt,*) 'xmax in error --abort'
       write(ltrm,*) 'xmax in error --abort'
       stop 100
      endif

      if(dxt.lt.cdpinc) then
       write(lprt,*) 'dx on velocity tape < cdpinc - ABORT'
       write(ltrm,*) 'dx on velocity tape < cdpinc - ABORT'
       stop 100
      endif

c     compute base coordinates
c     cdpinc = cdp     spacing
c     stainc = station spacing
c     igmul  = base group index multiplier 
c            = 1 if ncshot is even, 2 if ncshot is odd
c     spinc  = shot    spacing
       if(ncshot.lt.1) then
        write(lprt,*) '#cdps per shot =',ncshot
        write(lprt,*) '#cdps/shot is <= 1 '
        write(lprt,*) 'ABORT ---'
        write(ltrm,*) '#cdps per shot =',ncshot
        write(ltrm,*) '#cdps/shot is <= 1 '
        write(ltrm,*) 'ABORT ---'
        stop 100
       endif
      spinc = cdpinc*float(ncshot)
      if(ncshot.eq.ncshot/2*2+1) then
       stainc=cdpinc
      else
       stainc = cdpinc*2.
      endif

       if(xsgn.ge.0.0) xsgn=1.0
       if(xsgn.lt.0.0) xsgn=-1.0
c      template skew from center group (not read now)
       spskew = 0.0

      
c      make the ntap a pipe
      if(ntap.eq.' ' )ipipi = 1
c      make the otap a pipe
      if(otap.eq.' ' )ipipo = 1
c      bomb if not rms dataset (no vtrms no nmo ????)
      if(vtrms.eq.' ' ) then
       write(lprt,*) 'no velocity dataset - no nmo '
       write(ltrm,*) 'no velocity dataset - no nmo '
       ipipv = 1
      endif
       
      return
      end
      subroutine btmplt(pbasex,cdpinc,lbasex,
     &xmax,stainc,ncshot,spskew,iszbyt,lprt,ltrm)
c     computes base offset template:   basex
c     all needed templates are subsets of basex
      
      real basex(1)
      pointer (pbasex,basex)

c     basex      = base offset template 
c     lbasex     = length of basex (returned)
c     xmax       = max offset for basex
c     stainc     = trace spacing of basex = station increment
c     ncshot     = number of cdp's per shot
c     spskew     = shot bias (skew of template from center group)
c     iszbyt     = size of a word in bytes
 
c     compute half aperture
      xrate = cdpinc*2.*float(ncshot)
      nap   = ifix ( abs(xmax)/xrate+.5 )*xrate /(cdpinc*2.)

c     allocate memory for basex
      jerr  = 0
      lbasex = 2*nap + ncshot
      call galloc( pbasex, lbasex*iszbyt, jerr, 'ABORT')
      if ( jerr.ne. 0) then
       write(ltrm,*) 'memory allocation error in base distance template'
       write(lprt,*) 'memory allocation error in base distance template'
       stop 100
      endif

c     build the essential template

      basex(nap+1)       = 0.0
      do j=1,nap
      xbias              = float(j)* (cdpinc*2.0)
      basex(nap+1-j)     = -xbias  + spskew
      basex(nap+1+j)     = +xbias  + spskew
      enddo

c     pad the template -- to make things easier later

      do j=nap+1,nap+ncshot-1
      xbias              = float(j)* (cdpinc*2.)
      basex(nap+1+j)     = +xbias  + spskew
      enddo

c     reset xmax to first abs of first template
      xmax = abs(basex(1))


      return 
      end
      subroutine xynmo(datax,datay,num_smp,velsq,lvelsq,  
     &xoff,yoff,cdpinc,smp_int,iszbyt)
c     compute and apply nmo to datax and put in datay
c     datax is located at offset xoff and 
c     datay is located at offset yoff


c     input arrays:
      real datax(*),datay(*),velsq(*)

c     work arrays
      parameter (len=24000)
      integer ixx(len*4)
      real tab1(len),tab4(len*4),t0_sq(len),xxx(len*16)
      real tw(len),dataw(len*16),tx(len*4),ty(len*4)
      save tab1,tab4,xxx,ixx,t0_sq,tw,dataw,tx,ty

      integer iflag
      save iflag

      logical first
      save first
      data first/ .true. /
        


c     ***************************************
c     if lvelsq = 1, then no nmo is performed

      if (lvelsq.eq.1) then
       call vmov(datax,1,datay,1,num_smp)
       return
      endif

c     ***************************************


c     ***************************************
c     Begin first time pass

      if(first) then

c      set interpolation flag
       iflag = 1

c      initialize tables

       smp_int1 = smp_int/1000.
       smp_int4 = smp_int/4000.
       do jt=1,num_smp
       tab1(jt) = float(jt-1)*smp_int1
       t0_sq(jt) = tab1(jt)**2
       enddo
       do jt=1,num_smp*4
       tab4(jt) = float(jt-1)*smp_int4
       enddo
        
       first = .false.
        
      endif

c     End 1st time pass
c     ***************************************

        
c     ***************************************
c     if xoff close to yoff no nmo is done

      xydiff = abs(abs(xoff)-abs(yoff))
      if (xydiff .le. cdpinc/3.) then
       xoffsq = xoff**2
       itb    = num_smp
       do j=1,num_smp
        itc = sqrt(t0_sq(j)+xoffsq/velsq(j))/(smp_int/1000.)
        if(itc.lt.itb) itb = itc
       enddo
       call vmov(datax(itb),1,datay(itb),1,num_smp-itb+1)
       return
      endif

c     ***************************************


c     ***************************************
c     Process data: 

c                                            1/2
c     initialize tw to (t0**2+xoff**2/vel**2) 
        
      xoffsq = xoff**2
      do jt=1,num_smp
      tw(jt) = sqrt( t0_sq(jt)+xoffsq/velsq(jt) )
      enddo

c     interpolate tw -> tx (1 to 4)

      call lint4(tw,tx,num_smp)

c                                            1/2
c     initialize tw to (t0**2+yoff**2/vel**2)
        
      yoffsq = yoff**2
      do jt=1,num_smp
      tw(jt) = sqrt( t0_sq(jt)+yoffsq/velsq(jt) )
      enddo

c     interpolate tw -> ty (1 to 4)

      call lint4(tw,ty,num_smp)
        
c     interpolate input trace datax -> tw (1 to 4)           

      n4 = (num_smp-1)*4+1
      dt  = smp_int/4000.

      call ccuint(tab1,datax,num_smp,tab4,tw,n4,ixx,xxx,iflag)
      iflag = 0
      nxlast = ifix(tx(n4)/dt) + 1
      if(nxlast.gt.n4) call vclr(tw(n4+1),1,nxlast-n4)  

c     move tw (tx ) into datax (ty ) at 1/4 sample rate
                                              
      nylast = ifix(ty(n4)/dt+.5) + 1
      call vclr(dataw,1,nylast)
      do jt=1,n4
      dataw( ifix(ty(jt)/dt+.5) + 1 ) = tw( ifix(tx(jt)/dt+.5) + 1)
      enddo

 999  continue
c     put datax into datay (4 to 1)
      j4 = -3
      do jt=1,num_smp
      j4 = j4+4
      datay(jt) = dataw(j4)
      enddo

c     end subroutine
        
      return
      end
c               
c               
      subroutine lint4(avect,bvect,len)
c     lineary interpolate avect -> bvect (1 to 4)
      real avect(*),bvect(*)
        
      j4 = -3
      do j=1,len
      j4 = j4 + 4
      bvect(j4  ) =     avect(j)
      bvect(j4+1) = .75*avect(j) + .25*avect(j+1)
      bvect(j4+2) = .50*avect(j) + .50*avect(j+1)
      bvect(j4+3) = .25*avect(j) + .75*avect(j+1)
      enddo
        
      return
      end
