C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c subroutine to build cexp argumant tables
c
	subroutine bldargs (v,s,nkx,nw,nz,iz,kx2,nwlim,
     1			 nxfft2,w0,dw,iz0,argneg,argpos,
     3                   SZLNHD,dargp,dargn)
c
c
	integer	nkx,nw,iz,iz0,SZLNHD
	integer	iw,nz,ikx,nwlim
c
	real	omega,dw,w0
	real	viz,viz1,vizviz
        real    varg,sarg,siz
c
	real    v(nz),s(nz),kx2(nkx)
	real    argneg(SZLNHD)
	complex argpos(SZLNHD)
	real    posmax,negmax,dargp,dargn

      posmax = 0.
      negmax = 0.

        DO  iz = iz0, nz
 
        viz = v(iz)
        vizviz = viz * viz
        if (iz .gt. 1) then
            viz1 = v(iz-1)
        else
            viz1 = 0
        endif
        siz = s(iz)

	do iw=2,nwlim

           omega=(iw-1)*dw+w0
           varg = vizviz /(omega*omega)
           sarg = siz * omega

	   if(omega .ne. 0.0) then

	     if( (iz .eq. iz0) .or. (viz .ne. viz1) )then
c
c make the complex multipliers
c	
	       do ikx=1,nxfft2

                  disc = 1. - varg * kx2(ikx)

  		     if(disc .ge. 0.0)then
                       arga = sarg*sqrt(disc)
                       if (arga .ge. posmax) posmax = arga
  		     end if

  		     if(disc.lt.0.0)then
                       arga = sarg*sqrt(-disc)
                       if (arga .ge. negmax) negmax = arga
  		     end if

	       end do

	     end if

	   end if

c End of first frequency loop 
c
	end do
        ENDDO


      dargn = negmax / (SZLNHD - 1)
      dargp = posmax / (SZLNHD - 1)
      write(0,*)'posmax, negmax= ',posmax, negmax,dargn,dargp

      do  i = 1, SZLNHD
          arga = -float(i) * dargn
          argneg (i) = exp ( arga )
      enddo
      do  i = 1, SZLNHD
          arga = (i-1) * dargp
          argpos (i) = cexp (cmplx(0.,arga))
      enddo
c

c all done building tables
c
	return
	end
