C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------------top2pck--------------------------------------72
c
c Author Gary Murphy:Amoco Production Research:February 25, 1993
c
c top2pck reads a binmig topo file and creates xsd picks.
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c     declare variables
c
c ----- get machine dependent parameters -----
c

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c
c ----- dimension standard USP variables -----
c

      integer     luin,luout
      integer     argis


      character   name*7,topo*100,xsd*100

      logical     verbos,query


c ----- integer USP variables -----
c
c	itr   array: trace plus header from rtape
c       itrh  array: trace headers for record
c       lhed  array: line header
c       luin       : input device
c       lbytes     :
c       nbytes     :
c       obytes     :
c       argis      : 
c       JJ,KK      : loop counters
c       errcd1     : error flag from galloc
c       abort1     : abort flag from galloc
c
c ----- real USP variables -----
c
c	tri array  : working trace   
c
c ----- character USP variables -----
c
c	name       : for print file identification
c	topo       : input file name 
c       xsd        : output file name
c
c ----- logical USP variables -----
c
c	verbos     : printout verbosity flag
c	query      : online help flag
c
c
c ----- dimension program specific variables -----
c


      real        ref,dz,zmax

      logical     heap1

c ----- integer program variables -----
c
c
c ----- real program variables -----
c
c	ref         : reference surface
c
c ----- logical program variables -----
c
c	heap1      : flag used with galloc of vavgd array
c
c ----- set up useful hooks -----
c
 

c
c ----- initialize necessary variables -----
c

      data name/'TOP2PCK'/
      data luin/1/,lbytes/0/

      heap1 = .true.

c
c ----- get online help if necessary -----
c

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)

      if ( query ) then

           call help ()
           stop

      endif

c debug ----- ieee exception handler to find those mysterious bugs
c       
c       ieeer = ieee_handler ('set','Underflow',killit)
c -----

c
c ----- open printout files -----
c
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c

#include <f77/open.h>

c
c ----- get command line parameters -----
c

      call cmdln (topo,xsd,ref,dz,zmax,verbos)

c
c ----- get logical units -----
c

      call getln (luin,topo,'r',0)
      call getln (luout,xsd,'w',0)
      open(unit=luin,file=topo,status='old',err=2000)
      open(unit=luout,file=xsd,status='unknown',err=2080)


      write(LERR,*)'Input unit # is ',luin,' for DSN= ',topo
      write(LERR,*)'Output unit # is ',luout,' for DSN= ',xsd

c
c ----- printout -----
c

      call verbal(ref,dz,zmax)


c
c ----- malloc only space we're going to use -----
c

      itrc=0
      ntrc=0
      nelev=0
99    read(luin,*,end=100,err=99)elev
      itrc=itrc+1
      if(elev.ne.0.)then
         ntrc=itrc
      endif
      goto 99
100   continue
      rewind (luin)

c
c ----- print pick file header
c

       write (luout, 420) 1.0,1,ntrc,ifix(zmax/dz+1.5)
  420  format ('Units     1.000000     1.000000',f13.6,i9,2i7)
       write (luout, 430) 1
  430  format ('Segment =', i2)
 

c
c ----- output processed record ----
c

      itrc=0
199   read(luin,*,end=200,err=199)elev
      itrc=itrc+1
      if(elev.ne.0.)then
         write(luout,440)1.0,float(itrc),(ref-elev)/dz
440      format(f12.6,2f13.6)
      endif
      goto 199
200   continue

      


         if(verbos) then

            write(LERR,*) 'Processing complete.'

         endif


      close(luin)
      close(luout)
      goto 5000

2000  continue
      write (LERR,*) 'unable to open topo file'
      goto 5000

2080  continue
      write (LERR,*) 'unable to open output pick deck'
      goto 5000

5000  continue

      stop
      end

c
c ----- online help section -----
c

      subroutine  help

#include <f77/iounit.h>

        write(LER,*)'Command Line Arguments for top2pck'
        write(LER,*)'       '
        write(LER,*)'top2pck converts vel.crd to xsd picks'
        write(LER,*)' '
        write(LER,*)'-N[topo]      .. name of topo dataset'
        write(LER,*)'                 (no default)'
        write(LER,*)'-O[xsd]       .. output pick file'
        write(LER,*)'                 (no default)'
        write(LER,*)'-s[ref]       .. reference surface'
        write(LER,*)'                 (default is 0)'
        write(LER,*)'-dz[dz]       .. depth interval'
        write(LER,*)'                 (default is 10)'
        write(LER,*)'-z[zmax]      .. total depth'
        write(LER,*)'                 (default is 10)'
        write(LER,*)' '
        write(LER,*)'USAGE:'
        write(LER,*)'top2pck -N[] -O[] -s[] -dz[] -z[] -V'
        write(LER,*)' '
        write(LER,*)' '
        write(LER,*)' '


      return
      end

c
c ----- command line parsing subroutine -----
c

      subroutine cmdln (topo,xsd,ref,dz,zmax,verbos)

#include <f77/iounit.h>

      integer    argis

      real       dz, zmax
     
      character  topo*(*), xsd*(*)

      logical    verbos

          call argstr('-N',topo,' ',' ') 
          call argstr('-O',xsd,' ',' ') 

          call argr4('-s', ref, 0.0, 0.0)
          call argr4('-dz', dz, 10.0, 10.0)
          call argr4('-z', zmax, 10.0, 10.0)

          verbos = (argis('-V') .gt. 0)


      return
      end

      subroutine verbal(ref,dz,zmax)

#include <f77/iounit.h>

      
      real ref,dz,zmax

        write(LERR,*) ' '
        write(LERR,*)' Values read from command line'
        write(LERR,*) ' '
        write(LERR,*) ' Reference Surface  =  ', ref
        write(LERR,*) ' Depth Interval     =  ', dz
        write(LERR,*) ' Maximum Depth      =  ', zmax
        write(LERR,*) ' '

      return
      end
