C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: XYW2TXY     XYW -> TXY                                         *
C***********************************************************************
C
      subroutine xyw2txy( luinp, luout, verbos,
     &                    nrec1, irec1, irec2,
     &                    ntrc1, itrc1, itrc2,
     &                    nsmp1, ismp1, ismp2,
     &                    nt, ntoff, nw, iw1, nx, ny,
     &                    nrec2, ntrc2, nsmp2,
     &                    tfile, wm, memmax, ierr )
C
      implicit none
C
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
C
#include <ttds3d.h>
C
      logical verbos
      integer ibuf, ichnk, idata, ierr, ifltr, irec1, irec2,
     &        ismp1, ismp2, itab, itrc, itrc1, itrc2, iw1, iwrk, lbuf,
     &        lchnk, ldata, lfltr, lt, ltab, ltrc, luinp, luout, lwrk,
     &        memmax, mfree, nbrec, nrec1, nrec2, nsmp1, nsmp2,
     &        ntrc1, ntrc2, nw, nx, ny, nysl, nyslices, nt, ntoff, nwsl,
     &        nwslices
      real    wm(*)
      character tfile*128
C
C-----------------------------------------------------------------------
C
  901 format( /' ', 'MEMORY ALLOCATION:',
     1        /' ', '   MEMMAX   =', i10,
     2        /' ', '   LFLTR    =', i10,
     3        /' ', '   LTAB     =', i10,
     4        /' ', '   LTRC     =', i10,
     5        /' ', '   LWRK     =', i10,
     6        /' ', '   LDATA    =', i10,
     7        /' ', '   LCHNK    =', i10,
     8        /' ', '   LBUF     =', i10 )
  902 format( /' ', 'MORE COMPUTED PARAMETERS:',
     1        /' ', '   NYSL     =', i10,
     2        /' ', '   NYSLICES =', i10,
     3        /' ', '   NWSL     =', i10,
     4        /' ', '   NWSLICES =', i10,
     5        /' ', '   NBREC    =', i10 )
  911 format( /' ', '***** ERROR: INSUFFICIENT MEMORY SPACE ',/,
     &        ' ***** Please ask for more memory using -M flag *****'/ )
C
C-----------------------------------------------------------------------
C
C  ALLOCATE WORK SPACE
C
      lfltr = nw
      ltab  = 2 * nt
      ltrc  = max0( itrwrd+nsmp1, itrwrd+nsmp2 )
      lt    = nt + 3 - mod( nt, 2 )
      ldata = lt * nx
#ifdef CRAY
      lwrk  = 2 * nt * nx
#else
      lwrk  = 9 * nt / 2 + 18 * nx + 41
#endif

      mfree = memmax - lfltr - ltab - ltrc - ldata - lwrk
      call xyw2txy0( nx, ny, nw, mfree, nysl, nyslices,
     &               nwsl, nwslices, ierr )

      if( ierr .ne. 0 ) then
         write( luprt, 911 )
         ierr = 1003
         return
      endif
C
      lchnk = 2 * nx * nysl * nwsl
      lbuf  = 2 * max0( nx*ny*nwsl, nw*nx*nysl )
C
      ifltr = 1
      itab  = ifltr + lfltr
      itrc  = itab  + ltab
      iwrk  = itrc  + ltrc
      idata = iwrk  + lwrk
      ichnk = idata + ldata
      ibuf  = ichnk + lchnk
#ifdef SGISYSTEM
      nbrec = lchnk
#else
      nbrec = ISZBYT * lchnk
#endif
C
      if( verbos ) write( luprt, 901 ) memmax, lfltr, ltab, ltrc, lwrk,
     &                                 ldata, lchnk, lbuf
      if( verbos ) write( luprt, 902 ) nysl, nyslices, nwsl, nwslices,
     &                                 nbrec
C
      if( tfile .eq. ' ' ) then
         open( unit=lutmp, access='DIRECT', form='UNFORMATTED',
     &         recl=nbrec, status = 'SCRATCH' )
      else
         open( unit=lutmp, file=tfile, access='DIRECT',
     &         form='UNFORMATTED', recl=nbrec )
      endif

      call xyw2txy1( luinp, lutmp, luprt, nw, nx, ny,
     &               nysl, nyslices, nwsl, nwslices,
     &               nrec1, irec1, irec2,
     &               ntrc1, itrc1, itrc2,
     &               nsmp1, ismp1, ismp2,
     &               wm(itrc), wm(ichnk), wm(ibuf), ierr )
      if( ierr .ne. 0 ) go to 800
C
      call xyw2txy2( luout, lutmp, luprt, lt, nt, nx, ny, ntoff, nsmp2,
     &               nw, iw1, nysl, nyslices, nwsl, nwslices,
     &               wm(ifltr), wm(itab), wm(itrc), wm(iwrk), wm(idata),
     &               wm(ichnk), wm(ibuf), ierr )
C
  800 continue
      close( lutmp )
      return
C
      end
C
C=======================================================================
C
      subroutine xyw2txy0( nx, ny, nw, mfree, nysl, nyslices,
     &                     nwsl, nwslices, ierr )

      implicit none

      real p
      parameter ( p = 0.143 )

      integer nx, ny, nw, mfree, nysl, nyslices, nwsl, nwslices,
     &        ierr, mysl, mwsl, memreq, mreqy, mreqw
      real    r, y, w

c-----------------------------------------------------------------------

      if( mfree .le. 0 ) then
         ierr = 1
         return
      endif

      r    = float( 2*ny ) / float( nw )
      w    = sqrt( p * mfree / ( r * nx ) )
      y    = r * w / 2
      nwsl = nint( w )
      nysl = nint( y )

  110 continue
      if( nysl .le. 0 .or. nwsl .le. 0 ) then
         memreq = 2 * ( max0( nx*ny, nw*nx ) + nx )
         if( memreq .le. mfree ) then
            nysl = 1
            nwsl = 1
         else
            ierr = 1
            return
         endif
      else
         memreq = 2 * ( max0( nx*ny*nwsl, nw*nx*nysl ) + nx*nysl*nwsl )
         if( memreq .gt. mfree ) then
            nwsl = nwsl - 1
            nysl = nint( r * nwsl ) / 2
            go to 110
         endif
      endif

      if( nysl .gt. ny ) nysl = ny
      if( nwsl .gt. nw ) nwsl = nw

      nyslices = ( ny + nysl - 1 ) / nysl
      nwslices = ( nw + nwsl - 1 ) / nwsl

  120 continue
      if( nyslices .gt. 1 .and. nwslices .gt. 1 ) then
         nyslices = nyslices - 1
         nwslices = nwslices - 1
         nysl = ( ny + nyslices - 1 ) / nyslices
         nwsl = ( nw + nwslices - 1 ) / nwslices
         memreq = 2 * ( max0( nx*ny*nwsl, nw*nx*nysl ) + nx*nysl*nwsl )
         if( memreq .le. mfree ) then
            go to 120
         else
            nyslices = nyslices + 1
            nwslices = nwslices + 1
         endif
      endif

  130 continue
      nysl  = ( ny + nyslices - 1 ) / nyslices
      nwsl  = ( nw + nwslices - 1 ) / nwslices

      if( nyslices .gt. 1 ) then
         mysl  = ( ny + nyslices - 2 ) / ( nyslices - 1 )
         mreqy = 2 * ( max0( nx*ny*nwsl, nw*nx*mysl ) + nx*mysl*nwsl )
      else
         mreqy = mfree + 1
      endif

      if( nwslices .gt. 1 ) then
         mwsl  = ( nw + nwslices - 2 ) / ( nwslices - 1 )
         mreqw = 2 * ( max0( nx*ny*mwsl, nw*nx*nysl ) + nx*nysl*mwsl )
      else
         mreqw = mfree + 1
      endif

      if( mreqy .le. mfree ) then
         if( mreqw .le. mfree ) then
            if( mreqy .ge. mreqw ) then
               nyslices = nyslices - 1
               go to 130
            else
               nwslices = nwslices - 1
               go to 130
            endif
         else
            nyslices = nyslices - 1
            go to 130
         endif
      else
         if( mreqw .le. mfree ) then
            nwslices = nwslices - 1
            go to 130
         endif
      endif

      nysl = ( ny + nyslices - 1 ) / nyslices
      nwsl = ( nw + nwslices - 1 ) / nwslices

      ierr = 0
      return
      end
C
C=======================================================================
C
      subroutine xyw2txy1( luinp, lutmp, luerr, nw, nx, ny,
     &                     nysl, nyslices, nwsl, nwslices,
     &                     nrec1, irec1, irec2,
     &                     ntrc1, itrc1, itrc2,
     &                     nsmp1, ismp1, ismp2,
     &                     trace, chunk, buf, ierr )

      implicit none

c  arguments:

      integer luinp, lutmp, luerr, nx, ny, nw,
     &        nysl, nyslices, nwsl, nwslices, nrec1, irec1, irec2,
     &        ntrc1, itrc1, itrc2, nsmp1, ismp1, ismp2, ierr
      real    trace(*), chunk(nx,2*nysl,nwsl), buf(nx,2*ny,nwsl)

c  local variables:

      integer jrec, iy, jy1, jy2, jyslice, jw, jwslice, ky, loc

c-----------------------------------------------------------------------

      loc = 0
      jrec = irec1 - 1
      if( jrec .gt. 0 ) call sisseek( luinp, 1+jrec*ntrc1 )

c===  loop over w-slices

      do jwslice = 1, nwslices

c======  fill buf with an w-slice of data
c======  loop over w-planes; i.e., input records

         do jw = 1, nwsl
            jrec = jrec + 1
            if( jrec .le. irec2 ) then
               call rdrecnh( luinp, luerr, jrec, ntrc1, itrc1, itrc2,
     &                       nsmp1, ismp1, ismp2, 0, nx, 1, 2*ny, nx,
     &                       trace, buf(1,1,jw), ierr )
               if( ierr .ne. 0 ) then
                  ierr = 1500 + iabs( ierr )
                  return
               end if
            else
               call vclr( buf(1,1,jw), 1, 2*nx*ny )
            endif
         end do

c======  end of loop over w-planes

c======  get chunks of data from buf and write them to the temp file
c======  loop over y-slices

         jy2 = 0
         do jyslice = 1, nyslices
            jy1 = jy2 + 1
            jy2 = jy2 + nysl
            if( jy2 .gt. ny ) jy2 = ny
            ky = jy2 - jy1 + 1
            iy = 2 * jy1 - 1

c=========  get chunk from buf

            do jw = 1, nwsl
               call vmov( buf(1,iy,jw), 1, chunk(1,1,jw), 1, 2*nx*ky )
            end do

c=========  write chunk to temp file

            loc = loc + 1
            write( lutmp, rec=loc ) chunk

         end do

c======  end of loop over y-slices

      end do

c===  end of loop over w-slices

      ierr = 0
      return
      end
C
C=======================================================================
C
      subroutine xyw2txy2( luout, lutmp, luerr, lt, nt, nx, ny, ntoff,
     &                     nsmp2, nw, iw1, nysl, nyslices, nwsl,
     &                     nwslices, filter, table, trace, work,
     &                     dataout, chunk, buf, ierr )

      implicit none

c  arguments:

      integer luout, lutmp, luerr, lt, nt, nx, ny, ntoff, nsmp2,
     &        nw, iw1, nysl, nyslices, nwsl, nwslices, ierr
      real    filter(*), table(*), trace(*), work(*), dataout(lt,nx),
     &        chunk(nx,2,nysl,nwsl), buf(nx,2,nysl,nw)

c  local variables:

      integer ifac(19), iw, iy, jy, jy1, jy2, jyslice, jw, jw1, jw2,
     &        jwslice, loc

c-----------------------------------------------------------------------

      call fftfax( nt, ifac, table )

c===  loop over y-slices

      jy2 = 0
      do jyslice = 1, nyslices
         jy1 = jy2 + 1
         jy2 = jy2 + nysl
         if( jy2 .gt. ny ) jy2 = ny

c======  read a chunk of data from temp file and move it into buf
c======  loop over w-slices

         jw2 = 0
         do jwslice = 1, nwslices
            jw1 = jw2 + 1
            jw2 = jw2 + nwsl
            if( jw2 .gt. nw ) jw2 = nw

c=========  read a chunk of data from the temp file

            loc = ( jwslice - 1 ) * nyslices + jyslice
            read( lutmp, rec=loc ) chunk

c=========  move chunk into buf

            call vmov( chunk, 1, buf(1,1,1,jw1), 1, 2*nx*nysl*nwsl )

         end do

c======  end of loop over w-slices


c======  unfilter, transpose, transform, and write output records
c======  loop over y-planes; i.e., output records

         do jy = jy1, jy2
            iy = jy - jy1 + 1
            call vclr( dataout, 1, lt*nx )

c=========  move a plane from buf to dataout filtering and transposing
c=========  on the fly

            iw = 2 * iw1 - 2
            do jw = 1, nw
               iw = iw + 1
               call vsmul( buf(1,1,iy,jw), 1, filter(jw),
     &                     dataout(iw,1), lt, nx )
               iw = iw + 1
               call vsmul( buf(1,2,iy,jw), 1, filter(jw),
     &                     dataout(iw,1), lt, nx )
            end do

c=========  perform an inverse fft on the plane

            call rfftmlt( dataout, work, table, ifac, 1, lt, nt, nx, 1 )

c=========  write the output record (plane)

            call wrrecnh( luout, luerr, jy, nsmp2, 1, nx, lt, trace,
     &                    dataout(1+ntoff,1), ierr )
            if( ierr .ne. 0 ) then
               ierr = 1600 + iabs( ierr )
               return
            endif
         end do

c======  end of loop over y-planes

      end do

c===  end of loop over y-slices

      ierr = 0
      return
      end
