C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C*********************************************************************
C NAME:         CUBEVZ VELOCITY MODEL GENERATION            JUN 90   *
C*********************************************************************
C
C  PURPOSE:
C
C  USAGE:
C       vmod -O[otap] -C[card] [-V] [-h]
C
C       -O[otap]
C             Specifies 'otap' as the output SIS data set containing the
C             velocity functions. 
C
C	-C[card]
C		Specifies 'card' as the input card file. Must be
C		specified.
C
C       -V
C               Causes the program to generate verbose print output.
C
C       -h
C               Causes the program to write help information to the
C               standard output and then halts.
C
C  FILES:
C
C       otap	output velocity perturbation model consisting of one
C		record with each trace corresponding to an interval
C		velocity versus depth function.  Each function will
C		be used later to create a prestack migrated stack in
C  		program cubevz.
C
C*********************************************************************
C     AUTHOR:  Curtis Kruse
C     REVISED: Mary Ann Thornton     0l/30/92
C     Moved to sun for maintenance/distribution
C     REVISED: Mary Ann Thornton     06/01/92
C     Changed code to use saver, code now runs on 32 bit machine
C     Changed c-subroutines in lpinv.c so the code will run on the
C     Cray as well as the Sun.
C     Added +1 to MIDPERT calculation - David discovered this 
C     REVISED: Mary Ann Thornton     10/05/92
C              corrected computation of number of samples/trace
C     REVISED: Mary Ann Thornton     V: 3.2     07/08/93
C              Included hp.h so LTRM logical unit would not be 0 on HP
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

      PARAMETER (MXSAM=2048,MXTRA=256,MXSPH=6128,LHEAD=1500)
      PARAMETER (LPRT=26, LCRD=25, LLIST=27, MXTOT=MXSAM*MXTRA)
C
      DIMENSION IHEAD(LHEAD)
      DIMENSION RXX(MXSAM+ITRWRD),DATA(MXSAM)

C
      INTEGER*2 IRX(LNTRHD)
C
      LOGICAL VERBOS
      CHARACTER*1   PARR(66)
      CHARACTER*4  PPNAME
      CHARACTER*4  VERSION
      CHARACTER*128 OTAP,INPUT

      REAL TIMDEP(MXSAM)
      REAL RATIOMIN(MXSAM),RATIOMAX(MXSAM)
      REAL DEPTH(0:MXSAM)
      REAL VEL(MXTOT)
      REAL MINV,MAXV,DELTAV,MINIMUM,MAXIMUM
      INTEGER NUMPERT,BEGPERT,ENDPERT,IRFLAG,TDFLAG,SBFLAG
      REAL MAXDEPTH
      INTEGER DEFAULT

      REAL ZVEL(MXTOT),ZDEPTH(MXTOT)

      REAL TIMEMIN(0:MXSAM),TIMEMAX(0:MXSAM),TIMEMID(0:MXSAM)
      REAL VINTMIN(MXSAM),VINTMAX(MXSAM),VINTMID(MXSAM)
      REAL VMIN(0:MXSAM),VMAX(0:MXSAM),VMID(0:MXSAM)
      REAL VELT(0:MXSAM)
      REAL TEMP(0:MXSAM)
      LOGICAL DEBUG1,DEBUG2,DEBUG3
      INTEGER RMNFLAG,RMXFLAG,VMINFLAG,VMIDFLAG,VMAXFLAG
C
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))

C
      DATA VERSION/' 3.2'/
      DATA PPNAME/'VMOD'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ',' ','V','E','L','O','C','I','T','Y',' ','F','U','N','C',
     3'T','I','O','N',' ','P','E','R','T','U','R',
     3          'B','A','T','I','O','N','S',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/
C
C     (LTRM) TERMINAL=0 , EXCEPT WHEN USING PIPES, THEN TERMINAL=2
C
      LTRM = LER
      CALL cmdlin(OTAP,INPUT,IPIPO,LTRM,VERBOS,
     &  DEBUG1,DEBUG2,DEBUG3)

      IF(IPIPO.EQ.0) THEN
C        LUOUT IS AN OUTPUT DATASET
         CALL LBOPEN(LUOUT,OTAP,'w')
      ELSE
C        WE KNOW LUOUT IS A PIPE
         LUOUT = 1
      ENDIF

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     OPEN PRINTOUT
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      JERR = 0
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)

      IF(OTAP.NE.' ')WRITE(LPRT,900)OTAP
900   FORMAT(' OUTPUT VELOCITY FUNCTION DATASET = '/,A128)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     OPEN CARD FILE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      JERR = 0
      IF(INPUT.NE.' ')THEN
         OPEN(UNIT=LCRD,FILE=INPUT,STATUS='OLD',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE(LPRT,*)' ERROR OPENING INPUT CARD FILE'
            STOP 50
         ENDIF
      ELSE
         N=ICOPEN('-vmod.crd',LCRD)
            IF(N.EQ.0)THEN
               WRITE(LPRT,*)'  YOU MUST SUPPLY INPUT PARAMETERS'
               STOP 50
            ENDIF
      ENDIF

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ INPUT CARDS, SET UP JOB PARAMETERS, WRITE THEM OUT         C
C     JOBNAM = MOD DATASET NAME, FMIN-FMAX=FREQUENCY LIMITS
C     IPADTR-IPADRC=EITHER PAD OR NO PAD TRACES & RECORDS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL READCARD(LCRD,LPRT,NUMPERT,DELTAV,MINV,MAXV,
     &       BEGPERT,ENDPERT,IRFLAG,TDFLAG,
     &       MAXDEPTH,DELTAZ,DELTAT,
     &       TIMDEP,VMIN(1),VMAX(1),VMID(1),RATIOMIN,RATIOMAX,NDEPTH)

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      RMNFLAG=0
      RMXFLAG=0
      VMIDFLAG=0
      VMINFLAG=0
      VMAXFLAG=0
      DO 1131 I=1,NDEPTH
         IF(RATIOMIN(I).NE.0.) RMNFLAG=1
         IF(RATIOMAX(I).NE.0.) RMXFLAG=1
         IF(VMID(I).NE.0.)     VMIDFLAG=1
         IF(VMIN(I).NE.0.)     VMINFLAG=1
         IF(VMAX(I).NE.0.)     VMAXFLAG=1
1131  CONTINUE
      IF((VMINFLAG.EQ.1.OR.VMAXFLAG.EQ.1).AND.
     &   (RMNFLAG.EQ.1.OR.RMXFLAG.EQ.1))THEN
         WRITE(LPRT,*)
     &'Input velocities can be in terms of VMIN and VMAX or'
      WRITE(LPRT,*)
     & 'in terms of RATIOMIN and RATIOMAX. Both cannot be used.' 
         STOP 10
      ENDIF
C     -----interpolate unfilled values in input--------
      IF(VMIDFLAG.EQ.1)THEN
         IF(DEBUG1)WRITE(LPRT,*)"FILLING IN VMID VALUES"
         CALL INFILL(VMID(1),TIMDEP,NDEPTH)
      ENDIF

      IF(RMNFLAG.EQ.1 .AND. RMXFLAG.EQ.1 .AND. VMIDFLAG.EQ.1)THEN
         IF(DEBUG1)WRITE(LPRT,*)"FILLING IN RATIOMIN VALUES"
         CALL INFILL(RATIOMIN,TIMDEP,NDEPTH)
         CALL INFILL(RATIOMAX,TIMDEP,NDEPTH)
         DO 7812 I=1,NDEPTH
            IF(RATIOMIN(I).LT.0. .OR. RATIOMIN(I).GT.1.)THEN
               WRITE(LPRT,*)"ERROR: RATIOMIN must be >0 and <1."
               STOP 20
            ENDIF
            IF(RATIOMAX(I).LT.1. .OR. RATIOMAX(I).GT.100.)THEN
               WRITE(LPRT,*)"ERROR: RATIOMAX must be >1 and <100"
               STOP 20
            ENDIF
            VMIN(I)=RATIOMIN(I)*VMID(I)
            VMAX(I)=RATIOMAX(I)*VMID(I) 
            
 7812    CONTINUE
      ELSE IF(VMINFLAG.EQ.1 .AND. VMAXFLAG.EQ.1) THEN
         CALL INFILL(VMIN(1),TIMDEP,NDEPTH)
         CALL INFILL(VMAX(1),TIMDEP,NDEPTH)
      ELSE
         WRITE(LPRT,*)"ERROR: Not enough velocity information is"
     & , " present in input cards."
         STOP 10
      ENDIF

      IF(VMIDFLAG.NE.1)THEN
         WRITE(LPRT,*)"INTERPOLATING VMIN AND VMAX TO GET VMID"
         DO 3671 I=1,NDEPTH
            VMID(I)=(VMIN(I)+VMAX(I))/2.
             write(LPRT,*)"vmid(",i,")=",vmid(i)," = ( ",vmin(i),
     &   " + ",vmax(i)," )/2."
3671     CONTINUE
      ENDIF

C_________________________
C      DO 4536 i=1,NDEPTH
C         WRITE(LPRT,334)VMIN(I),VMAX(I),VMID(I),RATIOMIN(I),RATIOMAX(I)
C334      FORMAT(10X,5F8.2)
C4536  CONTINUE
c+++++++++++++++++++++++++         
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     PARAMETER CHECKING
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C   READ THE LINE HEADER AND PICK OUT PARAMETERS NEEDED TO READ TRACES*
C   LTR   = NUMBER OF TRACES PER RECORD
C   NREC  = NUMBER OF RECORDS PER JOB
C   ISI   = SAMPLE RATE INTERVAL (I.E. 4 INDICATES 4 MILLISECONDS)
C   KSAMP = NUMBER OF DATA SAMPLES PER TRACE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IF(DELTAZ.EQ.0.)DELTAZ=20.
      IF(DELTAZ.NE.0.) NSAMP = NINT(MAXDEPTH/DELTAZ + 1.)
      IF(NSAMP.EQ.0)THEN
           NSAMP = 100
           WRITE(LPRT,*)'NSAMP = 0'
      ENDIF
      IF(ENDPERT.EQ.0.AND.BEGPERT.GE.0)THEN
          ENDPERT=NUMPERT
          BEGPERT = 1
      ENDIF
      NTR = ENDPERT - BEGPERT + 1

      call vclr(ihead,1,lhead)
      CALL VCLR(IRX,1,ITRWRD)

      IF(DELTAT.EQ.0.) DELTAT=8.
      ISI = DELTAT

      IF(NSAMP.GT.MXSAM)THEN
         WRITE(LPRT,*)NSAMP," OUTPUT SAMPLES IS GREATER THAN ",MXSAM
         WRITE(LPRT,*)
     &  "EITHER REDUCE MAXDEPTH OR INCREASE DEPTH SAMPLE INTERVAL" 
         STOP 100
      ENDIF

      idt = DELTAZ*1000.
      numrec = 1
      ifmt = 3
      call savew(ihead,'NumSmp',nsamp,linhed)
      call savew(ihead,'NumRec',numrec,linhed)
      call savew(ihead,'SmpInt',isi,linhed)
      call savew(ihead,'NumTrc',ntr,linhed)
      call savew(ihead,'Format',ifmt,linhed)
      call savew(ihead,'Dz1000',idt,linhed)

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     SET DEFAULTS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IF (BEGPERT.EQ.0.AND.ENDPERT.EQ.0) THEN 
          BEGPERT = 1
          ENDPERT = NUMPERT
      ENDIF
      IF (IRFLAG.EQ.0) THEN IRFLAG = 1
      IF (TDFLAG.EQ.0) THEN TDFLAG = 1


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCT
C   HLH WILL PRINT LINEHEADER AND UPDATE THE HISTORICAL PORTION       *
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      LEN=4
CMAT  NBYTES=3144
      NBYTES=393*ISZBYT
      JCOF = NBYTES
      CALL HLHPRT(IHEAD,JCOF,PPNAME,LEN,LPRT)

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C      WRITE PARAMETERS TO USER REPORT
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      WRITE(LPRT,271)NUMPERT,DELTAV

271   FORMAT(//,7X, 'INPUT PARAMETERS AFTER DEFAULTS:',
     &       //,'NUMBER OF VELOCITY FUNCTIONS..............',4X,I5,
     &       //,'DELTA VELOCITY (MAXIMUM BLOCKING ERROR)...',1X,F8.2)


      MINIMUM = 100000 
      MAXIMUM = 0
      DO 231 I=1,NDEPTH
          IF((MINIMUM.GT.VMIN(I).AND.VMIN(I).NE.0).OR.MINIMUM.EQ.0)
     &                   MINIMUM = VMIN(I)
          IF(MAXIMUM.LT.VMAX(I))MAXIMUM=VMAX(I)
231   CONTINUE

      IF(MINV.EQ.0.0) THEN
          DEFAULT = 1            
          MINV = MINIMUM
      ENDIF
      WRITE(LPRT,272)MINV
272   FORMAT(//,'MINIMUM VELOCITY..........................',1X,F8.2,$)
      IF(DEFAULT.EQ.1)WRITE(LPRT,*)' DEFAULT'
      IF(DEFAULT.EQ.0)WRITE(LPRT,*)'       '
      DEFAULT = 0
      iminv = minv
      call savew(ihead,'MinVel',iminv,linhed)

      IF(MAXV.EQ.0.0) THEN
          DEFAULT =  1
          MAXV = MAXIMUM
      ENDIF
      WRITE(LPRT,273)MAXV
273   FORMAT(//,'MAXIMUM VELOCITY..........................',1X,F8.2,$)
      IF(DEFAULT.EQ.1)WRITE(LPRT,*)' DEFAULT'
      IF(DEFAULT.EQ.0)WRITE(LPRT,*)' '
      DEFAULT = 0
      imaxv = maxv
      call savew(ihead,'MaxVel',imaxv,linhed)


      WRITE(LPRT,275)BEGPERT,ENDPERT
275   FORMAT(//,'BEGINNING PERTURBATION....................',1X,I8,
     &       //,'ENDING PERTURBATION.......................',1X,I8)

      WRITE(LPRT,276)MAXDEPTH,DELTAZ
276   FORMAT(//,'MAXIMUM DEPTH.............................',1X,F8.2,
     &       //,'DELTA Z...................................',1X,F8.2)


      WRITE(LPRT,279)NTR,NSAMP
279   FORMAT(//,'NUMBER OF TRACES...........................',1X,I8,
     &       //,'NUMBER OF SAMPLES..........................',1X,I8)

      IF(NUMPERT.LT.2)NUMPERT=2

      WRITE(LPRT,*)' '
      IF(TDFLAG.EQ.1)THEN
         WRITE(LPRT,'("INPUT VELOCITY FUNCTIONS ARE IN TIME",$)')
      ELSE
         WRITE(LPRT,'("INPUT VELOCITY FUNCTIONS ARE IN DEPTH",$)')
      ENDIF

      IF(IRFLAG.EQ.1)THEN
         WRITE(LPRT,*)'AND INTERVAL VELOCITY'
      ELSE
         WRITE(LPRT,*)'AND RMS VELOCITY'
      ENDIF

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     PARAMETER CHECKING
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IF(DEBUG1)THEN
          WRITE(LPRT,*)' '
          IF(IRFLAG.EQ.1)WRITE(LPRT,*)
     &    '                 INTERVAL VELOCITY'
          IF(IRFLAG.EQ.2)WRITE(LPRT,*)'                 RMS VELOCITY'
          IF(TDFLAG.EQ.1)THEN
              WRITE(LPRT,*)'        TIME     VMIN     VMAX'
          ELSE
              WRITE(LPRT,*)'       DEPTH    VMIN     VMAX'
          ENDIF

         do 1332 I = 1,NDEPTH
             WRITE(LPRT,1342)I,TIMDEP(I),VMIN(I),VMAX(I)
1342    FORMAT(I4,1X,3(F8.0,1X))
1332     CONTINUE
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     INTERPOLATE VELOCITY FUNCTIONS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     ------convert from rms velocity to interval velocity--------
      IF(IRFLAG.EQ.2)THEN
          CALL TLP2TINT(VMIN(1),NDEPTH,VINTMIN,2.)
          CALL TLP2TINT(VMAX(1),NDEPTH,VINTMAX,2.)
          CALL TLP2TINT(VMID(1),NDEPTH,VINTMID,2.)
      ELSE
          CALL VMOV(VMIN(1),1,VINTMIN,1,NDEPTH)
          CALL VMOV(VMAX(1),1,VINTMAX,1,NDEPTH)
          CALL VMOV(VMID(1),1,VINTMID,1,NDEPTH)
      ENDIF

C     -------determine global minimum and maximum velocities--------
      GLMINV = VINTMIN(1)
      GLMAXV = VINTMAX(1)
      DO 200 I = 1,NDEPTH
          IF (GLMINV.GT.VINTMIN(I)) GLMINV = VINTMIN(I)
          IF (GLMAXV.LT.VINTMAX(I)) GLMAXV = VINTMAX(I)
200   CONTINUE


C     -------convert from depth to time-------------
      IF(TDFLAG.EQ.2)THEN
          CALL NLD2NLT(VINTMIN,TIMDEP,NDEPTH,TIMEMIN(1))
          CALL NLD2NLT(VINTMAX,TIMDEP,NDEPTH,TIMEMAX(1))
          CALL NLD2NLT(VINTMID,TIMDEP,NDEPTH,TIMEMID(1))
      ELSE
          CALL VSMUL(TIMDEP,1,.001,TIMEMIN(1),1,NDEPTH)
          CALL VSMUL(TIMDEP,1,.001,TIMEMAX(1),1,NDEPTH)
          CALL VSMUL(TIMDEP,1,.001,TIMEMID(1),1,NDEPTH)
      ENDIF

      IF(DEBUG2) THEN
          WRITE(LPRT,*)' '
          WRITE(LPRT,*)'     TIMEMIN  VINTMIN  TIMEMAX  VINTMAX'
     &  ,'  TIMEMID  VINTMID'
          DO 1235 I = 1,NDEPTH
              WRITE(LPRT,1236)
     &       I,1000*TIMEMIN(I),VINTMIN(I),
     &         1000*TIMEMAX(I),VINTMAX(I)
     &        , 1000*TIMEMID(I),VINTMID(I)
1236          FORMAT(I4,6(1X,F8.0))
1235      CONTINUE
      ENDIF


C__________________________
      IF(VERBOS) THEN
      WRITE(LPRT,*)" "
      WRITE(LPRT,*)" BEFORE RESAMPLING"
      WRITE(LPRT,*)"            VMIN        VMID        VMAX "
      WRITE(LPRT,88387)(IZ,VINTMIN(IZ),VINTMID(IZ),VINTMAX(IZ)
     &   ,IZ=1,NDEPTH)   
88387 FORMAT(I4,") ",3F12.0)
      ENDIF
C++++++++++++++++++++++++++

C     --------resample to a regular time sample interval--------
      DT = DELTAT*.001
      IF(DT.EQ.0)DT=.002
      NT = TIMEMIN(NDEPTH)/DT +1
      IF(NT.GT.MXSAM)THEN
         NT=MXSAM
         DT = TIMEMIN(NDEPTH)/(NT-1)
         WRITE(LPRT,*)"DELTAT RESET TO ",1000*DT
      ENDIF
      CALL LINTERP(VINTMIN,TIMEMIN(1),NDEPTH,VMIN(0),DT,NT+1)
      CALL LINTERP(VINTMAX,TIMEMAX(1),NDEPTH,VMAX(0),DT,NT+1)
      CALL LINTERP(VINTMID,TIMEMID(1),NDEPTH,VMID(0),DT,NT+1)

C___________________________
      IF(VERBOS) THEN
      write(LPRT,*)" "
      write(LPRT,*)" AFTER RESAMPLING TO REGULAR GRID "
      WRITE(LPRT,*) NT," samples   " ,DT,"=TIME SAMPLE INTERVAL"
      WRITE(LPRT,*)"            VMIN        VMID        VMAX "
      do 23045 IT=1,NT,NT/50
         write(LPRT,23046)IT,VMIN(IT),VMID(IT),VMAX(IT)
23046 FORMAT(I4,") ",3F12.0)
23045 continue
      ENDIF
C+++++++++++++++++++++++++++
          
C     ------interpolate functions----------------
      I = 0 
      MIDPERT=NUMPERT/2 + 1
      DO 400 IP = BEGPERT,ENDPERT
          I = I + 1
       
          IF(IP.LE.MIDPERT)THEN

C             CBEG = (MIDPERT-BEGPERT+1-IP)*1./(MIDPERT-BEGPERT)
             CBEG = (MIDPERT-IP)*1./(MIDPERT-1)

             CMID = (IP-1)*1./(MIDPERT-1)
C            CMID = (IP-BEGPERT)*1./(MIDPERT-1)

             CEND = 0.

          ELSE

             CBEG = 0.

             CMID = (NUMPERT-IP)*1./(NUMPERT-MIDPERT)

             CEND = (IP-MIDPERT)*1./(NUMPERT-MIDPERT)

          ENDIF                     
       IF(VERBOS)THEN
       WRITE(LPRT,*)"IP=",IP," CBEG=",CBEG," CMID=",CMID," CEND=",CEND

       ENDIF



          IZ = (I-1)*NT+1
          DO 500 IT = 1,NT      
              VELT(IT) = CBEG*VMIN(IT)+CMID*VMID(IT)+CEND*VMAX(IT)
500       CONTINUE

          VELT(0)=VELT(1)

C         --------convert from time to depth
          NZ = NSAMP
          IV = (I-1)*NZ +1
          CALL T2NLD(VELT,NT+1,DT,DEPTH)
 
          CALL VMOV(VELT(1),1,ZVEL(IZ),1,NT)
          CALL VMOV(DEPTH(1),1,ZDEPTH(IZ),1,NT)
         
C         --------interpolate to regular depth sample interval----
          CALL LINTERP(VELT,DEPTH,NT+1,TEMP,DELTAZ,NSAMP+1)
          CALL VMOV(TEMP(1),1,VEL(IV),1,NSAMP)


C         -------blocking into constant velocity layers--------

          IF(DELTAV.GT.0)THEN
              CALL VELBLOCK(VEL(IV),NSAMP,DELTAV)
          ENDIF
400   CONTINUE



C------------------------------------------------------
         IF(VERBOS) THEN
         WRITE(LPRT,*)" "
         write(LPRT,6004)BEGPERT,MIDPERT,ENDPERT       
6004     FORMAT("    DEPTH     VEL(",I3,")    VEL(",I3
     &                     ,")    VEL(",I3,")")
          IVB = 1
          IVM = (MIDPERT-BEGPERT)*NZ +1
          IVE = (ENDPERT-BEGPERT)*NZ +1
          do 1394 I=1,NZ,NZ/50
         WRITE(LPRT,9338)I*DELTAZ,VEL(IVB+I),VEL(IVM+I),VEL(IVE+I)
9338     FORMAT(F10.2,4F12.0)
1394      CONTINUE
          ENDIF
C------------------------------------------------------




CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     OUTPUT VELOCITY FUNCTION PERTURBATION DATASET
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL WRTAPE(LUOUT,IHEAD,JCOF)
      LA = 1
      IRX(106) = 1
      JEOF = (ITRWRD+NSAMP)*ISZBYT
         DO 600 L= 1,NTR
            IRX(107) = L
            CALL VMOV(VEL(LA),1,DATA,1,NSAMP)
            CALL WRTAPE(LUOUT,RXX,JEOF)
            LA = LA + NSAMP
600    CONTINUE


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      WRITE(LPRT,*) ' JOB COMPLETE'
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(6,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER FROM TAPE')
      CALL LBCLOS(LUOUT)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(6,1510)MR,L
 1510 FORMAT(2X,'TAPEIO ERROR PROCESSING OUTPUT RECORD',I5,' TRACE',I5)
      CALL LBCLOS(LUOUT)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR READING CARDS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
3000  CONTINUE
      WRITE(6,3011)
3011  FORMAT(2X,'ERROR READING PARAMETER CARD')
      CALL LBCLOS(LUOUT)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                             END OF JOB                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 5000 CONTINUE
      CALL LBCLOS(LUOUT)
      STOP
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       cmdlin                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      cmdlin  (NTAP,OTAP,NS,PIPI,IPIPO,LTRM,VERBOS)                    *
C  ARGUMENTS:                                                          *
C      NTAP    CHAR*128  ??IOU* -                                      *
C      OTAP    CHAR*128  ??IOU* -                                      *
C      NS      INTEGER   ??IOU* -                                      *
C      IPIPI   INTEGER   ??IOU* -                                      *
C      IPIPO   INTEGER   ??IOU* -                                      *
C      LTRM    INTEGER   ??IOU* -                                      *
C      VERBOS  LOGICAL   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 88/03/16  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/03/16  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      ARGSTR          -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LTRM  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE cmdlin(OTAP,INPUT,IPIPO,LTRM,VERBOS,
     & DEBUG1,DEBUG2,DEBUG3)
      INTEGER ARGIS
      LOGICAL HELP,VERBOS
      LOGICAL DEBUG1,DEBUG2,DEBUG3
      CHARACTER*128 OTAP,INPUT
C     SET DEFAULTS TO NO PIPES
      IPIPO=0
      VERBOS=.FALSE.
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS--VELOCITY PERTURBATIONS'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-O[otap]     . OUTPUT DATASET NAME OF VELOCITY '
         WRITE(LTRM,*)'             . FUNCTION DATASET'
         WRITE(LTRM,*)'-C[card]     . INPUT PARAMETER CARD FILE' 
         WRITE(LTRM,*)'-V           . VERBOSE PRINTOUT'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'vmod -O[] -C[]'
         STOP
      ENDIF
      CALL ARGSTR('-O',OTAP ,' ',' ')
      CALL ARGSTR('-C',INPUT,' ',' ')
      VERBOS =   (ARGIS( '-V' ).GT.0)

      DEBUG1 =   (ARGIS( '-D1' ).GT.0)
      DEBUG2 =   (ARGIS( '-D2' ).GT.0)
      DEBUG3 =   (ARGIS( '-D3' ).GT.0)
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

      SUBROUTINE READCARD(LCRD,IPRT,NUMPERT,DELTAV,MINV,MAXV,
     &       BEGPERT,ENDPERT,IRFLAG,TDFLAG,
     &       MAXDEPTH,DELTAZ,DELTAT,
     &       TIMDEP,VMIN,VMAX,VMID,RATIOMIN,RATIOMAX,NDEPTH)

      PARAMETER (MXSAM=2048)

      INTEGER LCRD,IPRT
      REAL DELTAV,MINV,MAXV,MAXFREQ
      REAL MAXDEPTH,DELTAZ,DELTAT
      INTEGER NUMPERT,BEGPERT,ENDPERT
      INTEGER IRFLAG,TDFLAG,SBFLAG,NDEPTH 
      REAL TIMDEP(MXSAM),VMIN(MXSAM),VMAX(MXSAM),VMID(MXSAM) 
      REAL RATIOMIN(MXSAM),RATIOMAX(MXSAM)


      CHARACTER*1  CARD(80)
      CHARACTER*4 NAME
      EQUIVALENCE (CARD(1),NAME)

      DO 200 J=1,999
         READ(LCRD,77,ERR=3000,END=999)CARD
   77    FORMAT(80A1)
                            
         IF(NAME.EQ.'VEL ')THEN
           READ(LCRD,300,ERR=3000,END=999)NUMPERT,
     &     DELTAV,MINV,MAXV,MAXFREQ
  300      FORMAT(10X,I10,4F10.0)
 
         ELSE IF(NAME.EQ.'PERT')THEN
           READ(LCRD,301,ERR=3000,END=999)
     &     BEGPERT,ENDPERT             
  301      FORMAT(10X,2I10)
 
         ELSE IF(NAME.EQ.'INPU')THEN
           READ(LCRD,303,ERR=3000,END=999)
     &     IRFLAG,TDFLAG,SBFLAG
  303      FORMAT(10X,3I10)

         ELSE IF(NAME.EQ.'OUTP')THEN
           READ(LCRD,302,ERR=3000,END=999)
     &     MAXDEPTH,DELTAZ,DELTAT
  302      FORMAT(10X,3F10.0)

         ELSE IF(NAME.EQ.'VELO')THEN
           DO 707 I=1,MXSAM               
              inum = i
              READ(LCRD,305,ERR=709,END=708)
     &        NAME,TIMDEP(I),VMIN(I),VMAX(I),
     &        VMID(I),RATIOMIN(I),RATIOMAX(I)
  305         FORMAT(A4,6X,BN,7F10.0)
              IF(NAME.NE.'    '.AND.NAME.NE.'VELO')GOTO 709
              IF(I.GT.1.AND.TIMDEP(I).LT.TIMDEP(I-1))THEN
                WRITE(IPRT,343)TIMDEP(I-1),VMIN(I-1),
     &          VMAX(I-1),VMID(I-1),RATIOMIN(I-1),RATIOMAX(I-1) 
                WRITE(IPRT,344)TIMDEP(I),VMIN(I),VMAX(I),
     &          VMID(I),RATIOMIN(I),RATIOMAX(I)
343             FORMAT(/,'** ERROR TIMES MUST INCREASE',/
     &          '     DEPTH      VMIN      VMAX      VMID     ',
     &          'RATIOMIN     RATIOMAX',/
     &          ,7F10.2)
344             FORMAT(7F10.2)
              ENDIF
707         CONTINUE
 
709       CONTINUE
          BACKSPACE(LCRD)
        ENDIF

708   CONTINUE
200   CONTINUE
      GOTO 999
 
3000  CONTINUE
      WRITE(IPRT,*)'ERROR READING INPUT CARDS'
999   CONTINUE
      NDEPTH = inum-1
      RETURN
      END

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C#   +    1    +    2    +    3    +    4    +    5    +    6    +    7
CVEL MODEL   # FUNCTS    DELTAV  MIN_VINT  MAX_VINT 
C                  40       500      1400      6500 
CPERTURBNO      BEG #     END #
C                   0         0
CINPUT        INT/RMS   TIM/DEP  
C                   1         1   
COUTPUT      MAXDEPTH    DELTAZ    DELTAT
C               15000        40         4
C#   +    1    +    2    +    3    +    4    +    5    +    6    +    7
CVELOCITIES TIME/DPTH      VMIN      VMAX      VMID  RATIOMIN  RATIOMAX
CVELOCITIES         0      1480      1480
CVELOCITIES        40      1480      1480
CVELOCITIES        80      1480      1480
CVELOCITIES       120      1480      1482
CVELOCITIES       160      1481      1494
CVELOCITIES       200      1483      1512
CVELOCITIES       240      1486      1534
CVELOCITIES       280      1488      1557
CVELOCITIES       320      1490      1583
CVELOCITIES       360      1493      1609
CVELOCITIES       400      1496      1637
CVELOCITIES       440      1498      1666
