c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c***********************************************************************
c maps one array into another given padding info
c***********************************************************************
      subroutine recpad(in,n1,n2, out,n1out,n2out,
     :                  i1b,i1e,i2b,i2e,ldead,val,val_flag,lnewrec)

      implicit none

c Scalar arguments
      integer  n1,n2, n1out,n2out, i1b,i1e, i2b,i2e
      real     val, val_flag
      logical  ldead,lnewrec

c Vector arguments
      real     in(n1,n2), out(n1out,n2out)

c Counters and pointers
      integer  i,j, ii,jj, iptr, jptr

c-----------------------------------------------------------------------
c   Done with Declarations
c-----------------------------------------------------------------------

c Loop over output traces
      do j = 1,n2out
        jptr = j - i2b
        jj = max(1,jptr)
        jj = min(n2,jj)

c   handle padded traces
        if ( jptr.lt.1 .or. jptr.gt.n2 ) then
          if (ldead) then
            do i = 1,n1out
              out(i,j) = 0.0
            enddo
          elseif ( val .ne. val_flag ) then
            do i = 1,n1out
              out(i,j) = val
            enddo
          else
            do i = 1,n1out
              iptr = i - i1b
              ii = max(1,iptr)
              ii = min(n1,ii)
              out(i,j) = in(ii,jj)
            enddo
          endif

        else

c   Loop over output samples of preexisting traces
          do i = 1,n1out
            iptr = i - i1b

c      set up sample pointer for input data
            ii = max(1,iptr)
            ii = min(n1,ii)

c      account for the user's padding value
            if ( val.ne.val_flag .and. lnewrec ) then
              out(i,j) = val

c      map input to output
            else
              out(i,j) = in(ii,jj)
            endif
          enddo

c   handle special case padded samples
          if ( val .ne. val_flag ) then
            if ( i1b .gt. 0 ) then
              do i = 1,i1b
                out(i,j) = val
              enddo
            endif

            if ( i1e .gt. 0 ) then
              do i = i1b+n1+1,n1out
                out(i,j) = val
              enddo
            endif
          endif

c end of test for padded traces
        endif

      enddo

c All Done
      return
      end
