C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FindStaticToApply ( Index, Trace, Sample, DphInd, 
     :     NumSegs, NumPicks, dt, dt_xgraph )

#include <f77/lhdrsz.h>

c Routine to calculate the delta-time to be applied at this trace based
c on DphInd entry and two segments in the xsd pickfile files.

      integer Index(2*SZSMPM,3), DphInd, NumSegs, NumPicks
      
      real Trace(NumSegs*NumPicks), Sample(NumSegs*NumPicks), dt
      real record, TopTime, BottomTime, dt_xgraph

c initialize variables

      dt = 0.0
      dt_xgraph = 0.0

      record = float(DphInd)

c Interpolate/extrapolate time for segment 1 at this DphInd

      if ( record .le. Trace(1) ) then

         TopTime = Sample(1)

      elseif ( record .gt. Trace(1) .and. record .lt. Trace(Index(1,1) )
     :        ) then

         do i = 1, index(1,1) - 1

            if ( record .le. Trace(i+1) ) then
               TopTime = Sample(i) + 
     :              ( Sample(i+1) - Sample(i) ) * 
     :              ( record - Trace(i) ) / 
     :              (Trace(i+1) - Trace(i) )
               goto 10
            endif

         enddo

      elseif ( record .ge. Trace(Index(1,1) ) ) then

         TopTime = Sample(Index(1,1))

      endif
c Interpolate/extrapolate time for segment 2 at this DphInd

 10    continue

      if ( record .le. Trace(Index(1,1)+1) ) then

         BottomTime = Sample(Index(1,1)+1)
         dt = TopTime - BottomTime

c load dt to dt_xgraph so that output plot shows actual
c time shift calculated from the input data prior to 
c adjusting the sign.  This was requested by Tom Chaimov

         dt_xgraph = dt

         if ( dt .gt. 0.0) dt = 0.0 - dt
         return

      elseif ( record .gt. Trace(1) .and. record .lt. Trace(Index(1,1) )
     :        ) then

         do i = index(1,1)+1, index(1,1) + index(2,1) - 1

            if ( record .le. Trace(i+1) ) then
               BottomTime = Sample(i) + 
     :              ( Sample(i+1) - Sample(i) ) * 
     :              ( record - Trace(i) ) / 
     :              (Trace(i+1) - Trace(i) )

c determine delta - time

               dt = TopTime - BottomTime
               dt_xgraph = dt

               if ( dt .gt. 0.0) dt = 0.0 - dt
               return

            endif

         enddo

      elseif ( record .ge. Trace(Index(1,1)+Index(2,1) ) ) then

         BottomTime = Sample(Index(1,1)+Index(2,1) )
         dt = TopTime - BottomTime
         dt_xgraph = dt
         if ( dt .gt. 0.0) dt = 0.0 - dt
         return

      endif

      end
