C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ProReadPick(lupick1, lupick2, Index, Trace, Sample, 
     :     NumSegs, NumPicks )

#include <ut_defs.h>
#include <f77/lhdrsz.h>
      
      integer Index(2*SZSMPM,3), nseg, NumSegs, Numpicks, zkeycount
      integer pkeycount, npicks, lupick ,lupick1, lupick2, zkeycountold
      integer pointer, JJ

      real Trace(NumSegs*NumPicks), Sample(NumSegs*NumPicks)
      real pkeyArray(2*SZSMPM), skeyArray(2*SZSMPM), zkeyArray(2*SZSMPM)
      real pkeyvalue, skeyvalue, zkeyvalue

      character InputLine*200, pkey*100, skey*100, zkey*100, key*100
      character EQ*100

c initialize data

      data EQ/'='/

      DO JJ = 1, 2

         if ( JJ .eq. 1 ) then
            lupick = lupick1
            pkeycount = 0
            zkeycount = 0
            zkeycountold = 0
         else
            lupick = lupick2
         endif
         
         
c read desc, pkey, skey, zkey information

         do while ( 1 .eq. 1 )

c read past all X-Sun crap at start of file and get pkey, skey and
c zkey definitions

            read (lupick,'(a200)') InputLine
            read (InputLine,'(a16)') key
            if ( key(1:4) .eq. 'PKEY' ) pkey = key(10:90)
            if ( key(1:4) .eq. 'SKEY' ) skey = key(10:90)
            if ( key(1:4) .eq. 'ZKEY' ) then
               zkey = key(10:90)
               goto 10
            endif
         enddo
         
 10      continue

         do while ( 1 .eq. 1 )
            key = ' '
            read (lupick, '(a200)', end = 20) InputLine
            call fsscnf ( InputLine,'%100c %100c', key(1:4), key(5:9) )
            
            lep = lenth(pkey)
            les = lenth(skey)
            
	    if (lep .gt. 0) then
             if ( key(1:lep) .eq. pkey(1:lep) ) then
               pkeycount = pkeycount + 1
               read ( InputLine, '(9x,f8.2)')pkeyvalue
               Index(pkeycount,2) = nint(pkeyvalue)
               if ( pkeycount .gt. 1 ) then
                  Index(pkeycount-1,1)= zkeycount - zkeycountold
                  zkeycountold = zkeycount
               endif
             endif
            endif
            
	    if (les .gt. 0) then
             if ( key(1:les) .eq. skey(1:les) )  then
               zkeycount = zkeycount + 1
               read ( InputLine, '(29x,f8.2,11x,f8.2)')skeyvalue, 
     :              zkeyvalue
               pkeyArray(zkeycount) = pkeyvalue
               skeyArray(zkeycount) = skeyvalue
               zkeyArray(zkeycount) = zkeyvalue
             endif
            endif
            
         enddo

c determine if each pkey has a zkey [i.e. stack data] or if
c there are multiple zkey entries per pkey [i.e. pre-stack data]

 20      continue
      
         IF ( pkeycount .eq. zkeycount ) then

c there is only one segment.  The pkey will go to the trace slot and 
c the zkey will go to the sample slot

            if ( JJ .eq. 1 ) then
               Index(JJ,1) = pkeycount
               Index(JJ,2) = 1
               call vmov(pkeyArray, 1, Trace, 1, pkeycount)
               call vmov(zkeyArray, 1, Sample, 1, pkeycount)
               pointer = pkeycount 
            else
               Index(JJ,1) = pkeycount - pointer
               Index(JJ,2) = 1
               call vmov(pkeyArray(pointer+1), 1,Trace(pointer+1), 1, 
     :              pkeycount - pointer )
               call vmov(zkeyArray(pointer+1), 1, Sample(pointer+1), 1, 
     :              pkeycount - pointer )
            endif
            
         ELSE

c there are multiple segments.  the pkey will go to Index(i,2)
c the skey will go to trace slot and the zkey will go to sample slot

            npicks = 0
            nseg = 0

            if ( JJ .eq. 1 ) then
               call vmov ( skeyArray, 1, Trace, 1, zkeycount )
               call vmov ( zkeyArray, 1, Sample, 1, zkeycount )
               pointer = zkeycount 
            else
               call vmov(skeyArray(pointer+1), 1,Trace(pointer+1), 1, 
     :              zkeycount - pointer )
               call vmov(zkeyArray(pointer+1), 1, Sample(pointer+1), 1, 
     :              zkeycount - pointer )
            endif
            Index(JJ,1) = zkeycount - zkeycountold
         
         ENDIF

      ENDDO

      return
      end

            

