C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c*******************************************************************c
*
* mctshift does a multi-component time-shift, as for a layer-
*          stripping operation on split-shear data.  It accepts
*          four input traces (xx,xy,yx,yy), and applies a user-
*          specified delay of dt to the yy trace (by default), and
*          of dt/2 to the xy and yx traces. 
c Further documentation of includes and utilities in prgm.F
c
c mar 96 .....L. Thomsen
c     - allowed VSP case
c feb 96 .....P.Garossino
c     - allowed negative number in filename
c June 94.....P. Garossino
c     - converted shift from nearest sample to full fft.
c     - retooled program nomenclature to be more usp like for ease
c       of programming.
c     - replaced skprec with recskp and skptrc with trcskp
c     - dimensioned all undimensioned variables
c     - added trace variable delta-time (between fast and slow) shear
c       determination and application from xsd pick file.  Referenced
c       the pickfile to DphInd in xsd header value files
c     - added promax pmx file reader and -PF -PS options
c     - added -sw to store static applied 
c     - put in IKP stuff
c
c******************************************************************c
c
c     declare variables

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c standard USP variables
 
      integer   itr( SZLNHD )                           
      integer   nsamp, nsi, ntrc, nrec, nreco, iform
      integer   luinIJ, luoutIJ, lbytes, nbytes, lbyout
      integer   luin( 2, 2 ), luout( 2, 2 )
      integer   irs, ire, ns, ne
      integer   pipei(4), pipeo(4)

      real      tri (SZLNHD)

      character    ntap*100

      logical    verbos, IKP
 
c MCTSHIFT specific variables Static memory

      integer   ordfft, argis, k2, ntnew, Index(2*SZSMPM,3)
      integer   SlowComponent, icslo, jcslo, le1, le2, leotap
      integer   lupick, luxgraph, NumPicks, NumSegs, NumSegs1, NumPicks1
      integer   NumSegs2, NumPicks2 
      integer   DphInd, l_DphInd, ln_DphInd, ifmt_DphInd
      integer   StaCor, l_StaCor, ln_StaCor, ifmt_StaCor
      integer   l_TVPT20, ln_TVPT20, ifmt_TVPT20
      integer   luprotap1, luprotap2
           
      real      work(2*SZLNHD), omega(2*SZLNHD)
      real      dt,dt_xgraph, StaticInSamples, pi, domega

      character    FileShift*5, FileExtension*3
      character    name*8, ptap*255, xtap*255, StaticMnemonic*6 
      character    protap1*255, protap2*255, otap*255
      character*255 ifile( 3, 2 ), ofile( 3, 2 ) 

      logical header, VSPcase

c MCTSHIFT specific variables Dynamic memory

      integer TrcErr, SmpErr, abort, ItemXsdPick

      real  Trace, Sample

      pointer     (TrcAdr, Trace(200000) )
      pointer     (SmpAdr, Sample(200000) )

c initialize variables

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'MCTSHIFT'/
      data header/.true./
      data lupick/21/
      data luprotap1/20/
      data luprotap2/21/
      data luxgraph/22/
      data pipei/0,3,5,7/
      data pipeo/1,4,6,8/

c activate help subroutine if requested

      if ( argis( '-?' ) .gt. 0 .or. 
     :     argis( '-h' ) .gt. 0 .or. 
     :     argis( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
 
c open printout file

#include <f77/open.h>
 
c get command line arguments

      call gcmdln( ntap, ns, ne, irs, ire, verbos, SlowComponent, dt, 
     :     ptap, protap1, protap2, header, StaticMnemonic, otap, 
     :     VSPcase, IKP )

c     verify case
      if (VSPcase) then
         write(LER ,*) 'VSP case specified.'
         write(LERR,*) 'VSP case specified.'
      else
         write(LER ,*) 'Reflection case specified.'
         write(LERR,*) 'Reflection case specified.'
      endif

c decompose SlowComponent into tens and ones multipliers
      if (SlowComponent .ne. 11 .and.
     :    SlowComponent .ne. 22      ) then
         write(LER,*) 'Specify either -s11 or -s22 (default)'
         stop
      endif
      write(LERR,*) 'Slow component is specified as ', SlowComponent
      icslo = SlowComponent/10
      jcslo = SlowComponent - 10*icslo

c handle DeltaTime determination from pickfile or command line as requested

      IF ( ptap .eq. ' ' 
     :     .and. protap1 .eq. ' ' 
     :     ) then

         write(FileShift, '(f5.1)') dt
         if ( FileShift(2:2) .eq. '-' ) then
            FileShift(1:1) = '-'
            FileShift(2:2) = '0'
         endif
         if ( FileShift(1:1) .eq. ' ' ) FileShift(1:1) = '+'
         if ( FileShift(2:2) .eq. ' ' ) FileShift(2:2) = '0'

      ELSEIF ( protap1 .eq. ' ' ) then

         FileShift = '_xsd'

c open the xsd header value file

         le1 = lenth(ptap)
         open( unit=lupick, file=ptap(1:le1), status='old', err=900 )

         call PickInit( lupick, NumPicks, NumSegs, ntrc, header )

c POLICEMAN: if NumSegs is not 2 then the user has buggered the pick file 
c and there is no point in continuing 

         if ( NumSegs .ne. 2 ) then

            write(LERR,*)' '
            write(LERR,*)' MCTSHIFT: The xsd pickfile',ptap(1:le1)
            write(LERR,*)'           does not contain 2 segments.  This'
            write(LERR,*)'           is not acceptable.  The file '
            write(LERR,*)'           should contain 2 segments.  The'
            write(LERR,*)'           first defines the event time for'
            write(LERR,*)'           the fast shear dataset, the '
            write(LERR,*)'           second for the slow shear dataset'
            write(LERR,*)' FATAL'
            write(LER,*)' '
            write(LER,*)' MCTSHIFT: The xsd pickfile',ptap(1:le1)
            write(LER,*)'           does not contain 2 segments.  This'
            write(LER,*)'           is not acceptable.  The file '
            write(LER,*)'           should contain 2 segments.  The'
            write(LER,*)'           first defines the event time for'
            write(LER,*)'           the fast shear dataset, the '
            write(LER,*)'           second for the slow shear dataset'
            write(LER,*)' FATAL'
            stop

         endif

c allocate memory for picks

         ItemXsdPick = NumSegs * NumPicks * SZSMPD
      
         call galloc (TrcAdr, ItemXsdPick, TrcErr, abort )
         call galloc (SmpAdr, ItemXsdPick, SmpErr, abort )
      
         if ( TrcErr .ne. 0 
     :        .or. SmpErr .ne. 0
     :        ) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) 2 * ItemXsdPick,'  bytes'
            write(LERR,*)' '
            go to 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) 2 * ItemXsdPick,'  bytes'
            write(LERR,*)' '
         endif

c initialize memory

         call vclr(Trace, 1, NumSegs*NumPicks)
         call vclr(Sample, 1, NumSegs*NumPicks)

c read xsd pickfile

         call ReadPick ( lupick, Index, Trace, Sample, NumSegs, 
     :        header, ntrc, verbos, NumPicks)

c open output xgraph file for quality control of dt used in pick option

         if (IKP) then
            xtap = 'mctshift_IKP_Xgraph'
         else
            le1 = lenth(ntap)
	    if (le1 .gt. 0) then
              xtap = ntap(1:le1) // '_Xgraph'
	    else
              xtap = 'mctshift' // '_Xgraph'
	    endif
         endif

         le1 = lenth(xtap)
         open( unit=luxgraph, file=xtap(1:le1), status='unknown', 
     :        err=901 )

c write header to xgraph file

         write(luxgraph,*)'" Mctshift Delta Time USP xsd (ms)'

      ELSE

c input pick file control is a promax fast and slow shear pmx file

         FileShift = '_pro'

c open the promax pmx files [ pkey better be CDP and zkey better be TIME]

         le1 = lenth(protap1)
         open( unit=luprotap1, file=protap1(1:le1), status='old', 
     :        err=902 )
         le1 = lenth(protap2)
         open( unit=luprotap2, file=protap2(1:le1), status='old', 
     :        err=903 )

         call ProPickInit(luprotap1, NumPicks1, NumSegs1, ntrc)
         call ProPickInit(luprotap2, NumPicks2, NumSegs2, ntrc)

         if ( NumSegs1 .ne. 1 .or. NumSegs2 .ne. 1 ) then
            write(LERR,*)'MCTSHIFT: too many segments in ProMAX files'
            write(LERR,*)'FATAL'
            write(LER,*)'MCTSHIFT: too many segments in ProMAX files'
            write(LER,*)'FATAL'
            goto 999
         endif

         NumSegs = 2
         NumPicks = NumPicks1 + NumPicks2

c allocate memory for picks

         ItemXsdPick = NumSegs * NumPicks * SZSMPD
      
         call galloc (TrcAdr, ItemXsdPick, TrcErr, abort )
         call galloc (SmpAdr, ItemXsdPick, SmpErr, abort )
      
         if ( TrcErr .ne. 0 
     :        .or. SmpErr .ne. 0
     :        ) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) 2 * ItemXsdPick,'  bytes'
            write(LERR,*)' '
            go to 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) 2 * ItemXsdPick,'  bytes'
            write(LERR,*)' '
         endif

c initialize memory

         call vclr(Trace, 1, NumSegs*NumPicks)
         call vclr(Sample, 1, NumSegs*NumPicks)

c read ProMAX pmx files

         call ProReadPick ( luprotap1, luprotap2, Index, Trace, Sample, 
     :        NumSegs, NumPicks )

c open output xgraph file for quality control of dt used in pick option

         if (IKP) then
            xtap = 'mctshift_IKP_Xgraph'
         else
            le1 = lenth(ntap)
	    if (le1 .gt. 0) then
              xtap = ntap(1:le1) // '_Xgraph'
	    else
              xtap = 'mctshift' // '_Xgraph'
	    endif
         endif

         le1 = lenth(xtap)
         open( unit=luxgraph, file=xtap(1:le1), status='unknown', 
     :        err=901 )

c write header to xgraph file

         write(luxgraph,*)'" Mctshift Delta Time ProMAX pmx(ms)'

      ENDIF

c initialize memory

      call vclr( omega, 1, 2*SZLNHD )
      call vclr( work, 1, 2*SZLNHD )

c do for each component

      le1 = lenth(ntap)
      leotap = lenth(otap)

c set IKP pipe counter

      ic = 0

      DO icomp = 1, 2

         DO jcomp = 1, 2

            ic = ic + 1

c construct filename.extension
            
            if ( icomp .eq. 1 ) then
               if ( jcomp .eq. 1 ) FileExtension = '.11'
               if ( jcomp .eq. 2 ) FileExtension = '.12'
            elseif ( icomp .eq. 2 ) then
               if ( jcomp .eq. 1 ) FileExtension = '.21'
               if ( jcomp .eq. 2 ) FileExtension = '.22'
            endif

c input files

	    if (le1 .gt. 0) then
              ifile( icomp, jcomp ) = ntap(1:le1) // FileExtension
	    else
              ifile( icomp, jcomp ) = FileExtension
	    endif

c output files

            le2 = lenth(FileShift)
            
            if ( otap .eq. ' ' ) then
	      if (le1 .gt. 0) then
               ofile( icomp, jcomp ) = ntap(1:le1) // '_sh' // 
     :              FileShift(1:le2) // FileExtension
	      else
               ofile( icomp, jcomp ) = '_sh' // 
     :              FileShift(1:le2) // FileExtension
	      endif
            else
               ofile( icomp, jcomp ) = otap(1:leotap) // '_sh' // 
     :              FileShift(1:le2) // FileExtension
            endif

c get logical unit numbers for input and output

            if (IKP) then
               call sisfdfit (luinIJ , pipei(ic))
               call sisfdfit (luoutIJ, pipeo(ic))
               write(LER,*)'Connecting input unit ',pipei(ic),
     1                     ' to unit ',luinIJ
               write(LER,*)'Connecting output unit ',pipeo(ic),
     1                     ' to unit ',luoutIJ
            else               
               call getln( luinIJ,  ifile( icomp, jcomp ), 'r', 0 )
               call getln( luoutIJ, ofile( icomp, jcomp ), 'w', 1 )
            endif

            luin( icomp, jcomp ) = luinIJ           
            luout( icomp, jcomp ) = luoutIJ
            
c read line header of input, check, and output 
            
            call rtape (luinIJ, itr, lbytes )            
            if (lbytes .eq. 0) then
               write(LERR,*)' '
               write(LERR,*)'MCTSHIFT: No line header read from ',
     :              ifile(icomp,jcomp)
               write(LERR,*)'          Check existence/permissions ',
     :             'and try again'
               write(LERR,*)'FATAL'
               write(LER,*)' '
               write(LER,*)'MCTSHIFT: No line header read from ',
     :              ifile(icomp,jcomp)
               write(LER,*)'          Check existence/permissions ',
     :             'and try again'
               write(LER,*)'FATAL'
               stop
            endif
            
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu(StaticMnemonic,ifmt_TVPT20,l_TVPT20,ln_TVPT20,
     :     TRACEHEADER)
            
c save certain parameters

            call saver(itr, 'NumSmp', nsamp, LINHED)
            call saver(itr, 'SmpInt', nsi  , LINHED)
            call saver(itr, 'NumTrc', ntrc , LINHED)
            call saver(itr, 'NumRec', nrec , LINHED)
            call saver(itr, 'Format', iform, LINHED)
            
c ensure that command line values are compatible with data set

            call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c modify line header to reflect actual number of traces output

            nreco = ire - irs + 1
            ntrcc = ne - ns + 1

            call savew(itr, 'NumRec', nreco, LINHED)
            call savew(itr, 'NumTrc', ntrcc, LINHED)

c write this progname (from command line) to historical line hdr

            call savhlh( itr, lbytes, lbyout)

c write line header

            call wrtape( luoutIJ, itr, lbyout )

c echo  all pertinent information to printout file before processing begins

            call verbal( nsamp, nsi, ntrcc, nreco, iform, ptap,
     :           ifile( icomp, jcomp ), ofile( icomp, jcomp ), dt, 
     :           StaticMnemonic, protap1, protap2, IKP )

c skip unwanted records

            call recskp( 1, irs-1, luin(icomp,jcomp), ntrc, itr )

         ENDDO

      ENDDO

c end of component loops

c ASSUME that: irs, ire, nsamp, ntrcc, lbytes, nbytes,
c                  iform, ns
c are the SAME for each component!

c determine fft stuff for ApplyStatics subroutine 
c do this here so it happens only once to speed things up
c This stuff is required for the rshift() subroutine which
c does a phase shift in fft to allow floating point static application

      pi = 4. * atan(1.0)
      k2 = ordfft ( nsamp )
      ntnew = 2**k2
      domega = 2. * pi/ntnew

      do iomega = 1, ntnew/2
         omega(iomega) = ( iomega - 1 ) * domega
      enddo  

      DO JJ = irs, ire

         DO KK = ns, ne

c do for each component

            do icomp=1,2

               do jcomp=1,2

c skip to start-trace

                  call trcskp( JJ, 1, ns-1, luin(icomp,jcomp), ntrc, 
     :                 itr )

c read trace 
                  nbytes = 0
                  call rtape( luin(icomp,jcomp), itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                     go to 999
                  endif

c retrieve DphInd from trace header for use with Pickfile DeltaTime
c determination
                  
                  call saver2( itr, ifmt_DphInd, l_DphInd, ln_DphInd, 
     :                 DphInd, TRACEHEADER )
                  call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :                 StaCor, TRACEHEADER )

c determine DeltaTime for this trace if required 

                  if ( (ptap .ne. ' ' .or. protap1 .ne. ' ')
     :                 .and. icomp .eq. 1 
     :                 .and. jcomp .eq. 1) then

                     call FindStaticToApply(Index, Trace, Sample,  
     :                    DphInd, NumSegs, NumPicks, dt, dt_xgraph )

c output dt information to xgraph file for quality control

                     write(luxgraph,*) float(DphInd), dt_xgraph
                  endif

c determine component being processed and shift accordingly

                  IF (icomp .ne. icslo .and. jcomp .ne. jcslo) then
                     
c for fast component, simply copy

                     call savew2( itr, ifmt_TVPT20, l_TVPT20, ln_TVPT20, 
     :                 0, TRACEHEADER )
                     call wrtape (luout(icomp,jcomp), itr, nbytes)

                  ELSEIF (icomp .eq. icslo .and. jcomp .eq. jcslo) then

c for slow-slow component, shift by dt if trace is live

                     if ( StaCor .ne. 30000 ) then

                        call vmov(itr(ITHWP1),1,work(1),1,nsamp)
                        StaticInSamples = -dt / float(nsi)
                        call ApplyStatic (tri, work, omega, nsamp, 
     :                       ntnew, StaticInSamples)
                        call vmov(tri(1),1,itr(ITHWP1),1,nsamp)

                     else

                        call vclr( tri, 1, nsamp )
                        call vmov(tri(1),1,itr(ITHWP1),1,nsamp)

                     endif

                     call savew2( itr,ifmt_TVPT20, l_TVPT20, ln_TVPT20, 
     :                 nint(-dt*1000.), TRACEHEADER )

                     call wrtape (luout(icomp,jcomp), itr, nbytes)

                  ELSEIF (icomp .ne. icslo .and. jcomp .eq. jcslo) then

c for this mixed component (slow source):
c reflection case (default): shift by dt/2 if trace is live
c VSP case                 : shift by dt   if trace is live

                     if ( StaCor .ne. 30000 ) then

                        call vmov(itr(ITHWP1),1,work(1),1,nsamp)
                        if (VSPcase) then
                           StaticInSamples = -dt / float(nsi)
                           call savew2( itr,ifmt_TVPT20, l_TVPT20, 
     :                          ln_TVPT20, nint(-dt*1000.),TRACEHEADER )
                        else
                           StaticInSamples = -dt / (2.0 * float(nsi) )
                           call savew2( itr,ifmt_TVPT20, l_TVPT20, 
     :                       ln_TVPT20, nint(-dt*1000./2.),TRACEHEADER )
                        endif
                        call ApplyStatic (tri, work, omega, nsamp, 
     :                       ntnew, StaticInSamples)
                        call vmov(tri(1),1,itr(ITHWP1),1,nsamp)

                     else

                        call vclr( tri, 1, nsamp )
                        call vmov(tri(1),1,itr(ITHWP1),1,nsamp)
                        call savew2( itr,ifmt_TVPT20, l_TVPT20, 
     :                       ln_TVPT20, nint(-dt*1000./2.),TRACEHEADER )
                     endif

                     call wrtape (luout(icomp,jcomp), itr, nbytes)

                  ELSEIF (icomp .eq. icslo .and. jcomp .ne. jcslo) then

c for this mixed component (fast source):
c reflection case (default): shift by dt/2 if trace is live
c VSP case                 : simply copy

                     if ( StaCor .ne. 30000 ) then

                        if (VSPcase) then
                           call savew2( itr, ifmt_TVPT20, l_TVPT20, 
     :                                  ln_TVPT20, 0, TRACEHEADER )
                        else
                           call vmov(itr(ITHWP1),1,work(1),1,nsamp)
                           StaticInSamples = -dt / (2.0 * float(nsi) )
                           call ApplyStatic (tri, work, omega, nsamp, 
     :                                       ntnew, StaticInSamples)
                           call vmov(tri(1),1,itr(ITHWP1),1,nsamp)
                           call savew2( itr,ifmt_TVPT20, l_TVPT20, 
     :                       ln_TVPT20, nint(-dt*1000./2.),TRACEHEADER )
                        endif

                     else

                        call vclr( tri, 1, nsamp )
                        call vmov(tri(1),1,itr(ITHWP1),1,nsamp)

                     endif

                     call wrtape (luout(icomp,jcomp), itr, nbytes)

                  ENDIF
 
c skip to end of record, on input files only

                  call skptrc(JJ, ne+1, ntrc, luin(icomp,jcomp),
     :                 nsamp, ntrc, itr, lbytes, nbytes, iform)

               enddo
            enddo

c end of component loops

         ENDDO

c end of trace loop

      ENDDO

c end of record loop
 
c Normal Termination - close all input and output files

      do icomp = 1, 2
         do jcomp = 1, 2
            call lbclos ( luin( icomp, jcomp ) )
            call lbclos (luout( icomp, jcomp ) )
         enddo
      enddo

      write(LERR,*) ' End of mctshift'

      IF (IKP) THEN
         write(LER ,*)'Output component 11 placed on output stream 1'
         write(LERR,*)'Output component 11 placed on output stream 1'
         write(LER ,*)'Output component 12 placed on output stream 4'
         write(LERR,*)'Output component 12 placed on output stream 4'
         write(LER ,*)'Output component 21 placed on output stream 6'
         write(LERR,*)'Output component 21 placed on output stream 6'
         write(LER ,*)'Output component 22 placed on output stream 8'
         write(LERR,*)'Output component 22 placed on output stream 8'
      ENDIF

      write(LERR,*) ' Processed ',nrec,' records of ', ntrc,' traces'
      write(LER,*) ' MCTSHIFT: Normal Termination'

      stop

 900  continue
      if (le1 .gt. 0) then
        write(LERR,*)'MCTSHIFT: Error opening xsd pick file ', 
     :     ptap(1:le1)     
        write(LERR,*)'          Check existence/permissions and try'
     :     ,' again'
      else
        write(LERR,*)'MCTSHIFT: Error opening xsd pick file ', 
     :     ' - no name specified'
      endif
      write(LERR,*)'FATAL'        
      if (le1 .gt. 0) then
        write(LER,*)'MCTSHIFT: Error opening pick file ', ptap(1:le1)     
        write(LER,*)'          Check existence/permissions and try '
     :		,'again'
      else
        write(LER,*)'MCTSHIFT: Error opening pick file - no name '
        write(LER,*)' specified'
      endif
      write(LER,*)'FATAL' 
      stop

 901  continue
      if (le1 .gt. 0) then
        write(LERR,*)'MCTSHIFT: Error opening xgraph file ', 
     :     xtap(1:le1)     
        write(LERR,*)'          Check existence/permissions and try'
     :     ,' again'
      else
        write(LERR,*)'MCTSHIFT: Error opening xgraph file ', 
     :     ' - no name specified'
      endif
      write(LERR,*)'FATAL'        
      if (le1 .gt. 0) then
        write(LER,*)'MCTSHIFT: Error opening xgraph file ', 
     :     xtap(1:le1)     
        write(LER,*)'          Check existence/permissions and try'
     :     ,' again'
      else
        write(LER,*)'MCTSHIFT: Error opening xgraph file ', 
     :     ' - no name specified'
      endif
      write(LER,*)'FATAL' 
      stop

 902  continue
      if (le1 .gt. 0) then
        write(LERR,*)'MCTSHIFT: Error opening ProMAX pmx file ', 
     :     protap1(1:le1)     
        write(LERR,*)'          Check existence/permissions and try'
     :     ,' again'
      else
        write(LERR,*)'MCTSHIFT: Error opening ProMAX pmx file ', 
     :     '- no name specified'
      endif
      write(LERR,*)'FATAL'        
      if (le1 .gt. 0) then
        write(LER,*)'MCTSHIFT: Error opening ProMAX pmx file ', 
     :     protap1(1:le1)     
        write(LER,*)'          Check existence/permissions and try'
     :     ,' again'
      else
        write(LER,*)'MCTSHIFT: Error opening ProMAX pmx file ', 
     :     '- no name specified'
      endif
      write(LER,*)'          Check existence/permissions and try again'
      write(LER,*)'FATAL' 
      stop

 903  continue
      if (le1 .gt. 0) then
        write(LERR,*)'MCTSHIFT: Error opening ProMAX pmx file ', 
     :     protap2(1:le1)     
        write(LERR,*)'          Check existence/permissions and try'
     :     ,' again'
      else
        write(LERR,*)'MCTSHIFT: Error opening ProMAX pmx file ', 
     :     '- no name specified'
      endif
      write(LERR,*)'FATAL'        
      if (le1 .gt. 0) then
        write(LER,*)'MCTSHIFT: Error opening ProMAX pmx file ', 
     :     protap2(1:le1)     
        write(LER,*)'          Check existence/permissions and try'
     :     ,' again'
      else
        write(LER,*)'MCTSHIFT: Error opening ProMAX pmx file ', 
     :     '- no name specified'
      endif
      write(LER,*)'          Check existence/permissions and try again'
      write(LER,*)'FATAL' 
      stop

 999  continue

      write(LERR,*) ' Abnormal end of MCTSHIFT'
      write(LER,*) ' MCTSHIFT: Abnormal Termination'
      stop
      end
