C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine shift(tri, nsi, nsamp, dt)

c shift trace in place (linear interpolation if nec)
 
#include <f77/iounit.h>

c variables passed from main
     
      integer nsi, nsamp

      real tri(1), dt

c local variables 
      
      integer nshift, ishift

      real wtnp1, wtn

c initialize variables

      nshift = dt / nsi
      ishift = nshift * nsi
      wtnp1 = (dt - ishift) / nsi
      wtn = 1. - wtnp1

      IF (wtn .eq. 1.0) then

         write(LERR,1155) dt, nshift
1155     format('     shift by ',f4.1,' msec (',i3,' samples)')

         do  n = 1, nsamp-nshift
            tri(n) = tri(n + nshift)
         enddo

      ELSE

         write(LERR,1157) dt, nshift
1157     format('     shift by ',f4.1,' msec (',i3,'+ samples)')

         do  n = 1, nsamp-nshift-1
            tri(n) = wtn*tri(n + nshift) +
     &               wtnp1*tri(n + nshift+1)
         enddo

         tri(nsamp-nshift) = 0.0

      ENDIF


*     pad with zeroes

      do  n = nsamp-nshift+1, nsamp
         tri(n) = 0.0
      enddo

      return
      end

